/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardSegy;

import com.PecosCore.Data.DataType;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Page_SegyWiz_Scalars
extends LinearLayoutWidget
implements ISimpleWizardPage,
GenericObjectListener.Listener {
    protected SegyWizardSharedData m_data;
    protected JLabel m_label = new JLabel(" ");
    protected Entry m_elev;
    protected Entry m_coord;
    protected Entry m_time;

    public Page_SegyWiz_Scalars(SegyWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            Segy_Dictionary dict = this.m_data.Dictionary;
            String s = "<HTML>The header locations of the coordinate, elevation and time scalars almost always follow the SEG-Y standard, so you probably don't need to modify anything on this page. Please see the SEG standards documents (free online at www.seg.org) for a complete explanation.</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            this.addComponent(lbl, 0);
            this.createGapLabel(30);
            this.m_elev = new Entry();
            this.m_coord = new Entry();
            this.m_time = new Entry();
            GridLayoutWidget w = this.createGridLayoutWidget(0, 0);
            int row = 0;
            w.addComponent(new JLabel("Byte offset"), row, 1, 1.0, 8.0);
            w.addComponent(new JLabel("Data type"), row, 2, 1.0, 8.0);
            w.addComponent(new JLabel("Elevation scalar"), ++row, 0, 1.0, 1.0);
            w.addComponent(this.m_elev.OffsetText, row, 1, 1.0, 8.0);
            w.addComponent(this.m_elev.Combo, row, 2, 1.0, 8.0);
            w.addComponent(new JLabel("Coordinate scalar"), ++row, 0, 1.0, 1.0);
            w.addComponent(this.m_coord.OffsetText, row, 1, 1.0, 8.0);
            w.addComponent(this.m_coord.Combo, row, 2, 1.0, 8.0);
            w.addComponent(new JLabel("Time scalar"), ++row, 0, 1.0, 1.0);
            w.addComponent(this.m_time.OffsetText, row, 1, 1.0, 8.0);
            w.addComponent(this.m_time.Combo, row, 2, 1.0, 8.0);
            this.addComponent(this.m_label, 0);
            this.addStretch(10);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
        try {
            this.m_elev.getData();
            this.m_coord.getData();
            this.m_time.getData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public void activatePage() {
        try {
            this.okayToGoToNextPage();
            Segy_Dictionary dict = this.m_data.Dictionary;
            this.m_elev.setHeader(dict.getEntry_Create("None", "SegyScalar_Elevation"));
            this.m_coord.setHeader(dict.getEntry_Create("None", "SegyScalar_Coord"));
            this.m_time.setHeader(dict.getEntry_Create("None", "SegyScalar_Time"));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class Entry {
        public Segy_Dictionary.Entry Header;
        public JTextField OffsetText = new JTextField("");
        public JComboBox<String> Combo = new JComboBox();

        public Entry() {
            this.Combo.addItem(DataType.Short.Description);
            this.Combo.addItem(DataType.Int.Description);
            this.Combo.addItem(DataType.Float.Description);
        }

        public void setHeader(Segy_Dictionary.Entry hdr) {
            this.Header = hdr;
            this.OffsetText.setText(Integer.toString(1 + hdr.FirstByte));
            this.Combo.setSelectedIndex(hdr.HeaderType.ordinal());
        }

        public void getData() {
            this.Header.FirstByte = Tools_Widget.extractInteger(this.OffsetText, 1, 1, 237) - 1;
            this.Header.HeaderType = DataType.values()[this.Combo.getSelectedIndex()];
        }
    }
}

