/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardEchos;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Echos.XtParadigmTraceFileTools;
import com.PecosLibrary.Seismic.Echos.Echos_Dictionary;
import com.PecosLibrary.Windows.Echos.EchosFilesWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.EchosWizardSharedData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;

public class Page_EchosWiz_File
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener,
PropertyChangeListener {
    protected EchosFilesWidget m_echosFilesWidget;
    protected EchosWizardSharedData m_data;
    protected JLabel m_errorLabel;

    public Page_EchosWiz_File(EchosWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.m_echosFilesWidget = new EchosFilesWidget();
            this.m_errorLabel = new JLabel("");
            this.m_errorLabel.setForeground(Color.RED);
            this.m_echosFilesWidget = new EchosFilesWidget();
            this.addComponent(this.m_echosFilesWidget, 0);
            this.addComponent(this.m_errorLabel, 10);
            this.m_echosFilesWidget.addPropertyChangeListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void leavingPage() {
        try {
            int[] selectedIndices = this.m_echosFilesWidget.getSelectedFileIndices();
            this.m_data.SelectedFileIndices = selectedIndices;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            String sEchosSurvey = this.m_data.EchosSurveyName;
            String sEchosHost = this.m_data.EchosSurveyHost;
            int iSurveyType = this.m_data.EchosSurveyType;
            this.m_echosFilesWidget.reloadTable(this.m_data.EchosSurvey);
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            int[] selectedIndices = this.m_echosFilesWidget.getSelectedFileIndices();
            if (selectedIndices == null) {
                this.m_errorLabel.setText("Please select a file");
                return false;
            }
            if (selectedIndices.length == 0) {
                this.m_errorLabel.setText("Please select a file");
                return false;
            }
            if (this.m_data.Files == null) {
                this.m_data.Files = new ArrayList();
            }
            this.m_data.Files.clear();
            long maxTraces = Integer.MAX_VALUE;
            for (int iIndex : selectedIndices) {
                String sLname = this.m_echosFilesWidget.getLname(iIndex);
                long iFileID = this.m_echosFilesWidget.getFileID(iIndex);
                int iLineID = this.m_echosFilesWidget.getLineID(iIndex);
                String sFileName = XtParadigmTraceFileTools.getFileRecXmlDescriptor(iFileID, sLname, this.m_data.EchosSurveyHost, this.m_data.EchosSurveyName, iLineID, this.m_data.EchosSurveyType);
                this.m_data.Echos_SeismicFile = XtParadigmTraceFileTools.createNewSeismicTraceFile(sFileName, new Echos_Dictionary("Flatirons", true));
                boolean bOpenOK = this.m_data.Echos_SeismicFile.getXtParadigmTraceFile().Open();
                if (!bOpenOK) {
                    this.m_data.Echos_SeismicFile.getXtParadigmTraceFile().Close();
                    throw new Exception("Unable to open echos file : " + sFileName);
                }
                long nTraces = this.m_data.Echos_SeismicFile.getXtParadigmTraceFile().GetNumTraces();
                this.m_data.Echos_SeismicFile.getXtParadigmTraceFile().Close();
                if (nTraces > maxTraces) {
                    throw new Exception("Maximum trace count exceeded : " + Long.toString(nTraces) + " : " + Long.toString(maxTraces));
                }
                this.m_data.Files.add(sFileName);
            }
            this.m_errorLabel.setText("");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_errorLabel.setText(error.getMessage());
            return false;
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.handleGenericObjectListener(null, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

