/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Import.Action_MergeProjects;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportExistingProjectsDialogV2
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ListSelectionListener {
    protected AutoIncrementWidgets m_ffidInc;
    protected AutoIncrementWidgets m_ffidRecLine;
    protected AutoIncrementWidgets m_ffidRecPoint;
    protected AutoIncrementWidgets m_ffidShotLine;
    protected AutoIncrementWidgets m_ffidShotPoint;
    protected JButton m_btnOK = new JButton("Launch merge");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JCheckBox m_checkMergeTraceTable = new JCheckBox("Merge trace tables");
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Statics);
    protected JList<String> m_list = new JList();
    protected JTable m_table = new JTable();
    protected DefaultListModel<String> m_model = new DefaultListModel();
    protected ArrayList<String> m_paths = new ArrayList();
    protected ArrayList<String> m_names = new ArrayList();
    protected Action_MergeProjects.MergedProjectList m_projectTable = new Action_MergeProjects.MergedProjectList();
    protected JButton m_addSelected;
    protected JButton m_clearSelected;
    protected Action_Sequence m_sequence = null;

    public ImportExistingProjectsDialogV2() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            String s = "<HTML><font size = \"5\" color=\"red\">You should close all open projects that will be used to create the new project. The program will not check to see if they are closed!</font></HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            middle.addComponent(lbl, 0);
            LinearLayoutWidget top = middle.createHorizontal(3, null, 0);
            LinearLayoutWidget left = top.createVertical(0, null, 10);
            left.addComponent(this.m_nameWidget, 3);
            this.m_nameWidget.getListenerController().addListener(this);
            left.addStretch(10);
            GridLayoutWidget grid = top.createGridLayoutWidget(0, "Increment options", 10);
            int row = 0;
            this.m_ffidInc = new AutoIncrementWidgets(grid, row++, "FFID increment   ", this);
            this.m_ffidRecLine = new AutoIncrementWidgets(grid, row++, "Receiver line increment  ", this);
            this.m_ffidRecPoint = new AutoIncrementWidgets(grid, row++, "Receiver point increment  ", this);
            this.m_ffidShotLine = new AutoIncrementWidgets(grid, row++, "Shot line increment  ", this);
            this.m_ffidShotPoint = new AutoIncrementWidgets(grid, row++, "Shot point increment  ", this);
            LinearLayoutWidget lower = middle.createHorizontal(3, null, 10);
            LinearLayoutWidget lowerLeft = lower.createVertical(0, null, 2);
            lowerLeft.addComponent(new JScrollPane(this.m_list), 10);
            this.m_list.addListSelectionListener(this);
            LinearLayoutWidget lowerMiddle = lower.createVertical(0, null, 0);
            this.m_addSelected = lowerMiddle.createButton("Add to selected >>", this, 0);
            this.m_clearSelected = lowerMiddle.createButton("Clear selected table", this, 0);
            lowerMiddle.addStretch(10);
            lower.addComponent(new JScrollPane(this.m_table), 10);
            this.m_table.setModel(this.m_projectTable);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_checkMergeTraceTable, 0);
            this.m_checkMergeTraceTable.setSelected(true);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(1024, 800);
            this.setTitle("Create a refraction project using existing projects");
            this.setLocationRelativeTo(null);
            this.reloadProjects();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadProjects() {
        try {
            this.m_model.clear();
            this.m_paths.clear();
            String parentPath = SharedApplicationData.staticsProjectPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(parentPath, false);
            Collections.sort(subdirs);
            for (String subdir : subdirs) {
                String fullProjectPath = parentPath + "/" + subdir;
                String projectName = "";
                if (subdir.endsWith(".xtref")) {
                    int endChar = subdir.length() - ".xtref".length();
                    projectName = subdir.substring(0, endChar);
                } else {
                    projectName = subdir;
                }
                if (!Tools_FileSystem.exists_path(fullProjectPath)) continue;
                this.m_model.addElement(projectName);
                this.m_paths.add(subdir);
            }
            this.m_list.setModel(this.m_model);
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public void showDialog() {
        try {
            this.reloadProjects();
            this.setVisible(true);
            this.requestFocus();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            this.m_btnOK.setEnabled(false);
            if (!this.m_nameWidget.checkName()) {
                return false;
            }
            if (this.m_projectTable.ProjectList.size() < 1) {
                return false;
            }
            this.m_btnOK.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.prepAutoInc(true);
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Action_Sequence sequence() {
        return this.m_sequence;
    }

    protected void prepAutoInc(boolean fire) {
        try {
            int inc = 0;
            int delta = 0;
            inc = 0;
            delta = 0;
            if (this.m_ffidShotPoint.on()) {
                delta = this.m_ffidShotPoint.increment();
            }
            for (Action_MergeProjects.Entry e : this.m_projectTable.ProjectList) {
                e.ShotPointIncrement = inc;
                inc += delta;
            }
            inc = 0;
            delta = 0;
            if (this.m_ffidShotLine.on()) {
                delta = this.m_ffidShotLine.increment();
            }
            for (Action_MergeProjects.Entry e : this.m_projectTable.ProjectList) {
                e.ShotLineIncrement = inc;
                inc += delta;
            }
            inc = 0;
            delta = 0;
            if (this.m_ffidRecPoint.on()) {
                delta = this.m_ffidRecPoint.increment();
            }
            for (Action_MergeProjects.Entry e : this.m_projectTable.ProjectList) {
                e.RecPointIncrement = inc;
                inc += delta;
            }
            inc = 0;
            delta = 0;
            if (this.m_ffidRecLine.on()) {
                delta = this.m_ffidRecLine.increment();
            }
            for (Action_MergeProjects.Entry e : this.m_projectTable.ProjectList) {
                e.RecLineIncrement = inc;
                inc += delta;
            }
            inc = 0;
            delta = 0;
            if (this.m_ffidInc.on()) {
                delta = this.m_ffidInc.increment();
            }
            for (Action_MergeProjects.Entry e : this.m_projectTable.ProjectList) {
                e.FFIDIncrement = inc;
                inc += delta;
            }
            if (fire) {
                this.m_projectTable.fireTableDataChanged();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void addSelected() {
        try {
            int[] sel = this.m_list.getSelectedIndices();
            if (sel == null) {
                return;
            }
            if (sel.length < 1) {
                return;
            }
            for (int n = 0; n < sel.length; ++n) {
                int index = sel[n];
                String name = this.m_paths.get(index);
                boolean alreadySelected = false;
                for (Action_MergeProjects.Entry e : this.m_projectTable.ProjectList) {
                    alreadySelected = alreadySelected || e.ProjectName.equals(name);
                }
                if (alreadySelected) continue;
                Action_MergeProjects.Entry entry = new Action_MergeProjects.Entry();
                if (name.endsWith(".xtref")) {
                    int endChar = name.length() - ".xtref".length();
                    entry.ProjectName = name.substring(0, endChar);
                } else {
                    entry.ProjectName = name;
                }
                this.m_projectTable.ProjectList.add(entry);
            }
            this.prepAutoInc(true);
            this.m_list.clearSelection();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void clearSelected() {
        try {
            this.m_list.clearSelection();
            this.m_projectTable.ProjectList.clear();
            this.m_projectTable.fireTableDataChanged();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String projectName() {
        try {
            return this.m_nameWidget.name();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR";
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_addSelected) {
                this.addSelected();
                return;
            }
            if (e.getSource() == this.m_clearSelected) {
                this.clearSelected();
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                if (!this.dataOK()) {
                    return;
                }
                this.m_sequence = new Action_Sequence();
                Action_MergeProjects merge = new Action_MergeProjects();
                merge.ProjectList = this.m_projectTable;
                String parentPath = SharedApplicationData.staticsProjectPath();
                merge.Hasher.string_put("ParentPath", parentPath);
                merge.Hasher.string_put("ProjectName", this.m_nameWidget.name());
                merge.Hasher.bool_put("MergeTraceTable", this.m_checkMergeTraceTable.isSelected());
                this.m_sequence.addAction(merge);
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class AutoIncrementWidgets
    implements ActionListener {
        public JLabel m_lbl;
        public JCheckBox m_chkAutoInc = new JCheckBox("Auto increment on");
        public JTextField m_textInc = new JTextField("10000");
        public GenericObjectListener m_listener = new GenericObjectListener();

        public AutoIncrementWidgets(GridLayoutWidget grid, int row, String label, GenericObjectListener.Listener listener) {
            try {
                this.m_lbl = new JLabel(label);
                this.m_listener.addListener(listener);
                this.m_chkAutoInc.addActionListener(this);
                this.m_textInc.addActionListener(this);
                grid.addSimple(row, (Component)this.m_lbl, (Component)this.m_chkAutoInc, (Component)this.m_textInc, 0, 3, 4);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public boolean on() {
            return this.m_chkAutoInc.isSelected();
        }

        public int increment() {
            return Tools_Widget.extractInteger(this.m_textInc, 0, -1000000000, 100000000);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.m_listener.broadcast(this, null);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

