/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Import.Action_MergeProjects;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportExistingProjectsDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ListSelectionListener {
    protected JButton m_btnOK = new JButton("Launch merge");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JCheckBox m_checkMergeTraceTable = new JCheckBox("Merge trace tables");
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Statics);
    protected JList<String> m_list = new JList();
    protected DefaultListModel<String> m_model = new DefaultListModel();
    protected ArrayList<String> m_paths = new ArrayList();
    protected Action_Sequence m_sequence = null;

    public ImportExistingProjectsDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            String s = "<HTML><font size = \"5\" color=\"red\">You should close all open projects that will be used to create the new project. The program will not check to see if they are closed!</font></HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            middle.addComponent(lbl, 0);
            middle.createGapLabel(12);
            middle.addComponent(this.m_nameWidget, 0);
            middle.addComponent(new JLabel("Select projects"), 0);
            middle.addComponent(new JScrollPane(this.m_list), 10);
            this.m_list.addListSelectionListener(this);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            bottom.addComponent(this.m_checkMergeTraceTable, 0);
            this.m_checkMergeTraceTable.setSelected(true);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(350, 600);
            this.setTitle("Create a refraction project using existing projects");
            this.setLocationRelativeTo(null);
            this.reloadProjects();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadProjects() {
        try {
            this.m_model.clear();
            this.m_paths.clear();
            String parentPath = SharedApplicationData.staticsProjectPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(parentPath, false);
            Collections.sort(subdirs);
            for (String subdir : subdirs) {
                String fullProjectPath = parentPath + "/" + subdir;
                if (!Tools_FileSystem.exists_path(fullProjectPath)) continue;
                this.m_model.addElement(subdir);
                this.m_paths.add(subdir);
            }
            this.m_list.setModel(this.m_model);
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.dataOK();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            this.reloadProjects();
            this.setVisible(true);
            this.requestFocus();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            this.m_btnOK.setEnabled(false);
            if (!this.m_nameWidget.checkName()) {
                return false;
            }
            int[] sel = this.m_list.getSelectedIndices();
            if (sel == null) {
                return false;
            }
            if (sel.length < 1) {
                return false;
            }
            this.m_btnOK.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Action_Sequence sequence() {
        return this.m_sequence;
    }

    public String projectName() {
        try {
            return this.m_nameWidget.name();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR";
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.dataOK()) {
                    return;
                }
                this.m_sequence = new Action_Sequence();
                ArrayList<String> list = new ArrayList<String>();
                int[] sel = this.m_list.getSelectedIndices();
                for (int n = 0; n < sel.length; ++n) {
                    String name = this.m_paths.get(sel[n]);
                    list.add(name);
                }
                Action_MergeProjects merge = new Action_MergeProjects();
                String parentPath = SharedApplicationData.staticsProjectPath();
                merge.Hasher.string_put("ParentPath", parentPath);
                merge.Hasher.string_put("ProjectName", this.m_nameWidget.name());
                merge.Hasher.stringList_put("ProjectList", list);
                merge.Hasher.bool_put("MergeTraceTable", this.m_checkMergeTraceTable.isSelected());
                this.m_sequence.addAction(merge);
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

