/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.HybridGliDt;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Refraction.HybridGliDt.Action_HybridGliDt_CreateModel;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.HybridGLI.HybridGliData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Refraction.HybridGliDt.HybridStaticsWidget;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class HybridGliWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener {
    protected ComboStringListWrapper m_nameCombo;
    protected JButton m_btnNewModel;
    protected JButton m_btnComputeModel;
    protected JButton m_btnReloadList;
    protected Java2D_SimpleComposite m_plotWidget;
    protected ComboStringListWrapper m_gridCombo;
    protected JButton m_btnReloadGridList;
    protected JCheckBox m_chkShowSrc = new JCheckBox("Show sources");
    protected JCheckBox m_chkShowRec = new JCheckBox("Show receivers");
    protected JButton m_btnReloadPlot;
    protected HybridStaticsWidget m_staticsWidget = new HybridStaticsWidget();
    protected MultiTextDialog m_dlg;

    public HybridGliWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.reloadModelList();
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_nameCombo.setPreferredSelected(project.hybridGliData().name());
            this.reloadGridList();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("Model", this.createModelLeft());
            tabs.addTab("Statics", this.m_staticsWidget);
            return tabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelLeft() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            LinearLayoutWidget sub = main.createVertical(0, "Hybrid model selection", 0);
            this.m_nameCombo = new ComboStringListWrapper();
            sub.addComponent(this.m_nameCombo, 0);
            this.m_nameCombo.listener().addListener(this);
            this.m_btnComputeModel = sub.createButton("Recompute current model", this, 0);
            this.m_btnReloadList = sub.createButton("Reload list of models", this, 0);
            this.m_btnNewModel = sub.createButton("Create a new model", this, 0);
            sub = main.createVertical(0, "Display options", 0);
            this.m_gridCombo = new ComboStringListWrapper();
            sub.addHorzPair(new JLabel("Select grid"), 0, this.m_gridCombo, 10);
            this.m_gridCombo.listener().addListener(this);
            this.m_btnReloadGridList = sub.createButton("Reload list of model grids", this, 0);
            sub.addHorzPair(this.m_chkShowSrc, 10, this.m_chkShowRec, 10);
            this.m_chkShowSrc.addActionListener(this);
            this.m_chkShowRec.addActionListener(this);
            this.m_btnReloadPlot = sub.createButton("Reload plot", this, 0);
            this.m_chkShowSrc.setSelected(true);
            this.m_chkShowRec.setSelected(true);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            this.m_plotWidget = new Java2D_SimpleComposite(true);
            return this.m_plotWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            String msg = null;
            if (data != null && data instanceof String) {
                msg = (String)data;
            }
            HybridGliData model = RefractionStaticsProject.singleton().hybridGliData();
            if (sender == this.m_nameCombo) {
                model.setModelName(this.m_nameCombo.getSelectedString(), -9999.0);
                this.reloadGridList();
                return;
            }
            if (sender == this.m_gridCombo) {
                this.reloadPlot();
                return;
            }
            if (sender == model && msg != null && msg.equalsIgnoreCase("GridAdded")) {
                this.reloadGridList();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_chkShowSrc || e.getSource() == this.m_chkShowRec || e.getSource() == this.m_btnReloadPlot) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_btnReloadGridList) {
                this.reloadGridList();
                return;
            }
            if (e.getSource() == this.m_btnReloadList) {
                this.reloadModelList();
                this.reloadGridList();
                return;
            }
            if (e.getSource() == this.m_btnComputeModel) {
                this.recompute();
                return;
            }
            if (e.getSource() == this.m_btnNewModel) {
                this.newModel();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadSrcRec() {
        try {
            if (this.m_chkShowSrc.isSelected()) {
                this.m_plotWidget.mainWidget().addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Shot", 3, Color.LIGHT_GRAY), -9999);
            }
            if (this.m_chkShowRec.isSelected()) {
                this.m_plotWidget.mainWidget().addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver", 3, Color.LIGHT_GRAY), -9999);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void testGrid() {
        try {
            this.m_plotWidget.mainWidget().clearPaintableList();
            Grid3D grid = Tools_RefractionStaticsProject.getInterpolatedGrid(50.0, 50.0, "Elevation", true);
            if (grid != null) {
                this.m_plotWidget.mainWidget().addPaintable(grid, 0);
            }
            this.loadSrcRec();
            this.m_plotWidget.setColorTitle(this.m_gridCombo.getSelectedString());
            this.m_plotWidget.mainWidget().transform().setTechnique(Java2D_Transform.Technique.Basemap);
            this.m_plotWidget.mainWidget().mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            this.m_plotWidget.mainWidget().clearPaintableList();
            HybridGliData model = RefractionStaticsProject.singleton().hybridGliData();
            Grid3D grid = model.getGrid(this.m_gridCombo.getSelectedString());
            if (grid != null) {
                this.m_plotWidget.mainWidget().addPaintable(grid, 0);
            }
            this.loadSrcRec();
            this.m_plotWidget.setColorTitle(this.m_gridCombo.getSelectedString());
            this.m_plotWidget.mainWidget().transform().setTechnique(Java2D_Transform.Technique.Basemap);
            this.m_plotWidget.mainWidget().mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadGridList() {
        try {
            HybridGliData model = RefractionStaticsProject.singleton().hybridGliData();
            this.m_gridCombo.setStringArray(model.getListOfGridNames());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadModelList() {
        try {
            String path = RefractionStaticsProject.singleton().hybridProjectsPath();
            ArrayList<String> names = Tools_FileSystem.subdirectories(path, false);
            this.m_nameCombo.setStringArray(names);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void recompute() {
        try {
            Action_HybridGliDt_CreateModel action = new Action_HybridGliDt_CreateModel();
            action.Hasher.bool_put("UseDelayTimeAnis", false);
            action.Hasher.bool_put("ComputeAnis", false);
            RefractionStaticsProject.singleton().executeSingleAction(action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void newModel() {
        try {
            if (this.m_dlg == null) {
                this.m_dlg = new MultiTextDialog(null, "Hybrid model parameters", "Model name", "Weathering velocity");
            }
            this.m_dlg.showDialog();
            String name = this.m_dlg.getText(0);
            double v0 = this.m_dlg.getDouble(1, 3000.0, 500.0, 20000.0);
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            if ((name = Tools_Strings.removeSpace(name)).length() < 2) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String fullPath = p.hybridProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(fullPath)) {
                JOptionPane.showMessageDialog(null, "Hybrid model already exists", "Hybrid model already exists", 0);
                return;
            }
            RefractionStaticsProject.singleton().hybridGliData().setModelName(name, v0);
            Action_HybridGliDt_CreateModel action = new Action_HybridGliDt_CreateModel();
            action.Hasher.bool_put("UseDelayTimeAnis", false);
            action.Hasher.bool_put("ComputeAnis", false);
            RefractionStaticsProject.singleton().executeSingleAction(action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

