/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.Grid2D_Conversion_Line;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class Grid2DDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Apply changes");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JTextField m_textAngle = new JTextField("");
    protected JTextField m_textOriginX = new JTextField("");
    protected JTextField m_textOriginY = new JTextField("");
    protected JTextField m_textSize = new JTextField("");
    protected Grid3D_Conversion m_grid3D;
    protected Grid2D_Conversion_Line m_grid2DLine;

    public Grid2DDialog(Grid3D_Conversion grid3D, Grid2D_Conversion_Line grid2DLine, double angle, double ox, double oy) {
        try {
            this.m_grid3D = grid3D;
            this.m_grid2DLine = grid2DLine;
            this.getContentPane().setLayout(new BorderLayout());
            GridLayoutWidget grid = new GridLayoutWidget(3, null);
            this.m_textAngle.setText(Tools_Strings.getString(angle, 2));
            this.m_textOriginX.setText(Tools_Strings.getString(ox, 1));
            this.m_textOriginY.setText(Tools_Strings.getString(oy, 1));
            this.m_textSize.setText(Tools_Strings.getString(this.m_grid2DLine.binSize(), 2));
            int row = 0;
            grid.createLabel("Inline angle", row, 0);
            grid.addComponent(this.m_textAngle, row, 1, 1.0, 10.0);
            grid.createLabel("X Origin", ++row, 0);
            grid.addComponent(this.m_textOriginX, row, 1, 1.0, 10.0);
            grid.createLabel("Y Origin", ++row, 0);
            grid.addComponent(this.m_textOriginY, row, 1, 1.0, 10.0);
            grid.createLabel("Bin size", ++row, 0);
            grid.addComponent(this.m_textSize, row, 1, 1.0, 10.0);
            ++row;
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)grid, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setTitle("Define the 2D grid");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected void setGrid3D() {
        try {
            double az = this.m_grid3D.inlineAngle() * 180.0 / Math.PI;
            az = Tools_Widget.extractDouble(this.m_textAngle, az, -360.0, 360.0);
            this.m_grid3D.setInlineAngle(az * Math.PI / 180.0);
            double size = Tools_Widget.extractDouble(this.m_textSize, 100.0, 10.0, 1000.0);
            this.m_grid3D.setBinSize(size, size);
            double ox = Tools_Widget.extractDouble(this.m_textOriginX, this.m_grid3D.originX(), Double.MIN_VALUE, Double.MAX_VALUE);
            double oy = Tools_Widget.extractDouble(this.m_textOriginY, this.m_grid3D.originY(), Double.MIN_VALUE, Double.MAX_VALUE);
            this.m_grid3D.setOrigin(ox, oy);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                double az = this.m_grid2DLine.angle() * 180.0 / Math.PI;
                az = Tools_Widget.extractDouble(this.m_textAngle, az, -360.0, 360.0);
                this.m_grid2DLine.setAngle(az * Math.PI / 180.0);
                double size = Tools_Widget.extractDouble(this.m_textSize, this.m_grid2DLine.binSize(), 10.0, 2000.0);
                this.m_grid2DLine.setBinSize(size);
                double ox = Tools_Widget.extractDouble(this.m_textOriginX, this.m_grid2DLine.originX(), Double.MIN_VALUE, Double.MAX_VALUE);
                double oy = Tools_Widget.extractDouble(this.m_textOriginY, this.m_grid2DLine.originY(), Double.MIN_VALUE, Double.MAX_VALUE);
                this.m_grid2DLine.setOrigin(ox, oy);
                this.setGrid3D();
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

