/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_StaticsInfo;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel_StaticsInfo;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Page_IMB_Static_Name
extends LinearLayoutWidget
implements ItemListener,
ActionListener,
ISimpleWizardPage,
DocumentListener {
    protected InteractiveModel_StaticsInfo m_staticsInfo;
    protected JTextField m_txt = new JTextField("Version1");
    protected JLabel m_messageLabel = new JLabel("");
    protected JCheckBox m_check = new JCheckBox("Overwrite existing statics values");
    protected Color m_darkYellow = new Color(150, 150, 0);

    public Page_IMB_Static_Name(InteractiveModel_StaticsInfo staticsInfo) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_staticsInfo = staticsInfo;
            this.m_txt = this.createSubTextField("Name of the statics field:", "Version1", null);
            this.m_txt.getDocument().addDocumentListener(this);
            this.addComponent(this.m_messageLabel, 0);
            this.addComponent(this.m_check, 0);
            this.m_check.setSelected(false);
            this.m_check.addActionListener(this);
            this.addStretch(10);
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_check) {
                this.checkName();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        return this.checkName();
    }

    @Override
    public void leavingPage() {
        try {
            this.m_staticsInfo.WeatheringVelocity = DelayTimeModel_StaticsInfo.WeatheringVelocityEnum.Normal;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
    }

    public boolean checkName() {
        try {
            this.m_staticsInfo.ColumnName = "";
            String name = this.m_txt.getText();
            this.m_messageLabel.setText("");
            if (name.length() < 3) {
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText("Name must have at least 3 characters");
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText("Spaces and special characters not allowed");
                return false;
            }
            String column = "STATICS_" + name;
            boolean exists = Tools_RefractionStaticsProject.columnExists(column, true, true);
            this.m_check.setVisible(exists);
            if (exists) {
                if (this.m_check.isSelected()) {
                    this.m_staticsInfo.ColumnName = column;
                    this.m_messageLabel.setForeground(this.m_darkYellow);
                    this.m_messageLabel.setText(String.format("Statics values in %s will be overwritten", column));
                    return true;
                }
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText(String.format("Statics column %s already exists", column));
                return false;
            }
            this.m_staticsInfo.ColumnName = column;
            this.m_messageLabel.setForeground(Color.blue);
            this.m_messageLabel.setText(String.format("Statics written to column %s", column));
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

