/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_ModInfo;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class Page_IMB_SelectAttribute
extends LinearLayoutWidget
implements ItemListener,
ISimpleWizardPage {
    protected DelayTimeModel_ModInfo m_modelModInfo;
    protected JComboBox<String> m_combo = new JComboBox();
    protected boolean m_ignoreCombo = true;
    protected JLabel m_messageLabel = new JLabel();
    protected String m_preferredCol = "";

    public Page_IMB_SelectAttribute(DelayTimeModel_ModInfo modelModInfo) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_modelModInfo = modelModInfo;
            this.createGapLabel(10);
            LinearLayoutWidget sub = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            sub.addComponent(new JLabel("Select attribute"), 0);
            sub.addComponent(this.m_combo, 10);
            this.m_combo.addItemListener(this);
            this.createGapLabel(10);
            this.addComponent(this.m_messageLabel, 0);
            this.dialogJustOpened();
            this.m_combo.addItemListener(this);
            this.addStretch(10);
            this.putMessage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
        try {
            this.m_ignoreCombo = true;
            this.m_combo.removeAllItems();
            this.m_combo.addItem("Weathering velocity");
            this.m_combo.setSelectedIndex(0);
            boolean weatheringOk = Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true);
            if (weatheringOk) {
                int b;
                for (b = 1; b <= this.m_modelModInfo.MaxBranch; ++b) {
                    this.m_combo.addItem(String.format("Refractor %d velocity ", b));
                    this.m_combo.addItem(String.format("Refractor %d elevation ", b));
                    this.m_combo.addItem(String.format("Refractor %d delay time ", b));
                }
                for (b = 1; b <= this.m_modelModInfo.MaxBranch; ++b) {
                    int index;
                    if (this.m_preferredCol.equalsIgnoreCase(Pecos.getColNameVel(b))) {
                        index = 1 + 3 * (b - 1);
                        this.m_combo.setSelectedIndex(index);
                    }
                    if (this.m_preferredCol.equalsIgnoreCase(Pecos.getColNameElev(b))) {
                        index = 2 + 3 * (b - 1);
                        this.m_combo.setSelectedIndex(index);
                    }
                    if (!this.m_preferredCol.equalsIgnoreCase(Pecos.getColNameDT(b))) continue;
                    index = 3 + 3 * (b - 1);
                    this.m_combo.setSelectedIndex(index);
                }
            }
            this.m_ignoreCombo = false;
            this.putMessage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void putMessage() {
        try {
            this.leavingPage();
            String s = "<HTML></HTML>";
            if (this.m_modelModInfo.ModifyElevation) {
                s = "<HTML>The software should be allowed to modify the weathering velocity after this step</HTML>";
            }
            if (this.m_modelModInfo.ModifyDelayTime) {
                s = "<HTML>Modifying the delay times here is usually not a good idea - it will invalidate the delay time solution. The refractor velocity field should be recomputed after this step.</HTML>";
            }
            if (this.m_modelModInfo.ModifyVelocity) {
                s = this.m_modelModInfo.Refractor >= 1 ? "<HTML>Modifying a refractor velocity field will invalidate the delay time solution. It is suggested that delay time analysis be redone after this step.</HTML>" : "<HTML>The software should be allowed to modify the refractor elevations using the delay time equation(s) after this step</HTML>";
            }
            this.m_messageLabel.setText(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void tryToSelectVisibleColumn(String colName) {
        try {
            this.m_preferredCol = colName;
            if (this.m_preferredCol == null) {
                this.m_preferredCol = "";
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreCombo) {
                return;
            }
            this.putMessage();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        return true;
    }

    @Override
    public void leavingPage() {
        try {
            this.m_modelModInfo.Description = (String)this.m_combo.getSelectedItem();
            this.m_modelModInfo.ModifyDelayTime = false;
            this.m_modelModInfo.ModifyVelocity = false;
            this.m_modelModInfo.ModifyElevation = false;
            int index = this.m_combo.getSelectedIndex();
            if (index >= 1) {
                int n = index - 1;
                this.m_modelModInfo.ModifyVelocity = n % 3 == 0;
                this.m_modelModInfo.ModifyElevation = n % 3 == 1;
                this.m_modelModInfo.ModifyDelayTime = n % 3 == 2;
                this.m_modelModInfo.Refractor = 1 + n / 3;
            } else {
                this.m_modelModInfo.ModifyVelocity = true;
                this.m_modelModInfo.Refractor = 0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
    }
}

