/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Page_IMB_Model_Name
extends LinearLayoutWidget
implements ItemListener,
ActionListener,
ISimpleWizardPage,
DocumentListener {
    protected JTextField m_txt = new JTextField("Version1");
    protected JLabel m_messageLabel = new JLabel("");
    protected Color m_darkYellow = new Color(150, 150, 0);

    public Page_IMB_Model_Name() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_txt = this.createSubTextField("Name of the model:", "Model1", null);
            this.m_txt.getDocument().addDocumentListener(this);
            this.addStretch(10);
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        return this.checkName();
    }

    @Override
    public void leavingPage() {
    }

    @Override
    public void activatePage() {
    }

    public boolean checkName() {
        try {
            String name = this.m_txt.getText();
            this.m_messageLabel.setText("");
            if (name.length() < 3) {
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText("Name must have at least 3 characters");
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText("Spaces and special characters not allowed");
                return false;
            }
            this.m_messageLabel.setForeground(Color.blue);
            this.m_messageLabel.setText(String.format("Model Name Ok", new Object[0]));
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

