/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataViewModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelSurfaceElevation;
import java.util.ArrayList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ModelTreeModel
implements TreeModel {
    ArrayList<TreeModelListener> _modelTreeListeners = new ArrayList();
    InteractiveModel _model;
    ModelSurfaceElevation _modelSurfaceElevation;

    public ModelTreeModel(InteractiveModel model) {
        try {
            this._model = model;
            this._modelSurfaceElevation = new ModelSurfaceElevation(this._model);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public InteractiveModel getInteractiveModel() {
        return this._model;
    }

    @Override
    public Object getRoot() {
        return this._model;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof InteractiveModel) {
            if (index == 0) {
                return this._modelSurfaceElevation;
            }
            InteractiveModel model = (InteractiveModel)parent;
            return model.getLayer(index - 1);
        }
        if (parent instanceof ModelLayer) {
            ModelLayer layer = (ModelLayer)parent;
            LayerDataType[] types = layer.getValidLayerDataTypes();
            LayerDataType dataType = types[index];
            ModelDataViewModel md = layer.getModelData(dataType).getDefaultView();
            return md;
        }
        if (parent instanceof ModelData) {
            return null;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof InteractiveModel) {
            InteractiveModel model = (InteractiveModel)parent;
            return model.getLayerCount() + 1;
        }
        if (parent instanceof ModelLayer) {
            ModelLayer layer = (ModelLayer)parent;
            LayerDataType[] types = layer.getValidLayerDataTypes();
            return types.length;
        }
        if (parent instanceof ModelData) {
            return 0;
        }
        if (parent instanceof ModelDataViewModel) {
            return 0;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof ModelSurfaceElevation) {
            return true;
        }
        if (node instanceof InteractiveModel) {
            InteractiveModel model = (InteractiveModel)node;
            int nLayers = model.getLayerCount();
            return nLayers == 0;
        }
        if (node instanceof ModelLayer) {
            return false;
        }
        if (node instanceof ModelData) {
            return true;
        }
        if (node instanceof ModelDataViewModel) {
            return true;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child instanceof ModelSurfaceElevation) {
            return 0;
        }
        if (parent instanceof InteractiveModel) {
            InteractiveModel model = (InteractiveModel)parent;
            int nLayers = model.getLayerCount();
            for (int i = 0; i < nLayers; ++i) {
                if (child != model.getLayer(i)) continue;
                return i;
            }
            return -1;
        }
        if (parent instanceof ModelLayer) {
            ModelLayer layer = (ModelLayer)parent;
            LayerDataType[] types = layer.getValidLayerDataTypes();
            int nTypes = types.length;
            for (int i = 0; i < nTypes; ++i) {
                LayerDataType dt = types[i];
                if (layer.getModelData(dt) == child) {
                    return i;
                }
                if (layer.getModelData(dt).getDefaultView() != child) continue;
                return i;
            }
            return -1;
        }
        if (parent instanceof ModelData) {
            return -1;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this._modelTreeListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this._modelTreeListeners.remove(l);
    }
}

