/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.IPropertyChangedListener;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ModelTableModel
implements TableModel,
IPropertyChangedListener {
    public static String LoadDataColumn = "Load Data          ";
    ArrayList<TableModelListener> _modelListenerList = new ArrayList();
    InteractiveModel _model;

    public ModelTableModel(InteractiveModel model) {
        this._model = model;
        this._model.addPropertyChangedListener(this);
    }

    @Override
    public int getRowCount() {
        int nRows = this._model.getSize();
        return nRows;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Name";
        }
        if (columnIndex == 1) {
            return "Type";
        }
        if (columnIndex == 2) {
            return "Load Elev";
        }
        if (columnIndex == 3) {
            return "Load Vel";
        }
        if (columnIndex == 4) {
            return "Load DT";
        }
        if (columnIndex == 5) {
            return "Filled";
        }
        if (columnIndex == 6) {
            return LoadDataColumn;
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return ModelLayerType.class;
        }
        if (columnIndex == 2) {
            return Boolean.class;
        }
        if (columnIndex == 3) {
            return Boolean.class;
        }
        if (columnIndex == 4) {
            return Boolean.class;
        }
        if (columnIndex == 5) {
            return Boolean.class;
        }
        if (columnIndex == 6) {
            return ModelLayer.class;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1 || columnIndex == 6) {
            return true;
        }
        if (columnIndex == 2 || columnIndex == 3) {
            ModelLayer layer = this._model.getLayer(rowIndex);
            ModelLayerType layerType = layer.getLayerType();
            return layerType == ModelLayerType.Refracting;
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModelLayer layer = this._model.getElementAt(rowIndex);
        if (columnIndex == 0) {
            return layer.getLayerName();
        }
        if (columnIndex == 1) {
            return layer.getLayerType();
        }
        if (columnIndex == 2) {
            ModelLayerType layerType = layer.getLayerType();
            if (layerType == ModelLayerType.Refracting) {
                return layer.getImportElevationData();
            }
            if (layerType == ModelLayerType.Base) {
                return false;
            }
            if (layerType == ModelLayerType.Free) {
                return true;
            }
            if (layerType == ModelLayerType.UpholeSurvey) {
                return true;
            }
        } else if (columnIndex == 3) {
            ModelLayerType layerType = layer.getLayerType();
            if (layerType == ModelLayerType.Refracting) {
                return layer.getImportVelocityData();
            }
            if (layerType == ModelLayerType.Base) {
                return true;
            }
            if (layerType == ModelLayerType.Free) {
                return true;
            }
            if (layerType == ModelLayerType.UpholeSurvey) {
                return true;
            }
        } else {
            if (columnIndex == 4) {
                ModelLayerType layerType = layer.getLayerType();
                if (layerType == ModelLayerType.Refracting) {
                    return true;
                }
                return false;
            }
            if (columnIndex == 5) {
                return layer.getIsFilled();
            }
            if (columnIndex == 6) {
                return layer;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ModelLayer layer = this._model.getElementAt(rowIndex);
        if (columnIndex == 0) return;
        if (columnIndex == 1) {
            ModelLayerType t = (ModelLayerType)((Object)aValue);
            if (rowIndex > 0 && t == ModelLayerType.UpholeSurvey) {
                return;
            }
            layer.setLayerType(t);
            return;
        } else if (columnIndex == 2) {
            ModelLayer upperLayer;
            ModelLayerType layerType = layer.getLayerType();
            if (layerType != ModelLayerType.Refracting) return;
            boolean bUpperLayerIsRefracting = false;
            int iLayerIndex = layer.getLayerIndex();
            int iUpperLayer = iLayerIndex - 1;
            if (iUpperLayer >= 0 && (upperLayer = layer.getModel().getLayer(iUpperLayer)).getLayerType() == ModelLayerType.Refracting) {
                bUpperLayerIsRefracting = true;
            }
            Boolean bValue = (Boolean)aValue;
            if (bUpperLayerIsRefracting) {
                if (bValue.booleanValue()) return;
                layer.setImportElevationData(bValue);
                return;
            } else {
                layer.setImportElevationData(bValue);
            }
            return;
        } else if (columnIndex == 3) {
            ModelLayer upperLayer;
            ModelLayerType layerType = layer.getLayerType();
            if (layerType != ModelLayerType.Refracting) return;
            boolean bUpperLayerIsRefracting = false;
            int iLayerIndex = layer.getLayerIndex();
            int iUpperLayer = iLayerIndex - 1;
            if (iUpperLayer >= 0 && (upperLayer = layer.getModel().getLayer(iUpperLayer)).getLayerType() == ModelLayerType.Refracting) {
                bUpperLayerIsRefracting = true;
            }
            Boolean bValue = (Boolean)aValue;
            if (bUpperLayerIsRefracting) {
                if (!bValue.booleanValue()) return;
                layer.setImportVelocityData(bValue);
                return;
            } else {
                layer.setImportVelocityData(bValue);
            }
            return;
        } else {
            if (columnIndex == 4) {
                ModelLayerType layerType = layer.getLayerType();
                if (layerType != ModelLayerType.Refracting) return;
            }
            if (columnIndex == 5) {
                Boolean bl = (Boolean)aValue;
                return;
            } else if (columnIndex != 6) return;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this._modelListenerList.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._modelListenerList.remove(l);
    }

    @Override
    public void handlePropertyChanged(Object sender, String sProperty) {
        try {
            if (sender == this._model) {
                TableModelEvent tme = new TableModelEvent(this);
                for (int i = 0; i < this._modelListenerList.size(); ++i) {
                    this._modelListenerList.get(i).tableChanged(tme);
                }
                TableModelEvent tme2 = new TableModelEvent(this, this._model.getSize());
                for (int i = 0; i < this._modelListenerList.size(); ++i) {
                    this._modelListenerList.get(i).tableChanged(tme2);
                }
                TableModelEvent tme3 = new TableModelEvent(this, this._model.getSize() - 1, this._model.getSize(), -1, 1);
                for (int i = 0; i < this._modelListenerList.size(); ++i) {
                    this._modelListenerList.get(i).tableChanged(tme3);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

