/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ImportFromDelayTimeModelDataSourcePanel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ImportFromEquationSourcePanel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ImportFromUpholeSurveyDataSourcePanel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ImportedAsciiDataSourcePanel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class LoadDataDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ItemListener {
    ModelLayer _layer;
    LinearLayoutWidget _topWidget;
    LinearLayoutWidget _bottomWidget;
    JComboBox _cmbDataSource;
    JComboBox _cmbDataType;
    JPanel _importPanel = null;
    JButton _closeButton = null;
    Boolean _bInitialized = false;
    ImportedAsciiDataSourcePanel _lastAsciiImportPanel = null;

    public LoadDataDialog(ModelLayer layer) {
        try {
            this._layer = layer;
            this.getContentPane().setLayout(new BorderLayout());
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(800, 300);
            this.setLocationRelativeTo(null);
            String sTitle = "Load Data for : " + this._layer.getLayerName() + layer.getLayerType().toString();
            this.setTitle(sTitle);
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._bottomWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._cmbDataSource = this._topWidget.createSubComboBox("Data Source", this);
            this._cmbDataType = this._topWidget.createSubComboBox("Data Type", this);
            this._closeButton = this._bottomWidget.createButton("Close", this, 0);
            Dimension minSize = new Dimension(100, 30);
            this._cmbDataSource.setMinimumSize(minSize);
            this._cmbDataType.setMinimumSize(minSize);
            this.getContentPane().add((Component)this._topWidget, "North");
            this.getContentPane().add((Component)this._bottomWidget, "South");
            LayerDataSource[] dataSources = LayerDataSource.values();
            if (layer.getLayerType() == ModelLayerType.UpholeSurvey) {
                this._cmbDataSource.addItem(LayerDataSource.UpholeSurvey);
                this._cmbDataSource.setSelectedIndex(0);
            } else {
                this._cmbDataSource.addItem(LayerDataSource.AsciiTable);
                this._cmbDataSource.addItem(LayerDataSource.DelayTimeModel);
                this._cmbDataSource.addItem(LayerDataSource.Database);
                this._cmbDataSource.addItem(LayerDataSource.Function);
                this._cmbDataSource.addItem(LayerDataSource.UpholeSurvey);
            }
            if (layer.getLayerType() == ModelLayerType.Base) {
                this._cmbDataType.addItem(LayerDataType.Velocity);
            }
            if (layer.getLayerType() == ModelLayerType.Refracting) {
                if (layer.getImportElevationData().booleanValue()) {
                    this._cmbDataType.addItem(LayerDataType.Elevation);
                }
                if (layer.getImportVelocityData().booleanValue()) {
                    this._cmbDataType.addItem(LayerDataType.Velocity);
                }
                this._cmbDataType.addItem(LayerDataType.DelayTime);
            }
            if (layer.getLayerType() == ModelLayerType.Free) {
                this._cmbDataType.addItem(LayerDataType.Elevation);
                this._cmbDataType.addItem(LayerDataType.Velocity);
            }
            if (layer.getLayerType() == ModelLayerType.UpholeSurvey) {
                this._cmbDataType.addItem(LayerDataType.Elevation);
                this._cmbDataType.addItem(LayerDataType.Velocity);
            }
            this._bInitialized = true;
            this._cmbDataType.setSelectedIndex(0);
            this.importChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._closeButton) {
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    void importChanged() {
        try {
            if (!this._bInitialized.booleanValue()) {
                return;
            }
            LayerDataSource dataSource = (LayerDataSource)((Object)this._cmbDataSource.getSelectedItem());
            LayerDataType dataType = (LayerDataType)((Object)this._cmbDataType.getSelectedItem());
            int iTest = 0;
            if (dataType == null) {
                int nItems;
                iTest = nItems = this._cmbDataType.getItemCount();
            }
            JPanel newPanel = null;
            if (dataSource == LayerDataSource.AsciiTable) {
                ImportedAsciiDataSourcePanel asciiImport = new ImportedAsciiDataSourcePanel(this._layer, dataType);
                String sColumnX = this._layer.getModel().getLastAsciiImportXColumn();
                String sColumnY = this._layer.getModel().getLastAsciiImportYColumn();
                newPanel = asciiImport;
            }
            if (dataSource == LayerDataSource.DelayTimeModel) {
                newPanel = new ImportFromDelayTimeModelDataSourcePanel(this._layer, dataType, false);
            }
            if (dataSource == LayerDataSource.Database) {
                newPanel = new ImportFromDelayTimeModelDataSourcePanel(this._layer, dataType, true);
            }
            if (dataSource == LayerDataSource.Function) {
                newPanel = new ImportFromEquationSourcePanel(this._layer, dataType, true);
            }
            if (dataSource == LayerDataSource.UpholeSurvey) {
                newPanel = new ImportFromUpholeSurveyDataSourcePanel(this._layer, dataType);
            }
            if (this._importPanel != null) {
                this.getContentPane().remove(this._importPanel);
            }
            this.getContentPane().add((Component)newPanel, "Center");
            this._importPanel = newPanel;
            Dimension d = this.getSize();
            ++d.height;
            ++d.width;
            this.setSize(d);
            --d.height;
            --d.width;
            this.setSize(d);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this._cmbDataSource == e.getSource() || this._cmbDataType == e.getSource()) {
                this.importChanged();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

