/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LayerWidget
extends LinearLayoutWidget
implements DocumentListener,
ItemListener,
ActionListener {
    protected JLabel m_lblName = new JLabel("");
    protected JComboBox m_cmbType;
    protected JButton m_btnLoadData;

    public LayerWidget() {
        super(LinearLayoutWidget.Direction.Horizontal, 3, null);
        try {
            this.m_lblName = this.createLabel("Name", 0, 10);
            this.m_cmbType = this.createSubComboBox("Type", this);
            this.m_btnLoadData = this.createButton("Load Data", this, 10);
            Dimension d = new Dimension();
            d.height = 25;
            d.width = 300;
            this.m_lblName.setMaximumSize(d);
            this.m_cmbType.setMaximumSize(d);
            ModelLayerType[] types = ModelLayerType.values();
            for (int i = 0; i < types.length; ++i) {
                this.m_cmbType.addItem(types[i]);
            }
            this.addStretch(10);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setLayer(ModelLayer layer) {
        int iLayerIndex = layer.getLayerIndex();
        int iLayerNumber = iLayerIndex + 1;
        String sLayerName = "Layer " + Integer.toString(iLayerNumber);
        this.m_lblName.setText(sLayerName);
        int nCmbItems = this.m_cmbType.getItemCount();
        int iSelectedItem = -1;
        for (int i = 0; i < nCmbItems; ++i) {
            Object objItem = this.m_cmbType.getItemAt(i);
            if (objItem != layer.getLayerType()) continue;
            iSelectedItem = i;
        }
        if (iSelectedItem > 0) {
            this.m_cmbType.setSelectedIndex(iSelectedItem);
        }
    }

    public String getLayerName() {
        return this.m_lblName.getText();
    }

    public void setLayerName(String sName) {
        this.m_lblName.setText(sName);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

