/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_ModInfo;
import com.PecosLibrary.Refraction.ProjectGridAnalyzer;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.IPropertyChangedListener;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.SelectedGeometryItem;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class InteractiveModel
implements ListModel<ModelLayer>,
IPropertyChangedListener {
    SelectedGeometryItem _selectedGeometryItem = new SelectedGeometryItem();
    ArrayList<ModelLayer> _layers = new ArrayList();
    ArrayList<ListDataListener> _dataListeners = new ArrayList();
    ArrayList<IPropertyChangedListener> _propertyChangedListeners = new ArrayList();
    IDatabaseConnection _geometryConn;
    Table_Abstract _srcTable;
    Table_Abstract _recTable;
    int _iColumnSrcElevation = -1;
    int _iColumnRecElevation = -1;
    int _iColumnGeometrySrcElevation = -1;
    int _iColumnGeometryRecElevation = -1;
    int _iColumnSrcEasting = -1;
    int _iColumnSrcNorthing = -1;
    int _iColumnRecEasting = -1;
    int _iColumnRecNorthing = -1;
    int _iColumnGeometrySrcEasting = -1;
    int _iColumnGeometryRecEasting = -1;
    int _iColumnGeometrySrcNorthing = -1;
    int _iColumnGeometryRecNorthing = -1;
    String _sModelName;
    String _sLastAsciiImportXColumn = "";
    String _sLastAsciiImportYColumn = "";
    String _sLastAsciiImportTable = "";

    public InteractiveModel() {
        this._sModelName = "";
    }

    public InteractiveModel(String sModelName) throws Exception {
        if (!InteractiveModel.doesModelExist(sModelName).booleanValue()) {
            throw new Exception("Model does not exist: " + sModelName);
        }
        this._sModelName = sModelName;
        String dir = RefractionStaticsProject.singleton().getSubPath("InteractiveModels");
        String newVersionPath = Tools_FileSystem.confirmSubDirectoryExists(dir, sModelName);
        String fileNameDB = newVersionPath + "/geometry.db";
        this._geometryConn = Tools_JDBC.getConnection(false, fileNameDB);
        UpholeModel upholeModel = RefractionStaticsProject.singleton().getUphole();
        this._srcTable = this._geometryConn.extractTableDataUsingQuery("Shot", "select * from Shot", Pecos.MaxQueryRowCount);
        this._recTable = this._geometryConn.extractTableDataUsingQuery("Receiver", "select * from Receiver", Pecos.MaxQueryRowCount);
        this._iColumnSrcElevation = this._srcTable.column_indexOfColumn("Elevation");
        this._iColumnRecElevation = this._recTable.column_indexOfColumn("Elevation");
        this._iColumnSrcEasting = this._srcTable.column_indexOfColumn("Easting");
        this._iColumnSrcNorthing = this._srcTable.column_indexOfColumn("Northing");
        this._iColumnRecEasting = this._recTable.column_indexOfColumn("Easting");
        this._iColumnRecNorthing = this._recTable.column_indexOfColumn("Northing");
        ArrayList<String> srcColumns = this._srcTable.column_listOfNames();
        ArrayList<String> recColumns = this._recTable.column_listOfNames();
        int nMaxLayers = 100;
        for (int iLayer = 0; iLayer < nMaxLayers; ++iLayer) {
            String sElevation = this.getColumnName(iLayer, LayerDataType.Elevation);
            String sVelocity = this.getColumnName(iLayer, LayerDataType.Velocity);
            String sDelayTime = this.getColumnName(iLayer, LayerDataType.DelayTime);
            Boolean bSrcElevationOk = this.containsString(srcColumns, sElevation);
            Boolean bRecElevationOk = this.containsString(recColumns, sElevation);
            Boolean bSrcVelOk = this.containsString(srcColumns, sVelocity);
            Boolean bRecVelOk = this.containsString(recColumns, sVelocity);
            Boolean bSrcDtOk = this.containsString(srcColumns, sDelayTime);
            Boolean bRecDtOk = this.containsString(recColumns, sDelayTime);
            if (bSrcElevationOk.booleanValue() && bRecElevationOk.booleanValue() && bSrcVelOk.booleanValue() && bRecVelOk.booleanValue() && bSrcDtOk.booleanValue() && bRecDtOk.booleanValue()) {
                this._layers.add(new ModelLayer(ModelLayerType.Refracting, this, iLayer));
                continue;
            }
            if (bSrcElevationOk.booleanValue() && bRecElevationOk.booleanValue() && bSrcVelOk.booleanValue() && bRecVelOk.booleanValue()) {
                if (iLayer == 0 && upholeModel != null) {
                    ModelLayer tmpLayer = new ModelLayer(ModelLayerType.UpholeSurvey, this, iLayer);
                    tmpLayer.setUpholeModel(upholeModel);
                    this._layers.add(tmpLayer);
                    continue;
                }
                this._layers.add(new ModelLayer(ModelLayerType.Free, this, iLayer));
                continue;
            }
            if (!bSrcVelOk.booleanValue() || !bRecVelOk.booleanValue()) continue;
            this._layers.add(new ModelLayer(ModelLayerType.Base, this, iLayer));
        }
    }

    public String getLastAsciiImportXColumn() {
        return this._sLastAsciiImportXColumn;
    }

    public String getLastAsciiImportYColumn() {
        return this._sLastAsciiImportYColumn;
    }

    public String getLastAsciiImportTable() {
        return this._sLastAsciiImportTable;
    }

    public void setLastAsciiImportXColumn(String sX) {
        this._sLastAsciiImportXColumn = sX;
    }

    public void setLastAsciiImportYColumn(String sY) {
        this._sLastAsciiImportYColumn = sY;
    }

    public void setLastAsciiImportTable(String sTable) {
        this._sLastAsciiImportTable = sTable;
    }

    public void calculateThickness() {
        try {
            int nSrc = this.getSourceCount();
            int nRec = this.getReceiverCount();
            int nLayers = this.getLayerCount();
            double dMinThickness = Double.MAX_VALUE;
            double dMaxThickness = Double.MIN_VALUE;
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                double dThickness;
                double dElevation;
                double dUpperElev;
                int i;
                ModelLayer layer = this.getLayer(iLayer);
                ModelLayerType lt = layer.getLayerType();
                if (lt == ModelLayerType.Base) continue;
                for (i = 0; i < nSrc; ++i) {
                    dUpperElev = iLayer == 0 ? this.getSurfaceElevation(i, true) : this.getLayer(iLayer - 1).getElevation(i, true);
                    dThickness = dUpperElev - (dElevation = layer.getElevation(i, true));
                    if (dThickness < dMinThickness) {
                        dMinThickness = dThickness;
                    }
                    if (dThickness > dMaxThickness) {
                        dMaxThickness = dThickness;
                    }
                    layer.setThickness(i, true, dThickness);
                }
                for (i = 0; i < nRec; ++i) {
                    dUpperElev = iLayer == 0 ? this.getSurfaceElevation(i, false) : this.getLayer(iLayer - 1).getElevation(i, false);
                    dThickness = dUpperElev - (dElevation = layer.getElevation(i, false));
                    if (dThickness < dMinThickness) {
                        dMinThickness = dThickness;
                    }
                    if (dThickness > dMaxThickness) {
                        dMaxThickness = dThickness;
                    }
                    layer.setThickness(i, false, dThickness);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public SelectedGeometryItem getSelectedItem() {
        return this._selectedGeometryItem;
    }

    public void setSelectedItem(int index, Boolean bShotIsClosest) {
        try {
            this._selectedGeometryItem.Index = index;
            this._selectedGeometryItem.IsSrc = bShotIsClosest;
            int nListeners = this._propertyChangedListeners.size();
            for (int i = 0; i < nListeners; ++i) {
                this._propertyChangedListeners.get(i).handlePropertyChanged(this, "SelectedItem");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void close() {
        try {
            if (this._geometryConn != null) {
                this._geometryConn.closeConnection();
            }
            this._geometryConn = null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String toString() {
        if (this._sModelName.length() < 1) {
            return "empty model";
        }
        return this._sModelName;
    }

    public String getModelName() {
        return this._sModelName;
    }

    public int getLayerCount() {
        return this._layers.size();
    }

    public ModelLayer getLayer(int index) {
        return this._layers.get(index);
    }

    public int getShotElevationColumn() {
        return this._iColumnSrcElevation;
    }

    public int getRecElevationColumn() {
        return this._iColumnRecElevation;
    }

    public Range_Double getSurfaceElevationRange() throws Exception {
        double dVal;
        Range_Double r = new Range_Double();
        if (this._iColumnSrcElevation < 0) {
            return r;
        }
        int nSrc = this.getSourceCount();
        int nRec = this.getReceiverCount();
        for (int iSrc = 0; iSrc < nSrc; ++iSrc) {
            dVal = this.getSurfaceElevation(iSrc, true);
            r.expandRange(dVal);
        }
        for (int iRec = 0; iRec < nRec; ++iRec) {
            dVal = this.getSurfaceElevation(iRec, false);
            r.expandRange(dVal);
        }
        return r;
    }

    Boolean containsString(ArrayList<String> list, String sVal) {
        int size = list.size();
        String sUpperCaseVal = sVal.toUpperCase();
        for (int i = 0; i < size; ++i) {
            if (!list.get(i).toUpperCase().equals(sUpperCaseVal)) continue;
            return true;
        }
        return false;
    }

    public static Boolean doesModelExist(String sModelName) {
        ArrayList<String> modelNames = InteractiveModel.getModelNames();
        for (int i = 0; i < modelNames.size(); ++i) {
            if (!modelNames.get(i).equals(sModelName)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int iLayer, LayerDataType dt) {
        Object sColumn = "";
        if (dt == LayerDataType.Elevation) {
            sColumn = "IMB_Elevation_" + Integer.toString(iLayer);
        } else if (dt == LayerDataType.Velocity) {
            sColumn = "IMB_Velocity_" + Integer.toString(iLayer);
        } else if (dt == LayerDataType.DelayTime) {
            sColumn = "IMB_DelayTime_" + Integer.toString(iLayer);
        } else if (dt == LayerDataType.Thickness) {
            sColumn = "IMB_Thickness_" + Integer.toString(iLayer);
        }
        return sColumn;
    }

    public void writeModelToDatabase(String sModelName, boolean bUpdateModel) {
        try {
            ModelLayer firstLayer;
            if (InteractiveModel.doesModelExist(sModelName).booleanValue() && !bUpdateModel) {
                throw new Exception("Model already exists: " + sModelName);
            }
            String dir = RefractionStaticsProject.singleton().getSubPath("InteractiveModels");
            String newVersionPath = Tools_FileSystem.confirmSubDirectoryExists(dir, sModelName);
            String fileNameDB = newVersionPath + "/geometry.db";
            IDatabaseConnection geometryConn = Tools_JDBC.getConnection(false, fileNameDB);
            Table_Abstract geometrySrcTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract geometryRecTable = RefractionStaticsProject.singleton().receiverTable();
            ArrayList<String> oldTables = geometryConn.getTableNames();
            for (String oldTable : oldTables) {
                geometryConn.dropTable(oldTable);
            }
            geometryConn.createDatabaseTable(geometrySrcTable);
            geometryConn.appendTable(geometrySrcTable, 0);
            geometryConn.createDatabaseTable(geometryRecTable);
            geometryConn.appendTable(geometryRecTable, 0);
            int nLayers = this._layers.size();
            if (nLayers > 0 && (firstLayer = this._layers.get(0)).getLayerType() == ModelLayerType.UpholeSurvey) {
                UpholeModel upholeModel = firstLayer.getUpholeModel();
                if (upholeModel == null) {
                    throw new Exception("Null uphole model");
                }
                upholeModel.save(geometryConn, "Uphole");
            }
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                ModelLayer layer = this._layers.get(iLayer);
                LayerDataType[] validTypes = layer.getValidLayerDataTypes();
                for (int iType = 0; iType < validTypes.length; ++iType) {
                    LayerDataType dt = validTypes[iType];
                    ModelData md = layer.getModelData(dt);
                    String sColumnName = this.getColumnName(iLayer, dt);
                    if (!geometryConn.columnExists("Shot", sColumnName)) {
                        geometryConn.addColumnNotNull("Shot", sColumnName, DataType.Double);
                    }
                    if (geometryConn.columnExists("Receiver", sColumnName)) continue;
                    geometryConn.addColumnNotNull("Receiver", sColumnName, DataType.Double);
                }
            }
            Table_Abstract srcTable = geometryConn.extractTableDataUsingQuery("Shot", "select * from Shot", Pecos.MaxQueryRowCount);
            Table_Abstract recTable = geometryConn.extractTableDataUsingQuery("Receiver", "select * from Receiver", Pecos.MaxQueryRowCount);
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                ModelLayer layer = this._layers.get(iLayer);
                LayerDataType[] validTypes = layer.getValidLayerDataTypes();
                for (int iType = 0; iType < validTypes.length; ++iType) {
                    double dVal;
                    int iRow;
                    LayerDataType dt = validTypes[iType];
                    ModelData md = layer.getModelData(dt);
                    String sColumnName = this.getColumnName(iLayer, dt);
                    double[] srcData = md.getDataLoadSourceValues();
                    double[] recData = md.getDataLoadReceiverValues();
                    int iSrcColumn = srcTable.column_indexOfColumn(sColumnName);
                    int iRecColumn = recTable.column_indexOfColumn(sColumnName);
                    int nSrcTableRows = srcTable.row_count();
                    int nRecTableRows = recTable.row_count();
                    if (nSrcTableRows != srcData.length) {
                        throw new Exception("invalid Source Table Row count");
                    }
                    if (nRecTableRows != recData.length) {
                        throw new Exception("invalid Receiver Table Row count");
                    }
                    for (iRow = 0; iRow < srcData.length; ++iRow) {
                        dVal = srcData[iRow];
                        srcTable.putDouble(iRow, iSrcColumn, dVal);
                    }
                    for (iRow = 0; iRow < recData.length; ++iRow) {
                        dVal = recData[iRow];
                        recTable.putDouble(iRow, iRecColumn, dVal);
                    }
                    geometryConn.writeColumnContentsToDatabase(srcTable, sColumnName);
                    geometryConn.writeColumnContentsToDatabase(recTable, sColumnName);
                }
            }
            geometryConn.closeConnection();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static ArrayList<String> getModelNames() {
        ArrayList<String> modelNames = new ArrayList<String>();
        try {
            String dir = RefractionStaticsProject.singleton().getSubPath("InteractiveModels");
            modelNames = Tools_FileSystem.subdirectories(dir, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return modelNames;
    }

    public static InteractiveModel createNewInMemoryModel() {
        InteractiveModel model = null;
        model = new InteractiveModel();
        return model;
    }

    public int getSourceCount() {
        if (this._srcTable == null) {
            return RefractionStaticsProject.singleton().shotTable().row_count();
        }
        return this._srcTable.row_count();
    }

    public int getReceiverCount() {
        if (this._recTable == null) {
            return RefractionStaticsProject.singleton().receiverTable().row_count();
        }
        return this._recTable.row_count();
    }

    public Table_Abstract getSourceTable() {
        return this._srcTable;
    }

    public Table_Abstract getReceiverTable() {
        return this._recTable;
    }

    public void sendPropertyChangedEvent(String sProperty) {
        try {
            for (int i = 0; i < this._propertyChangedListeners.size(); ++i) {
                this._propertyChangedListeners.get(i).handlePropertyChanged(this, sProperty);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addPropertyChangedListener(IPropertyChangedListener l) {
        this._propertyChangedListeners.add(l);
    }

    public void removePropertyChangedListener(IPropertyChangedListener l) {
        this._propertyChangedListeners.remove(l);
    }

    public int getLayerIndex(ModelLayer layer) {
        for (int i = 0; i < this._layers.size(); ++i) {
            ModelLayer layerAtIndex = this._layers.get(i);
            if (layer != layerAtIndex) continue;
            return i;
        }
        return -1;
    }

    public void addModelLayer(ModelLayer layer) {
        try {
            this._layers.add(layer);
            int index = this._layers.size() - 1;
            ListDataEvent event = new ListDataEvent(this, 1, index, index);
            for (int i = 0; i < this._dataListeners.size(); ++i) {
                ListDataListener listener = this._dataListeners.get(i);
                listener.contentsChanged(event);
            }
            this.sendPropertyChangedEvent("Layers");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public int getSize() {
        return this._layers.size();
    }

    @Override
    public ModelLayer getElementAt(int index) {
        ModelLayer layer = this._layers.get(index);
        return layer;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (!this._dataListeners.contains(l)) {
            this._dataListeners.add(l);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this._dataListeners.contains(l)) {
            this._dataListeners.remove(l);
        }
    }

    @Override
    public void handlePropertyChanged(Object sender, String sProperty) {
        try {
            if (sender instanceof ModelLayer && sProperty.equals("LayerType")) {
                ModelLayer layer = (ModelLayer)sender;
                this.addMinimimLayers();
                this.removeLayersAfterBaseLayer();
                this.addBaseLayerAfterLastRefactingLayer();
                this.removeLayersAfterBaseLayer();
                this.sendPropertyChangedEvent("LayerData");
            }
            if (sender instanceof ModelLayer && sProperty.equals("LayerData")) {
                this.sendPropertyChangedEvent("LayerData");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void addMinimimLayers() {
        try {
            int nLayers = this._layers.size();
            if (nLayers == 1 && (this._layers.get(0).getLayerType() == ModelLayerType.Free || this._layers.get(0).getLayerType() == ModelLayerType.Refracting || this._layers.get(0).getLayerType() == ModelLayerType.UpholeSurvey)) {
                this._layers.add(1, new ModelLayer(ModelLayerType.Base, this));
                this.sendPropertyChangedEvent("Layers");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void addBaseLayerAfterLastRefactingLayer() {
        try {
            if (this._layers.isEmpty()) {
                this.addModelLayer(new ModelLayer(ModelLayerType.Base, this));
            } else {
                Boolean bLayersChanged = false;
                int nLayers = this._layers.size();
                ModelLayerType layerType = this._layers.get(nLayers - 1).getLayerType();
                if (layerType == ModelLayerType.Free || layerType == ModelLayerType.Refracting || layerType == ModelLayerType.UpholeSurvey) {
                    this._layers.add(nLayers, new ModelLayer(ModelLayerType.Base, this));
                    bLayersChanged = true;
                }
                if (bLayersChanged.booleanValue()) {
                    this.sendPropertyChangedEvent("Layers");
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeLayer(ModelLayer layer) {
        try {
            this._layers.remove(layer);
            this.removeLayersAfterBaseLayer();
            this.addBaseLayerAfterLastRefactingLayer();
            this.removeLayersAfterBaseLayer();
            this.sendPropertyChangedEvent("LayerData");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void removeLayersAfterBaseLayer() {
        try {
            int i;
            int nLayers = this._layers.size();
            ArrayList<ModelLayer> layersToRemove = new ArrayList<ModelLayer>();
            Boolean bFoundBase = false;
            for (i = 0; i < nLayers; ++i) {
                if (bFoundBase.booleanValue()) {
                    layersToRemove.add(this._layers.get(i));
                }
                if (this._layers.get(i).getLayerType() != ModelLayerType.Base) continue;
                bFoundBase = true;
            }
            for (i = 0; i < layersToRemove.size(); ++i) {
                this._layers.remove(layersToRemove.get(i));
            }
            if (layersToRemove.size() > 0) {
                this.sendPropertyChangedEvent("Layers");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public IDatabaseConnection geometryDatabase() {
        return this._geometryConn;
    }

    public void calculateElevation(ModelLayer layer, int iIndex, Boolean bSrc, double dMinimumThickness) throws Exception {
        ModelLayerType layerType;
        int iLayerIndex;
        block29: {
            double dUpperLayerElevation;
            block28: {
                iLayerIndex = layer.getLayerIndex();
                layerType = layer.getLayerType();
                if (layer.getLayerElevationValid(iIndex, bSrc).booleanValue()) {
                    return;
                }
                if (layerType == ModelLayerType.Base) {
                    return;
                }
                if (layerType == ModelLayerType.Free) break block28;
                if (layerType != ModelLayerType.UpholeSurvey) break block29;
            }
            if (iLayerIndex > 0) {
                int iUpperLayer = iLayerIndex - 1;
                ModelLayer upperLayer = this.getLayer(iUpperLayer);
                if (!upperLayer.getLayerElevationValid(iIndex, bSrc).booleanValue()) {
                    this.calculateElevation(upperLayer, iIndex, bSrc, dMinimumThickness);
                }
                dUpperLayerElevation = upperLayer.getElevation(iIndex, bSrc);
            } else {
                dUpperLayerElevation = this.getSurfaceElevation(iIndex, bSrc);
            }
            double dElevation = layer.getProvisionalElevation(iIndex, bSrc);
            double dThickness = dUpperLayerElevation - dElevation;
            int iTest = 0;
            if (!bSrc.booleanValue() && iIndex == 0) {
                ++iTest;
            }
            if (dThickness < dMinimumThickness) {
                dElevation = dUpperLayerElevation - dMinimumThickness;
                layer.setElevation(iIndex, bSrc, dElevation);
            }
            layer.setLayerElevationValid(iIndex, bSrc, true);
            return;
        }
        if (layerType == ModelLayerType.Refracting) {
            double dElevation;
            int iIndexUpperLayer = iLayerIndex - 1;
            ModelLayer upperLayer = null;
            ModelLayer lowerLayer = this.getLayer(iLayerIndex + 1);
            if (iIndexUpperLayer >= 0) {
                upperLayer = this.getLayer(iIndexUpperLayer);
            }
            if (upperLayer != null) {
                this.calculateElevation(upperLayer, iIndex, bSrc, dMinimumThickness);
            }
            double dVelUpper = layer.getVelocity(iIndex, bSrc);
            double dVelLower = lowerLayer.getVelocity(iIndex, bSrc);
            double dDelayTime = layer.getDelayTime(iIndex, bSrc);
            double dDelayTimeFromUpperLayers = 0.0;
            for (int iTmpLayer = 0; iTmpLayer < iLayerIndex; ++iTmpLayer) {
                ModelLayer tmpLayer = this.getLayer(iTmpLayer);
                double dTmpVel = tmpLayer.getVelocity(iIndex, bSrc);
                dElevation = tmpLayer.getElevation(iIndex, bSrc);
                double dUpperElevation = iTmpLayer == 0 ? this.getSurfaceElevation(iIndex, bSrc) : this.getLayer(iTmpLayer - 1).getElevation(iIndex, bSrc);
                double dPartialDelayTime = 0.0;
                if (tmpLayer.getLayerType() == ModelLayerType.UpholeSurvey) {
                    if (iTmpLayer != 0) {
                        throw new Exception("Uphole survey layer must be the first layer");
                    }
                    dPartialDelayTime = tmpLayer.getPartialDelayTime(iIndex, bSrc, dVelLower);
                    if (dPartialDelayTime < 0.0) {
                        throw new Exception("velocity inversions were found in the interpolated uphole survey");
                    }
                } else {
                    double dThickness = dUpperElevation - dElevation;
                    if (dThickness < 0.0) {
                        dThickness = 0.0;
                    }
                    dPartialDelayTime = 1000.0 * dThickness / dTmpVel * Math.cos(Math.asin(dTmpVel / dVelLower));
                }
                dDelayTimeFromUpperLayers += dPartialDelayTime;
            }
            double dRemainingDelayTime = dDelayTime - dDelayTimeFromUpperLayers;
            if (dRemainingDelayTime <= 0.0) {
                double dUpperElevation = iLayerIndex == 0 ? this.getSurfaceElevation(iIndex, bSrc) : this.getLayer(iLayerIndex - 1).getElevation(iIndex, bSrc);
                dElevation = dUpperElevation - dMinimumThickness;
                layer.setElevation(iIndex, bSrc, dElevation);
            } else {
                double dThickness;
                double dUpperElevation = iLayerIndex == 0 ? this.getSurfaceElevation(iIndex, bSrc) : this.getLayer(iLayerIndex - 1).getElevation(iIndex, bSrc);
                if (dVelLower <= dVelUpper) {
                    dVelUpper = dVelLower * 0.99;
                    layer.setVelocity(iIndex, bSrc, dVelUpper);
                }
                if ((dThickness = 0.001 * dRemainingDelayTime / (Math.sqrt(dVelLower * dVelLower - dVelUpper * dVelUpper) / (dVelUpper * dVelLower))) < dMinimumThickness) {
                    dThickness = dMinimumThickness;
                    double dVal = dVelLower * 0.001 * dRemainingDelayTime / dMinimumThickness;
                    double dNewVelUsingMinThickness = dVelLower / Math.sqrt(dVal * dVal + 1.0);
                    layer.setVelocity(iIndex, bSrc, dNewVelUsingMinThickness);
                    double dThicknessTest = 0.001 * dRemainingDelayTime / (Math.sqrt(dVelLower * dVelLower - dNewVelUsingMinThickness * dNewVelUsingMinThickness) / (dNewVelUsingMinThickness * dVelLower));
                    double dDiff = dThicknessTest - dMinimumThickness;
                    if (dDiff > 0.5) {
                        throw new Exception("Invalid Velocity using Minimum Thickness");
                    }
                }
                dElevation = dUpperElevation - dThickness;
                layer.setElevation(iIndex, bSrc, dElevation);
            }
        }
    }

    public void calculateVelocity(ModelLayer layer, int iIndex, Boolean bSrc, double dMinimumThickness) throws Exception {
        ModelLayerType layerType;
        int iLayerIndex;
        block19: {
            block18: {
                iLayerIndex = layer.getLayerIndex();
                layerType = layer.getLayerType();
                if (layer.getLayerVelocityValid(iIndex, bSrc).booleanValue()) {
                    return;
                }
                if (layerType == ModelLayerType.Base) {
                    layer.setLayerVelocityValid(iIndex, bSrc, true);
                    return;
                }
                if (layerType == ModelLayerType.Free) break block18;
                if (layerType != ModelLayerType.UpholeSurvey) break block19;
            }
            layer.setLayerVelocityValid(iIndex, bSrc, true);
            return;
        }
        if (layerType == ModelLayerType.Refracting) {
            double dElevation;
            int iIndexUpperLayer = iLayerIndex - 1;
            ModelLayer upperLayer = null;
            ModelLayer lowerLayer = this.getLayer(iLayerIndex + 1);
            if (iIndexUpperLayer >= 0) {
                upperLayer = this.getLayer(iIndexUpperLayer);
            }
            if (upperLayer != null) {
                this.calculateElevation(upperLayer, iIndex, bSrc, dMinimumThickness);
            }
            this.calculateVelocity(lowerLayer, iIndex, bSrc, dMinimumThickness);
            double dVelLower = lowerLayer.getVelocity(iIndex, bSrc);
            double dDelayTime = layer.getDelayTime(iIndex, bSrc);
            double dDelayTimeFromUpperLayers = 0.0;
            for (int iTmpLayer = 0; iTmpLayer < iLayerIndex; ++iTmpLayer) {
                ModelLayer tmpLayer = this.getLayer(iTmpLayer);
                double dTmpVel = tmpLayer.getVelocity(iIndex, bSrc);
                double dUpperElevation = iTmpLayer == 0 ? this.getSurfaceElevation(iIndex, bSrc) : this.getLayer(iTmpLayer - 1).getElevation(iIndex, bSrc);
                double dThickness = dUpperElevation - (dElevation = tmpLayer.getElevation(iIndex, bSrc));
                if (dThickness < dMinimumThickness) {
                    throw new Exception("invalid thickness");
                }
                double dPartialDelayTime = 0.0;
                if (tmpLayer.getLayerType() == ModelLayerType.UpholeSurvey) {
                    if (iTmpLayer != 0) {
                        throw new Exception("Uphole survey layer must be the first layer");
                    }
                    dPartialDelayTime = tmpLayer.getPartialDelayTime(iIndex, bSrc, dVelLower);
                    if (!(dPartialDelayTime < 0.0)) continue;
                    throw new Exception("velocity inversions were found in the interpolated uphole survey");
                }
                dPartialDelayTime = 1000.0 * dThickness / dTmpVel * Math.cos(Math.asin(dTmpVel / dVelLower));
                dDelayTimeFromUpperLayers += dPartialDelayTime;
            }
            double dRemainingDelayTime = dDelayTime - dDelayTimeFromUpperLayers;
            if (dRemainingDelayTime <= 0.0) {
                double dUpperElevation = iLayerIndex == 0 ? this.getSurfaceElevation(iIndex, bSrc) : this.getLayer(iLayerIndex - 1).getElevation(iIndex, bSrc);
                dElevation = dUpperElevation - dMinimumThickness;
                layer.setElevation(iIndex, bSrc, dElevation);
                layer.setVelocity(iIndex, bSrc, dVelLower * 0.999);
            } else {
                double dUpperElevation = iLayerIndex == 0 ? this.getSurfaceElevation(iIndex, bSrc) : this.getLayer(iLayerIndex - 1).getElevation(iIndex, bSrc);
                double dThickness = dUpperElevation - (dElevation = layer.getElevation(iIndex, bSrc));
                if (dThickness < dMinimumThickness) {
                    dElevation = dUpperElevation - dMinimumThickness;
                    layer.setElevation(iIndex, bSrc, dElevation);
                }
                this.computeRefractingLayerVelocity(iLayerIndex, iIndex, bSrc, dMinimumThickness, dRemainingDelayTime);
            }
        }
    }

    public void computeRefractingLayerVelocity(int iLayer, int index, Boolean bSrc, double dMinThickness, double dRemainingDelayTime) throws Exception {
        try {
            double error;
            double dElevation;
            double dThickness;
            int n;
            double bestV0;
            double minError;
            int iter;
            int nLayers = this.getLayerCount();
            int iMaxLayerWithElev = nLayers - 2;
            if (iLayer < 0) {
                throw new Exception("Invalid Layer");
            }
            if (iLayer > iMaxLayerWithElev) {
                throw new Exception("Invalid Layer");
            }
            ModelLayer layer = this.getLayer(iLayer);
            ModelLayer lowerLayer = this.getLayer(iLayer + 1);
            double dVelLower = lowerLayer.getVelocity(index, bSrc);
            double dElevationUpper = iLayer == 0 ? this.getSurfaceElevation(index, bSrc) : this.getLayer(iLayer - 1).getElevation(index, bSrc);
            double desired = layer.getElevation(index, bSrc);
            double minV0 = 10.0;
            double maxV0 = 0.99 * dVelLower;
            double range = maxV0 - minV0;
            int num = 20;
            double delta = range / (double)num;
            double dVelocity = 1.0;
            for (iter = 0; iter < 5; ++iter) {
                minError = 1.0E100;
                bestV0 = 1.0;
                for (n = 0; n <= num; ++n) {
                    dVelocity = minV0 + (double)n * delta;
                    dThickness = 0.001 * dRemainingDelayTime / (Math.sqrt(dVelLower * dVelLower - dVelocity * dVelocity) / (dVelocity * dVelLower));
                    dElevation = dElevationUpper - dThickness;
                    error = Math.abs(desired - dElevation);
                    if (!(error < minError)) continue;
                    bestV0 = dVelocity;
                    minError = error;
                }
                dVelocity = bestV0;
                minV0 = bestV0 - 2.0 * delta;
                minV0 = Math.max(10.0, minV0);
                maxV0 = bestV0 + 2.0 * delta;
                maxV0 = Math.min(0.99 * dVelLower, maxV0);
                range = maxV0 - minV0;
                delta = range / (double)num;
            }
            dThickness = 0.001 * dRemainingDelayTime / (Math.sqrt(dVelLower * dVelLower - dVelocity * dVelocity) / (dVelocity * dVelLower));
            if (dThickness < dMinThickness) {
                desired = dElevationUpper - dMinThickness;
                for (iter = 0; iter < 5; ++iter) {
                    minError = 1.0E100;
                    bestV0 = 1.0;
                    for (n = 0; n <= num; ++n) {
                        dVelocity = minV0 + (double)n * delta;
                        dThickness = 0.001 * dRemainingDelayTime / (Math.sqrt(dVelLower * dVelLower - dVelocity * dVelocity) / (dVelocity * dVelLower));
                        dElevation = dElevationUpper - dThickness;
                        error = Math.abs(desired - dElevation);
                        if (!(error < minError)) continue;
                        bestV0 = dVelocity;
                        minError = error;
                    }
                    dVelocity = bestV0;
                    minV0 = bestV0 - 2.0 * delta;
                    minV0 = Math.max(10.0, minV0);
                    maxV0 = bestV0 + 2.0 * delta;
                    maxV0 = Math.min(0.99 * dVelLower, maxV0);
                    range = maxV0 - minV0;
                    delta = range / (double)num;
                }
                layer.setElevation(index, bSrc, desired);
            }
            layer.setVelocity(index, bSrc, dVelocity);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void buildModel(double dMinimumThickness) {
        try {
            int iRec;
            int iSrc;
            ModelLayer layer;
            int iLayer;
            int nLayers = this._layers.size();
            int nSrc = this.getSourceCount();
            int nRec = this.getReceiverCount();
            for (iLayer = 0; iLayer < nLayers; ++iLayer) {
                layer = this._layers.get(iLayer);
                ModelLayerType layerType = layer.getLayerType();
                for (iSrc = 0; iSrc < nSrc; ++iSrc) {
                    if (layerType == ModelLayerType.Base) {
                        layer.setLayerDelayTimeValid(iSrc, true, false);
                        layer.setLayerElevationValid(iSrc, true, false);
                        layer.setLayerVelocityValid(iSrc, true, true);
                        continue;
                    }
                    if (layerType == ModelLayerType.Free) {
                        layer.setLayerDelayTimeValid(iSrc, true, false);
                        layer.setLayerElevationValid(iSrc, true, false);
                        layer.setLayerVelocityValid(iSrc, true, true);
                        continue;
                    }
                    if (layerType == ModelLayerType.UpholeSurvey) {
                        layer.setLayerDelayTimeValid(iSrc, true, false);
                        layer.setLayerElevationValid(iSrc, true, false);
                        layer.setLayerVelocityValid(iSrc, true, true);
                        continue;
                    }
                    if (layerType != ModelLayerType.Refracting) continue;
                    layer.setLayerDelayTimeValid(iSrc, true, true);
                    layer.setLayerElevationValid(iSrc, true, false);
                    layer.setLayerVelocityValid(iSrc, true, false);
                    if (layer.getImportElevationData().booleanValue()) {
                        layer.setLayerElevationValid(iSrc, true, true);
                    }
                    if (!layer.getImportVelocityData().booleanValue()) continue;
                    layer.setLayerVelocityValid(iSrc, true, true);
                }
                for (iRec = 0; iRec < nRec; ++iRec) {
                    if (layerType == ModelLayerType.Base) {
                        layer.setLayerDelayTimeValid(iRec, false, false);
                        layer.setLayerElevationValid(iRec, false, false);
                        layer.setLayerVelocityValid(iRec, false, true);
                        continue;
                    }
                    if (layerType == ModelLayerType.Free) {
                        layer.setLayerDelayTimeValid(iRec, false, false);
                        layer.setLayerElevationValid(iRec, false, false);
                        layer.setLayerVelocityValid(iRec, false, true);
                        continue;
                    }
                    if (layerType == ModelLayerType.UpholeSurvey) {
                        layer.setLayerDelayTimeValid(iRec, false, false);
                        layer.setLayerElevationValid(iRec, false, false);
                        layer.setLayerVelocityValid(iRec, false, true);
                        continue;
                    }
                    if (layerType != ModelLayerType.Refracting) continue;
                    layer.setLayerDelayTimeValid(iRec, false, true);
                    layer.setLayerElevationValid(iRec, false, false);
                    layer.setLayerVelocityValid(iRec, false, false);
                    if (layer.getImportElevationData().booleanValue()) {
                        layer.setLayerElevationValid(iRec, false, true);
                    }
                    if (!layer.getImportVelocityData().booleanValue()) continue;
                    layer.setLayerVelocityValid(iRec, false, true);
                }
            }
            if (nLayers == 1) {
                return;
            }
            for (iLayer = 0; iLayer < nLayers; ++iLayer) {
                layer = this.getLayer(iLayer);
                ModelLayerType mlt = layer.getLayerType();
                if (mlt == ModelLayerType.Free) {
                    for (iSrc = 0; iSrc < nSrc; ++iSrc) {
                        this.calculateElevation(layer, iSrc, true, dMinimumThickness);
                    }
                    for (iRec = 0; iRec < nRec; ++iRec) {
                        this.calculateElevation(layer, iRec, false, dMinimumThickness);
                    }
                }
                if (mlt == ModelLayerType.UpholeSurvey) {
                    for (iSrc = 0; iSrc < nSrc; ++iSrc) {
                        this.calculateElevation(layer, iSrc, true, dMinimumThickness);
                    }
                    for (iRec = 0; iRec < nRec; ++iRec) {
                        this.calculateElevation(layer, iRec, false, dMinimumThickness);
                    }
                }
                if (mlt != ModelLayerType.Refracting) continue;
                if (layer.getImportElevationData().booleanValue()) {
                    for (iSrc = 0; iSrc < nSrc; ++iSrc) {
                        this.calculateVelocity(layer, iSrc, true, dMinimumThickness);
                    }
                    for (iRec = 0; iRec < nRec; ++iRec) {
                        this.calculateVelocity(layer, iRec, false, dMinimumThickness);
                    }
                }
                if (!layer.getImportVelocityData().booleanValue()) continue;
                for (iSrc = 0; iSrc < nSrc; ++iSrc) {
                    this.calculateElevation(layer, iSrc, true, dMinimumThickness);
                }
                for (iRec = 0; iRec < nRec; ++iRec) {
                    this.calculateElevation(layer, iRec, false, dMinimumThickness);
                }
            }
            this.calculateThickness();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double getSurfaceElevation(int iIndex, Boolean bSrc) throws Exception {
        double dSurfaceElevation = 0.0;
        if (this._iColumnSrcElevation >= 0 && this._iColumnRecElevation >= 0) {
            if (bSrc.booleanValue()) {
                int iSrcElevationColumn = this.getShotElevationColumn();
                dSurfaceElevation = this._srcTable.getDouble(iIndex, iSrcElevationColumn);
            } else {
                int iRecElevationColumn = this.getRecElevationColumn();
                dSurfaceElevation = this._recTable.getDouble(iIndex, iRecElevationColumn);
            }
        } else {
            if (this._iColumnGeometrySrcElevation < 0) {
                this._iColumnGeometrySrcElevation = RefractionStaticsProject.singleton().shotTable().column_indexOfColumn("Elevation");
            }
            if (this._iColumnGeometryRecElevation < 0) {
                this._iColumnGeometryRecElevation = RefractionStaticsProject.singleton().receiverTable().column_indexOfColumn("Elevation");
            }
            dSurfaceElevation = bSrc != false ? RefractionStaticsProject.singleton().shotTable().getDouble(iIndex, this._iColumnGeometrySrcElevation) : RefractionStaticsProject.singleton().receiverTable().getDouble(iIndex, this._iColumnGeometryRecElevation);
        }
        return dSurfaceElevation;
    }

    public double getGeometryEasting(int iIndex, Boolean bSrc) throws Exception {
        double dEasting = 0.0;
        if (this._iColumnSrcEasting >= 0 && this._iColumnRecEasting >= 0) {
            if (bSrc.booleanValue()) {
                int iSrcEastingColumn = this._iColumnSrcEasting;
                dEasting = this._srcTable.getDouble(iIndex, iSrcEastingColumn);
            } else {
                int iRecEastingColumn = this._iColumnRecEasting;
                dEasting = this._recTable.getDouble(iIndex, iRecEastingColumn);
            }
        } else {
            if (this._iColumnGeometrySrcEasting < 0) {
                this._iColumnGeometrySrcEasting = RefractionStaticsProject.singleton().shotTable().column_indexOfColumn("Easting");
            }
            if (this._iColumnGeometryRecEasting < 0) {
                this._iColumnGeometryRecEasting = RefractionStaticsProject.singleton().receiverTable().column_indexOfColumn("Easting");
            }
            dEasting = bSrc != false ? RefractionStaticsProject.singleton().shotTable().getDouble(iIndex, this._iColumnGeometrySrcEasting) : RefractionStaticsProject.singleton().receiverTable().getDouble(iIndex, this._iColumnGeometryRecEasting);
        }
        return dEasting;
    }

    public double getGeometryNorthing(int iIndex, Boolean bSrc) throws Exception {
        double dNorthing = 0.0;
        if (this._iColumnSrcNorthing >= 0 && this._iColumnRecNorthing >= 0) {
            if (bSrc.booleanValue()) {
                int iSrcEastingColumn = this._iColumnSrcNorthing;
                dNorthing = this._srcTable.getDouble(iIndex, iSrcEastingColumn);
            } else {
                int iRecEastingColumn = this._iColumnRecNorthing;
                dNorthing = this._recTable.getDouble(iIndex, iRecEastingColumn);
            }
        } else {
            if (this._iColumnGeometrySrcNorthing < 0) {
                this._iColumnGeometrySrcNorthing = RefractionStaticsProject.singleton().shotTable().column_indexOfColumn("Northing");
            }
            if (this._iColumnGeometryRecNorthing < 0) {
                this._iColumnGeometryRecNorthing = RefractionStaticsProject.singleton().receiverTable().column_indexOfColumn("Northing");
            }
            dNorthing = bSrc != false ? RefractionStaticsProject.singleton().shotTable().getDouble(iIndex, this._iColumnGeometrySrcNorthing) : RefractionStaticsProject.singleton().receiverTable().getDouble(iIndex, this._iColumnGeometryRecNorthing);
        }
        return dNorthing;
    }

    public void setColumnValue_Double(String colName, double value) {
        try {
            this.confirmColumn(colName, DataType.Double);
            int index = this.getSourceTable().column_indexOfColumn(colName);
            this.getSourceTable().column_setToValue(index, value);
            index = this.getReceiverTable().column_indexOfColumn(colName);
            this.getReceiverTable().column_setToValue(index, value);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void confirmColumn(String colName, DataType type) {
        try {
            boolean needReload = false;
            if (!this.geometryDatabase().columnExists("Shot", colName)) {
                needReload = true;
                this.geometryDatabase().addColumn("Shot", colName, type);
            }
            if (!this.geometryDatabase().columnExists("Receiver", colName)) {
                needReload = true;
                this.geometryDatabase().addColumn("Receiver", colName, type);
            }
            if (!this.getSourceTable().column_exists(colName)) {
                needReload = true;
            }
            if (!this.getReceiverTable().column_exists(colName)) {
                needReload = true;
            }
            if (needReload) {
                this.reloadAllData();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void smoothColumn(String columnName, double minValidValue, double smoothRadius, PolygonUsage polyUsage) throws Exception {
        try {
            double smoothGridSize = smoothRadius / 10.0;
            ProjectGridAnalyzer gridAnalysis = new ProjectGridAnalyzer(smoothGridSize);
            gridAnalysis.prepareForInterpolation(columnName, (float)minValidValue, false, "", this.getSourceTable(), this.getReceiverTable());
            gridAnalysis.smooth(polyUsage, smoothRadius);
            gridAnalysis.fromGridToTable(columnName, this.getReceiverTable(), polyUsage);
            this.geometryDatabase().writeColumnContentsToDatabase(this.getReceiverTable(), columnName);
            gridAnalysis.fromGridToTable(columnName, this.getSourceTable(), polyUsage);
            this.geometryDatabase().writeColumnContentsToDatabase(this.getSourceTable(), columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double computeAverage(String columnName, double min, double max) throws Exception {
        try {
            double v;
            boolean dead;
            int row;
            double sum = 0.0;
            double count = 1.0E-5;
            Table_Abstract table = this.getReceiverTable();
            int indexDead = -9999;
            if (table.column_exists("Killed")) {
                indexDead = table.column_indexOfColumn("Killed");
            }
            int indexV = table.column_indexOfColumn(columnName);
            for (row = 0; row < table.row_count(); ++row) {
                dead = false;
                if (indexDead >= 0) {
                    dead = table.getBool(row, indexDead);
                }
                if (dead || !((v = table.getDouble(row, indexV)) >= min) || !(v <= max)) continue;
                sum += v;
                count += 1.0;
            }
            table = this.getSourceTable();
            indexDead = -9999;
            if (table.column_exists("Killed")) {
                indexDead = table.column_indexOfColumn("Killed");
            }
            indexV = table.column_indexOfColumn(columnName);
            for (row = 0; row < table.row_count(); ++row) {
                dead = false;
                if (indexDead >= 0) {
                    dead = table.getBool(row, indexDead);
                }
                if (dead || !((v = table.getDouble(row, indexV)) >= min) || !(v <= max)) continue;
                sum += v;
                count += 1.0;
            }
            return sum / count;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public void writeColumnToRefractionProject(String sModelColumnName, String sDatabaseColumnName) {
        try {
            double dVal;
            Table_Abstract srcTable = this.getSourceTable();
            Table_Abstract recTable = this.getReceiverTable();
            RefractionStaticsProject.singleton().geometryDatabase().confirmColumn_Double("Shot", sDatabaseColumnName, 0.0);
            RefractionStaticsProject.singleton().geometryDatabase().confirmColumn_Double("Receiver", sDatabaseColumnName, 0.0);
            RefractionStaticsProject.singleton().reloadAllData();
            Table_Abstract projectSrcTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract projectRecTable = RefractionStaticsProject.singleton().receiverTable();
            int nSrc = srcTable.row_count();
            int nRec = recTable.row_count();
            if (!srcTable.column_exists(sModelColumnName)) {
                throw new Exception("Columnn does not exist in model source table : " + sModelColumnName);
            }
            if (!recTable.column_exists(sModelColumnName)) {
                throw new Exception("Columnn does not exist in model receiver table : " + sModelColumnName);
            }
            int iColumnSrc = srcTable.column_indexOfColumn(sModelColumnName);
            int iColumnRec = recTable.column_indexOfColumn(sModelColumnName);
            int iColumnProjectSrc = projectSrcTable.column_indexOfColumn(sDatabaseColumnName);
            int iColumnProjectRec = projectRecTable.column_indexOfColumn(sDatabaseColumnName);
            if (projectSrcTable.row_count() != nSrc) {
                throw new Exception("source table row count mismatch");
            }
            if (projectRecTable.row_count() != nRec) {
                throw new Exception("reciever table row count mismatch");
            }
            for (int iSrc = 0; iSrc < nSrc; ++iSrc) {
                dVal = srcTable.getDouble(iSrc, iColumnSrc);
                projectSrcTable.putDouble(iSrc, iColumnProjectSrc, dVal);
            }
            for (int iRec = 0; iRec < nRec; ++iRec) {
                dVal = recTable.getDouble(iRec, iColumnRec);
                projectRecTable.putDouble(iRec, iColumnProjectRec, dVal);
            }
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(projectSrcTable, sDatabaseColumnName);
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(projectRecTable, sDatabaseColumnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadAllData() throws Exception {
        try {
            this.loadReceiverTableFromMemoryDatabase();
            this.loadShotTableFromMemoryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void loadReceiverTableFromMemoryDatabase() {
        try {
            this._geometryConn.confirmColumn_Bool("Receiver", "Killed", false);
            this._geometryConn.confirmColumn_Double("Receiver", "Polarity", 1.0);
            this._geometryConn.confirmColumn_Double("Receiver", "TimeShift", 0.0);
            this._geometryConn.confirmColumn_Int("Receiver", "Flag", 0);
            this._recTable = this._geometryConn.extractTableDataUsingQuery("Receiver", "SELECT * FROM Receiver", 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadShotTableFromMemoryDatabase() {
        try {
            this._geometryConn.confirmColumn_Bool("Shot", "Killed", false);
            this._geometryConn.confirmColumn_Double("Shot", "Polarity", 1.0);
            this._geometryConn.confirmColumn_Double("Shot", "TimeShift", 0.0);
            this._geometryConn.confirmColumn_Int("Shot", "PatternShiftTotal", 0);
            this._geometryConn.confirmColumn_Int("Shot", "Flag", 0);
            this._srcTable = this._geometryConn.extractTableDataUsingQuery("Shot", "SELECT * FROM Shot", 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public ArrayList<String> getStaticsVersions() {
        ArrayList<String> versions = new ArrayList<String>();
        try {
            ArrayList<String> columns = this.getSourceTable().column_listOfNames();
            for (int i = 0; i < columns.size(); ++i) {
                String sColumn = columns.get(i);
                if (!sColumn.contains("STATICS_") || !this.getReceiverTable().column_exists(sColumn)) continue;
                versions.add(sColumn);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        return versions;
    }

    public void shiftColumnValue_Double(String colName, double shift) {
        try {
            double v;
            int row;
            Table_Abstract table = this.getReceiverTable();
            int index = table.column_indexOfColumn(colName);
            for (row = 0; row < table.row_count(); ++row) {
                v = table.getDouble(row, index);
                table.putDouble(row, index, v + shift);
            }
            table = this.getSourceTable();
            index = table.column_indexOfColumn(colName);
            for (row = 0; row < table.row_count(); ++row) {
                v = table.getDouble(row, index);
                table.putDouble(row, index, v + shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void fillVelocityAtElevation(Table_Abstract table, double dElevation, boolean bSrc) {
        try {
            if (!table.column_exists("VelAtElevation")) {
                table.column_append("VelAtElevation", DataType.Double);
            }
            int iColumn = table.column_indexOfColumn("VelAtElevation");
            int iX = table.column_indexOfColumn("Easting");
            int iY = table.column_indexOfColumn("Northing");
            int iZ = table.column_indexOfColumn("Elevation");
            int nLayers = this.getLayerCount();
            float[] fDepths = new float[1];
            float[] fVelsAtDepth = new float[1];
            int nRows = table.row_count();
            for (int i = 0; i < nRows; ++i) {
                double x = table.getDouble(i, iX);
                double y = table.getDouble(i, iY);
                double dSurfaceElevation = table.getDouble(i, iZ);
                boolean bFoundVel = false;
                double dVel = 0.0;
                float fDepth = (float)(dSurfaceElevation - dElevation);
                if (fDepth < 0.0f) {
                    fDepth = 0.0f;
                }
                fDepths[0] = fDepth;
                for (int iLayer = 0; iLayer < nLayers - 1; ++iLayer) {
                    ModelLayer layer = this.getLayer(iLayer);
                    double dTmpElev = layer.getElevation(i, bSrc);
                    if (dElevation >= dTmpElev) {
                        if (layer.getLayerType() == ModelLayerType.UpholeSurvey) {
                            UpholeModel upholeModel = layer.getUpholeModel();
                            if (upholeModel.getInterpolationMaxDepth() <= 0.0) {
                                upholeModel.interpolateVelocities(0.5, upholeModel.getMaxDepth());
                            }
                            upholeModel.getInterpolatedVelocity(x, y, dSurfaceElevation, fDepths, fVelsAtDepth);
                            bFoundVel = true;
                            dVel = fVelsAtDepth[0];
                        } else {
                            bFoundVel = true;
                            dVel = layer.getVelocity(i, bSrc);
                        }
                    }
                    if (bFoundVel) break;
                }
                if (!bFoundVel) {
                    ModelLayer lastLayer = this.getLayer(nLayers - 1);
                    dVel = lastLayer.getVelocity(i, bSrc);
                }
                table.putDouble(i, iColumn, dVel);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_Paintable_Table loadGeomPO(String tableName, String colName, double dElevation, boolean bUseElevation) {
        try {
            if (this._geometryConn == null) {
                return null;
            }
            String sql = String.format("SELECT Easting, Northing, %s, %sID FROM %s WHERE KILLED = FALSE", colName, tableName, tableName);
            Table_Abstract table = this.geometryDatabase().extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            if (bUseElevation) {
                boolean bSrc = tableName.equals("Shot");
                this.fillVelocityAtElevation(table, dElevation, bSrc);
                colName = "VelAtElevation";
            }
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            painter.setTable(table);
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            painter.setAxisC(colName);
            painter.UseColorScale = true;
            painter.FixedColor = Color.BLACK;
            painter.Size_Pixel = 3;
            painter.Symbol = Java2D_PointSymbol.FilledSquare;
            painter.Size_UsePixel = false;
            painter.Size_World = RefractionStaticsProject.singleton().units_feet() ? 80.0 : 25.0;
            return painter;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void modifyColumn(DelayTimeModel_ModInfo modInfo, String columnName) throws Exception {
        try {
            Table_Abstract shotTable = this.getSourceTable();
            Table_Abstract recTable = this.getReceiverTable();
            IDatabaseConnection database = this.geometryDatabase();
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_PolygonEdit)) {
                if (modInfo.CutInside) {
                    Tools_RefractionStaticsProject.cutAndRepairUsingPolygon(columnName, PolygonUsage.Inside, shotTable, recTable, database);
                } else {
                    Tools_RefractionStaticsProject.cutAndRepairUsingPolygon(columnName, PolygonUsage.Outside, shotTable, recTable, database);
                }
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_GridSmooth)) {
                if (!modInfo.SmoothUseWeight) {
                    Tools_RefractionStaticsProject.smoothColumn(columnName, -999999.0, modInfo.SmoothRadius, modInfo.SmoothPolygon, shotTable, recTable, database);
                } else {
                    Tools_RefractionStaticsProject.smoothColumn(columnName, -999999.0, modInfo.SmoothRadius, modInfo.SmoothPolygon, modInfo.SmoothColumn, shotTable, recTable, database);
                }
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_Clip)) {
                Tools_RefractionStaticsProject.clipColumn(columnName, modInfo.ClipMin, modInfo.ClipMax, modInfo.ClipPolygon, shotTable, recTable, database);
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_Constant)) {
                Tools_RefractionStaticsProject.setColumnToConstant(columnName, modInfo.ConstantValue, modInfo.ConstantPolygon, shotTable, recTable, database);
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_ImportColumn)) {
                Tools_RefractionStaticsProject.copyColumn(modInfo.ImportColumn, columnName, true, true, shotTable, recTable, database);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    void enforceMinimumThickness(ModelLayer layer, int index, Boolean bSrc, double dMinThickness) throws Exception {
        try {
            int iLayerIndex = layer.getLayerIndex();
            double dElevation = layer.getElevation(index, bSrc);
            double dUpperElevation = iLayerIndex == 0 ? this.getSurfaceElevation(index, bSrc) : this.getLayer(iLayerIndex - 1).getElevation(index, bSrc);
            double dThickness = dUpperElevation - dElevation;
            if (dThickness < dMinThickness) {
                dElevation = dUpperElevation - dMinThickness;
                layer.setElevation(index, bSrc, dElevation);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    void enforceMinimumThickness(ModelLayer layer, double dMinimumThickness) throws Exception {
        try {
            int i;
            int nSrc = this.getSourceCount();
            int nRec = this.getReceiverCount();
            for (i = 0; i < nSrc; ++i) {
                this.enforceMinimumThickness(layer, i, true, dMinimumThickness);
            }
            for (i = 0; i < nRec; ++i) {
                this.enforceMinimumThickness(layer, i, false, dMinimumThickness);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    void calculateVelocity(ModelLayer layer, double dMinimumThickness) throws Exception {
        try {
            int i;
            int nSrc = this.getSourceCount();
            int nRec = this.getReceiverCount();
            for (i = 0; i < nSrc; ++i) {
                this.calculateVelocity(layer, i, true, dMinimumThickness);
            }
            for (i = 0; i < nRec; ++i) {
                this.calculateVelocity(layer, i, false, dMinimumThickness);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    void calculateElevation(ModelLayer layer, double dMinimumThickness) throws Exception {
        try {
            int i;
            int nSrc = this.getSourceCount();
            int nRec = this.getReceiverCount();
            for (i = 0; i < nSrc; ++i) {
                this.calculateElevation(layer, i, true, dMinimumThickness);
            }
            for (i = 0; i < nRec; ++i) {
                this.calculateElevation(layer, i, false, dMinimumThickness);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    void invalidateVelocity(ModelLayer layer) throws Exception {
        try {
            int i;
            int nSrc = this.getSourceCount();
            int nRec = this.getReceiverCount();
            for (i = 0; i < nSrc; ++i) {
                layer.setLayerVelocityValid(i, true, false);
            }
            for (i = 0; i < nRec; ++i) {
                layer.setLayerVelocityValid(i, false, false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    void invalidateElevation(ModelLayer layer) throws Exception {
        try {
            int i;
            int nSrc = this.getSourceCount();
            int nRec = this.getReceiverCount();
            for (i = 0; i < nSrc; ++i) {
                layer.setLayerElevationValid(i, true, false);
            }
            for (i = 0; i < nRec; ++i) {
                layer.setLayerElevationValid(i, false, false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void performRequestedMods(DelayTimeModel_ModInfo modInfo, ModelLayer layer, ModelData md, double dMinimumThickness) {
        try {
            ModelLayer tmpLayer;
            ModelLayerType tmpLayerType;
            int iTmpLayer;
            int iLayer = layer.getLayerIndex();
            LayerDataType dt = md.getLayerDataType();
            String sColumnName = this.getColumnName(iLayer, dt);
            int nLayers = this.getLayerCount();
            this.modifyColumn(modInfo, sColumnName);
            if (dt == LayerDataType.Elevation) {
                this.enforceMinimumThickness(layer, dMinimumThickness);
                for (iTmpLayer = iLayer; iTmpLayer >= 0 && (tmpLayerType = (tmpLayer = this.getLayer(iTmpLayer)).getLayerType()) != ModelLayerType.Free && tmpLayerType != ModelLayerType.UpholeSurvey; --iTmpLayer) {
                    if (tmpLayerType != ModelLayerType.Refracting) continue;
                    this.invalidateVelocity(tmpLayer);
                    this.calculateVelocity(tmpLayer, dMinimumThickness);
                }
                for (iTmpLayer = iLayer + 1; iTmpLayer < nLayers - 1 && (tmpLayerType = (tmpLayer = this.getLayer(iTmpLayer)).getLayerType()) != ModelLayerType.Free && tmpLayerType != ModelLayerType.Base && tmpLayerType != ModelLayerType.UpholeSurvey; ++iTmpLayer) {
                    if (tmpLayerType != ModelLayerType.Refracting) continue;
                    this.invalidateElevation(tmpLayer);
                    this.calculateElevation(tmpLayer, dMinimumThickness);
                }
            }
            if (dt == LayerDataType.Velocity) {
                if (layer.getLayerType() == ModelLayerType.Refracting) {
                    this.invalidateElevation(layer);
                    this.calculateElevation(layer, dMinimumThickness);
                }
                for (iTmpLayer = iLayer - 1; iTmpLayer >= 0 && (tmpLayerType = (tmpLayer = this.getLayer(iTmpLayer)).getLayerType()) != ModelLayerType.Free && tmpLayerType != ModelLayerType.UpholeSurvey; --iTmpLayer) {
                    if (tmpLayerType != ModelLayerType.Refracting) continue;
                    this.invalidateVelocity(tmpLayer);
                    this.calculateVelocity(tmpLayer, dMinimumThickness);
                }
                for (iTmpLayer = iLayer + 1; iTmpLayer < nLayers - 1 && (tmpLayerType = (tmpLayer = this.getLayer(iTmpLayer)).getLayerType()) != ModelLayerType.Free && tmpLayerType != ModelLayerType.Base && tmpLayerType != ModelLayerType.UpholeSurvey; ++iTmpLayer) {
                    if (tmpLayerType != ModelLayerType.Refracting) continue;
                    this.invalidateElevation(tmpLayer);
                    this.calculateElevation(tmpLayer, dMinimumThickness);
                }
            }
            this.calculateThickness();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

