/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImportFromUpholeSurveyDataSourcePanel
extends JPanel
implements ItemListener,
ActionListener {
    JComboBox _cmbUpholeSurvey;
    ModelLayer _layer;
    LayerDataType _layerDataType;
    LinearLayoutWidget _topWidget;
    JButton _btnImport;
    Boolean _bIsValid = false;
    JLabel _lblIsValid;

    public ImportFromUpholeSurveyDataSourcePanel(ModelLayer layer, LayerDataType layerDataType) {
        try {
            this._layer = layer;
            this._layerDataType = layerDataType;
            this.setLayout(new BorderLayout());
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._cmbUpholeSurvey = this._topWidget.createSubComboBox("Uphole Survey", this);
            this._lblIsValid = this._topWidget.createLabel("Empty", 0, 1);
            Font font = new Font("Courier", 1, 14);
            this._lblIsValid.setFont(font);
            this.setDataValid(false);
            this._btnImport = this._topWidget.createButton("Import", this, 2);
            Dimension minSize = new Dimension(300, 30);
            this._cmbUpholeSurvey.setMinimumSize(minSize);
            this._cmbUpholeSurvey.setMaximumSize(minSize);
            this.add((Component)this._topWidget, "North");
            this.fillUpholeSurveys();
            ModelData md = this._layer.getModelData(this._layerDataType);
            ModelDataSource mds = md.getModelDataSource();
            this.setModelDataSource(mds);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void setDataValid(Boolean bValid) {
        try {
            this._bIsValid = bValid;
            if (bValid.booleanValue()) {
                this._lblIsValid.setText("Filled");
                this._lblIsValid.setForeground(Color.BLUE);
            } else {
                this._lblIsValid.setText("Empty");
                this._lblIsValid.setForeground(Color.RED);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void fillUpholeSurveys() {
        try {
            Object objOld = this._cmbUpholeSurvey.getSelectedItem();
            ArrayList<String> listOfUpholeSurveys = RefractionStaticsProject.singleton().getListOfUpholeSurveys();
            this._cmbUpholeSurvey.removeAllItems();
            for (String sVal : listOfUpholeSurveys) {
                this._cmbUpholeSurvey.addItem(sVal);
            }
            if (objOld != null) {
                this.setComboBoxValue(this._cmbUpholeSurvey, objOld.toString());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void setComboBoxValue(JComboBox cb, String sValue) {
        try {
            int iSelectedIndex = -1;
            for (int i = 0; i < cb.getItemCount(); ++i) {
                String sItem = cb.getItemAt(i).toString();
                if (!sItem.equals(sValue)) continue;
                iSelectedIndex = i;
            }
            if (iSelectedIndex >= 0) {
                cb.setSelectedIndex(iSelectedIndex);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setModelDataSource(ModelDataSource mds) {
        try {
            ModelData data = this._layer.getModelData(this._layerDataType);
            this.setDataValid(data.getIsDataLoadDataValid());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public ModelDataSource getModelDatasource() {
        ModelDataSource mds = null;
        try {
            mds = new ModelDataSource();
            mds.IsValid = this._bIsValid;
            mds.DataSourceType = LayerDataSource.UpholeSurvey;
            String sSelectedSurvey = "";
            if (this._cmbUpholeSurvey.getSelectedItem() != null) {
                sSelectedSurvey = this._cmbUpholeSurvey.getSelectedItem().toString();
            }
            mds.UpholeSurveyName = sSelectedSurvey;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return mds;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._btnImport) {
                if (this._cmbUpholeSurvey.getSelectedItem() == null) {
                    return;
                }
                String sSelectedSurvey = this._cmbUpholeSurvey.getSelectedItem().toString();
                this.importData(this._layer, this._layerDataType, sSelectedSurvey);
                ModelData data = this._layer.getModelData(this._layerDataType);
                this.setDataValid(data.getIsDataLoadDataValid());
                ModelDataSource mds = this.getModelDatasource();
                this._layer.getModelData(this._layerDataType).setModelDataSource(mds);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    boolean importData(boolean bSrc, ModelLayer layer, UpholeModel upholeModel) {
        try {
            ModelData elevationData = layer.getModelData(LayerDataType.Elevation);
            ModelData velocityData = layer.getModelData(LayerDataType.Velocity);
            double[] elevationArray = null;
            double[] velocityArray = null;
            Object thicknessArray = null;
            if (bSrc) {
                elevationArray = elevationData.getDataLoadSourceValues();
                velocityArray = velocityData.getDataLoadSourceValues();
            } else {
                elevationArray = elevationData.getDataLoadReceiverValues();
                velocityArray = velocityData.getDataLoadReceiverValues();
            }
            InteractiveModel model = layer.getModel();
            if (upholeModel.getInterpolationMaxDepth() == 0.0) {
                double dDepthDigi = 0.5;
                double dMaxUpholeSurveyDepth = upholeModel.getMaxDepth();
                upholeModel.interpolateVelocities(dDepthDigi, dMaxUpholeSurveyDepth);
            }
            int nRows = velocityArray.length;
            float[] fDepths = new float[1];
            float[] fVelsAtDepth = new float[1];
            for (int iRow = 0; iRow < nRows; ++iRow) {
                double dVel;
                double x = model.getGeometryEasting(iRow, bSrc);
                double y = model.getGeometryNorthing(iRow, bSrc);
                double dSurfaceElevation = model.getSurfaceElevation(iRow, bSrc);
                double dMaxUpholeDepth = upholeModel.getInterpolatedMaxDepth(x, y);
                fDepths[0] = (float)dMaxUpholeDepth;
                upholeModel.getInterpolatedVelocity(x, y, dSurfaceElevation, fDepths, fVelsAtDepth);
                velocityArray[iRow] = dVel = (double)fVelsAtDepth[0];
                elevationArray[iRow] = dSurfaceElevation - dMaxUpholeDepth;
            }
            layer.setUpholeModel(upholeModel);
            boolean bIsFilled = layer.getIsFilled();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    void importData(ModelLayer layer, LayerDataType dt, String sUpholeSurvey) {
        try {
            UpholeModel upholeModel = RefractionStaticsProject.singleton().getUpholeSurveyModel(sUpholeSurvey);
            boolean bSrcOK = this.importData(true, layer, upholeModel);
            boolean bRecOk = this.importData(false, layer, upholeModel);
            if (bSrcOK && bRecOk) {
                layer.getModelData(LayerDataType.Elevation).setIsDataLoadDataValid(true);
                layer.getModelData(LayerDataType.Velocity).setIsDataLoadDataValid(true);
            } else {
                layer.getModelData(LayerDataType.Elevation).setIsDataLoadDataValid(false);
                layer.getModelData(LayerDataType.Velocity).setIsDataLoadDataValid(false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

