/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImportOtherProjectDelayTimeDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener,
ItemListener {
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Import");
    protected ComboStringListWrapper m_cmbOtherProject = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cmbOtherVersion = new ComboStringListWrapper();
    protected ButtonGroup m_group = new ButtonGroup();
    protected JRadioButton m_radLPI = new JRadioButton("Use LineNumber/PointNumber/PointIndex");
    protected JRadioButton m_radUseNearest = new JRadioButton("Use the value of the nearest shot or receiver");
    protected JRadioButton m_radInverseSquare = new JRadioButton("Use inverse-square interpolation");
    protected JRadioButton m_radInverseFourth = new JRadioButton("Use inverse-fourth interpolation");
    protected JTextField m_txtRadius = new JTextField("1000");
    protected JLabel m_lblStatus = new JLabel("", 0);
    protected JLabel m_lblProgress = new JLabel("Import progress", 0);
    protected boolean m_convertedWaveOptions = false;
    protected JCheckBox m_chkUpdateCoords = new JCheckBox("Update coordinates");
    protected JCheckBox m_chkDelayTimeAnalysis = new JCheckBox("Launch receiver delay time analysis after importing data");

    public ImportOtherProjectDelayTimeDialog(boolean convertedWaveOptions) {
        try {
            this.m_convertedWaveOptions = convertedWaveOptions;
            if (this.m_convertedWaveOptions) {
                this.setTitle("Converted wave delay time");
            } else {
                this.setTitle("Import delay time info");
            }
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            GridLayoutWidget otherGrid = main.createGridLayoutWidget(0, "Select other project, version, and column", 0);
            int row = 0;
            otherGrid.addSimple(row++, new JLabel("Select other project"), this.m_cmbOtherProject);
            otherGrid.addSimple(row++, new JLabel("Select version"), this.m_cmbOtherVersion);
            otherGrid.addSimple(row++, new JLabel("  "), this.m_lblStatus);
            this.m_cmbOtherProject.listener().addListener(this);
            this.m_cmbOtherVersion.listener().addListener(this);
            LinearLayoutWidget sub = main.createVertical(row, "Interpolation method", 0);
            sub.addComponent(this.m_radLPI, 0);
            sub.addComponent(this.m_radUseNearest, 0);
            sub.addComponent(this.m_radInverseSquare, 0);
            sub.addComponent(this.m_radInverseFourth, 0);
            sub.addHorzPair(new JLabel("Smoothing radius (ft/m)"), 0, this.m_txtRadius, 5);
            this.m_group.add(this.m_radLPI);
            this.m_group.add(this.m_radUseNearest);
            this.m_group.add(this.m_radInverseSquare);
            this.m_group.add(this.m_radInverseFourth);
            this.m_radLPI.addActionListener(this);
            this.m_radUseNearest.addActionListener(this);
            this.m_radInverseSquare.addActionListener(this);
            this.m_radInverseFourth.addActionListener(this);
            this.m_radUseNearest.setSelected(true);
            this.m_txtRadius.setEnabled(!this.m_radUseNearest.isSelected());
            this.m_chkUpdateCoords.setEnabled(this.m_radLPI.isSelected());
            main.addComponent(this.m_chkUpdateCoords, 0);
            main.addComponent(this.m_lblProgress, 0);
            if (this.m_convertedWaveOptions) {
                this.m_chkDelayTimeAnalysis.setSelected(true);
                main.addComponent(this.m_chkDelayTimeAnalysis, 0);
            }
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_cmbOtherProject) {
                this.reloadVersions();
                return;
            }
            if (sender == this.m_cmbOtherVersion) {
                this.checkOtherVersion();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void reloadVersions() {
        try {
            String projectsPath = SharedApplicationData.staticsProjectPath();
            String selected = this.m_cmbOtherProject.getSelectedString();
            String fullProjectPath = projectsPath + "/" + selected;
            String versionContainerPath = fullProjectPath + "/Versions";
            ArrayList<String> versions = Tools_FileSystem.subdirectories(versionContainerPath, false);
            this.m_cmbOtherVersion.setStringArray(versions);
            this.checkOtherVersion();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadProjects() {
        try {
            String currentProject = RefractionStaticsProject.singleton().name();
            String projectsPath = SharedApplicationData.staticsProjectPath();
            ArrayList<String> projects = new ArrayList<String>();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(projectsPath, false);
            for (String subdir : subdirs) {
                boolean sameProject = subdir.equalsIgnoreCase(currentProject);
                String fullProjectPath = projectsPath + "/" + subdir;
                String descFileName = fullProjectPath + "/ProjectDescription.xml";
                if (sameProject || !Tools_FileSystem.exists_file(descFileName)) continue;
                projects.add(subdir);
            }
            this.m_cmbOtherProject.setStringArray(projects);
            this.reloadVersions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            try {
                this.reloadProjects();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkOtherVersion() {
        try {
            boolean ok = false;
            IDatabaseConnection db = this.getDB();
            if (db == null) {
                this.m_lblStatus.setText("Other database not valid");
            } else {
                String dtPath = this.getOtherDelayTimePath();
                BranchAssignment ba = new BranchAssignment();
                String branchFileName = dtPath + "/Branch.xml";
                ba.read(branchFileName);
                if (ba.maxBranch() < 1) {
                    this.m_lblStatus.setText("No branches defined");
                } else {
                    this.m_lblStatus.setText(Integer.toString(ba.maxBranch()) + " refractor(s)");
                    ok = true;
                }
            }
            if (ok) {
                this.m_lblStatus.setForeground(Color.blue);
            } else {
                this.m_lblStatus.setForeground(Color.red);
            }
            this.m_btnInterpolate.setEnabled(ok);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected String getOtherDelayTimePath() {
        try {
            return this.getOtherVersionPath() + "/DelayTime";
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    protected String getOtherVersionPath() {
        try {
            String projectsPath = SharedApplicationData.staticsProjectPath();
            String selectedProject = this.m_cmbOtherProject.getSelectedString();
            String fullProjectPath = projectsPath + "/" + selectedProject;
            String versionContainerPath = fullProjectPath + "/Versions";
            String selectedVersion = this.m_cmbOtherVersion.getSelectedString();
            String versionPath = versionContainerPath + "/" + selectedVersion;
            return versionPath;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    protected IDatabaseConnection getDB() {
        try {
            String versionPath = this.getOtherVersionPath();
            String fileNameDB = versionPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            return db;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void interpolateTable(Table_Abstract table, Table_Abstract otherTable, String column) {
        try {
            this.m_lblProgress.setForeground(Color.blue);
            this.m_lblProgress.setText(table.name() + " - " + column);
            this.m_lblProgress.paintImmediately(0, 0, this.getSize().width, 33);
            if (!otherTable.column_exists(column)) {
                return;
            }
            if (!table.column_exists(column)) {
                this.database().addColumn(table.name(), column, DataType.Double);
                table.column_append(column, DataType.Double);
            }
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(column);
            int indexX2 = otherTable.column_indexOfColumn("Easting");
            int indexY2 = otherTable.column_indexOfColumn("Northing");
            int indexV2 = otherTable.column_indexOfColumn(column);
            int indexKilled = otherTable.column_indexOfColumn("Killed");
            boolean useNearest = this.m_radUseNearest.isSelected();
            boolean square = this.m_radInverseSquare.isSelected();
            boolean fourth = this.m_radInverseFourth.isSelected();
            double rad = Tools_Widget.extractDouble(this.m_txtRadius, 1000.0, 10.0, 100000.0);
            double rad2 = rad * rad;
            double rad4 = rad2 * rad2;
            for (int r = 0; r < table.row_count(); ++r) {
                double minDist = Double.MAX_VALUE;
                double bestValue = 0.0;
                double sum1 = 0.0;
                double sum2 = 1.0E-60;
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                for (int row = 0; row < otherTable.row_count(); ++row) {
                    if (otherTable.getBool(row, indexKilled)) continue;
                    double dx = x - otherTable.getDouble(row, indexX2);
                    double dy = y - otherTable.getDouble(row, indexY2);
                    double dist = dx * dx + dy * dy;
                    double v = otherTable.getDouble(row, indexV2);
                    if (dist < minDist) {
                        minDist = dist;
                        bestValue = v;
                    }
                    double w = 1.0;
                    if (square) {
                        w = rad2 / (rad2 + dist);
                    }
                    if (fourth) {
                        w = rad4 / (rad4 + dist * dist);
                    }
                    sum1 += w * v;
                    sum2 += w;
                }
                if (square) {
                    bestValue = sum1 / sum2;
                }
                if (fourth) {
                    bestValue = sum1 / sum2;
                }
                table.putDouble(r, indexV, bestValue);
            }
            this.database().writeColumnContentsToDatabase(table, column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void interpolateTable_LPI(Table_Abstract table, Table_Abstract otherTable, String column) {
        try {
            this.m_lblProgress.setForeground(Color.blue);
            this.m_lblProgress.setText(table.name() + " - " + column);
            this.m_lblProgress.paintImmediately(0, 0, this.getSize().width, 33);
            if (!otherTable.column_exists(column)) {
                return;
            }
            if (!table.column_exists(column)) {
                this.database().addColumn(table.name(), column, DataType.Double);
                table.column_append(column, DataType.Double);
            }
            int indexL = table.column_indexOfColumn("LineNumber");
            int indexP = table.column_indexOfColumn("PointNumber");
            int indexI = table.column_indexOfColumn("PointIndex");
            int indexV = table.column_indexOfColumn(column);
            int indexL2 = otherTable.column_indexOfColumn("LineNumber");
            int indexP2 = otherTable.column_indexOfColumn("PointNumber");
            int indexI2 = otherTable.column_indexOfColumn("PointIndex");
            int indexV2 = otherTable.column_indexOfColumn(column);
            HashMap_Integers<Double> map = new HashMap_Integers<Double>();
            for (int row = 0; row < otherTable.row_count(); ++row) {
                int line = otherTable.getInt(row, indexL2);
                int point = otherTable.getInt(row, indexP2);
                int index = otherTable.getInt(row, indexI2);
                double v = otherTable.getDouble(row, indexV2);
                map.put(v, line, point, index);
            }
            int dammit = 0;
            for (int r = 0; r < table.row_count(); ++r) {
                int line = table.getInt(r, indexL);
                int point = table.getInt(r, indexP);
                int index = table.getInt(r, indexI);
                table.putDouble(r, indexV, -999999.0);
                if (map.containsKey(line, point, index)) {
                    double v = (Double)map.get(line, point, index);
                    table.putDouble(r, indexV, v);
                    continue;
                }
                ++dammit;
            }
            if (dammit > 0) {
                System.out.println("unfound = " + dammit);
            }
            this.database().writeColumnContentsToDatabase(table, column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importDT() {
        try {
            int b;
            IDatabaseConnection db = this.getDB();
            String dtPath = this.getOtherDelayTimePath();
            BranchAssignment ba = new BranchAssignment();
            String branchFileName = dtPath + "/Branch.xml";
            ba.read(branchFileName);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.getDelayTimeData().setBranchAssignment(ba);
            Table_Abstract shotTable = p.shotTable();
            Table_Abstract recTable = p.receiverTable();
            Table_Abstract otherShotTable = db.extractTableDataUsingQuery("Shot", "SELECT * FROM SHOT", 999999);
            Table_Abstract otherRecTable = db.extractTableDataUsingQuery("Receiver", "SELECT * FROM RECEIVER", 999999);
            if (this.m_radLPI.isSelected()) {
                if (this.m_chkUpdateCoords.isSelected()) {
                    this.interpolateTable_LPI(shotTable, otherShotTable, "Easting");
                    this.interpolateTable_LPI(recTable, otherRecTable, "Northing");
                }
                this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameVel(0));
                this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameVel(0));
                for (b = 1; b <= ba.maxBranch(); ++b) {
                    this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameVel(b));
                    this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameDT(b));
                    this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameElev(b));
                    this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameDtAnisAz(b));
                    this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameDtAnisMag(b));
                    this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameError(b));
                    this.interpolateTable_LPI(recTable, otherRecTable, Pecos.getColNameCount(b));
                    this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameVel(b));
                    this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameDT(b));
                    this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameElev(b));
                    this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameDtAnisAz(b));
                    this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameDtAnisMag(b));
                    this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameError(b));
                    this.interpolateTable_LPI(shotTable, otherShotTable, Pecos.getColNameCount(b));
                }
            } else {
                this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameVel(0));
                this.interpolateTable(recTable, otherRecTable, Pecos.getColNameVel(0));
                for (b = 1; b <= ba.maxBranch(); ++b) {
                    this.interpolateTable(recTable, otherRecTable, Pecos.getColNameVel(b));
                    this.interpolateTable(recTable, otherRecTable, Pecos.getColNameDT(b));
                    this.interpolateTable(recTable, otherRecTable, Pecos.getColNameElev(b));
                    this.interpolateTable(recTable, otherRecTable, Pecos.getColNameDtAnisAz(b));
                    this.interpolateTable(recTable, otherRecTable, Pecos.getColNameDtAnisMag(b));
                    this.interpolateTable(recTable, otherRecTable, Pecos.getColNameError(b));
                    this.interpolateTable(recTable, otherRecTable, Pecos.getColNameCount(b));
                    this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameVel(b));
                    this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameDT(b));
                    this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameElev(b));
                    this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameDtAnisAz(b));
                    this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameDtAnisMag(b));
                    this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameError(b));
                    this.interpolateTable(shotTable, otherShotTable, Pecos.getColNameCount(b));
                }
            }
            for (b = ba.maxBranch() + 1; b < 6; ++b) {
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameVel(b));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameDT(b));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameElev(b));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameDtAnisAz(b));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameDtAnisMag(b));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameError(b));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameCount(b));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameVel(b));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameDT(b));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameElev(b));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameDtAnisAz(b));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameDtAnisMag(b));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameError(b));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameCount(b));
            }
            p.reloadAllData();
            Messenger.broadcastReloadAllGathers(this);
            Messenger.broadcast(Messenger.Message.ColumnsModified, db, ba);
            if (!this.m_convertedWaveOptions || this.m_chkDelayTimeAnalysis.isSelected()) {
                // empty if block
            }
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_btnInterpolate.setEnabled(true);
            this.m_txtRadius.setEnabled(!this.m_radUseNearest.isSelected());
            this.m_chkUpdateCoords.setEnabled(this.m_radLPI.isSelected());
            if (e.getSource() == this.m_btnInterpolate) {
                this.importDT();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

