/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_BranchPickKiller;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Picking.PickCopyDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class BranchPickKillDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ITraceTableScannerMonitor {
    protected RefractionStaticsProject m_project;
    protected DelayTimeData m_delayTimeData;
    protected BranchAssignment m_branchAssignment;
    protected JCheckBox m_killOutsideAcceptanceZone;
    protected JProgressBar m_progress = new JProgressBar();
    protected JCheckBox m_killOutsideBranch;
    protected JCheckBox m_killLessBranch;
    protected JCheckBox m_killMoreBranch;
    protected JButton m_btnOK = new JButton("Kill picks");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JButton m_btnCopy = new JButton("Open pick copy dialog");
    public boolean OK = false;

    public BranchPickKillDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.m_delayTimeData = this.m_project.getDelayTimeData();
            this.m_branchAssignment = this.m_delayTimeData.branchAssignment();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_killOutsideAcceptanceZone = new JCheckBox("Kill picks inside branch but outside acceptance zone");
            main.addComponent(this.m_killOutsideAcceptanceZone, 0);
            this.m_killOutsideBranch = new JCheckBox("Kill all picks outside of branch");
            main.addComponent(this.m_killOutsideBranch, 0);
            this.m_killLessBranch = new JCheckBox("Kill picks less than minimum branch offset");
            main.addComponent(this.m_killLessBranch, 0);
            this.m_killMoreBranch = new JCheckBox("Kill picks more than maximum branch offset");
            main.addComponent(this.m_killMoreBranch, 0);
            this.m_killOutsideAcceptanceZone.addActionListener(this);
            this.m_killOutsideBranch.addActionListener(this);
            this.m_killLessBranch.addActionListener(this);
            this.m_killMoreBranch.addActionListener(this);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnCopy, 0);
            this.m_progress.setMaximum(1000);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_btnCopy.addActionListener(this);
            this.m_btnOK.setEnabled(false);
            main.addComponent(this.m_progress, 0);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setTitle("Kill picks using branch assignment");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean branchOK() {
        try {
            this.m_btnOK.setEnabled(false);
            int maxBranch = this.m_branchAssignment.maxBranch();
            if (maxBranch < 1) {
                return false;
            }
            for (int branch = 1; branch < maxBranch; ++branch) {
                if (this.m_branchAssignment.hasBranch(branch)) continue;
                return false;
            }
            this.m_btnOK.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_branchAssignment) {
                this.branchOK();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_btnOK.setEnabled(this.m_killOutsideBranch.isSelected() || this.m_killOutsideAcceptanceZone.isSelected() || this.m_killMoreBranch.isSelected() || this.m_killLessBranch.isSelected());
            if (e.getSource() == this.m_btnCopy) {
                PickCopyDialog dlg = PickCopyDialog.singleton();
                dlg.showDialog(null);
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
                TraceTable_BranchPickKiller killer = new TraceTable_BranchPickKiller(table, "FBP_User");
                killer.KillAllPicksOutsideBranch = this.m_killOutsideBranch.isSelected();
                killer.KillOutsideAcceptanceZone = this.m_killOutsideAcceptanceZone.isSelected();
                killer.KillPicksGreaterThanMaximumOffset = this.m_killMoreBranch.isSelected();
                killer.KillPicksLessThanMinimimOffset = this.m_killLessBranch.isSelected();
                killer.scan(table, this);
                System.out.println("killer.NumKilled = " + killer.NumKilled);
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

