/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Refraction.Action_ComputeMoveoutTrends;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_BranchPickLocations;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_BranchPickCollections;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleHeaderCrossplot;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Wiggles;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_RangeExpander;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Branch;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BranchAssignmentWidget
extends JSplitPane
implements GenericObjectListener.Listener,
IParameterWidgetListener,
ActionListener,
ListSelectionListener,
ItemListener,
ITraceTableScannerMonitor {
    protected Java2D_SimpleComposite m_basemapWidget = new Java2D_SimpleComposite(false);
    protected ComboStringListWrapper m_cCombo = new ComboStringListWrapper();
    protected JTextField m_txtMinSeparation = new JTextField("2000");
    protected Java2D_SimpleComposite m_branchWidget = new Java2D_SimpleComposite(false);
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected JButton m_clearButton;
    protected boolean m_bIgnoreList = false;
    protected JList<String> m_branchList = new JList();
    protected DefaultListModel<String> m_branchModel = new DefaultListModel();
    protected JCheckBox m_chkTrackLMO = new JCheckBox("Set LMO velocity using branch number");
    protected JComboBox<String> m_comboDelayTimeShifts = new JComboBox();
    protected double[] m_lmoVel = new double[20];
    protected RadioPanel m_radioInterpMethod;
    protected JButton m_btnSetAllOffset;
    protected JButton m_btnCopyFirstToSecond;
    protected JButton m_btnImportFirstFromAnotherVersion;
    protected BitmapCardWidget m_bitmapCardWidget;
    protected Sequence_MainWidget m_workerWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected PlotType m_plotType = PlotType.Picks;
    protected SliderWidget m_lmoSlider;
    protected JComboBox<String> m_radiusCombo = new JComboBox();
    protected ComboStringListWrapper m_pickVersionCombo;
    protected LinearLayoutWidget m_pickVersionWidget;
    protected JComboBox<String> m_fromBranchCombo = new JComboBox();
    protected JComboBox<String> m_toBranchCombo = new JComboBox();
    protected JButton m_btnReassign;
    protected JButton m_launchMoveoutButton;
    protected JTextField m_moveSizeText = new JTextField("1000");
    protected JTextField m_killRadiusText = new JTextField("140");
    protected JCheckBox m_showKillRadiusCheck = new JCheckBox("Display");
    protected BranchAssignment m_branchAssignment;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC;
    protected Java2D_UserEventConsumer_MouseMove m_mapMouseMoveUEC;
    protected String m_pickName = "";
    protected String m_shiftName = "ShiftedPick";
    protected Ensemble m_ensemble = new Ensemble();
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Java2D_Paintable_Ensemble_Wiggles m_paintableTraces = new Java2D_Paintable_Ensemble_Wiggles();
    protected Java2D_Paintable_EnsembleHeaderCrossplot m_paintablePicks = new Java2D_Paintable_EnsembleHeaderCrossplot();
    protected Java2D_Paintable_RangeExpander m_pickExpander = new Java2D_Paintable_RangeExpander();
    protected Java2D_UserEventConsumer_Branch m_branchUEC = new Java2D_UserEventConsumer_Branch();
    protected Java2D_UserEventConsumer_KeyPressed m_branchKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected ParameterTree m_parameterTree = new ParameterTree();
    protected String m_parameterFileName;
    protected ArrayList<JTextField> m_arrayMinOffsetText = new ArrayList();
    protected ArrayList<JTextField> m_arrayMaxOffsetText = new ArrayList();
    protected ArrayList<JButton> m_arrayClearButton = new ArrayList();
    protected MultiTextDialog m_offsetDialog;
    protected JButton m_btnReloadAllMapPlots = new JButton("Reload all plots");
    protected ArrayList<JComboBox<String>> m_listComboBranch = new ArrayList();
    protected ArrayList<JComboBox<String>> m_listComboDisplay = new ArrayList();
    protected ArrayList<JButton> m_listButtonReload = new ArrayList();
    protected ArrayList<Java2D_SimpleComposite> m_listMapDisplay = new ArrayList();
    protected JTextField m_textPrecomputeSpacing = new JTextField("5000");
    protected JTextField m_textPrecomputeRadius = new JTextField("300");
    protected JButton m_btnPrecompute;
    protected JButton m_btnPrecomputeClear;
    protected JProgressBar m_progressPrecompute = new JProgressBar();
    protected JRadioButton m_rad_sparse = new JRadioButton("Use precomputed sparse CMP gathers");
    protected JRadioButton m_rad_cmp = new JRadioButton("Use standard CMP gathers");
    protected JRadioButton m_rad_shot = new JRadioButton("Use shot gathers");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JTabbedPane m_leftTabs = new JTabbedPane();
    protected JCheckBox m_chk_apply_current_model;
    protected JComboBox m_combo_current_model_branch;
    protected boolean m_model_applied = false;

    public BranchAssignmentWidget(BranchAssignment ba, PlotType plotType) {
        super(1);
        try {
            this.m_parameterFileName = RefractionStaticsProject.singleton().projectPath() + "/BranchAssignmentOptions.xml";
            this.m_parameterTree.read(this.m_parameterFileName);
            this.m_plotType = plotType;
            this.m_branchAssignment = ba;
            this.m_pickName = "FBP_User";
            this.m_paintableTraces.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            this.m_paintableTraces.setAxisTableColumn("Trace", "Offset");
            this.m_paintableTraces.WiggleOverlap = 3.0f;
            this.m_paintableTraces.ApplyClipping = true;
            this.m_paintableTraces.PositiveColor = Color.LIGHT_GRAY;
            this.setRightComponent(this.createRightWidget());
            if (plotType == PlotType.Picks) {
                this.setLeftComponent(this.createLeftWidget());
            } else {
                this.setLeftComponent(this.createTraceLeftWidget());
            }
            this.reloadColumns();
            this.reloadMapPlot(false);
            for (int n = 0; n < this.m_listButtonReload.size(); ++n) {
                this.loadMapPlot(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns() {
        try {
            this.m_cCombo.removeAllItems();
            ArrayList<String> unionColList = new ArrayList<String>();
            ArrayList<String> recColList = this.database().listOfColumnNames("Receiver");
            ArrayList<String> shotColList = this.database().listOfColumnNames("Shot");
            for (String s : recColList) {
                unionColList.add(s);
            }
            for (String s : shotColList) {
                boolean ok = false;
                for (String s2 : unionColList) {
                    ok = ok || s2.equalsIgnoreCase(s);
                }
                if (ok) continue;
                unionColList.add(s);
            }
            Collections.sort(unionColList);
            unionColList.add(0, "Gray");
            this.m_cCombo.setStringArray(unionColList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRightWidget() {
        try {
            JTextField txt;
            int n;
            JSplitPane splitter = new JSplitPane(1);
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget top1 = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_axisLockerOffset = new Java2D_AxisLocker("Lock offset axis", "Lock offset axis");
            this.m_axisLockerOffset.listener().addListener(this);
            this.m_axisLockerOffset.setParentParameterTree(this.m_parameterTree, "OffsetAxis");
            this.m_axisLockerTime = new Java2D_AxisLocker("Lock time axis", "Lock time axis");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setParentParameterTree(this.m_parameterTree, "TimeAxis");
            this.m_lmoSlider = new SliderWidget(this, "Apply linear moveout - HIGHLY RECOMMENDED", "Linear moveout correction", 0, 3000.0, 1000.0, 22000.0);
            this.m_lmoSlider.setCheckSelected(this.m_parameterTree.bool_get("LmoOn", false));
            this.m_lmoSlider.setDoubleValue(this.m_parameterTree.double_get("LmoVel", 3000.0));
            top1.addComponent(this.m_lmoSlider, 6);
            top1.addComponent(this.m_axisLockerOffset, 0);
            top1.addComponent(this.m_axisLockerTime, 0);
            LinearLayoutWidget top2 = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            for (int n2 = 1; n2 <= 5; ++n2) {
                this.m_branchModel.addElement("Define branch " + Integer.toString(n2));
            }
            this.m_branchList.setModel(this.m_branchModel);
            LinearLayoutWidget sub = top2.createVertical(0, "Select branch", 10);
            sub.addComponent(this.m_branchList, 10);
            this.m_branchList.setSelectedIndex(0);
            this.m_branchList.addListSelectionListener(this);
            GridLayoutWidget grid = top2.createGridLayoutWidget(0, "Offset ranges of current branch location", 20);
            int row = 0;
            int num = 5;
            for (n = 1; n <= num; ++n) {
                grid.addComponent(new JLabel("Refractor " + Integer.toString(n)), row, n - 1, 1.0, 10.0);
            }
            ++row;
            for (n = 1; n <= num; ++n) {
                txt = new JTextField("");
                grid.addComponent(txt, row, n - 1, 1.0, 10.0);
                this.m_arrayMinOffsetText.add(txt);
                txt.addActionListener(this);
            }
            ++row;
            for (n = 1; n <= num; ++n) {
                txt = new JTextField("");
                grid.addComponent(txt, row, n - 1, 1.0, 10.0);
                this.m_arrayMaxOffsetText.add(txt);
                txt.addActionListener(this);
            }
            ++row;
            for (n = 1; n <= num; ++n) {
                JButton btn = new JButton("Clear");
                grid.addComponent(btn, row, n - 1, 1.0, 10.0);
                this.m_arrayClearButton.add(btn);
                btn.addActionListener(this);
            }
            Tools_FontChanger.changeSizeOfFont(top1, -2, null, true);
            Tools_FontChanger.changeSizeOfFont(top2, -2, null, true);
            this.m_branchWidget.setAxesVisible(true, true);
            this.m_branchWidget.setColorScaleVisible(false);
            this.m_branchUEC.addListener(this);
            this.m_branchKeyUEC.addListener(this);
            main.addComponent(this.m_branchWidget, 10);
            splitter.setLeftComponent(main);
            splitter.setRightComponent(this.createMapWidgets());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void populateTextFields() {
        try {
            BranchAssignment.Location loc = this.m_branchAssignment.currentLocation();
            for (JTextField txt : this.m_arrayMinOffsetText) {
                txt.setText("");
                txt.setEnabled(false);
            }
            for (JTextField txt : this.m_arrayMaxOffsetText) {
                txt.setText("");
                txt.setEnabled(false);
            }
            if (loc == null) {
                return;
            }
            for (BranchAssignment.Entry entry : loc.EntryList) {
                if (entry.Refractor < 1) continue;
                JTextField txt = this.m_arrayMinOffsetText.get(entry.Refractor - 1);
                txt.setText(Integer.toString((int)entry.MinimumOffset));
                txt.setEnabled(true);
                txt = this.m_arrayMaxOffsetText.get(entry.Refractor - 1);
                txt.setText(Integer.toString((int)entry.MaximumOffset));
                txt.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleStuffModified(boolean lockMapAxes) {
        try {
            this.reloadBranchPlot();
            this.reloadMapPlot(lockMapAxes);
            this.populateTextFields();
            for (int n = 0; n < this.m_listButtonReload.size(); ++n) {
                this.loadMapPlot(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateAllOffset() {
        try {
            if (this.m_offsetDialog == null) {
                this.m_offsetDialog = new MultiTextDialog(null, "", "Branch number", "Minimum offset", "Maximum offset");
                this.m_offsetDialog.setText(0, "1");
                this.m_offsetDialog.setText(1, "1000");
                this.m_offsetDialog.setText(2, "3000");
            }
            this.m_offsetDialog.showDialog("Reset offsets");
            if (!this.m_offsetDialog.OK) {
                return;
            }
            int b = this.m_offsetDialog.getInt(0, 1, 1, 10);
            double min = this.m_offsetDialog.getDouble(1, 1000.0, 0.0, 100000.0);
            double max = this.m_offsetDialog.getDouble(2, 1000.0, min + 10.0, 100000.0);
            this.m_branchAssignment.setBranchOffset(b, min, max);
            this.handleStuffModified(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateOffsets(int branch) {
        try {
            BranchAssignment.Location loc = this.m_branchAssignment.currentLocation();
            if (loc == null) {
                return;
            }
            for (int n = loc.EntryList.size() - 1; n >= 0; --n) {
                BranchAssignment.Entry entry = loc.EntryList.get(n);
                if (entry.Refractor != branch) continue;
                double currMin = entry.MinimumOffset;
                double currMax = entry.MaximumOffset;
                JTextField txtMin = this.m_arrayMinOffsetText.get(branch - 1);
                JTextField txtMax = this.m_arrayMaxOffsetText.get(branch - 1);
                double min = Tools_Widget.extractDouble(txtMin, currMin, 1.0, 100000.0);
                double max = Tools_Widget.extractDouble(txtMax, currMax, min + 1.0, 100000.0);
                entry.resetOffsets(min, max);
            }
            this.handleStuffModified(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateMaxOffset(int branch) {
        try {
            BranchAssignment.Location loc = this.m_branchAssignment.currentLocation();
            if (loc == null) {
                return;
            }
            for (int n = loc.EntryList.size() - 1; n >= 0; --n) {
                BranchAssignment.Entry entry = loc.EntryList.get(n);
                if (entry.Refractor != branch) continue;
                double curr = entry.MaximumOffset;
                JTextField txt = this.m_arrayMaxOffsetText.get(branch - 1);
                double v = Tools_Widget.extractDouble(txt, curr, 1.0, 100000.0);
                entry.resetMaximumOffset(v);
            }
            this.handleStuffModified(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateMinOffset(int branch) {
        try {
            BranchAssignment.Location loc = this.m_branchAssignment.currentLocation();
            if (loc == null) {
                return;
            }
            for (int n = loc.EntryList.size() - 1; n >= 0; --n) {
                BranchAssignment.Entry entry = loc.EntryList.get(n);
                if (entry.Refractor != branch) continue;
                double curr = entry.MinimumOffset;
                JTextField txt = this.m_arrayMinOffsetText.get(branch - 1);
                double v = Tools_Widget.extractDouble(txt, curr, 1.0, 100000.0);
                entry.resetMinimumOffset(v);
            }
            this.handleStuffModified(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void clearBranchEntry(int branch) {
        try {
            BranchAssignment.Location loc = this.m_branchAssignment.currentLocation();
            if (loc == null) {
                return;
            }
            for (int n = loc.EntryList.size() - 1; n >= 0; --n) {
                BranchAssignment.Entry entry = loc.EntryList.get(n);
                if (entry.Refractor != branch) continue;
                loc.EntryList.remove(n);
            }
            this.handleStuffModified(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createMapWidgets() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            main.addComponent(this.m_btnReloadAllMapPlots, 0);
            this.m_btnReloadAllMapPlots.addActionListener(this);
            for (int n = 0; n < 2; ++n) {
                if (n >= 1) {
                    main.createGapLabel(10);
                }
                LinearLayoutWidget sub = main.createVertical(0, null, 10);
                LinearLayoutWidget top = sub.createHorizontal(0, null, 0);
                JButton btn = new JButton("Reload");
                btn.addActionListener(this);
                this.m_listButtonReload.add(btn);
                JComboBox<String> c1 = new JComboBox<String>();
                JComboBox<String> c2 = new JComboBox<String>();
                for (int b = 1; b <= 10; ++b) {
                    c1.addItem(String.format("Branch %d", b));
                }
                c1.setSelectedIndex(0);
                c2.addItem("Minumum offset");
                c2.addItem("Maximum offset");
                c2.addItem("Offset range");
                c2.addItem("Velocity");
                c2.addItem("Delay time");
                c2.addItem("Interpolated V0");
                c2.setSelectedIndex(n % 5);
                this.m_listComboBranch.add(c1);
                this.m_listComboDisplay.add(c2);
                top.addComponent(c1, 10);
                top.addComponent(c2, 10);
                top.addComponent(btn, 0);
                c1.addItemListener(this);
                c2.addItemListener(this);
                Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
                Java2D_SimpleComposite map = new Java2D_SimpleComposite(true);
                this.m_listMapDisplay.add(map);
                map.setAxesVisible(false, false);
                map.setScrollVisible(false, false);
                sub.addComponent(map, 10);
            }
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void loadMapPlot(int index) {
        try {
            Java2D_PaintablePointArray ppa;
            Java2D_SimpleComposite map = this.m_listMapDisplay.get(index);
            map.mainWidget().clearPaintableList();
            BranchAssignment.MapPlotType pt = BranchAssignment.MapPlotType.DelayTime;
            JComboBox<String> cmb = this.m_listComboDisplay.get(index);
            map.setColorTitle((String)cmb.getSelectedItem());
            int branch = 1 + this.m_listComboBranch.get(index).getSelectedIndex();
            if (cmb.getSelectedIndex() == 0) {
                pt = BranchAssignment.MapPlotType.MinOffset;
            }
            if (cmb.getSelectedIndex() == 1) {
                pt = BranchAssignment.MapPlotType.MaxOffset;
            }
            if (cmb.getSelectedIndex() == 2) {
                pt = BranchAssignment.MapPlotType.OffsetRange;
            }
            if (cmb.getSelectedIndex() == 3) {
                pt = BranchAssignment.MapPlotType.Velocity;
            }
            if (cmb.getSelectedIndex() == 4) {
                pt = BranchAssignment.MapPlotType.DelayTime;
            }
            if (cmb.getSelectedIndex() == 5) {
                pt = BranchAssignment.MapPlotType.InterpolatedV0;
                branch = 1;
            }
            if ((ppa = this.m_branchAssignment.createPointArray(pt, branch)) != null) {
                map.mainWidget().addPaintable(ppa, 0);
                map.mainWidget().addPaintable(this.m_branchAssignment, BranchAssignment.PlotType.Map.ordinal());
            }
            map.mainWidget().setRequireDisplay();
            map.mainWidget().transform().setTechnique(Java2D_Transform.Technique.Basemap);
            map.mainWidget().mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createTraceLeftWidget() {
        try {
            this.m_bitmapCardWidget = new BitmapCardWidget();
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createLeftWidget(), "Basemap");
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            this.m_wiggleOptionsWidget.setFill(false, true);
            this.m_wiggleOptionsWidget.setNoOverlap();
            LinearLayoutWidget w = LinearLayoutWidget.vert(0, null);
            w.addComponent(this.m_wiggleOptionsWidget, 0);
            w.addStretch(10);
            this.m_workerWidget = new Sequence_MainWidget("Branch_Trace", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, w, "Display options");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            Tools_FontChanger.changeSizeOfFont(this.m_workerWidget, 2);
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createAdditionalOptionsWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_btnCopyFirstToSecond = main.createButton("Copy first branch to second branch", this, 0);
            this.m_btnSetAllOffset = main.createButton("Set offset range for a given branch", this, 0);
            LinearLayoutWidget temp = main.createVertical(0, "Additional options", 0);
            this.m_comboDelayTimeShifts.addItem("Do not apply delay time shifts");
            this.m_comboDelayTimeShifts.addItem("Shift using appropriate branch");
            this.m_comboDelayTimeShifts.addItem("Shift all using branch 1 delay times");
            this.m_comboDelayTimeShifts.addItem("Shift all using branch 2 delay times");
            this.m_comboDelayTimeShifts.addItem("Shift all using branch 3 delay times");
            this.m_comboDelayTimeShifts.addItem("Shift all using branch 4 delay times");
            this.m_comboDelayTimeShifts.addItem("Shift all using branch 5 delay times");
            this.m_comboDelayTimeShifts.addItemListener(this);
            temp.addComponent(this.m_comboDelayTimeShifts, 0);
            temp.addComponent(this.m_chkTrackLMO, 0);
            this.m_chkTrackLMO.addActionListener(this);
            for (int n = 0; n < this.m_lmoVel.length; ++n) {
                this.m_lmoVel[n] = -9999.0;
            }
            temp = main.createVertical(1, "Pick acceptance radius, milliseconds", 0);
            String s = "<HTML>The \"acceptance zone\" may be used to kill bad picks</HTML>";
            temp.addComponent(new JLabel(s), 0);
            temp.addHorzPair(this.m_killRadiusText, 8, this.m_showKillRadiusCheck, 1);
            this.m_killRadiusText.addActionListener(this);
            this.m_showKillRadiusCheck.addActionListener(this);
            this.m_showKillRadiusCheck.setSelected(true);
            this.m_branchAssignment.setKillRadius(140.0);
            this.m_showKillRadiusCheck.setSelected(this.m_branchAssignment.getShowKillRadius());
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeftWidget() {
        try {
            JSplitPane leftSplitter = new JSplitPane(0);
            leftSplitter.setMinimumSize(new Dimension(300, 300));
            leftSplitter.setPreferredSize(new Dimension(300, 300));
            leftSplitter.setTopComponent(this.createPickWidget());
            leftSplitter.setBottomComponent(this.createMapWidget());
            this.m_leftTabs = new JTabbedPane();
            this.m_leftTabs.addTab("Map", null, leftSplitter, "Basemap");
            this.m_leftTabs.addTab("Additional", null, this.createAdditionalOptionsWidget(), "Additional options");
            return this.m_leftTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMapWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            main.addHorzPair(new JLabel("Shot/receiver color"), 0, this.m_cCombo, 9);
            this.m_cCombo.listener().addListener(this);
            JLabel lbl = new JLabel("Minimum location separation (ft/m)");
            lbl.setForeground(Color.red);
            main.addHorzPair(lbl, 0, this.m_txtMinSeparation, 9);
            this.m_basemapWidget.setAxesVisible(false, false);
            this.m_basemapWidget.setColorScaleVisible(false);
            this.m_basemapWidget.setScrollVisible(true, true);
            main.addComponent(this.m_basemapWidget, 10);
            main.createLabel("Left-click to add/select branch location", 2, 0);
            main.createLabel("Press \"r\" to remove nearest branch location", 2, 0);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_clearButton = sub.createButton("Remove all branch locations", this, 0);
            sub.addStretch(10);
            this.m_mapMouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
            this.m_mapMouseMoveUEC.addListener(this);
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
            this.m_mapKeyUEC.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createInterpWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMoveoutWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            String s = "<HTML>The selected pick version may be used to compute moveout trend lines. The operation will overwrite user-defined trend lines</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            lbl.setBackground(Color.white);
            main.addComponent(lbl, 0);
            main.createGapLabel(20);
            main.addComponent(new JLabel("Moveout location spacing (ft/m)"), 0);
            main.addComponent(this.m_moveSizeText, 0);
            main.createGapLabel(20);
            this.m_launchMoveoutButton = main.createButton("Begin trend line computation", this, 0);
            main.addStretch(10);
            if (RefractionStaticsProject.singleton().units_feet()) {
                this.m_moveSizeText.setText("5280");
            } else {
                this.m_moveSizeText.setText("1000");
            }
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void saveParameters() {
        try {
            this.m_axisLockerOffset.saveParameters();
            this.m_axisLockerTime.saveParameters();
            if (this.m_lmoSlider.hasCheck()) {
                this.m_parameterTree.bool_put("LmoOn", this.m_lmoSlider.isCheckSelected());
            }
            this.m_parameterTree.double_put("LmoVel", this.m_lmoSlider.getDoubleValue());
            this.m_parameterTree.save(this.m_parameterFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createPickWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
            LinearLayoutWidget gt = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 2, "Select type of gather type", 0);
            gt.addComponent(this.m_rad_sparse, 0);
            gt.addComponent(this.m_rad_cmp, 0);
            gt.addComponent(this.m_rad_shot, 0);
            boolean sparse_ok = sparse.valid() && RefractionStaticsProject.singleton().dim3D();
            boolean pick_coll_ok = this.pickCollection().valid();
            this.m_group.add(this.m_rad_sparse);
            this.m_group.add(this.m_rad_cmp);
            this.m_group.add(this.m_rad_shot);
            if (this.m_plotType == PlotType.Picks) {
                this.m_rad_sparse.setText("Use precomputed pick gathers");
                GridLayoutWidget grid = main.createGridLayoutWidget(3, 0);
                grid.addSimple(0, new JLabel("Spacing (ft/m)"), this.m_textPrecomputeSpacing);
                grid.addSimple(1, new JLabel("Radius (ft/m"), this.m_textPrecomputeRadius);
                this.m_btnPrecompute = main.createButton("Create precomputed pick gathers", this, 0);
                this.m_btnPrecomputeClear = main.createButton("Remove all precomputed pick gathers", this, 0);
                main.addComponent(this.m_progressPrecompute, 0);
                this.m_progressPrecompute.setMinimum(0);
                this.m_progressPrecompute.setMaximum(1000);
                this.pickCollection().read();
                this.m_rad_sparse.setSelected(this.pickCollection().valid());
                this.m_rad_sparse.setEnabled(this.pickCollection().valid());
            } else {
                this.m_rad_sparse.setSelected(sparse.valid());
                this.m_rad_sparse.setEnabled(sparse.valid());
            }
            this.m_rad_shot.setSelected(!this.m_rad_sparse.isSelected());
            this.m_rad_sparse.addActionListener(this);
            this.m_rad_cmp.addActionListener(this);
            this.m_rad_shot.addActionListener(this);
            LinearLayoutWidget first = main.createHorizontal(0, null, 0);
            boolean dim3D = RefractionStaticsProject.singleton().dim3D();
            LinearLayoutWidget temp = first.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Number of bins - used if standard CMP bins", 10);
            this.m_radiusCombo.addItem("1 bin");
            if (dim3D) {
                for (n = 1; n < 11; ++n) {
                    num = 2 * n + 1;
                    s = String.format("%d x %d bins", num, num);
                    this.m_radiusCombo.addItem(s);
                }
            } else {
                for (n = 1; n < 11; ++n) {
                    num = 2 * n + 1;
                    s = String.format("%d bins", num);
                    this.m_radiusCombo.addItem(s);
                }
            }
            if (this.m_plotType == PlotType.Picks) {
                this.m_radiusCombo.setSelectedIndex(2);
            } else {
                this.m_radiusCombo.setSelectedIndex(0);
            }
            temp.addComponent(this.m_radiusCombo, 10);
            this.m_pickVersionWidget = first.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Pick version", 10);
            this.m_pickVersionCombo = new ComboStringListWrapper("FBP_User");
            ITraceTable traceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> pickCols = traceTable.columns("FBP_");
            this.m_pickVersionCombo.setStringArray(pickCols);
            this.m_pickVersionCombo.listener().addListener(this);
            this.m_pickVersionWidget.addComponent(this.m_pickVersionCombo, 10);
            this.m_pickVersionWidget.setVisible(this.m_plotType == PlotType.Picks);
            this.m_radioInterpMethod = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Interpolation method", "Inverse-square", "Inverse-fourth");
            BranchAssignment.InterpolationMethod im = this.m_branchAssignment.interpolationMethod();
            this.m_radioInterpMethod.setSelectedIndex(0);
            if (im == BranchAssignment.InterpolationMethod.InverseFourth) {
                this.m_radioInterpMethod.setSelectedIndex(1);
            }
            this.m_radioInterpMethod.listener().addListener(this);
            main.addComponent(this.m_radioInterpMethod, 0);
            LinearLayoutWidget shifts = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Current model options");
            this.m_chk_apply_current_model = shifts.createCheckBox("Apply interactive delay time model", 0, this);
            this.m_combo_current_model_branch = shifts.createComboBox(this);
            this.m_combo_current_model_branch.addItem("Branch 1");
            this.m_combo_current_model_branch.addItem("Branch 2");
            this.m_combo_current_model_branch.addItem("Branch 3");
            this.m_combo_current_model_branch.addItem("Branch 4");
            main.addComponent(shifts, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            int branch;
            if (this.m_bIgnoreList) {
                return;
            }
            this.m_branchAssignment.DefiningBranch = this.m_branchUEC.Refractor = (branch = 1 + this.m_branchList.getSelectedIndex());
            this.handleStuffModified(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void getKillRadius() {
        try {
            this.m_branchUEC.ShowKillRadius = this.m_showKillRadiusCheck.isSelected();
            this.m_branchUEC.KillRadius = Tools_Widget.extractDouble(this.m_killRadiusText, 20.0, 5.0, 1000.0);
            this.m_branchAssignment.setShowKillRadius(this.m_showKillRadiusCheck.isSelected());
            this.m_branchAssignment.setKillRadius(this.m_branchUEC.KillRadius);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_comboDelayTimeShifts) {
                RefractionStaticsProject.singleton().prepGeometryHeaders(this.m_ensemble, true, true);
                this.shiftPicks();
                this.reloadBranchPlot();
                return;
            }
            for (int n = 0; n < this.m_listButtonReload.size(); ++n) {
                if (e.getSource() == this.m_listComboBranch.get(n)) {
                    this.loadMapPlot(n);
                    return;
                }
                if (e.getSource() != this.m_listComboDisplay.get(n)) continue;
                this.loadMapPlot(n);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void precomputeClear() {
        try {
            this.pickCollection().deleteCurrentLocations();
            this.m_rad_sparse.setEnabled(false);
            this.m_rad_shot.setSelected(true);
            this.m_leftTabs.setSelectedIndex(0);
            this.handleStuffModified(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            int v = (int)(10.0 * percent);
            System.out.println("setPercentDone = " + v);
            this.m_progressPrecompute.setMinimum(0);
            this.m_progressPrecompute.setMaximum(1000);
            this.m_progressPrecompute.setValue(v);
            this.m_progressPrecompute.paintImmediately(0, 0, 600, 24);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected Java2D_Paintable_BranchPickCollections pickCollection() {
        try {
            return RefractionStaticsProject.singleton().preselectedPickLocations();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void precompute() {
        try {
            this.precomputeClear();
            this.pickCollection().deleteCurrentLocations();
            Java2D_Paintable_BranchPickCollections coll = this.pickCollection();
            double spacing = Tools_Widget.extractDouble(this.m_textPrecomputeSpacing, 5000.0, 1.0, 20000.0);
            double radius = Tools_Widget.extractDouble(this.m_textPrecomputeRadius, 300.0, 1.0, 10000.0);
            coll.prep(spacing, radius);
            TraceTable_Scanner_BranchPickLocations scanner = new TraceTable_Scanner_BranchPickLocations(coll);
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, this);
            coll.finishedScanning();
            coll.save();
            this.m_rad_sparse.setEnabled(coll.valid());
            if (coll.valid()) {
                this.m_rad_sparse.setSelected(true);
            } else {
                this.m_rad_shot.setSelected(true);
            }
            this.m_progressPrecompute.setValue(0);
            this.m_leftTabs.setSelectedIndex(0);
            this.handleStuffModified(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int n;
            if (e.getSource() == this.m_btnSetAllOffset) {
                this.updateAllOffset();
                return;
            }
            if (e.getSource() == this.m_chk_apply_current_model) {
                this.shiftPicks();
                this.reloadBranchPlot();
                return;
            }
            if (e.getSource() == this.m_combo_current_model_branch) {
                this.shiftPicks();
                this.reloadBranchPlot();
                return;
            }
            if (e.getSource() == this.m_btnCopyFirstToSecond) {
                BranchAssignment ba = this.m_branchAssignment;
                ba.copy(1, 2);
                this.reloadAllPlots();
                return;
            }
            for (n = 0; n < this.m_arrayMaxOffsetText.size() - 1; ++n) {
                if (e.getSource() != this.m_arrayMaxOffsetText.get(n)) continue;
                this.updateOffsets(n + 1);
                return;
            }
            for (n = 0; n < this.m_arrayMinOffsetText.size() - 1; ++n) {
                if (e.getSource() != this.m_arrayMinOffsetText.get(n)) continue;
                this.updateOffsets(n + 1);
                return;
            }
            for (n = 0; n < this.m_arrayClearButton.size() - 1; ++n) {
                if (e.getSource() != this.m_arrayClearButton.get(n)) continue;
                this.clearBranchEntry(n + 1);
                return;
            }
            if (e.getSource() == this.m_btnPrecomputeClear) {
                this.precomputeClear();
                return;
            }
            if (e.getSource() == this.m_rad_sparse || e.getSource() == this.m_rad_shot || e.getSource() == this.m_rad_cmp) {
                this.reloadMapPlot(false);
                return;
            }
            if (e.getSource() == this.m_btnPrecompute) {
                this.precompute();
                return;
            }
            if (e.getSource() == this.m_btnReloadAllMapPlots) {
                for (n = 0; n < this.m_listButtonReload.size(); ++n) {
                    this.loadMapPlot(n);
                }
                return;
            }
            for (n = 0; n < this.m_listButtonReload.size(); ++n) {
                if (e.getSource() != this.m_listButtonReload.get(n)) continue;
                this.loadMapPlot(n);
                return;
            }
            if (e.getSource() == this.m_showKillRadiusCheck || e.getSource() == this.m_killRadiusText) {
                this.getKillRadius();
                this.reloadBranchPlot();
                return;
            }
            if (e.getSource() == this.m_launchMoveoutButton) {
                int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite user-defined trend lines?", "Confirm overwrite trend lines", 2, 2, null);
                if (res != 0) {
                    return;
                }
                Action_ComputeMoveoutTrends action = new Action_ComputeMoveoutTrends();
                action.Hasher.string_put("PickVersion", this.m_pickName);
                action.Hasher.string_put("Spacing", this.m_moveSizeText.getText());
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (e.getSource() == this.m_clearButton) {
                this.m_branchAssignment.removeAll();
                this.handleStuffModified(false);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            if (sender == this.m_lmoSlider) {
                this.shiftPicks();
                this.reloadBranchPlot();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleMouseMove() {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_cCombo) {
                this.reloadMapPlot(true);
                return;
            }
            if (sender == this.m_mapMouseMoveUEC) {
                this.handleMouseMove();
                return;
            }
            if (sender == this.m_radioInterpMethod) {
                BranchAssignment ba = this.m_branchAssignment;
                if (this.m_radioInterpMethod.getSelectedIndex() == 0) {
                    ba.setInterpolationMethod(BranchAssignment.InterpolationMethod.InverseSquare);
                } else if (this.m_radioInterpMethod.getSelectedIndex() == 1) {
                    ba.setInterpolationMethod(BranchAssignment.InterpolationMethod.InverseFourth);
                }
                for (int n = 0; n < this.m_listButtonReload.size(); ++n) {
                    this.loadMapPlot(n);
                }
                return;
            }
            if (sender == this.m_wiggleOptionsWidget) {
                this.reloadBranchPlot();
                return;
            }
            if (sender == this.m_sequence && data instanceof EnsembleWorker_Sequence.MessageDataStruct) {
                EnsembleWorker_Sequence.MessageDataStruct md = (EnsembleWorker_Sequence.MessageDataStruct)data;
                if (md.Type == EnsembleWorker_Sequence.MessageType.SequenceModified) {
                    this.shiftPicks();
                    this.reloadBranchPlot();
                }
            }
            if (sender == this.m_branchAssignment) {
                return;
            }
            if (sender == this.m_pickVersionCombo) {
                this.m_pickName = this.m_pickVersionCombo.getSelectedString();
                this.shiftPicks();
                this.reloadBranchPlot();
            }
            if (sender == this.m_branchUEC) {
                if (this.m_branchUEC.Dragging) {
                    this.m_branchWidget.mainWidget().repaint();
                    return;
                }
                if (this.m_branchUEC.StuffOK) {
                    if (this.m_model_applied) {
                        EnsembleTrace mint = this.m_ensemble.getNearestTrace_Pixel(this.m_branchUEC.StartPixelX);
                        EnsembleTrace maxt = this.m_ensemble.getNearestTrace_Pixel(this.m_branchUEC.EndPixelX);
                        float t1 = mint.data().getFirstSampleCoord_WithShifts();
                        float t2 = maxt.data().getFirstSampleCoord_WithShifts();
                        double mintime = this.m_branchUEC.MinTime - (double)t1;
                        double maxtime = this.m_branchUEC.MaxTime - (double)t2;
                        this.m_branchAssignment.setBranch(this.m_branchUEC.Refractor, this.m_branchUEC.MinOff, this.m_branchUEC.MaxOff, mintime, maxtime);
                    } else {
                        this.m_branchAssignment.setBranch(this.m_branchUEC.Refractor, this.m_branchUEC.MinOff, this.m_branchUEC.MaxOff, this.m_branchUEC.MinTime, this.m_branchUEC.MaxTime);
                    }
                }
                this.shiftPicks();
                this.handleStuffModified(true);
                this.m_basemapWidget.mainWidget().repaint();
                for (int n = 0; n < this.m_listButtonReload.size(); ++n) {
                    this.loadMapPlot(n);
                }
            }
            if (sender == this.m_branchKeyUEC) {
                int code = this.m_branchKeyUEC.KeyCode;
                if (code >= 49 && code <= 53) {
                    this.m_branchUEC.Refractor = code - 49 + 1;
                    this.resetLMOVel();
                    this.m_branchAssignment.DefiningBranch = this.m_branchUEC.Refractor;
                    this.reloadBranchPlot();
                    this.m_bIgnoreList = true;
                    this.m_branchList.setSelectedIndex(this.m_branchUEC.Refractor - 1);
                    this.m_bIgnoreList = false;
                }
                if (code == 32) {
                    this.goToNextSparse();
                }
                if (code == 39) {
                    this.goToNextSparse();
                }
                if (code == 37) {
                    this.goToPriorSparse();
                }
                this.populateTextFields();
            }
            if (sender == this.m_mapKeyUEC) {
                if (this.m_mapKeyUEC.KeyCode == 82) {
                    this.m_branchAssignment.removeClosest(this.m_mapKeyUEC.PixelX, this.m_mapKeyUEC.PixelY);
                    this.m_basemapWidget.mainWidget().repaint();
                    this.m_ensemble.clearTraces(false);
                    this.reloadBranchPlot();
                }
                return;
            }
            if (sender == this.m_leftClickUEC) {
                this.handleMapClick();
                return;
            }
            if (sender == this.m_axisLockerOffset || sender == this.m_axisLockerTime) {
                this.reloadBranchPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick_Picks2D() {
        try {
            double minSep = Tools_Widget.extractDouble(this.m_txtMinSeparation, 2000.0, 25.0, 20000.0);
            this.m_branchAssignment.selectLocation_Coords(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, minSep);
            double currX = this.m_branchAssignment.currentLocation().X;
            double currY = this.m_branchAssignment.currentLocation().Y;
            if (this.m_rad_cmp.isSelected() || this.m_rad_sparse.isSelected()) {
                IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                int bin = grid2D.getBin(currX, currY);
                int radius = this.m_radiusCombo.getSelectedIndex();
                RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_ensemble, bin, radius, false);
            } else {
                this.m_ensemble.clearTraces(true);
                RefractionStaticsProject.singleton().shotTable().selectNearestSpatialPoint(currX, currY);
                int sid = RefractionStaticsProject.singleton().shotTable().SelectedID;
                RefractionStaticsProject.singleton().ensemble_Shot(this.m_ensemble, sid, false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick_Traces2D() {
        try {
            double minSep = Tools_Widget.extractDouble(this.m_txtMinSeparation, 2000.0, 25.0, 20000.0);
            this.m_branchAssignment.selectLocation_Coords(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, minSep);
            double currX = this.m_branchAssignment.currentLocation().X;
            double currY = this.m_branchAssignment.currentLocation().Y;
            if (this.m_rad_cmp.isSelected() || this.m_rad_sparse.isSelected()) {
                IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                int bin = grid2D.getBin(currX, currY);
                int radius = this.m_radiusCombo.getSelectedIndex();
                RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_inputEnsemble, bin, radius, true);
            } else {
                this.m_inputEnsemble.clearTraces(true);
                RefractionStaticsProject.singleton().shotTable().selectNearestSpatialPoint(currX, currY);
                int sid = RefractionStaticsProject.singleton().shotTable().SelectedID;
                RefractionStaticsProject.singleton().ensemble_Shot(this.m_inputEnsemble, sid, true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick_Picks3D() {
        try {
            double currY;
            double currX;
            double minSep = Tools_Widget.extractDouble(this.m_txtMinSeparation, 2000.0, 25.0, 20000.0);
            boolean okay = false;
            if (this.m_rad_sparse.isSelected() && this.pickCollection().valid()) {
                okay = this.pickCollection().nearest(this.m_ensemble, this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY);
                this.m_branchAssignment.selectLocation_Coords(this.pickCollection().SelectedX, this.pickCollection().SelectedY, minSep);
            }
            if (this.m_rad_cmp.isSelected()) {
                okay = true;
                this.m_branchAssignment.selectLocation_Coords(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, minSep);
                currX = this.m_branchAssignment.currentLocation().X;
                currY = this.m_branchAssignment.currentLocation().Y;
                Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
                grid3D.setWorldLocation(currX, currY);
                int radius = this.m_radiusCombo.getSelectedIndex();
                RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_ensemble, grid3D.Inline, grid3D.Crossline, radius, false);
            }
            if (!okay) {
                this.m_branchAssignment.selectLocation_Coords(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, minSep);
                currX = this.m_branchAssignment.currentLocation().X;
                currY = this.m_branchAssignment.currentLocation().Y;
                this.m_ensemble.clearTraces(true);
                RefractionStaticsProject.singleton().shotTable().selectNearestSpatialPoint(currX, currY);
                int sid = RefractionStaticsProject.singleton().shotTable().SelectedID;
                RefractionStaticsProject.singleton().ensemble_Shot(this.m_ensemble, sid, false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewSparseEnsemble() {
        try {
            SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
            RefractionStaticsProject.singleton().prepGeometryHeaders(this.m_inputEnsemble, true, true);
            RefractionStaticsProject.singleton().inputDataProcessor_Run(this.m_inputEnsemble);
            int pixelX = this.m_basemapWidget.mainWidget().transform().getPixelFromWorld_X(sparse.SelectedX);
            int pixelY = this.m_basemapWidget.mainWidget().transform().getPixelFromWorld_Y(sparse.SelectedY);
            this.m_branchAssignment.selectLocation_Coords(sparse.SelectedX, sparse.SelectedY, 100.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void goToNextSparse() {
        try {
            if (!this.m_rad_sparse.isSelected()) {
                return;
            }
            SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
            sparse.next(this.m_inputEnsemble);
            this.handleNewSparseEnsemble();
            this.shiftPicks();
            this.reloadBranchPlot();
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void goToPriorSparse() {
        try {
            if (this.m_rad_sparse.isSelected()) {
                return;
            }
            SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
            sparse.prior(this.m_inputEnsemble);
            this.handleNewSparseEnsemble();
            this.shiftPicks();
            this.reloadBranchPlot();
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick_Traces3D() {
        try {
            double minSep = Tools_Widget.extractDouble(this.m_txtMinSeparation, 2000.0, 25.0, 20000.0);
            if (this.m_rad_sparse.isSelected()) {
                SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                sparse.selectNearestCMP(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, this.m_inputEnsemble);
                this.handleNewSparseEnsemble();
                return;
            }
            this.m_branchAssignment.selectLocation_Coords(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, minSep);
            double currX = this.m_branchAssignment.currentLocation().X;
            double currY = this.m_branchAssignment.currentLocation().Y;
            if (this.m_rad_shot.isSelected()) {
                this.m_inputEnsemble.clearTraces(true);
                RefractionStaticsProject.singleton().shotTable().selectNearestSpatialPoint(currX, currY);
                int sid = RefractionStaticsProject.singleton().shotTable().SelectedID;
                RefractionStaticsProject.singleton().ensemble_Shot(this.m_inputEnsemble, sid, true);
                return;
            }
            Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
            grid3D.setWorldLocation(currX, currY);
            int radius = this.m_radiusCombo.getSelectedIndex();
            RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_inputEnsemble, grid3D.Inline, grid3D.Crossline, radius, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick() {
        try {
            boolean okay = false;
            this.m_ensemble.clearTraces(false);
            this.m_inputEnsemble.clearTraces(false);
            if (RefractionStaticsProject.singleton().dim3D()) {
                if (this.m_plotType == PlotType.Picks) {
                    this.handleMapClick_Picks3D();
                } else {
                    this.handleMapClick_Traces3D();
                }
            } else if (this.m_plotType == PlotType.Picks) {
                this.handleMapClick_Picks2D();
            } else {
                this.handleMapClick_Traces2D();
            }
            this.populateTextFields();
            this.shiftPicks();
            this.reloadBranchPlot();
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void resetLMOVel() {
        try {
            if (this.m_chkTrackLMO.isSelected() && this.m_lmoVel[this.m_branchUEC.Refractor] > 100.0) {
                this.m_lmoSlider.setDoubleValue(this.m_lmoVel[this.m_branchUEC.Refractor]);
            }
            this.shiftPicks();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shiftPicks() {
        try {
            this.m_model_applied = false;
            if (this.m_plotType == PlotType.Traces) {
                this.m_inputEnsemble.copyToOtherEnsemble(this.m_ensemble);
                if (this.m_sequence != null) {
                    this.m_ensemble = this.m_sequence.work(this.m_ensemble);
                }
            }
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            int indexShift = this.m_ensemble.dictionary().addEntry("Trace", this.m_shiftName, DataType.Float);
            int indexOffset = this.m_ensemble.dictionary().getEntryIndex("Trace", "Offset");
            double lmoVel = this.m_lmoSlider.getDoubleValue();
            for (int n = 0; n < this.m_lmoVel.length; ++n) {
                if (!(this.m_lmoVel[n] < 10.0) && this.m_chkTrackLMO.isSelected()) continue;
                this.m_lmoVel[n] = lmoVel;
            }
            this.m_lmoVel[this.m_branchUEC.Refractor] = lmoVel;
            boolean applyLMO = this.m_lmoSlider.isCheckSelected();
            this.m_branchUEC.ApplyLMO = false;
            this.m_branchUEC.VelLMO = lmoVel;
            this.m_branchAssignment.ApplyLMO = false;
            this.m_branchAssignment.ModelApplied = false;
            this.m_branchAssignment.VelLMO = lmoVel;
            int dtMethod = this.m_comboDelayTimeShifts.getSelectedIndex();
            if (this.m_plotType == PlotType.Picks) {
                this.m_branchUEC.ApplyLMO = applyLMO;
                this.m_branchAssignment.ApplyLMO = applyLMO;
                int indexPick = this.m_ensemble.dictionary().getEntryIndex("Trace", this.m_pickName);
                for (int t = 0; t < this.m_ensemble.traceCount(); ++t) {
                    Column_Abstract header = this.m_ensemble.trace(t).header();
                    double offset = header.getDouble(indexOffset);
                    float pick = header.getFloat(indexPick);
                    if (applyLMO) {
                        double shift = 1000.0 * offset / lmoVel;
                        pick -= (float)shift;
                    }
                    header.putFloat(indexShift, pick);
                }
                if (dtMethod == 1 && this.m_branchAssignment.maxBranch() >= 1) {
                    this.m_branchAssignment.assignBranch(this.m_ensemble, "Branch");
                    this.m_branchAssignment.shiftPicksUsingDelayTime_ZeroMean(this.m_ensemble, this.m_shiftName, "Branch");
                }
                if (dtMethod >= 2) {
                    int branch = dtMethod - 1;
                    this.m_branchAssignment.shiftAllPicksUsingDelayTime_ZeroMean(this.m_ensemble, this.m_shiftName, branch);
                }
            } else {
                boolean apply_model = this.m_chk_apply_current_model.isSelected();
                if (apply_model) {
                    int b = 1 + this.m_combo_current_model_branch.getSelectedIndex();
                    this.m_branchAssignment.ModelApplied = this.m_model_applied = this.m_branchAssignment.apply_interactive_model(this.m_ensemble, b);
                }
                this.m_branchUEC.ApplyLMO = applyLMO && !this.m_model_applied;
                this.m_branchAssignment.ApplyLMO = applyLMO && !this.m_model_applied;
                for (int t = 0; t < this.m_ensemble.traceCount(); ++t) {
                    FloatArrayWrapper wrapper = this.m_ensemble.trace(t).data();
                    if (!applyLMO || apply_model) continue;
                    double offset = this.m_ensemble.trace(t).header().getDouble(indexOffset);
                    float shift = (float)(1000.0 * offset / lmoVel);
                    wrapper.addShiftToFirstSampleCoord(0.0f - shift);
                }
                if (!apply_model && dtMethod == 1 && this.m_branchAssignment.maxBranch() >= 1) {
                    this.m_branchAssignment.assignBranch(this.m_ensemble, "Branch");
                    this.m_branchAssignment.shiftTracesUsingDelayTime_ZeroMean(this.m_ensemble, "Branch");
                }
                if (!apply_model && dtMethod >= 2) {
                    int branch = dtMethod - 1;
                    this.m_branchAssignment.shiftAllTracesUsingDelayTime_ZeroMean(this.m_ensemble, branch);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadAllPlots() {
        try {
            this.m_ensemble.clearTraces(false);
            this.m_inputEnsemble.clearTraces(false);
            this.m_branchAssignment.clearLocation();
            this.reloadBranchPlot();
            this.reloadMapPlot(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadBranchPlot() {
        try {
            Java2D_Widget w = this.m_branchWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_ensemble.traceCount() < 1) {
                w.mooz();
                return;
            }
            if (this.m_plotType == PlotType.Picks) {
                this.m_paintablePicks.MinimumValidY = -1000.0;
                this.m_paintablePicks.setEnsemble(this.m_ensemble);
                this.m_paintablePicks.setAxisX("Trace", "Offset");
                this.m_paintablePicks.setAxisY("Trace", this.m_shiftName);
                this.m_paintablePicks.Size = 5;
                this.m_paintablePicks.FixedColor = Color.BLACK;
                this.m_paintablePicks.Symbol = Java2D_PointSymbol.Plus;
                this.m_paintablePicks.UseColorScale = false;
                w.addPaintable(this.m_paintablePicks, -9999);
            } else {
                this.m_paintableTraces.setEnsemble(this.m_ensemble);
                this.m_wiggleOptionsWidget.prepPainter(this.m_paintableTraces);
                w.addPaintable(this.m_paintableTraces, -9999);
            }
            this.m_pickExpander.ApplyX = true;
            this.m_pickExpander.MinX = -200.0;
            this.m_pickExpander.MaxX = 0.0;
            this.m_pickExpander.ApplyY = true;
            this.m_pickExpander.MinY = -100.0;
            this.m_pickExpander.MaxY = 0.0;
            w.addPaintable(this.m_pickExpander, -9999);
            w.addPaintable(this.m_branchAssignment, BranchAssignment.PlotType.Branch.ordinal());
            w.transform().setAxisLockedX(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
            w.transform().setAxisLockedY(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            w.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_branchUEC);
            w.addEventConsumer(this.m_branchKeyUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMapPlot(boolean lockAxes) {
        try {
            SparseCmpGatherManager sparse;
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (lockAxes) {
                w.transform().lockCurrentViewport();
            }
            boolean showShot = true;
            boolean showRec = true;
            this.m_shotPaintable = null;
            this.m_receiverPaintable = null;
            if (this.m_cCombo.getSelectedIndex() < 1) {
                this.m_shotPaintable = Tools_RefractionStaticsProject.loadGeomPO("Shot");
                this.m_receiverPaintable = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
                this.m_shotPaintable.FixedColor = Color.LIGHT_GRAY;
                this.m_receiverPaintable.FixedColor = Color.LIGHT_GRAY;
            } else {
                String axisC = this.m_cCombo.getSelectedString();
                if (RefractionStaticsProject.singleton().shotTable().column_exists(axisC)) {
                    this.m_shotPaintable = Tools_RefractionStaticsProject.loadGeomPO("Shot", axisC);
                }
                if (RefractionStaticsProject.singleton().receiverTable().column_exists(axisC)) {
                    this.m_receiverPaintable = Tools_RefractionStaticsProject.loadGeomPO("Receiver", axisC);
                }
            }
            if (this.m_shotPaintable != null && showShot) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_receiverPaintable != null && showRec) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            if (this.m_plotType == PlotType.Picks && this.pickCollection() != null && this.m_rad_sparse.isSelected() && this.pickCollection().valid()) {
                w.addPaintable(this.pickCollection(), -9999);
            }
            if (this.m_plotType == PlotType.Traces && this.m_rad_sparse.isSelected() && (sparse = RefractionStaticsProject.singleton().sparseCmpGathers()).size() > 0) {
                Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray(sparse);
                w.addPaintable(pa, -9999);
            }
            w.addPaintable(this.m_branchAssignment, BranchAssignment.PlotType.Map.ordinal());
            if (lockAxes) {
                w.repaint();
            } else {
                w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                w.mooz();
            }
            w.transform().unlockCurrentViewport();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_leftClickUEC);
            w.addEventConsumer(this.m_mapKeyUEC);
            w.addEventConsumer(this.m_mapMouseMoveUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static enum PlotType {
        Picks,
        Traces;

    }
}

