/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchPickKillDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class BranchAssignmentDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ClipboardOwner {
    protected boolean m_bCalledFromShearMenu = false;
    protected RefractionStaticsProject m_project;
    protected DelayTimeData m_delayTimeData;
    protected BranchAssignment m_branchAssignment;
    protected BranchAssignmentWidget m_branchWidget;
    protected JLabel m_statusLabel = new JLabel("", 0);
    protected JButton m_btnOK = new JButton("Apply changes");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JButton m_btnSave = new JButton("Save");
    protected JButton m_btnOpen = new JButton("Open");
    protected JButton m_btnImportSS = new JButton("Import SS");
    protected JButton m_btnScreen = new JButton("Screencapture");
    protected JButton m_btnImportBrazos = new JButton("Import Brazos");
    protected JButton m_btnImportCSV = new JButton("Import CSV");
    protected JButton m_btnExportCSV = new JButton("Export CSV");
    public boolean BranchModified = false;

    public BranchAssignmentDialog(BranchAssignmentWidget.PlotType plotType, boolean bCalledFromShearMenu) {
        try {
            this.m_bCalledFromShearMenu = bCalledFromShearMenu;
            this.m_project = RefractionStaticsProject.singleton();
            this.m_delayTimeData = this.m_project.getDelayTimeData();
            String branchFileName = this.m_delayTimeData.branchFileName();
            this.m_branchAssignment = new BranchAssignment();
            this.m_branchAssignment.read(branchFileName);
            this.m_branchAssignment.addListener(this);
            this.getContentPane().setLayout(new BorderLayout());
            this.m_branchWidget = new BranchAssignmentWidget(this.m_branchAssignment, plotType);
            Tools_FontChanger.changeSizeOfFont(this.m_statusLabel, 2);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addComponent(this.m_statusLabel, 10);
            bottom.addComponent(this.m_btnSave, 0);
            bottom.addComponent(this.m_btnOpen, 0);
            bottom.addComponent(this.m_btnImportSS, 0);
            bottom.addComponent(this.m_btnImportBrazos, 0);
            bottom.addComponent(this.m_btnScreen, 0);
            bottom.addComponent(this.m_btnImportCSV, 0);
            bottom.addComponent(this.m_btnExportCSV, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_btnSave.addActionListener(this);
            this.m_btnOpen.addActionListener(this);
            this.m_btnImportSS.addActionListener(this);
            this.m_btnScreen.addActionListener(this);
            this.m_btnImportBrazos.addActionListener(this);
            this.m_btnImportCSV.addActionListener(this);
            this.m_btnExportCSV.addActionListener(this);
            this.getContentPane().add((Component)this.m_branchWidget, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.branchOK();
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.setSize(1150, 850);
            this.setTitle("Refractor branch assignment");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean branchOK() {
        try {
            this.m_btnOK.setEnabled(false);
            int maxBranch = this.m_branchAssignment.maxBranch();
            if (maxBranch < 1) {
                this.m_statusLabel.setForeground(Color.RED);
                this.m_statusLabel.setText("No branch points assigned");
                return false;
            }
            for (int branch = 1; branch < maxBranch; ++branch) {
                if (this.m_branchAssignment.hasBranch(branch)) continue;
                this.m_statusLabel.setForeground(Color.RED);
                this.m_statusLabel.setText("Cannot define branch " + Integer.toString(maxBranch) + " without also defining branch " + Integer.toString(branch));
                return false;
            }
            if (!this.m_branchAssignment.checkOffsetRanges()) {
                this.m_statusLabel.setForeground(Color.RED);
                this.m_statusLabel.setText(this.m_branchAssignment.OffsetRangeErrorMessage);
                return false;
            }
            this.m_statusLabel.setForeground(Color.BLUE);
            this.m_statusLabel.setText("Branch assignment appears to be okay");
            this.m_btnOK.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_branchAssignment) {
                this.branchOK();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected void screen() {
        try {
            Rectangle rec = this.getBounds();
            BufferedImage capture = new Robot().createScreenCapture(rec);
            TransferableImage trans = new TransferableImage(capture);
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(trans, this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.BranchModified = false;
            if (e.getSource() == this.m_btnScreen) {
                this.screen();
                return;
            }
            if (e.getSource() == this.m_btnImportCSV) {
                String fileName = Tools_Chooser.getFileName();
                if (fileName == null) {
                    return;
                }
                this.m_branchAssignment.importCSV(fileName);
                this.m_branchWidget.reloadAllPlots();
                this.branchOK();
                return;
            }
            if (e.getSource() == this.m_btnExportCSV) {
                String fileName = Tools_Chooser.getFileName();
                if (fileName == null) {
                    return;
                }
                this.m_branchAssignment.exportCSV(fileName);
                return;
            }
            if (e.getSource() == this.m_btnImportBrazos) {
                String fileName = Tools_Chooser.getFileName();
                if (fileName == null) {
                    return;
                }
                this.m_branchAssignment.importBrazos(fileName);
                this.m_branchWidget.reloadAllPlots();
                this.branchOK();
                return;
            }
            if (e.getSource() == this.m_btnImportSS) {
                String fileName = Tools_Chooser.getFileName();
                if (fileName == null) {
                    return;
                }
                this.m_branchAssignment.importSS(fileName);
                this.m_branchWidget.reloadAllPlots();
                this.branchOK();
                return;
            }
            if (e.getSource() == this.m_btnOpen) {
                String fileName = Tools_Chooser.getFileName();
                if (fileName == null) {
                    return;
                }
                this.m_branchAssignment.read(fileName);
                this.m_branchWidget.reloadAllPlots();
                this.branchOK();
                return;
            }
            if (e.getSource() == this.m_btnSave) {
                String fileName = Tools_Chooser.getSaveFileName(null);
                if (fileName != null) {
                    fileName = Tools_Strings.confirmSuffix(fileName, "xml");
                    this.m_branchAssignment.save(fileName);
                }
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                this.m_branchWidget.getKillRadius();
                this.m_delayTimeData.setBranchAssignment(this.m_branchAssignment);
                if (!this.m_bCalledFromShearMenu) {
                    int res = JOptionPane.showConfirmDialog(null, "Do you want to interpolate the defined fields to \nthe refractor velocities and delay times?\nThis will overwrite existing information", "", 0);
                    if (res == 0) {
                        this.m_delayTimeData.interpolateFromBranch();
                    } else {
                        this.m_delayTimeData.removeUnusedRefractorData();
                        this.m_delayTimeData.interpolateFromBranch_IfNeeded();
                    }
                    this.m_delayTimeData.confirmDelayTimeAnisotropyColumnsExist();
                    res = JOptionPane.showConfirmDialog(null, "Do you want to kill picks using the branch assignment information? \nIt might be a good idea to back up picks first...", "", 0);
                    if (res == 0) {
                        BranchPickKillDialog branchPickKillDialog = new BranchPickKillDialog();
                    }
                    Messenger.broadcast(Messenger.Message.ColumnsModified, null, null);
                }
                this.BranchModified = true;
                this.dispose();
                RefractionStaticsProject.singleton().preselectedPickLocations().freeMemory();
                this.m_branchWidget.saveParameters();
                if (!this.m_bCalledFromShearMenu) {
                    RefractionProjectSuggestions.singleton().branchModified();
                }
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                RefractionStaticsProject.singleton().preselectedPickLocations().freeMemory();
                this.m_branchWidget.saveParameters();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

