/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid2D_Conversion_Line;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Refraction.DefineGridThreeCornerDialog;
import com.PecosLibrary.Windows.Refraction.Grid2DDialog;
import com.PecosLibrary.Windows.Refraction.Grid3DDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class DefineGridWidget
extends JPanel
implements ActionListener,
GenericObjectListener.Listener {
    protected Java2D_SimpleComposite m_plotWidget = new Java2D_SimpleComposite(false);
    protected Java2D_UserEventConsumer_Line m_lineUEC = new Java2D_UserEventConsumer_Line();
    protected Java2D_Paintable_Table m_shotPaintable = new Java2D_Paintable_Table();
    protected Java2D_Paintable_Table m_receiverPaintable = new Java2D_Paintable_Table();
    protected JButton m_btnOK;
    protected JButton m_btnCancel;
    protected JButton m_btnPromax;
    protected JButton m_btnReceiver;
    protected JProgressBar m_progress = new JProgressBar();
    protected boolean m_okayToCancel;
    protected boolean m_dim3D;
    protected Grid3D_Conversion m_tempGrid3D;
    protected IGrid2D_Conversion m_tempGrid2D;
    protected WeakReference<DefineGridWidgetOwner> m_owner;
    protected Timer m_timer = new Timer(300, this);
    protected int m_timerCount = 0;

    public DefineGridWidget(boolean okayToCancel, DefineGridWidgetOwner owner, boolean autoFire) {
        try {
            if (owner != null) {
                this.m_owner = new WeakReference<DefineGridWidgetOwner>(owner);
            }
            this.m_dim3D = RefractionStaticsProject.singleton().dim3D();
            this.m_okayToCancel = okayToCancel;
            this.m_plotWidget.setColorScaleVisible(false);
            Grid3D_Conversion grid = Tools_RefractionStaticsProject.getGrid3D();
            this.m_tempGrid3D = grid.clone();
            Tools_RefractionStaticsProject.gridRange3D(this.m_tempGrid3D);
            this.m_tempGrid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion().clone();
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            if (this.m_okayToCancel) {
                this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            }
            if (RefractionStaticsProject.singleton().dim3D()) {
                this.m_btnPromax = bottom.createButton("3 corner definition", this, 0);
                this.m_btnReceiver = bottom.createButton("Use receiver info", this, 0);
            }
            this.m_btnOK = bottom.createButton("Apply", this, 0);
            bottom.addComponent(this.m_progress, 10);
            String s = "<HTML><center>Left-click and drag to define the grid azimuth.  You will then be prompted to enter the bin sizes.<br></center></HTML>";
            JLabel lbl = new JLabel(s, 0);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)lbl, "North");
            this.add((Component)this.m_plotWidget, "Center");
            this.add((Component)bottom, "South");
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_shotPaintable.setTable(p.shotTable());
            this.m_shotPaintable.UseColorScale = false;
            this.m_shotPaintable.Size_Pixel = 3;
            this.m_shotPaintable.FixedColor = Color.RED;
            this.m_shotPaintable.Symbol = Java2D_PointSymbol.X;
            this.m_shotPaintable.setAxisX("Easting");
            this.m_shotPaintable.setAxisY("Northing");
            this.m_receiverPaintable.setTable(p.receiverTable());
            this.m_receiverPaintable.UseColorScale = false;
            this.m_receiverPaintable.Size_Pixel = 3;
            this.m_receiverPaintable.FixedColor = Color.BLUE;
            this.m_receiverPaintable.Symbol = Java2D_PointSymbol.Plus;
            this.m_receiverPaintable.setAxisX("Easting");
            this.m_receiverPaintable.setAxisY("Northing");
            this.m_plotWidget.mainWidget().addZoomer();
            this.m_plotWidget.mainWidget().addEventConsumer(this.m_lineUEC);
            this.m_lineUEC.addListener(this);
            this.reloadPlot();
            if (autoFire) {
                this.m_timer.start();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadPlot() {
        try {
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            if (this.m_dim3D) {
                Grid3D g = new Grid3D(this.m_tempGrid3D);
                g.DrawColor = false;
                g.DrawLines = true;
                w.addPaintable(g, -9999);
            }
            w.addPaintable(this.m_receiverPaintable, -9999);
            w.addPaintable(this.m_shotPaintable, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_lineUEC) {
                int off = (int)this.m_lineUEC.Offset;
                double az = this.m_lineUEC.Azimuth * 180.0 / Math.PI;
                if (this.m_lineUEC.Dragging) {
                    return;
                }
                this.m_plotWidget.mainWidget().repaint();
                if (this.m_lineUEC.TinyLine) {
                    return;
                }
                if (RefractionStaticsProject.singleton().dim3D()) {
                    Grid3DDialog dlg = new Grid3DDialog(this.m_tempGrid3D, az, this.m_lineUEC.StartWorldX, this.m_lineUEC.StartWorldY);
                    Tools_RefractionStaticsProject.gridRange3D(this.m_tempGrid3D);
                } else if (this.m_tempGrid2D instanceof Grid2D_Conversion_Line) {
                    Grid2DDialog grid2DDialog = new Grid2DDialog(this.m_tempGrid3D, (Grid2D_Conversion_Line)this.m_tempGrid2D, az, this.m_lineUEC.StartWorldX, this.m_lineUEC.StartWorldY);
                }
                this.reloadPlot();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void importPromax() {
        try {
            DefineGridThreeCornerDialog dlg = new DefineGridThreeCornerDialog(this.m_tempGrid3D, true);
            Tools_RefractionStaticsProject.gridRange3D(this.m_tempGrid3D);
            this.reloadPlot();
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            try {
                JOptionPane.showMessageDialog(null, "Import failed", "Import failed", 0);
            }
            catch (Exception error2) {
                ExceptionMonitor.add(error2);
            }
            return;
        }
    }

    public void work(boolean showDialog) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.killBinSort();
            boolean dim2D = project.dim2D();
            IGrid2D_Conversion grid2D = project.getGrid2D_Conversion();
            Grid3D_Conversion grid3D = project.getGrid3D_Conversion();
            if (dim2D) {
                project.setGrid2D_Conversion(this.m_tempGrid2D);
                grid2D = project.getGrid2D_Conversion();
            }
            grid3D.setBinSize(this.m_tempGrid3D.inlineBinSize(), this.m_tempGrid3D.crosslineBinSize());
            grid3D.setOrigin(this.m_tempGrid3D.originX(), this.m_tempGrid3D.originY());
            grid3D.setInlineAngle(this.m_tempGrid3D.inlineAngle());
            grid3D.setCrosslineAtOrigin(this.m_tempGrid3D.crosslineAtOrigin());
            grid3D.setInlineAtOrigin(this.m_tempGrid3D.inlineAtOrigin());
            Tools_RefractionStaticsProject.gridRange3D(grid3D);
            project.saveGrid3D_Conversion();
            Grid3D foldGrid = project.getEmptyGrid3D();
            foldGrid.setValue(0.0f);
            float[][] foldData = foldGrid.data();
            int foldGridErrorCount = 0;
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            this.m_progress.setMaximum((int)(traceTable.rowCount() / 1000L));
            int indexInline = traceTable.column_indexOfColumn("Inline");
            int indexCrossline = traceTable.column_indexOfColumn("Crossline");
            int indexShotID = traceTable.column_indexOfColumn("ShotID");
            int indexRecID = traceTable.column_indexOfColumn("ReceiverID");
            int indexBin2D = -9999;
            if (dim2D) {
                indexBin2D = traceTable.column_append("Bin2D", DataType.Int);
            }
            Table_Abstract shotTable = project.shotTable();
            HashMap_Integer shotMap = project.shotMap();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotKilled = shotTable.column_indexOfColumn("Killed");
            Table_Abstract recTable = project.receiverTable();
            HashMap_Integer recMap = project.receiverMap();
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecKilled = recTable.column_indexOfColumn("Killed");
            int maxOffset = 0;
            int minOffset = Integer.MAX_VALUE;
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                double midY;
                double midX;
                block21: {
                    boolean killed;
                    int shotID = traceTable.getInt(row, indexShotID);
                    int recID = traceTable.getInt(row, indexRecID);
                    if (!shotMap.containsKey(shotID) || !recMap.containsKey(recID)) continue;
                    int shotRow = shotMap.get(shotID);
                    int recRow = recMap.get(recID);
                    double sx = shotTable.getDouble(shotRow, indexShotX);
                    double sy = shotTable.getDouble(shotRow, indexShotY);
                    boolean shotKilled = shotTable.getBool(shotRow, indexShotKilled);
                    double rx = recTable.getDouble(recRow, indexRecX);
                    double ry = recTable.getDouble(recRow, indexRecY);
                    boolean recKilled = recTable.getBool(recRow, indexRecKilled);
                    midX = 0.5 * (sx + rx);
                    midY = 0.5 * (sy + ry);
                    double dx = rx - sx;
                    double dy = ry - sy;
                    int off = (int)Math.sqrt(0.001 + dx * dx + dy * dy);
                    maxOffset = Math.max(maxOffset, off);
                    minOffset = Math.min(minOffset, off);
                    grid3D.setWorldLocation(midX, midY);
                    traceTable.putInt(row, indexInline, grid3D.Inline);
                    traceTable.putInt(row, indexCrossline, grid3D.Crossline);
                    boolean bl = killed = shotKilled || recKilled;
                    if (!killed) {
                        try {
                            foldGrid.setWorldLocation(midX, midY);
                            int ix = foldGrid.InlineGridIndex;
                            int iy = foldGrid.CrosslineGridIndex;
                            foldData[ix][iy] = foldData[ix][iy] + 1.0f;
                        }
                        catch (Exception gridError) {
                            if (++foldGridErrorCount >= 10) break block21;
                            gridError.printStackTrace();
                        }
                    }
                }
                if (dim2D) {
                    int bin = grid2D.getBin(midX, midY);
                    traceTable.putInt(row, indexBin2D, bin);
                }
                if (row % 100000L != 0L) continue;
                this.m_progress.setValue((int)(row / 1000L));
                this.m_progress.paintImmediately(0, 0, 1200, 25);
            }
            this.m_progress.setValue(0);
            traceTable.saveCurrentSection();
            project.information().string_put("MaxOffset", Integer.toString(maxOffset));
            project.information().string_put("MinOffset", Integer.toString(minOffset));
            project.saveInformation();
            double areaPerBin = grid3D.inlineBinSize() / 1000.0 * (grid3D.crosslineBinSize() / 1000.0);
            if (project.units_feet()) {
                areaPerBin = grid3D.inlineBinSize() / 5280.0 * (grid3D.crosslineBinSize() / 5280.0);
            }
            String fileName = project.projectPath() + "/statistics.txt";
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(fileName));
                writer.write("Shot count = ");
                writer.write(Integer.toString(shotTable.row_count()));
                writer.newLine();
                writer.write("Receiver count = ");
                writer.write(Integer.toString(recTable.row_count()));
                writer.newLine();
                writer.write("MinimumFold, NumberOfBins, Area");
                writer.newLine();
                boolean keepGoing = true;
                int count = 1;
                while (keepGoing) {
                    int numBins = 0;
                    float cutOff = (float)count - 0.5f;
                    for (int ix = 0; ix < foldData.length; ++ix) {
                        for (int iy = 0; iy < foldData[ix].length; ++iy) {
                            if (!(foldData[ix][iy] > cutOff)) continue;
                            ++numBins;
                        }
                    }
                    double area = (double)numBins * areaPerBin;
                    String s = String.format("%d, %d, %f", count, numBins, Float.valueOf((float)area));
                    writer.write(s);
                    writer.newLine();
                    if (count == 1) {
                        int t = (int)(1000.0 * area);
                        area = (double)t / 1000.0;
                        project.information().string_put("SurveyArea", Double.toString(area));
                        project.saveInformation();
                    }
                    ++count;
                    keepGoing = numBins >= 1;
                }
            }
            catch (Exception writeError) {
                writeError.printStackTrace();
            }
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception writeError) {
                ExceptionMonitor.add(writeError);
            }
            if (showDialog) {
                JOptionPane.showMessageDialog(null, "Project statistics saved in statistics.txt", " ", 1);
            }
            if (this.m_owner != null) {
                ((DefineGridWidgetOwner)this.m_owner.get()).handleDone(this);
            }
            this.m_owner = null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void receiverCoords() {
        try {
            IDatabaseConnection db = RefractionStaticsProject.singleton().geometryDatabase();
            String sql = "SELECT * FROM Receiver ORDER BY LineNumber, PointNumber";
            Table_Abstract table = db.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            System.out.println("Num rec = " + table.row_count());
            int colLine = table.column_indexOfColumn("LineNumber");
            int colPoint = table.column_indexOfColumn("PointNumber");
            int colX = table.column_indexOfColumn("Easting");
            int colY = table.column_indexOfColumn("Northing");
            double sumDX = 0.0;
            double sumDY = 0.0;
            double count = 1.0E-20;
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, colX);
                double y = table.getDouble(r, colY);
                double line = table.getInt(r, colLine);
                int point = table.getInt(r, colPoint);
                int minr = Math.min(r + 10, table.row_count() - 1);
                for (int r1 = r + 1; r1 <= minr; ++r1) {
                    int point1;
                    int dp;
                    if (line != (double)table.getInt(r1, colLine) || (dp = (point1 = table.getInt(r1, colPoint)) - point) < 1 || dp >= 10) continue;
                    double dx = (table.getDouble(r1, colX) - x) / (double)(point1 - point);
                    double dy = (table.getDouble(r1, colY) - y) / (double)(point1 - point);
                    sumDX += dx;
                    sumDY += dy;
                    count += 1.0;
                }
            }
            double avgDX = sumDX / count;
            double avgDY = sumDY / count;
            System.out.println("avgDX = " + avgDX);
            System.out.println("avgDY = " + avgDY);
            double dist = Math.sqrt(avgDX * avgDX + avgDY * avgDY);
            System.out.println("dist = " + dist);
            double errDX = 0.2 * Math.abs(avgDX);
            double errDY = 0.2 * Math.abs(avgDY);
            sumDX = 0.0;
            sumDY = 0.0;
            count = 1.0E-20;
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, colX);
                double y = table.getDouble(r, colY);
                double line = table.getInt(r, colLine);
                int point = table.getInt(r, colPoint);
                int minr = Math.min(r + 10, table.row_count() - 1);
                for (int r1 = r + 1; r1 <= minr; ++r1) {
                    int point1;
                    int dp;
                    if (line != (double)table.getInt(r1, colLine) || (dp = (point1 = table.getInt(r1, colPoint)) - point) < 1 || dp >= 10) continue;
                    double dx = (table.getDouble(r1, colX) - x) / (double)(point1 - point);
                    double dy = (table.getDouble(r1, colY) - y) / (double)(point1 - point);
                    double ex = Math.abs(dx - avgDX);
                    double ey = Math.abs(dy - avgDY);
                    if (!(ex < errDX) || !(ey < errDY)) continue;
                    sumDX += dx;
                    sumDY += dy;
                    count += 1.0;
                }
            }
            avgDX = sumDX / count;
            avgDY = sumDY / count;
            System.out.println("avgDX = " + avgDX);
            System.out.println("avgDY = " + avgDY);
            dist = Math.sqrt(avgDX * avgDX + avgDY * avgDY);
            System.out.println("dist = " + dist);
            double d = Math.atan2(avgDY, avgDX);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer) {
                System.out.println("e.getSource() == m_timer");
                ++this.m_timerCount;
                if (this.m_timerCount == 2) {
                    this.m_timer.stop();
                    System.out.println("m_timerCount == 2");
                    this.work(false);
                }
            }
            if (e.getSource() == this.m_btnReceiver) {
                this.receiverCoords();
                return;
            }
            if (e.getSource() == this.m_btnPromax) {
                this.importPromax();
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                this.work(true);
                if (this.m_okayToCancel) {
                    Messenger.broadcast(Messenger.Message.Rebinned, null, null);
                }
            }
            if (e.getSource() == this.m_btnCancel && this.m_owner != null) {
                ((DefineGridWidgetOwner)this.m_owner.get()).handleCancel(this);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static interface DefineGridWidgetOwner {
        public void handleCancel(DefineGridWidget var1);

        public void handleDone(DefineGridWidget var1);
    }
}

