/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.History;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class VersionManagerDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JList m_list = new JList();
    protected JLabel m_selLabel = new JLabel();
    protected JButton m_newButton;
    protected JButton m_openButton;
    protected ArrayList<String> m_versionList;

    public VersionManagerDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            String s = "<HTML>Each version shares the same trace table. </HTML>";
            JLabel lbl = new JLabel(s);
            main.addComponent(lbl, 0);
            this.m_project = RefractionStaticsProject.singleton();
            this.m_selLabel.setText("Current version: " + this.m_project.versionName());
            this.m_selLabel.setForeground(Color.BLUE);
            Tools_FontChanger.changeSizeOfFont(this.m_selLabel, 1);
            this.m_selLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(this.m_selLabel, 0);
            main.addComponent(new JScrollPane(this.m_list), 10);
            this.m_newButton = main.createButton("Create a new version", this, 0);
            this.m_openButton = main.createButton("Open selected version", this, 0);
            this.reloadList();
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setTitle("Version manager");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadList() {
        try {
            String parentPath = this.m_project.versionContainerPath();
            this.m_versionList = Tools_FileSystem.subdirectories(parentPath, false);
            this.m_list.setListData(this.m_versionList.toArray());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected void createNewVersion() {
        try {
            JOptionPane.showMessageDialog(null, "The new version will initially be \n a carbon-copy of the current version", "", 1);
            String newVersionName = JOptionPane.showInputDialog(null, "Name of the new version (no spaces or special characters)", "New Version Name", -1);
            if (newVersionName == null) {
                return;
            }
            if (newVersionName.length() < 1) {
                return;
            }
            String parentPath = this.m_project.versionContainerPath();
            String newVersionPath = Tools_FileSystem.confirmSubDirectoryExists(parentPath, newVersionName);
            if (newVersionPath == null) {
                JOptionPane.showMessageDialog(null, "Failed to create new directory for version", "Failed", 0);
                return;
            }
            String currentVersionPath = this.m_project.versionPath();
            String currentVersionName = this.m_project.versionName();
            this.m_project.reloadAllData();
            String fileNameDB = newVersionPath + "/geometry.db";
            IDatabaseConnection geometryConn = Tools_JDBC.getConnection(false, fileNameDB);
            geometryConn.createDatabaseTable(this.m_project.shotTable());
            geometryConn.appendTable(this.m_project.shotTable(), 0);
            geometryConn.createDatabaseTable(this.m_project.receiverTable());
            geometryConn.appendTable(this.m_project.receiverTable(), 0);
            geometryConn = null;
            System.gc();
            Tools_FileSystem.copySubdirectory(currentVersionPath, newVersionPath, "DelayTime");
            this.m_project.versionSelect(newVersionName);
            History hist = RefractionStaticsProject.delayTimeData().getHistory();
            hist.addWithTime("************ NEW VERSION CREATED ***************");
            hist.add("Original version name: " + currentVersionName);
            hist.add("New version name: " + newVersionName);
            hist.save();
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_openButton) {
                int index = this.m_list.getSelectedIndex();
                String v = this.m_versionList.get(index);
                if (v.equalsIgnoreCase(this.m_project.versionName())) {
                    return;
                }
                this.m_project.versionSelect(v);
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_newButton) {
                this.createNewVersion();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

