/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_SegyHeaderExport;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SegyHeaderExportDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener,
ITraceTableScannerMonitor {
    public ArrayList<Entry> m_list = new ArrayList();
    protected ArrayList<EntryWidgets> m_widgetList = new ArrayList();
    protected FileWidget m_outputDir;
    protected JButton m_btnSave;
    protected JButton m_btnSaveAs;
    protected JButton m_btnOpen;
    protected JTextField m_txtFileName = new JTextField("");
    protected RefractionStaticsProject m_project;
    protected JButton m_btnAdd = new JButton("Add");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JButton m_btnExport = new JButton("Export header information");
    protected ArrayList<String> m_colListShot;
    protected ArrayList<String> m_colListRec;
    protected ArrayList<String> m_colListTrace;

    public SegyHeaderExportDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_outputDir = new FileWidget(true, false, 0, "Output directory - SEG-Y files will be saved here", this);
            main.addComponent(this.m_outputDir, 0);
            LinearLayoutWidget sub = main.createHorizontal(0, "Output dictionary file name", 0);
            sub.addComponent(this.m_txtFileName, 10);
            this.m_txtFileName.setEditable(false);
            this.m_btnSave = sub.createButton("Save", this, 0);
            this.m_btnSaveAs = sub.createButton("Save as", this, 0);
            this.m_btnOpen = sub.createButton("Open", this, 0);
            Object file = SharedApplicationData.singleton().homeDirectory() + "/SegyExportMap.txt";
            file = SharedApplicationData.singleton().getParameterTree().string_get("SegyExportMap", (String)file);
            this.m_txtFileName.setText((String)file);
            String dir = "";
            dir = SharedApplicationData.singleton().getParameterTree().string_get("SegyExportPath", dir);
            this.m_outputDir.setText(dir);
            sub = main.createHorizontal(3, null, 0);
            this.m_btnAdd = sub.createButton("Add", this, 0);
            sub.addStretch(10);
            this.m_btnCancel = sub.createButton("Cancel", this, 0);
            this.m_btnExport = sub.createButton("Begin export", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "", 0);
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add(DataType.Int.Description);
            typeList.add(DataType.Short.Description);
            typeList.add(DataType.Float.Description);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Shot");
            tableList.add("Receiver");
            tableList.add("Trace");
            int row = 0;
            double weightTable = 1.0;
            double weightColumn = 3.0;
            double weightOffset = 1.0;
            double weightType = 1.0;
            grid.addComponent(new JLabel(" "), row, 0, 0.0, 0.0);
            grid.addComponent(new JLabel("Table"), row, 1, 0.0, weightTable);
            grid.addComponent(new JLabel("Column"), row, 2, 0.0, weightColumn);
            grid.addComponent(new JLabel("Offset"), row, 3, 0.0, weightOffset);
            grid.addComponent(new JLabel("Header type"), row, 4, 0.0, weightType);
            ++row;
            for (int n = 0; n < 25; ++n) {
                EntryWidgets w = new EntryWidgets();
                this.m_widgetList.add(w);
                grid.addComponent(w.Remove, row, 0, 0.0, 0.0);
                grid.addComponent(w.Table, row, 1, 0.0, weightTable);
                grid.addComponent(w.Column, row, 2, 0.0, weightColumn);
                grid.addComponent(w.Offset, row, 3, 0.0, weightOffset);
                grid.addComponent(w.Type, row, 4, 0.0, weightType);
                w.Offset.addActionListener(this);
                w.Remove.addActionListener(this);
                w.Table.listener().addListener(this);
                w.Column.listener().addListener(this);
                w.Type.listener().addListener(this);
                w.Table.setStringArray(tableList);
                w.Type.setStringArray(typeList);
                ++row;
            }
            sub = main.createVertical(3, null, 10);
            this.getContentPane().add((Component)main, "Center");
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getWidth() + 300, 600);
            this.setTitle("Export database to SEG-Y headers");
            this.setLocationRelativeTo(null);
            this.read();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            if (!this.m_project.isOrigin("SEGY")) {
                JOptionPane.showMessageDialog(null, "Project must be based on SEG-Y files", "", 0);
                return;
            }
            this.m_colListRec = this.database().listOfColumnNames("Receiver");
            this.m_colListShot = this.database().listOfColumnNames("Shot");
            this.m_colListTrace = this.m_project.traceTableWrapper().traceTable().columns();
            this.updateAllColumnList();
            this.copyToControls();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            System.out.println("Percent segy update = " + percent);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    public void setVis() {
        try {
            int num = this.m_list.size();
            for (int n = 0; n < this.m_widgetList.size(); ++n) {
                EntryWidgets w = this.m_widgetList.get(n);
                w.setVisible(n < num);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void updateAllColumnList() {
        try {
            for (EntryWidgets w : this.m_widgetList) {
                this.updateColumnList(w.Table, w.Column);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void updateColumnList(ComboStringListWrapper tbl, ComboStringListWrapper col) {
        try {
            String table = tbl.getSelectedString();
            if (table.equalsIgnoreCase("Shot")) {
                col.setStringArray(this.m_colListShot);
            } else if (table.equalsIgnoreCase("Receiver")) {
                col.setStringArray(this.m_colListRec);
            } else {
                col.setStringArray(this.m_colListTrace);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void copyFromControls() {
        try {
            for (int n = 0; n < this.m_list.size(); ++n) {
                EntryWidgets w = this.m_widgetList.get(n);
                Entry e = this.m_list.get(n);
                e.Table = w.Table.getSelectedString();
                e.Column = w.Column.getSelectedString();
                try {
                    e.Offset = Integer.parseInt(w.Offset.getText());
                }
                catch (Exception errr) {
                    e.Offset = -9999;
                }
                e.Type = DataType.typeFromDescription(w.Type.getSelectedString());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void copyToControls() {
        try {
            for (int n = 0; n < this.m_list.size(); ++n) {
                EntryWidgets w = this.m_widgetList.get(n);
                w.Table.setPreferredSelected(this.m_list.get((int)n).Table);
                this.updateColumnList(w.Table, w.Column);
                w.Column.setPreferredSelected(this.m_list.get((int)n).Column);
                w.Type.setPreferredSelected(this.m_list.get((int)n).Type.Description);
                w.Offset.setText(Integer.toString(this.m_list.get((int)n).Offset));
            }
            this.setVis();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void save() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_txtFileName.getText()));
            String s = String.format("%d,%d", this.m_list.size(), 4);
            writer.write(s);
            writer.newLine();
            for (int n = 0; n < this.m_list.size(); ++n) {
                Entry e = this.m_list.get(n);
                s = String.format("%s,%s,%d,%s", e.Table, e.Column, e.Offset, e.Type.Description);
                writer.write(s);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void read() {
        try {
            this.m_list.clear();
            if (!Tools_FileSystem.exists_file(this.m_txtFileName.getText())) {
                this.copyToControls();
                this.save();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(this.m_txtFileName.getText()));
            String line = reader.readLine();
            ArrayList<String> tokens = Tools_Strings.tokenizer_improved(line, ',');
            int numRows = Integer.parseInt(tokens.get(0));
            int numCols = Integer.parseInt(tokens.get(1));
            for (int n = 0; n < numRows; ++n) {
                line = reader.readLine();
                tokens = Tools_Strings.tokenizer_improved(line, ',');
                Entry e = new Entry();
                e.Table = tokens.get(0);
                e.Column = tokens.get(1);
                e.Offset = Integer.parseInt(tokens.get(2));
                e.Type = DataType.typeFromDescription(tokens.get(3));
                this.m_list.add(e);
            }
            reader.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.copyToControls();
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void export() {
        try {
            String dir = this.m_outputDir.getText();
            if (!Tools_FileSystem.exists_path(dir)) {
                JOptionPane.showMessageDialog(null, "Output directory not valid", "", 0);
                return;
            }
            SharedApplicationData.singleton().getParameterTree().string_put("SegyExportPath", dir);
            SharedApplicationData.singleton().saveParameterTree();
            TraceTable_Scanner_SegyHeaderExport scanner = new TraceTable_Scanner_SegyHeaderExport(dir, this.m_list);
            scanner.scan(this.m_project.traceTableWrapper().traceTable(), this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            for (int n = 0; n < this.m_widgetList.size(); ++n) {
                EntryWidgets w = this.m_widgetList.get(n);
                if (sender == w.Table) {
                    this.updateColumnList(w.Table, w.Column);
                    this.m_list.get((int)n).Table = w.Table.getSelectedString();
                    this.m_list.get((int)n).Column = w.Column.getSelectedString();
                }
                if (sender == w.Column) {
                    this.m_list.get((int)n).Column = w.Column.getSelectedString();
                }
                if (sender != w.Type) continue;
                this.m_list.get((int)n).Type = DataType.typeFromDescription(w.Type.getSelectedString());
            }
            this.save();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            EntryWidgets w;
            int n;
            String file;
            if (e.getSource() == this.m_btnSave) {
                this.save();
                return;
            }
            if (e.getSource() == this.m_btnSaveAs) {
                file = Tools_Chooser.getSaveFileName("txt");
                if (file == null) {
                    return;
                }
                this.m_txtFileName.setText(file);
                this.save();
                SharedApplicationData.singleton().getParameterTree().string_put("SegyExportMap", file);
                SharedApplicationData.singleton().saveParameterTree();
            }
            if (e.getSource() == this.m_btnOpen) {
                file = Tools_Chooser.getFileName();
                if (file == null) {
                    return;
                }
                this.m_txtFileName.setText(file);
                this.read();
                SharedApplicationData.singleton().getParameterTree().string_put("SegyExportMap", file);
                SharedApplicationData.singleton().saveParameterTree();
            }
            for (n = 0; n < this.m_widgetList.size(); ++n) {
                w = this.m_widgetList.get(n);
                if (e.getSource() != w.Remove) continue;
                this.m_list.remove(n);
                this.save();
                this.copyToControls();
            }
            for (n = 0; n < this.m_widgetList.size(); ++n) {
                w = this.m_widgetList.get(n);
                if (e.getSource() != w.Offset) continue;
                this.m_list.get((int)n).Offset = Integer.parseInt(w.Offset.getText());
                this.save();
                return;
            }
            if (e.getSource() == this.m_btnAdd) {
                this.m_list.add(new Entry());
                this.save();
                this.copyToControls();
                return;
            }
            if (e.getSource() == this.m_btnExport) {
                this.export();
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class EntryWidgets {
        public JButton Remove = new JButton("Remove");
        public ComboStringListWrapper Table = new ComboStringListWrapper("Shot");
        public ComboStringListWrapper Column = new ComboStringListWrapper();
        public JTextField Offset = new JTextField("0");
        public ComboStringListWrapper Type = new ComboStringListWrapper();

        protected EntryWidgets() {
        }

        public void setVisible(boolean v) {
            this.Remove.setVisible(v);
            this.Table.setVisible(v);
            this.Column.setVisible(v);
            this.Offset.setVisible(v);
            this.Type.setVisible(v);
        }
    }

    public static class Entry {
        public String Table = "Shot";
        public String Column = "Easting";
        public int Offset = 73;
        public DataType Type = DataType.Int;
        public boolean Valid = false;
        public boolean IsShot = false;
        public boolean IsRec = false;
        public boolean IsTrace = false;
        public int ColumnIndex;
        public DataType InputType = DataType.Int;
        public boolean ApplyElevScalar = false;
        public boolean ApplyCoordScalar = false;
    }
}

