/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Sort.Action_CreateSparseCmpGathers;
import com.PecosLibrary.Action.Sort.Action_ExternalMergeSort;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Menu_Sort
implements ActionListener {
    protected JMenu m_menu = new JMenu("Sort");
    protected JMenuItem m_menuItem_Sparse;
    protected JMenuItem m_menuItem_SortBin;
    protected JMenuItem m_menuItem_UnSortBin;
    protected JMenuItem m_menuItem_SortReceiver;
    protected JMenuItem m_menuItem_UnSortReceiver;

    public Menu_Sort(JMenuBar menuBar) {
        try {
            menuBar.add(this.m_menu);
            if (RefractionStaticsProject.singleton().dim3D()) {
                this.m_menuItem_SortBin = this.addMenuItem(this.m_menu, "Create bin sort");
                this.m_menuItem_UnSortBin = this.addMenuItem(this.m_menu, "Remove bin sort");
                this.m_menu.addSeparator();
                this.m_menuItem_Sparse = this.addMenuItem(this.m_menu, "Create sparse CMP gathers");
                this.m_menu.addSeparator();
            }
            this.m_menuItem_SortReceiver = this.addMenuItem(this.m_menu, "Create receiver sort");
            this.m_menuItem_UnSortReceiver = this.addMenuItem(this.m_menu, "Remove receiver sort");
            this.m_menu.addSeparator();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Action_ExternalMergeSort action;
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_menuItem_Sparse) {
                MultiTextDialog dlg = new MultiTextDialog(null, "Create sparse CMP gathers", "CMP spacing (ft/m)", "Bin radius (ft/m)", "Minimum offset", "Maximum offset");
                dlg.showDialog("Create CMP gathers");
                if (!dlg.OK) {
                    return;
                }
                Action_CreateSparseCmpGathers action2 = new Action_CreateSparseCmpGathers();
                action2.Spacing = dlg.getDouble(0, 2000.0, 200.0, 12000.0);
                action2.Radius = dlg.getDouble(1, 100.0, 25.0, 2000.0);
                action2.MinOffset = dlg.getDouble(2, 0.0, 0.0, 50000.0);
                action2.MaxOffset = dlg.getDouble(3, 20000.0, 0.0, 50000.0);
                RefractionStaticsProject.singleton().executeSingleAction(action2);
            }
            if (e.getSource() == this.m_menuItem_UnSortBin) {
                RefractionStaticsProject.singleton().killBinSort();
                return;
            }
            if (e.getSource() == this.m_menuItem_UnSortReceiver) {
                RefractionStaticsProject.singleton().killReceiverSort();
                return;
            }
            if (e.getSource() == this.m_menuItem_SortReceiver) {
                action = new Action_ExternalMergeSort("ReceiverID", null);
                RefractionStaticsProject.singleton().executeSingleAction(action);
                RefractionStaticsProject.singleton().reloadSortManagers();
                return;
            }
            if (e.getSource() == this.m_menuItem_SortBin) {
                action = new Action_ExternalMergeSort("Inline", "Crossline");
                RefractionStaticsProject.singleton().executeSingleAction(action);
                RefractionStaticsProject.singleton().reloadSortManagers();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

