/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_LineSegment;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_DragFixedLine;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class DraggerWidget
extends JSplitPane
implements GenericObjectListener.Listener,
ActionListener {
    protected Java2D_SimpleComposite m_mapWidget;
    protected JLabel m_selLabel = new JLabel(" ", 0);
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_inputEnsemble_Copy = new Ensemble();
    protected Ensemble m_processedEnsemble = new Ensemble();
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected Sequence_MainWidget m_workerWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected JTextField m_textStartX = new JTextField();
    protected JTextField m_textStartY = new JTextField();
    protected JTextField m_textMoveX = new JTextField();
    protected JTextField m_textMoveY = new JTextField();
    protected JTextField m_textMoveDistance = new JTextField();
    protected Java2D_UserEventConsumer_DragFixedLine m_dragUEC = new Java2D_UserEventConsumer_DragFixedLine();
    protected int m_elementID;
    protected Plane m_plane = Plane.None;
    protected double m_worldX;
    protected double m_worldY;
    protected int m_indexOtherX;
    protected int m_indexOtherY;
    protected int m_indexX;
    protected int m_indexY;
    protected int m_indexOffset;
    protected Java2D_Paintable_Table m_shotPO;
    protected Java2D_Paintable_Table m_recPO;
    protected Java2D_Paintable_LineSegment m_lineSegment = new Java2D_Paintable_LineSegment();

    public DraggerWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createMapWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_mapWidget = new Java2D_SimpleComposite(false);
            this.m_mapWidget.setAxesVisible(true, true);
            this.m_mapWidget.setColorScaleVisible(false);
            Tools_FontChanger.changeSizeOfFont(this.m_selLabel, 1);
            this.m_selLabel.setForeground(Color.blue);
            this.m_selLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(this.m_selLabel, 0);
            String s = "<HTML>Left-click and drag to move the shot or receiver to a new location. It may help to zoom in first. If no traces are visible make sure the axis locks are turned off. You may directly type in the new coordinates - be sure to press \"Enter\".</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Coordinate info", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Initial X"), this.m_textStartX);
            grid.addSimple(row++, new JLabel("Initial Y"), this.m_textStartY);
            this.m_textStartX.setEnabled(false);
            this.m_textStartY.setEnabled(false);
            grid.addSimple(row++, new JLabel("Current X"), this.m_textMoveX);
            grid.addSimple(row++, new JLabel("Current Y"), this.m_textMoveY);
            this.m_textMoveX.addActionListener(this);
            this.m_textMoveY.addActionListener(this);
            grid.addSimple(row++, new JLabel("Distance"), this.m_textMoveDistance);
            this.m_textMoveDistance.setEnabled(false);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            main.addComponent(this.m_mapWidget, 10);
            this.m_dragUEC.addListener(this);
            this.m_mapWidget.mainWidget().addZoomer();
            this.m_mapWidget.mainWidget().addEventConsumer(this.m_dragUEC);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("Dragger", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget(null);
            this.m_wiggleOptionsWidget.setFill(false, true);
            this.m_wiggleOptionsWidget.setClippingState(true);
            BitmapCardWidget bmc = new BitmapCardWidget();
            bmc.addComponent(BitmapEnum.Basemap, this.createMapWidget(), "Basemap");
            bmc.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            bmc.addComponent(BitmapEnum.Wiggle, this.m_wiggleOptionsWidget, "Wiggle display options");
            return bmc;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            this.m_widget.setAxisTableColumn("Trace", "Offset");
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            main.addComponent(this.m_widget, 10);
            this.m_widget.addZoomer();
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightRight() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_axisLockerOffset = new Java2D_AxisLocker("Horizontal lock", "Lock axis ");
            this.m_axisLockerOffset.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            main.addComponent(this.m_axisLockerOffset, 0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -1, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createRightPlot());
            splitter.setRightComponent(this.createRightRight());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_textMoveX) {
                this.moveElement(false);
                return;
            }
            if (e.getSource() == this.m_textMoveY) {
                this.moveElement(false);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadWiggle() {
        try {
            this.m_widget.setEnsemble(0, this.m_processedEnsemble);
            this.m_widget.clearAndLoadWigglePaintables();
            this.m_widget.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void processEnsemble(boolean unzoom) {
        try {
            if (this.m_inputEnsemble == null) {
                this.m_processedEnsemble = null;
            } else {
                this.m_inputEnsemble.copyToOtherEnsemble(this.m_inputEnsemble_Copy);
                this.m_processedEnsemble = this.m_sequence.work(this.m_inputEnsemble_Copy);
            }
            this.moveElement(unzoom);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_dragUEC) {
                this.m_textMoveX.setText(Tools_Strings.doubleToString(this.m_dragUEC.EndWorldX, 111.0));
                this.m_textMoveY.setText(Tools_Strings.doubleToString(this.m_dragUEC.EndWorldY, 111.0));
                this.moveElement(false);
                if (this.m_dragUEC.JustReleased) {
                    this.m_lineSegment.Dirty = true;
                    this.m_mapWidget.mainWidget().forceImageRepaint();
                }
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_axisLockerOffset) {
                this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    this.processEnsemble(false);
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void acceptMove() {
        try {
            if (this.m_plane == Plane.None) {
                return;
            }
            double x = Tools_Widget.extractDouble(this.m_textMoveX, this.m_worldX, -1.0E20, 1.0E20);
            double y = Tools_Widget.extractDouble(this.m_textMoveY, this.m_worldY, -1.0E20, 1.0E20);
            if (this.m_plane == Plane.Shot) {
                RefractionStaticsProject.singleton().moveShot(this.m_elementID, x, y);
            }
            if (this.m_plane == Plane.Receiver) {
                RefractionStaticsProject.singleton().moveReceiver(this.m_elementID, x, y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void moveElement(boolean unzoom) {
        try {
            if (this.m_plane == Plane.None) {
                return;
            }
            double x = Tools_Widget.extractDouble(this.m_textMoveX, this.m_worldX, -1.0E20, 1.0E20);
            double y = Tools_Widget.extractDouble(this.m_textMoveY, this.m_worldY, -1.0E20, 1.0E20);
            this.m_lineSegment.X2 = x;
            this.m_lineSegment.Y2 = y;
            this.m_lineSegment.Valid = true;
            double dx = x - this.m_worldX;
            double dy = y - this.m_worldY;
            double dist = Math.sqrt(dx * dx + dy * dy + 1.0E-20);
            this.m_textMoveDistance.setText(Tools_Strings.doubleToString(dist, 111.0));
            for (int n = 0; n < this.m_processedEnsemble.traceCount(); ++n) {
                this.m_processedEnsemble.trace(n).header().putDouble(this.m_indexX, x);
                this.m_processedEnsemble.trace(n).header().putDouble(this.m_indexY, y);
            }
            Tools_Ensemble.computeAzimuthAndOffset(this.m_processedEnsemble);
            if (unzoom) {
                this.reloadWiggle();
            } else {
                this.m_widget.forcePaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMapPlot() {
        try {
            Java2D_Widget w = this.m_mapWidget.mainWidget();
            w.clearPaintableList();
            if (this.m_plane == Plane.None) {
                w.mooz();
                return;
            }
            w.addPaintable(this.m_shotPO, -9999);
            w.addPaintable(this.m_recPO, -9999);
            w.addPaintable(this.m_lineSegment, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void dragShot(int shotID) {
        try {
            this.m_selLabel.setText("");
            this.m_plane = Plane.None;
            this.m_elementID = shotID;
            Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
            HashMap_Integer map = RefractionStaticsProject.singleton().shotMap();
            if (!map.containsKey(this.m_elementID)) {
                this.m_elementID = -9999;
                this.m_widget.setEnsemble(0, null);
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
                this.reloadMapPlot();
                return;
            }
            this.m_inputEnsemble.clearTraces(false);
            RefractionStaticsProject.singleton().ensemble_Shot(this.m_inputEnsemble, this.m_elementID, true);
            if (this.m_inputEnsemble.traceCount() < 1) {
                this.m_elementID = -9999;
                this.m_widget.setEnsemble(0, null);
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
                this.reloadMapPlot();
                return;
            }
            this.m_shotPO = Tools_RefractionStaticsProject.loadGeomPO("Shot");
            this.m_shotPO.FixedColor = Color.LIGHT_GRAY;
            this.m_recPO = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
            this.m_recPO.FixedColor = Color.LIGHT_GRAY;
            this.m_plane = Plane.Shot;
            this.m_selLabel.setText("Dragging shot " + Integer.toString(this.m_elementID));
            Tools_Ensemble.computeAzimuthAndOffset(this.m_inputEnsemble);
            this.m_indexX = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Easting");
            this.m_indexY = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            this.m_indexOtherX = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            this.m_indexOtherY = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            this.m_indexOffset = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "Offset");
            this.m_worldX = this.m_inputEnsemble.trace(0).header().getDouble(this.m_indexX);
            this.m_worldY = this.m_inputEnsemble.trace(0).header().getDouble(this.m_indexY);
            this.m_dragUEC.StartWorldX = this.m_worldX;
            this.m_dragUEC.StartWorldY = this.m_worldY;
            this.m_lineSegment.X1 = this.m_worldX;
            this.m_lineSegment.Y1 = this.m_worldY;
            this.m_lineSegment.X2 = this.m_worldX;
            this.m_lineSegment.Y2 = this.m_worldY;
            this.m_lineSegment.Valid = true;
            this.m_textStartX.setText(Tools_Strings.doubleToString(this.m_worldX, 111.0));
            this.m_textStartY.setText(Tools_Strings.doubleToString(this.m_worldY, 111.0));
            this.m_textMoveX.setText(this.m_textStartX.getText());
            this.m_textMoveY.setText(this.m_textStartY.getText());
            this.processEnsemble(true);
            this.reloadMapPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected static enum Plane {
        Shot,
        Receiver,
        None;

    }
}

