/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Application.Environment;
import com.PecosCore.Data.DataType;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Export.Action_ExportBinaryGLI_All;
import com.PecosLibrary.Action.Import.Action_AddSegyFilesToProject;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid2D_Conversion_Line;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.ApplicationFrames.ComponentManagerFrame;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.ApplicationFrames.Menu_Window;
import com.PecosLibrary.Windows.ApplicationFrames.SystemWidget;
import com.PecosLibrary.Windows.ConvertedWave.Menu_ConvertedWave;
import com.PecosLibrary.Windows.Extra.Menu_Extra;
import com.PecosLibrary.Windows.GLI.Menu_GLI;
import com.PecosLibrary.Windows.JDBC.BasemapWidget;
import com.PecosLibrary.Windows.JDBC.MultiBasemapWidget;
import com.PecosLibrary.Windows.Menus.Menu_Test;
import com.PecosLibrary.Windows.Refraction.AddSegyFilesDialog;
import com.PecosLibrary.Windows.Refraction.Database.Menu_Help;
import com.PecosLibrary.Windows.Refraction.Database.Menu_RefractionDatabase;
import com.PecosLibrary.Windows.Refraction.Database.Menu_Sort;
import com.PecosLibrary.Windows.Refraction.DefineGridDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.Menu_DelayTime;
import com.PecosLibrary.Windows.Refraction.FWI.Menu_FWI;
import com.PecosLibrary.Windows.Refraction.LayeredTomo.Menu_LayeredTomo;
import com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_V2;
import com.PecosLibrary.Windows.Refraction.Picking.Menu_Picking;
import com.PecosLibrary.Windows.Refraction.ReceiverTableWidget;
import com.PecosLibrary.Windows.Refraction.SelectProjectDialog;
import com.PecosLibrary.Windows.Refraction.ShotTableWidget;
import com.PecosLibrary.Windows.Refraction.Tomography.Menu_Tomography;
import com.PecosLibrary.Windows.Refraction.Tomography.VNS.Menu_TomoVNS;
import com.PecosLibrary.Windows.Refraction.TraceTableWidget;
import com.PecosLibrary.Windows.Refraction.Uphole.Menu_Uphole;
import com.PecosLibrary.Windows.Segy.AppFrame_Segy;
import com.PecosLibrary.Windows.Stack.Menu_Stack;
import com.PecosLibrary.Windows.Synthetic.Menu_Synthetic;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.Timer;

public class AppFrame_RefractionStatics
extends ComponentManagerFrame
implements ActionListener,
ClipboardOwner {
    protected Menu_GLI m_gliMenu;
    protected Menu_Tomography m_tomoMenu;
    protected Menu_TomoVNS m_tomoVNSMenu;
    protected Menu_LayeredTomo m_layeredTomoMenu;
    protected Menu_FWI m_fwiMenu;
    protected Menu_RefractionDatabase m_databaseMenu;
    protected Menu_DelayTime m_delayTimeMenu;
    protected Menu_ConvertedWave m_convertedWaveMenu;
    protected Menu_Synthetic m_synMenu;
    protected Menu_Picking m_pickMenu;
    protected Menu_Stack m_stackMenu;
    protected Menu_Test m_Menu_Test;
    protected Menu_Sort m_sortMenu;
    protected Menu_Help m_helpMenu;
    protected Menu_Extra m_extraMenu;
    protected Menu_Uphole m_menuUphole;
    protected Timer m_timer = new Timer(1000, this);
    protected JMenuItem m_captureScreenMI;
    protected JMenuItem m_captureWindowMI;
    protected JCheckBoxMenuItem m_captureWindowAskSaveToFileMI;
    protected boolean m_captureImage = true;
    protected JMenu m_captureMenu = new JMenu("ScreenCapture");
    protected JMenu m_projectMenu = new JMenu("Project");
    protected JMenuItem m_openProjectMI;
    protected JMenuItem m_openSegY;
    protected JMenuItem m_addSegyFiles;
    protected String m_projectPath;
    protected JMenuItem m_closeProgram;
    protected JMenu m_licenseMenu = new JMenu("Licensing");
    protected JMenuItem m_licPrimary;
    protected JMenuItem m_licSecondary;
    protected JMenu m_phoenixMenu = new JMenu("Phoenix");
    protected JMenuItem m_phoenix_projects_MI;
    private boolean IS_OMEGA;
    protected Timer m_timerSC = new Timer(200, this);
    protected int m_timerCount = 0;
    protected boolean m_captureScreen = true;
    protected AddSegyFilesDialog m_addDialog;

    public AppFrame_RefractionStatics(boolean load, boolean omega) {
        try {
            int res;
            this.IS_OMEGA = omega;
            Messenger.singleton().addListener(this);
            HashMap<String, String> map = SharedApplicationData.singleton().LaunchCodes;
            String projectName = map.get("ProjectName");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String projectName2 = project.name();
            project.setName(projectName);
            this.m_projectPath = project.projectPath();
            this.setJMenuBar(this.m_menuBar);
            this.m_menuBar.add(this.m_projectMenu);
            this.m_openProjectMI = new JMenuItem("Open project");
            this.m_projectMenu.add(this.m_openProjectMI);
            this.m_openProjectMI.addActionListener(this);
            this.m_openSegY = new JMenuItem("Open SEG-Y Viewer/Dictionary Editor");
            this.m_projectMenu.add(this.m_openSegY);
            this.m_openSegY.addActionListener(this);
            this.m_addSegyFiles = new JMenuItem("Add SEG-Y files to existing project");
            this.m_projectMenu.add(this.m_addSegyFiles);
            this.m_addSegyFiles.addActionListener(this);
            this.m_projectMenu.addSeparator();
            this.m_closeProgram = new JMenuItem("Exit Flatirons");
            this.m_projectMenu.add(this.m_closeProgram);
            this.m_closeProgram.addActionListener(this);
            this.createMenus();
            this.m_menuBar.add(this.m_captureMenu);
            this.m_captureScreenMI = new JMenuItem("Entire screen");
            this.m_captureMenu.add(this.m_captureScreenMI);
            this.m_captureScreenMI.addActionListener(this);
            this.m_captureWindowMI = new JMenuItem("Active window");
            this.m_captureMenu.add(this.m_captureWindowMI);
            this.m_captureWindowMI.addActionListener(this);
            this.m_captureMenu.addSeparator();
            this.m_captureWindowAskSaveToFileMI = new JCheckBoxMenuItem("Ask if the image should be saved to disk");
            this.m_captureMenu.add(this.m_captureWindowAskSaveToFileMI);
            this.m_captureWindowAskSaveToFileMI.addActionListener(this);
            this.m_captureWindowAskSaveToFileMI.setState(this.m_captureImage);
            this.m_licPrimary = new JMenuItem("Set primary license server");
            this.m_licSecondary = new JMenuItem("Set secondary license server");
            this.m_licenseMenu.add(this.m_licPrimary);
            this.m_licenseMenu.add(this.m_licSecondary);
            this.m_licPrimary.addActionListener(this);
            this.m_licSecondary.addActionListener(this);
            this.checkTabs(load);
            try {
                this.setIconImage(Tools_Bitmap.makeImage(BitmapEnum.Flatirons));
            }
            catch (Exception errr) {
                errr.printStackTrace();
            }
            this.setSize(1200, 900);
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(3);
            int runCount = RefractionStaticsProject.singleton().runCount();
            String origin = RefractionStaticsProject.singleton().information().string_get("Origin", "");
            boolean isMerge = false;
            if (origin != null) {
                isMerge = origin.equalsIgnoreCase("MERGE");
            }
            if (runCount <= 1) {
                boolean gridSet = false;
                if (!gridSet) {
                    Object g2d;
                    project.createDefaultGrid3D();
                    if (project.dim2D()) {
                        project.grid2DPrepDefault();
                        g2d = new Grid2D_Conversion_Line();
                        ((Grid2D_Conversion_Line)g2d).setAngle(project.TempGrid2DAngle);
                        ((Grid2D_Conversion_Line)g2d).setBinSize(project.TempGrid2DBinSize);
                        ((Grid2D_Conversion_Line)g2d).setOrigin(project.TempGrid2DOriginX, project.TempGrid2DOriginY);
                        project.setGrid2D_Conversion((IGrid2D_Conversion)g2d);
                    }
                    g2d = new DefineGridDialog(false, true);
                }
                try {
                    if (!isMerge) {
                        IDatabaseConnection db = project.geometryDatabase();
                        db.addColumn("Shot", "InitialEasting", DataType.Double);
                        db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialEasting", "Easting"));
                        db.addColumn("Shot", "InitialNorthing", DataType.Double);
                        db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialNorthing", "Northing"));
                        db.addColumn("Receiver", "InitialEasting", DataType.Double);
                        db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialEasting", "Easting"));
                        db.addColumn("Receiver", "InitialNorthing", DataType.Double);
                        db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialNorthing", "Northing"));
                    }
                }
                catch (Exception eee) {
                    ExceptionMonitor.add(eee);
                }
            }
            if (runCount <= 1 && origin.equalsIgnoreCase("GLI") && (res = JOptionPane.showConfirmDialog(null, "For GLI-based projects the first step is usually branch assignment. \nDo you want to open the branch assignment dialog now?", "", 0)) == 0) {
                BranchAssignmentDialog branchAssignmentDialog = new BranchAssignmentDialog(BranchAssignmentWidget.PlotType.Picks, false);
            }
            if (runCount <= 1 && origin.equalsIgnoreCase("SEGY")) {
                RefractionProjectSuggestions.singleton().firstTimeSegyRun();
            }
            this.setWindowTitle();
            this.m_timerSC.addActionListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public JMenuBar menuBar() {
        return this.m_menuBar;
    }

    protected void showDefaultWindows() {
        try {
            if (this.m_windowLayout == SharedApplicationData.Tabs || this.m_windowLayout == SharedApplicationData.SplitTabs) {
                this.AskWhichTab = false;
                this.showComponent(MultiBasemapWidget.class.getName(), "MultiMap", "MultiMap", true);
                this.showComponent(BasemapWidget.class.getName(), "Basemap", "Basemap", true);
                this.showComponent(ReceiverTableWidget.class.getName(), "Receiver", "Receiver table", true);
                this.showComponent(ShotTableWidget.class.getName(), "Shot", "Shot table", true);
                this.showComponent(TraceTableWidget.class.getName(), "Trace", "Trace table", true);
                this.showComponent(SystemWidget.class.getName(), "System", "System", true);
                this.AskWhichTab = true;
            }
            if (this.m_tabs != null) {
                this.m_tabs.setSelectedIndex(0);
            }
            if (this.m_leftTabs != null) {
                this.m_leftTabs.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private boolean isPasswordCorrect(char[] inputPassword) {
        try {
            char[] actualPassword = new char[]{'s', 'a', 'n', 'i', 't', 'a', 's'};
            if (inputPassword.length != actualPassword.length) {
                return false;
            }
            for (int i = 0; i < inputPassword.length; ++i) {
                if (inputPassword[i] == actualPassword[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean checkPassword() {
        try {
            JPasswordField passwordField = new JPasswordField();
            passwordField.setEchoChar('*');
            Object[] obj = new Object[]{"Please enter the password:\n\n", passwordField};
            Object[] stringArray = new Object[]{"OK", "Cancel"};
            if (JOptionPane.showOptionDialog(null, obj, "Need password", 0, 3, null, stringArray, obj) == 0) {
                char[] pass = passwordField.getPassword();
                return this.isPasswordCorrect(pass);
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    protected void createMenus() {
        try {
            this.m_databaseMenu = new Menu_RefractionDatabase(this.m_menuBar);
            this.m_sortMenu = new Menu_Sort(this.m_menuBar);
            this.m_pickMenu = new Menu_Picking(this.m_menuBar);
            this.m_delayTimeMenu = new Menu_DelayTime(this.m_menuBar);
            this.m_convertedWaveMenu = new Menu_ConvertedWave(this.m_menuBar);
            this.m_tomoMenu = new Menu_Tomography(this.m_menuBar);
            this.m_tomoVNSMenu = new Menu_TomoVNS(this.m_menuBar);
            if (SharedApplicationData.allowTestCode()) {
                this.m_gliMenu = new Menu_GLI(this.m_menuBar);
                this.m_Menu_Test = new Menu_Test(this.m_menuBar);
            }
            this.m_menuUphole = new Menu_Uphole(this.m_menuBar);
            this.m_stackMenu = new Menu_Stack(this.m_menuBar);
            this.m_windowMenu = new Menu_Window(this.m_menuBar);
            this.m_helpMenu = new Menu_Help(this.m_menuBar);
            if (this.m_mdiMenu != null) {
                this.m_menuBar.add(this.m_mdiMenu);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setWindowTitle() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String format = "Flatirons\u2122 Refraction Statics --- v%s --- Project: %s --- Version: %s";
            Object title = String.format(format, Environment.XT_VERSION, p.name(), p.versionName());
            if (this.IS_OMEGA) {
                title = "Omega " + (String)title;
            }
            this.setTitle((String)title);
            System.out.println("setWindowTitle() = " + (String)title);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessage(Messenger.Message message, Object sender, Object data) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (message == Messenger.Message.ProjectVersionChanged) {
                System.out.println("handleMessenger ProjectVersionChanged");
                this.setWindowTitle();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected void screenCapture(boolean entireScreen) {
        try {
            Point p = this.getLocationOnScreen();
            Dimension d = this.getSize();
            Rectangle rect = new Rectangle(p, d);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (entireScreen) {
                Dimension screenSize = toolkit.getScreenSize();
                rect = new Rectangle(screenSize);
            }
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(rect);
            TransferableImage trans = new TransferableImage(image);
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(trans, this);
            try {
                String fileName;
                if (this.m_captureImage && (fileName = Tools_Chooser.getSaveFileName("jpg")) != null) {
                    File file = new File(fileName);
                    ImageIO.write((RenderedImage)image, "jpg", file);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void testSuggestion() {
    }

    protected void addSegyFiles() {
        try {
            if (!RefractionStaticsProject.singleton().isOrigin("SEGY")) {
                JOptionPane.showMessageDialog(null, "Requires a SEGY project", "Requires a SEGY project", 0);
                return;
            }
            if (this.m_addDialog == null) {
                this.m_addDialog = new AddSegyFilesDialog();
            }
            this.m_addDialog.showDialog();
            if (!this.m_addDialog.OK) {
                return;
            }
            Action_AddSegyFilesToProject action = new Action_AddSegyFilesToProject();
            String dictFileName = this.m_addDialog.getDictFileName();
            ArrayList<String> files = this.m_addDialog.getFileList();
            action.Hasher.clear();
            action.Hasher.string_put("DictionaryFile", dictFileName);
            ArrayList<String> list = new ArrayList<String>();
            for (String fileName : files) {
                Segy segy = new Segy();
                segy.setFileName(fileName, true);
                if (!segy.isFileOK()) continue;
                list.add(fileName);
            }
            if (list.size() < 1) {
                JOptionPane.showMessageDialog(null, "No valid SEGY files selected", "No valid SEGY files selected", 0);
                return;
            }
            action.Hasher.stringList_put("FileList", list);
            Action_Sequence sequence = RefractionStaticsProject.singleton().actionSequence();
            sequence.clear();
            sequence.addAction(action);
            RefractionStaticsProject.singleton().executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_phoenix_projects_MI) {
                this.export_phoenix();
                return;
            }
            if (e.getSource() == this.m_addSegyFiles) {
                this.addSegyFiles();
                return;
            }
            if (e.getSource() == this.m_timerSC) {
                if (this.m_timerCount == 2) {
                    this.m_timerSC.stop();
                    this.screenCapture(this.m_captureScreen);
                }
                if (this.m_timerCount >= 3) {
                    this.m_timerSC.stop();
                }
                ++this.m_timerCount;
                return;
            }
            if (e.getSource() == this.m_timer) {
                // empty if block
            }
            if (e.getSource() == this.m_captureWindowAskSaveToFileMI) {
                this.m_captureImage = !this.m_captureImage;
                this.m_captureWindowAskSaveToFileMI.setState(this.m_captureImage);
            }
            if (e.getSource() == this.m_captureWindowMI) {
                this.m_timerCount = 0;
                this.m_captureScreen = false;
                this.m_timerSC.start();
            }
            if (e.getSource() == this.m_captureScreenMI) {
                this.m_timerCount = 0;
                this.m_captureScreen = true;
                this.m_timerSC.start();
            }
            if (e.getSource() == this.m_openProjectMI) {
                this.openProject();
                return;
            }
            if (e.getSource() == this.m_openSegY) {
                AppFrame_Segy appFrame_Segy = new AppFrame_Segy(false);
            }
            if (e.getSource() == this.m_closeProgram) {
                System.out.println("Exiting Flatirons...");
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void export_phoenix() {
        try {
            SelectProjectDialog dlg = new SelectProjectDialog(false, true);
            if (!dlg.OK) {
                return;
            }
            String fileName = Tools_Chooser.getDirectory("Top level directory for export");
            if (fileName == null) {
                return;
            }
            Action_ExportBinaryGLI_All action = new Action_ExportBinaryGLI_All();
            action.ProjectList = dlg.SelectedProjects;
            action.OutputPath = fileName;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.executeSingleAction(action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void openProject() {
        try {
            SelectProjectDialog dlg = new SelectProjectDialog(false, false);
            if (!dlg.OK) {
                return;
            }
            this.closeAllComponents();
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.setName(dlg.ProjectName, true);
            int runCount = project.runCount();
            if (runCount <= 1) {
                project.createDefaultGrid3D();
                if (project.dim2D()) {
                    project.grid2DPrepDefault();
                    Grid2D_Conversion_Line g2d = new Grid2D_Conversion_Line();
                    g2d.setAngle(project.TempGrid2DAngle);
                    g2d.setBinSize(project.TempGrid2DBinSize);
                    g2d.setOrigin(project.TempGrid2DOriginX, project.TempGrid2DOriginY);
                    project.setGrid2D_Conversion(g2d);
                }
                DefineGridDialog defineGridDialog = new DefineGridDialog(false, true);
            }
            this.setWindowTitle();
            this.showDefaultWindows();
            return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return;
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            String tabPath = this.m_projectPath + "/tab.properties";
            Properties tabProp = new Properties();
            for (JTabbedPane tabs : this.m_tabList) {
                int n_tabs = tabs.getTabCount();
                for (int n = 0; n < n_tabs; ++n) {
                    String tabIndex;
                    String tabName;
                    Component tab = tabs.getComponentAt(n);
                    if (tab instanceof ISaveableFrame) {
                        ISaveableFrame frame = (ISaveableFrame)((Object)tab);
                        tabName = frame.TAB_NAME();
                        tabIndex = "tab" + n;
                        tabProp.put(tabIndex, tabName);
                        continue;
                    }
                    if (!(tab instanceof BasicPickWidget_V2)) continue;
                    BasicPickWidget_V2 picker = (BasicPickWidget_V2)tab;
                    tabName = "com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_V2";
                    tabIndex = "tab" + n;
                    tabProp.put(tabIndex, tabName);
                    String tabLayout = picker.layoutMethod().toString();
                    String tabLayoutIndex = "picker" + n;
                    tabProp.put(tabLayoutIndex, tabLayout);
                }
            }
            tabProp.store(new FileOutputStream(tabPath), "");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void checkTabs(boolean load) {
        try {
            String tabPath = this.m_projectPath + "/tab.properties";
            File tabFile = new File(tabPath);
            if (tabFile.exists() && load) {
                this.loadTabs();
            } else {
                this.showDefaultWindows();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadTabs() {
        try {
            String tabPath = this.m_projectPath + "/tab.properties";
            File tabFile = new File(tabPath);
            Properties tabProp = new Properties();
            tabProp.load(new FileInputStream(tabPath));
            Set<String> tabList = tabProp.stringPropertyNames();
            int tabCount = tabList.size();
            if (this.m_windowLayout == SharedApplicationData.Tabs || this.m_windowLayout == SharedApplicationData.SplitTabs) {
                this.AskWhichTab = false;
                for (int n = 0; n < tabCount; ++n) {
                    String tabKey = "tab" + n;
                    String tabValue = tabProp.getProperty(tabKey);
                    if (tabValue == null) continue;
                    ClassLoader loader = this.getClass().getClassLoader();
                    Class<?> tempClass = loader.loadClass(tabValue);
                    Object tempObj = tempClass.newInstance();
                    if (tempObj instanceof ISaveableFrame) {
                        ISaveableFrame frame = (ISaveableFrame)tempObj;
                        String label = frame.TAB_LABEL();
                        String description = frame.TAB_DESCRIPTION();
                        boolean unique = frame.TAB_UNIQUE();
                        this.showComponent(tabValue, label, description, unique);
                        continue;
                    }
                    if (!(tempObj instanceof BasicPickWidget_V2)) continue;
                    String pickerKey = "picker" + n;
                    String pickerValue = tabProp.getProperty(pickerKey);
                    if (pickerValue.equalsIgnoreCase("Standard")) {
                        SharedApplicationData.singleton().SharedString = "Standard";
                        this.showComponent(tabValue, "Picker", "Picker", false);
                    }
                    if (pickerValue.equalsIgnoreCase("OffsetBins")) {
                        SharedApplicationData.singleton().SharedString = "Offset";
                        this.showComponent(tabValue, "Offset Picker", "Offset Picker", false);
                    }
                    if (pickerValue.equalsIgnoreCase("OffsetBinUsingProfile")) {
                        SharedApplicationData.singleton().SharedString = "OffsetProfile";
                        this.showComponent(tabValue, "Profile Picker", "Offset plane picker using 2D profiles", false);
                    }
                    if (!pickerValue.equalsIgnoreCase("OffsetBinUsingInlineCrossline")) continue;
                    SharedApplicationData.singleton().SharedString = "OffsetInlineCrossline";
                    this.showComponent(tabValue, "I/C Picker", "Offset plane picker using inlines/crosslines", false);
                }
                this.AskWhichTab = true;
            }
            if (this.m_tabs != null) {
                this.m_tabs.setSelectedIndex(0);
            }
            if (this.m_leftTabs != null) {
                this.m_leftTabs.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.showDefaultWindows();
        }
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

