/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.LWRS;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.SemblanceProfileVelocityCollection;
import com.PecosLibrary.Stack.SemblanceProfileVolume;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.LWRS.LwrsWidget;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LwrsCreateStacksWidget
extends LinearLayoutWidget
implements ComponentListener,
ActionListener,
ItemListener,
ChangeListener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected LwrsWidget.SharedData m_sharedData;
    protected JButton m_btnCreateNewStack;
    protected ComboStringListWrapper m_comboTop = new ComboStringListWrapper();
    protected JProgressBar m_progress = new JProgressBar();
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected SeismicProfile m_profile;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_UserEventConsumer_MultiLineSegments m_lineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
    protected Java2D_UserEventConsumer_KeyPressed m_keyUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
    protected Java2D_UserEventConsumer_ButtonPressed m_middleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected StackGizmo m_stackGizmo = new StackGizmo();
    protected int m_selectedBin = 0;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public StackGizmo getStackGizmo() {
        return this.m_stackGizmo;
    }

    public LwrsCreateStacksWidget(LwrsWidget.SharedData sharedData, GenericObjectListener.Listener listener, EnsembleWorker_Sequence sequence) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_sharedData = sharedData;
            this.m_sequence = sequence;
            this.m_listener.addListener(listener);
            Messenger.singleton().addListener(this);
            LinearLayoutWidget top = this.createHorizontal(3, null, 0);
            this.m_btnCreateNewStack = top.createButton("Create new stack", this, 0);
            this.m_btnCreateNewStack.setEnabled(false);
            top.addComponent(this.m_progress, 10);
            top.addComponent(new JLabel("Top:"), 0);
            top.addComponent(this.m_comboTop, 2);
            this.m_comboTop.listener().addListener(this);
            PickerGizmo.singleton().listener().addListener(this);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(4);
            this.m_widget.setVisibleCount(1);
            this.m_widget.HeaderTextRowCount = 0;
            this.m_widget.setHeaderPlotVisibleCount(0, 0);
            this.m_widget.DrawColor = true;
            this.m_widget.DrawWiggles = false;
            this.m_widget.setPlotBorder(true, Color.BLACK, 2);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            this.m_widget.setHeaderPlotVisibleCount(0, 0);
            this.m_widget.setHeaderPlotVisibleCount(1, 0);
            this.addComponent(this.m_widget, 10);
            this.m_lineSegmentUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            this.m_mouseMoveUEC.addListener(this);
            this.m_middleClickUEC.addListener(this);
            this.m_keyUEC.addListener(this);
            this.loadUEC();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadUEC() {
        try {
            boolean needControlPoint;
            this.m_widget.clearUserEventConsumerList();
            PickerGizmo pg = PickerGizmo.singleton();
            boolean bl = needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointSelect;
            if (needControlPoint) {
                this.m_widget.addEventConsumer(0, this.m_lineSegmentUEC);
            } else {
                this.m_widget.addEventConsumer(0, this.m_leftClickUEC);
            }
            this.m_widget.addEventConsumer(0, this.m_middleClickUEC);
            this.m_widget.addEventConsumer(0, this.m_mouseMoveUEC);
            this.m_widget.addEventConsumer(0, this.m_keyUEC);
            this.m_widget.addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadStacks() {
        try {
            this.m_sharedData.StackEnsemble = null;
            if (this.m_profile == null) {
                return;
            }
            this.m_sharedData.StackEnsemble = this.m_profile.getStackULWS(this.m_comboTop.getSelectedString());
            if (this.m_sharedData.StackEnsemble != null) {
                EnsembleFirstBreakPickPlotData pickPlotData = this.m_sharedData.StackEnsemble.pickPlotData();
                pickPlotData.add("FBP_User", Color.green, 7, Java2D_PointSymbol.FilledOval);
            }
            this.m_widget.setEnsemble(0, this.m_sharedData.StackEnsemble);
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            this.m_widget.setTimeLineColorAndSpacing(Color.DARK_GRAY, 50.0);
            this.m_widget.clearAndLoadWigglePaintables();
            this.m_widget.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadProfile() {
        try {
            this.m_btnCreateNewStack.setEnabled(false);
            if (this.m_profile == null) {
                return;
            }
            this.m_btnCreateNewStack.setEnabled(true);
            this.reloadCombo();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSeismicProfile(SeismicProfile profile) {
        try {
            this.m_profile = profile;
            this.m_btnCreateNewStack.setEnabled(this.m_profile != null);
            this.loadProfile();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ProfileSemblanceRecomputed) {
                this.loadProfile();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadCombo() {
        try {
            if (this.m_profile == null) {
                return;
            }
            ArrayList<String> stacks = this.m_profile.stackNamesULWS();
            this.m_comboTop.setStringArray(stacks);
            this.reloadStacks();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.reloadStacks();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    public void createNewStack() {
        try {
            if (this.m_profile == null) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SemblanceProfileVelocityCollection vc = this.m_profile.semblanceProfileVelocityCollection();
            int numPicks = vc.getNumPickedBins();
            if (numPicks < 1) {
                JOptionPane.showMessageDialog(null, "Pick velocities first", "", 0);
                return;
            }
            String name = JOptionPane.showInputDialog(null, "Name of the stack model", "Stack name ", -1);
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            if (!this.m_profile.validStackNameULWS(name = Tools_Strings.removeCrap(name, true))) {
                JOptionPane.showMessageDialog(null, "Name too short? Stack already exists?", "Not a valid stack name", 0);
                return;
            }
            SemblanceProfileVolume spv = this.m_profile.semblanceProfileVolume();
            if (!spv.valid()) {
                return;
            }
            double mute = spv.stretchMutePercent();
            double minOff = spv.minimumOffset();
            double maxOff = spv.maximumOffset();
            int samplesPerTrace = spv.numTimes();
            float t0 = (float)spv.minimumTime();
            float digi = (float)spv.digi();
            vc.prepVelocity(t0, digi, samplesPerTrace);
            StackGizmo giz = new StackGizmo();
            Ensemble stackEnsemble = new Ensemble();
            this.m_progress.setMaximum(this.m_profile.binCount());
            for (int b = 0; b < this.m_profile.binCount(); ++b) {
                this.m_progress.setValue(b);
                this.m_progress.paintImmediately(0, 0, 600, 30);
                Ensemble ensemble = new Ensemble();
                this.m_profile.populateSeismicProfileEnsemble(b, ensemble);
                float[] stack = null;
                if (ensemble.traceCount() >= 1) {
                    p.prepGeometryHeaders(ensemble, false, false);
                    p.inputDataProcessor_Run(ensemble);
                    if (!ensemble.dictionary().containsEntry("Trace", "Offset")) {
                        JOptionPane.showMessageDialog(null, "Unable to compute offset - are coords okay?", "Cannot create stack", 0);
                        return;
                    }
                    Ensemble ensembleProc = this.m_sequence.work(ensemble.clone());
                    float[] vel = vc.getVelocity(b);
                    stack = giz.stack(ensembleProc, vel, t0, digi, mute, minOff, maxOff);
                } else {
                    stack = new float[samplesPerTrace];
                }
                EnsembleTrace stackTrace = stackEnsemble.addTrace();
                stackTrace.data().insertArray(stack, samplesPerTrace);
            }
            this.m_profile.saveStackULWS(name, stackEnsemble, t0, digi, samplesPerTrace);
            this.m_progress.setValue(0);
            this.reloadCombo();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_btnCreateNewStack == e.getSource()) {
                this.createNewStack();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_comboTop) {
                this.reloadStacks();
                return;
            }
            if (sender == PickerGizmo.singleton()) {
                this.loadUEC();
                return;
            }
            PickerGizmo pg = PickerGizmo.singleton();
            if (sender == this.m_keyUEC) {
                this.handleKeyUEC();
                return;
            }
            if (sender == this.m_lineSegmentUEC) {
                if (this.m_lineSegmentUEC.Dragging) {
                    return;
                }
                if (!this.m_lineSegmentUEC.Finished) {
                    return;
                }
                this.m_sharedData.StackEnsemble.dictionary().addEntry("Trace", "FBP_User", DataType.Float);
                if (pg.handleControlPoint(this.m_lineSegmentUEC, this.m_sharedData.StackEnsemble, this.m_sharedData.StackEnsemble)) {
                    this.m_widget.forcePaintAll();
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKeyUEC() {
        try {
            if (this.m_sharedData.StackEnsemble == null) {
                return;
            }
            this.m_sharedData.StackEnsemble.dictionary().addEntry("Trace", "FBP_User", DataType.Float);
            PickerGizmo pg = PickerGizmo.singleton();
            if (this.m_keyUEC.KeyCode >= 48 && this.m_keyUEC.KeyCode <= 57) {
                return;
            }
            if (this.m_keyUEC.EscapePressed) {
                return;
            }
            if (pg.keyOff(this.m_keyUEC)) {
                return;
            }
            boolean lockedViewport = false;
            if (pg.handleKey(this.m_keyUEC, this.m_sharedData.StackEnsemble, this.m_sharedData.StackEnsemble, this.m_sequence, true, this.m_widget.transform(0), true)) {
                this.m_widget.forcePaintAll();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

