/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Java2D_UserEventConsumer_ParallelLines
extends Java2D_UserEventConsumerBase {
    public Color LineColor = Color.MAGENTA;
    public Stroke LineStroke = new BasicStroke(3.0f);
    public boolean Dragging = false;
    public boolean BroadcastWhenDragging = true;
    public int MouseButton = 1;
    public int StartPixelX;
    public int StartPixelY;
    public int EndPixelX;
    public int EndPixelY;
    public double StartWorldX;
    public double StartWorldY;
    public double EndWorldX;
    public double EndWorldY;
    public boolean TinyLine = true;
    public double Azimuth = 0.0;
    public double Offset;
    public int TotalLines = 3;
    public double LineSpacing = 5000.0;

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            if (!this.Dragging) {
                this.NeedsToBePainted = false;
                if (eventData.UserEventOrigin != Java2D_UserEventOrigin.MousePressed) {
                    return;
                }
                if (eventData.InputMouseEvent.getButton() != this.MouseButton) {
                    return;
                }
                this.StartPixelX = eventData.PixelX;
                this.StartPixelY = eventData.PixelY;
                this.StartWorldX = eventData.Transform.getWorldFromPixel_X(this.StartPixelX);
                this.StartWorldY = eventData.Transform.getWorldFromPixel_Y(this.StartPixelY);
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.Dragging = true;
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseDragged) {
                this.NeedsToBePainted = true;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                boolean bl = this.TinyLine = Math.abs(this.EndPixelX - this.StartPixelX) < 3 && Math.abs(this.EndPixelY - this.StartPixelY) < 3;
                if (this.TinyLine) {
                    this.Offset = 0.0;
                    this.Azimuth = 0.0;
                } else {
                    double dx = this.EndWorldX - this.StartWorldX;
                    double dy = this.EndWorldY - this.StartWorldY;
                    this.Azimuth = Math.atan2(dy, dx);
                    this.Offset = Math.sqrt(dx * dx + dy * dy);
                }
                if (this.BroadcastWhenDragging) {
                    this.broadcast(this, null);
                }
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseReleased) {
                this.NeedsToBePainted = false;
                this.Dragging = false;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                boolean bl = this.TinyLine = Math.abs(this.EndPixelX - this.StartPixelX) < 3 && Math.abs(this.EndPixelY - this.StartPixelY) < 3;
                if (this.TinyLine) {
                    this.Offset = 0.0;
                    this.Azimuth = 0.0;
                } else {
                    double dx = this.EndWorldX - this.StartWorldX;
                    double dy = this.EndWorldY - this.StartWorldY;
                    this.Azimuth = Math.atan2(dy, dx);
                    this.Offset = Math.sqrt(dx * dx + dy * dy);
                }
                this.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            if (!this.Dragging) {
                return;
            }
            if (this.TinyLine) {
                return;
            }
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(this.LineStroke);
            g2d.setColor(this.LineColor);
            int half = this.TotalLines / 2;
            double dx = this.EndWorldX - this.StartWorldX;
            double dy = this.EndWorldY - this.StartWorldY;
            double angle = Math.atan2(dy, dx);
            double perp = angle + 1.5707963267948966;
            double sx = this.LineSpacing * Math.cos(perp);
            double sy = this.LineSpacing * Math.sin(perp);
            for (int n = -half; n <= half; ++n) {
                double x1 = this.StartWorldX + (double)n * sx;
                double y1 = this.StartWorldY + (double)n * sy;
                double x2 = this.EndWorldX + (double)n * sx;
                double y2 = this.EndWorldY + (double)n * sy;
                paintParameter.drawLine(x1, y1, x2, y2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.Dragging = false;
            this.NeedsToBePainted = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

