/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;

public class Java2D_UserEventConsumer_MultiLineSegments
extends Java2D_UserEventConsumerBase
implements GenericObjectListener.Listener {
    protected boolean m_usePickerKeys = false;
    public Color LineColor = Color.red;
    public Stroke LineStroke = new BasicStroke(2.0f);
    protected ArrayList<Entry> m_list = new ArrayList();
    protected int m_numValid = 0;
    public boolean Finished = false;
    public boolean Dragging = false;
    public boolean DefiningPolygon = false;
    protected double m_currentX;
    protected double m_currentY;
    public boolean AddPicks_SnapToEvent = false;
    public boolean AddPicks_PenMode = false;
    public boolean KillPicks = false;
    public boolean KillTraces = false;
    public boolean FlipPolarity = false;
    protected long m_currentClickTime = System.currentTimeMillis();
    protected long m_priorClickTime = 0L;

    public void setUsePickerKeys() {
        try {
            this.m_usePickerKeys = true;
            PickerGizmo.singleton().listener().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_UserEventConsumer_MultiLineSegments() {
    }

    public Java2D_UserEventConsumer_MultiLineSegments(boolean UsePickerKeys) {
        try {
            if (UsePickerKeys) {
                this.setUsePickerKeys();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (this.m_usePickerKeys && sender == PickerGizmo.singleton()) {
                this.m_list.clear();
                this.Dragging = false;
                this.Finished = false;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int numPoints() {
        if (this.m_usePickerKeys) {
            return this.m_list.size();
        }
        return this.m_numValid;
    }

    public double getX(int n) {
        return this.m_list.get((int)n).WorldX;
    }

    public double getY(int n) {
        return this.m_list.get((int)n).WorldY;
    }

    public void clear() {
        this.m_numValid = 0;
        if (this.m_usePickerKeys) {
            this.m_list.clear();
        }
    }

    protected void handleUserEvent_PickerGizmo(Java2D_UserEventDataWrapper eventData) {
        try {
            this.NeedsToBePainted = false;
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.KeyPressed) {
                boolean addPoint;
                int keyCode = eventData.InputKeyEvent.getKeyCode();
                if (PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandCancel)) {
                    this.Dragging = false;
                    this.Finished = false;
                    this.m_list.clear();
                    this.NeedsToBePainted = true;
                    return;
                }
                if (PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandStart)) {
                    this.Dragging = true;
                    this.Finished = false;
                    this.m_list.clear();
                    this.m_list.add(new Entry());
                    Entry e = this.m_list.get(0);
                    e.WorldX = eventData.WorldX;
                    e.WorldY = eventData.WorldY;
                    e.PixelX = eventData.PixelX;
                    e.PixelY = eventData.PixelY;
                    return;
                }
                if (this.m_list.size() < 1 || !this.Dragging) {
                    return;
                }
                this.AddPicks_SnapToEvent = PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandAddPicksSnapToEvent);
                this.AddPicks_PenMode = PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandAddPicksAtLine);
                this.KillPicks = PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandKillPicks);
                this.KillTraces = PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandKillTraces);
                this.FlipPolarity = PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandFlipPolarity);
                boolean done = this.AddPicks_SnapToEvent || this.AddPicks_PenMode || this.KillPicks || this.KillTraces || this.FlipPolarity;
                boolean bl = addPoint = done || PickerGizmo.singleton().isKeyCodeThisAction(keyCode, PickerGizmo.KeyActionEnum.RubberBandAddPoint);
                if (!addPoint) {
                    return;
                }
                for (Entry e : this.m_list) {
                    int dist = Math.abs(eventData.PixelX - e.PixelX) + Math.abs(eventData.PixelY - e.PixelY);
                    if (dist >= 3) continue;
                    return;
                }
                Entry e = new Entry();
                this.m_list.add(e);
                e.WorldX = eventData.WorldX;
                e.WorldY = eventData.WorldY;
                e.PixelX = eventData.PixelX;
                e.PixelY = eventData.PixelY;
                this.NeedsToBePainted = true;
                if (done) {
                    this.Finished = true;
                    this.Dragging = false;
                    this.broadcast(this, null);
                    this.NeedsToBePainted = true;
                    return;
                }
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseMoved) {
                if (!this.Dragging) {
                    return;
                }
                this.m_currentX = eventData.WorldX;
                this.m_currentY = eventData.WorldY;
                this.NeedsToBePainted = true;
                this.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            if (this.m_usePickerKeys) {
                this.handleUserEvent_PickerGizmo(eventData);
                return;
            }
            this.NeedsToBePainted = false;
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MousePressed) {
                if (eventData.InputMouseEvent.getButton() != 1) {
                    return;
                }
                boolean useCustomClick = SharedApplicationData.singleton().getParameterTree().bool_get("UseCustomDoubleClick", false);
                long doubleClickTime = SharedApplicationData.singleton().getParameterTree().int_get("DoubleClickTime", 300);
                doubleClickTime = Math.max(doubleClickTime, 100L);
                doubleClickTime = Math.min(doubleClickTime, 1000L);
                this.m_currentClickTime = System.currentTimeMillis();
                long timeSinceLast = this.m_currentClickTime - this.m_priorClickTime;
                this.m_priorClickTime = this.m_currentClickTime;
                boolean isDoubleClick = false;
                if (useCustomClick) {
                    isDoubleClick = timeSinceLast < doubleClickTime;
                } else {
                    boolean bl = isDoubleClick = eventData.InputMouseEvent.getClickCount() >= 2;
                }
                if (isDoubleClick) {
                    this.Finished = true;
                    this.Dragging = false;
                    if (this.m_numValid < 2) {
                        this.Finished = false;
                        this.m_numValid = 0;
                    } else {
                        System.out.println("Java2D_UserEventConsumer_MultiLineSegments " + Integer.toString(this.m_numValid));
                        this.broadcast(this, null);
                    }
                    this.NeedsToBePainted = true;
                    return;
                }
                System.out.println("multi line left click, count = " + this.m_numValid);
                if (this.Finished) {
                    this.m_numValid = 0;
                }
                this.Finished = false;
                while (this.m_numValid >= this.m_list.size()) {
                    this.m_list.add(new Entry());
                }
                Entry e = this.m_list.get(this.m_numValid);
                e.WorldX = eventData.WorldX;
                e.WorldY = eventData.WorldY;
                e.PixelX = eventData.PixelX;
                e.PixelY = eventData.PixelY;
                for (int n = 0; n < this.m_numValid; ++n) {
                    Entry et = this.m_list.get(n);
                    int dist = Math.abs(e.PixelX - et.PixelX) + Math.abs(e.PixelY - et.PixelY);
                    if (dist >= 8) continue;
                    return;
                }
                ++this.m_numValid;
                this.Dragging = true;
                if (this.m_numValid <= 1) {
                    return;
                }
                this.NeedsToBePainted = true;
                this.broadcast(this, null);
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseMoved) {
                if (!this.Dragging) {
                    return;
                }
                this.m_currentX = eventData.WorldX;
                this.m_currentY = eventData.WorldY;
                this.NeedsToBePainted = true;
                this.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void paintLine(Java2D_PaintParameter paintParameter, double x1, double t1, double x2, double t2) {
        try {
            Graphics2D g2d = paintParameter.G2D;
            Java2D_Transform transform = paintParameter.Transform;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int ix1 = (int)(x1 * scaleX + shiftX);
            int iy1 = (int)(t1 * scaleY + shiftY);
            int ix2 = (int)(x2 * scaleX + shiftX);
            int iy2 = (int)(t2 * scaleY + shiftY);
            g2d.drawLine(ix1, iy1, ix2, iy2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            if (!this.Dragging) {
                return;
            }
            if (this.m_usePickerKeys) {
                this.m_numValid = this.m_list.size();
            }
            if (this.m_numValid < 1) {
                return;
            }
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(this.LineStroke);
            g2d.setColor(this.LineColor);
            if (this.m_numValid == 1) {
                Entry e = this.m_list.get(0);
                this.paintLine(paintParameter, e.WorldX, e.WorldY, this.m_currentX, this.m_currentY);
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            for (int n = 0; n < this.m_numValid - 1; ++n) {
                Entry e1 = this.m_list.get(n);
                Entry e2 = this.m_list.get(n + 1);
                this.paintLine(paintParameter, e1.WorldX, e1.WorldY, e2.WorldX, e2.WorldY);
            }
            Entry e = this.m_list.get(this.m_numValid - 1);
            this.paintLine(paintParameter, e.WorldX, e.WorldY, this.m_currentX, this.m_currentY);
            if (this.DefiningPolygon) {
                e = this.m_list.get(0);
                this.paintLine(paintParameter, e.WorldX, e.WorldY, this.m_currentX, this.m_currentY);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.NeedsToBePainted = this.Dragging;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class Entry {
        public double WorldX;
        public double WorldY;
        public int PixelX;
        public int PixelY;

        protected Entry() {
        }
    }
}

