/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchColors;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_UserEventConsumer_Branch
extends Java2D_UserEventConsumerBase {
    public double KillRadius = 30.0;
    public boolean ShowKillRadius = true;
    public boolean ApplyLMO = false;
    public double VelLMO = 100.0;
    public int Refractor = 1;
    public boolean Dragging = false;
    public boolean BroadcastWhenDragging = true;
    public int MouseButton = 1;
    public int StartPixelX;
    public int StartPixelY;
    public int EndPixelX;
    public int EndPixelY;
    public double StartWorldX;
    public double StartWorldY;
    public double EndWorldX;
    public double EndWorldY;
    public double MinOff;
    public double MaxOff;
    public double MinTime;
    public double MaxTime;
    public boolean StuffOK = false;
    public double Velocity = 0.0;
    public double DelayTime = 0.0;
    protected Color m_killColor = new Color(255, 200, 200, 200);
    protected int[] m_polyX = new int[4];
    protected int[] m_polyY = new int[4];

    protected void computeStuff() {
        try {
            this.StuffOK = false;
            if (this.StartPixelX <= this.EndPixelX) {
                this.MinOff = this.StartWorldX;
                this.MaxOff = this.EndWorldX;
                this.MinTime = this.StartWorldY;
                this.MaxTime = this.EndWorldY;
            } else {
                this.MaxOff = this.StartWorldX;
                this.MinOff = this.EndWorldX;
                this.MaxTime = this.StartWorldY;
                this.MinTime = this.EndWorldY;
            }
            if (this.ApplyLMO) {
                this.MinTime += 1000.0 * this.MinOff / this.VelLMO;
                this.MaxTime += 1000.0 * this.MaxOff / this.VelLMO;
            }
            if (Math.abs(this.EndPixelX - this.StartPixelX) < 4) {
                return;
            }
            if (Math.abs(this.MaxTime - this.MinTime) < 1.0E-6) {
                return;
            }
            this.Velocity = 1000.0 * (this.MaxOff - this.MinOff) / (this.MaxTime - this.MinTime);
            this.DelayTime = 0.5 * (this.MinTime - 1000.0 * this.MinOff / this.Velocity);
            this.StuffOK = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.StuffOK = false;
        }
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            if (!this.Dragging) {
                this.NeedsToBePainted = false;
                if (eventData.UserEventOrigin != Java2D_UserEventOrigin.MousePressed) {
                    return;
                }
                if (eventData.InputMouseEvent.getButton() != this.MouseButton) {
                    return;
                }
                this.StartPixelX = eventData.PixelX;
                this.StartPixelY = eventData.PixelY;
                this.StartWorldX = eventData.Transform.getWorldFromPixel_X(this.StartPixelX);
                this.StartWorldY = eventData.Transform.getWorldFromPixel_Y(this.StartPixelY);
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.Dragging = true;
                this.computeStuff();
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseDragged) {
                this.NeedsToBePainted = true;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.computeStuff();
                if (this.BroadcastWhenDragging) {
                    this.broadcast(this, null);
                }
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseReleased) {
                this.NeedsToBePainted = false;
                this.Dragging = false;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.computeStuff();
                this.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            if (!this.Dragging) {
                return;
            }
            this.computeStuff();
            Graphics2D g2d = paintParameter.G2D;
            Java2D_Transform transform = paintParameter.Transform;
            if (this.ShowKillRadius) {
                this.m_polyX[0] = this.EndPixelX;
                this.m_polyY[0] = transform.getPixelFromWorld_Y(this.EndWorldY + this.KillRadius);
                this.m_polyX[1] = this.EndPixelX;
                this.m_polyY[1] = transform.getPixelFromWorld_Y(this.EndWorldY - this.KillRadius);
                this.m_polyX[2] = this.StartPixelX;
                this.m_polyY[2] = transform.getPixelFromWorld_Y(this.StartWorldY - this.KillRadius);
                this.m_polyX[3] = this.StartPixelX;
                this.m_polyY[3] = transform.getPixelFromWorld_Y(this.StartWorldY + this.KillRadius);
                g2d.setColor(this.m_killColor);
                g2d.fillPolygon(this.m_polyX, this.m_polyY, 4);
            }
            g2d.setColor(BranchColors.solidColor(this.Refractor));
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setFont(Tools_FontLibrary.Font16);
            g2d.drawLine(this.EndPixelX, this.EndPixelY, this.StartPixelX, this.StartPixelY);
            if (this.StuffOK) {
                int minOff = (int)Math.min(this.StartWorldX, this.EndWorldX);
                int maxOff = (int)Math.max(this.StartWorldX, this.EndWorldX);
                int left = Math.min(this.EndPixelX, this.StartPixelX);
                int top = Math.min(this.EndPixelY, this.StartPixelY) - 5;
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
                String s = String.format("V=%d  DT=%d Min=%d  Max=%d", (int)this.Velocity, (int)(0.5 + this.DelayTime), minOff, maxOff);
                g2d.drawString(s, left, top);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.Dragging = false;
            this.NeedsToBePainted = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

