/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class Java2D_Paintable_BranchPickCollections
implements Java2D_PaintableInterface {
    protected ArrayList<PrecomputeLocation> m_locations = new ArrayList();
    protected String m_fileName;
    public double SelectedX;
    public double SelectedY;
    public int SelectedPixelX;
    public int SelectedPixelY;
    protected double m_spacing;
    protected double m_radius;
    protected double m_radiusSquared;
    public boolean ForceSymmetricalRange = false;

    public Java2D_Paintable_BranchPickCollections(String fileName) {
        try {
            this.m_fileName = fileName;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finishedScanning() {
        try {
            for (PrecomputeLocation loc : this.m_locations) {
                loc.finishedScanning();
            }
            System.gc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save() {
        try {
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            for (int n = this.m_locations.size() - 1; n >= 0; --n) {
                PrecomputeLocation loc = this.m_locations.get(n);
                if (loc.Count >= 1) continue;
                this.m_locations.remove(n);
            }
            int magic = 34553;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                int count = this.count();
                file.writeInt(count);
                for (PrecomputeLocation loc : this.m_locations) {
                    loc.save(file);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read() {
        try {
            this.freeMemory();
            if (!Tools_FileSystem.exists_file(this.m_fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            int magic = file.readInt();
            if (magic != 34553) {
                throw new Exception("magic != 34553");
            }
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                for (int n = 0; n < count; ++n) {
                    this.m_locations.add(new PrecomputeLocation(file));
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean valid() {
        return this.m_locations.size() > 0;
    }

    public int count() {
        return this.m_locations.size();
    }

    public void deleteCurrentLocations() {
        try {
            this.freeMemory();
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void freeMemory() {
        try {
            System.out.println("Java2D_Paintable_BranchPickCollections freeMemory");
            this.m_locations.clear();
            System.gc();
            System.gc();
            System.gc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean nearest(Ensemble ensemble, int px, int py) {
        try {
            ensemble.clearTraces(false);
            PrecomputeLocation best = null;
            int minDist = 1000000;
            for (PrecomputeLocation loc : this.m_locations) {
                int dist;
                if (loc.Count <= 1 || (dist = Math.abs(px - loc.PixelX) + Math.abs(py - loc.PixelY)) >= minDist) continue;
                minDist = dist;
                best = loc;
            }
            if (best == null) {
                return false;
            }
            this.SelectedX = best.X;
            this.SelectedY = best.Y;
            this.SelectedPixelX = best.PixelX;
            this.SelectedPixelY = best.PixelY;
            int indexShotID = ensemble.dictionary().addEntry("Trace", "ShotID", DataType.Int);
            int indexRecID = ensemble.dictionary().addEntry("Trace", "ReceiverID", DataType.Int);
            int indexPick = ensemble.dictionary().addEntry("Trace", "FBP_User", DataType.Float);
            int indexOffset = ensemble.dictionary().addEntry("Trace", "Offset", DataType.Float);
            for (int row = 0; row < best.Count; ++row) {
                EnsembleTrace trace = ensemble.addTrace();
                trace.header().putInt(indexShotID, best.ShotID[row]);
                trace.header().putInt(indexRecID, best.RecID[row]);
                trace.header().putFloat(indexPick, best.Pick[row]);
                trace.header().putFloat(indexOffset, best.Offset[row]);
            }
            RefractionStaticsProject.singleton().prepGeometryHeaders(ensemble, true, true);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void prep(double spacing, double radius) {
        try {
            this.m_radius = radius;
            this.m_radiusSquared = radius * radius;
            this.m_spacing = spacing;
            this.m_locations.clear();
            Range_Double rx = new Range_Double();
            Range_Double ry = new Range_Double();
            RefractionStaticsProject.singleton().shotTable().column_range("Easting", rx);
            RefractionStaticsProject.singleton().shotTable().column_range("Northing", ry);
            RefractionStaticsProject.singleton().receiverTable().column_range("Easting", rx);
            RefractionStaticsProject.singleton().receiverTable().column_range("Northing", ry);
            for (double x = rx.rangeMin() + 0.5 * this.m_spacing; x < rx.rangeMax(); x += this.m_spacing) {
                for (double y = ry.rangeMin() + 0.5 * this.m_spacing; y < ry.rangeMax(); y += this.m_spacing) {
                    PrecomputeLocation loc = new PrecomputeLocation(x, y);
                    this.m_locations.add(loc);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void add(double x, double y, int shotID, int recID, float pick, float offset) {
        try {
            for (PrecomputeLocation loc : this.m_locations) {
                double dx = x - loc.X;
                double dy = y - loc.Y;
                if (!(dx * dx + dy * dy < this.m_radiusSquared)) continue;
                int row = loc.Table.row_increment();
                loc.Table.putInt(row, loc.IndexShotID, shotID);
                loc.Table.putInt(row, loc.IndexRecID, recID);
                loc.Table.putFloat(row, loc.IndexPick, pick);
                loc.Table.putFloat(row, loc.IndexOffset, offset);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int r = 13;
            int r2 = r / 2;
            g2d.setColor(Color.magenta);
            for (PrecomputeLocation loc : this.m_locations) {
                if (loc.Count <= 0) continue;
                loc.PixelX = (int)(scaleX * loc.X + shiftX);
                loc.PixelY = (int)(scaleY * loc.Y + shiftY);
                g2d.drawOval(loc.PixelX - r2, loc.PixelY - r2, r, r);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            for (PrecomputeLocation loc : this.m_locations) {
                if (loc.Count <= 0) continue;
                rangeX.expandRange(loc.X);
                rangeY.expandRange(loc.Y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    protected class PrecomputeLocation {
        public double X;
        public double Y;
        public int PixelX;
        public int PixelY;
        protected Table_Abstract Table;
        protected int IndexShotID;
        protected int IndexRecID;
        protected int IndexPick;
        protected int IndexOffset;
        public int Count;
        public int[] ShotID;
        public int[] RecID;
        public float[] Pick;
        public float[] Offset;

        public PrecomputeLocation(double x, double y) {
            this.Table = new Table_Memory();
            this.Count = 0;
            try {
                this.Table = new Table_Memory();
                this.X = x;
                this.Y = y;
                this.IndexShotID = this.Table.column_append("ShotID", DataType.Int);
                this.IndexRecID = this.Table.column_append("ReceiverID", DataType.Int);
                this.IndexPick = this.Table.column_append("FBP_User", DataType.Float);
                this.IndexOffset = this.Table.column_append("Offset", DataType.Float);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public PrecomputeLocation(RandomAccessFile file) throws Exception {
            block7: {
                this.Table = new Table_Memory();
                this.Count = 0;
                try {
                    int magic = file.readInt();
                    if (magic != 876332) {
                        throw new Exception("magic != 876332");
                    }
                    int version = file.readInt();
                    this.IndexShotID = this.Table.column_append("ShotID", DataType.Int);
                    this.IndexRecID = this.Table.column_append("ReceiverID", DataType.Int);
                    this.IndexPick = this.Table.column_append("FBP_User", DataType.Float);
                    this.IndexOffset = this.Table.column_append("Offset", DataType.Float);
                    if (version == 1000) {
                        this.X = file.readDouble();
                        this.Y = file.readDouble();
                        this.Count = file.readInt();
                        for (int r = 0; r < this.Count; ++r) {
                            int row = this.Table.row_increment();
                            this.Table.putInt(row, this.IndexShotID, file.readInt());
                            this.Table.putInt(row, this.IndexRecID, file.readInt());
                            this.Table.putFloat(row, this.IndexPick, file.readFloat());
                            this.Table.putFloat(row, this.IndexOffset, file.readFloat());
                        }
                        this.finishedScanning();
                        break block7;
                    }
                    if (version == 1001) {
                        this.Table = null;
                        this.X = file.readDouble();
                        this.Y = file.readDouble();
                        this.Count = file.readInt();
                        this.ShotID = new int[this.Count];
                        this.RecID = new int[this.Count];
                        this.Pick = new float[this.Count];
                        this.Offset = new float[this.Count];
                        int numBytes = 16 * this.Count;
                        ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes);
                        file.read(buffer.array(), 0, numBytes);
                        for (int r = 0; r < this.Count; ++r) {
                            this.ShotID[r] = buffer.getInt();
                            this.RecID[r] = buffer.getInt();
                            this.Pick[r] = buffer.getFloat();
                            this.Offset[r] = buffer.getFloat();
                        }
                        break block7;
                    }
                    throw new Exception("bad version");
                }
                catch (Exception ex) {
                    ExceptionMonitor.add(ex);
                    throw ex;
                }
            }
        }

        public void finishedScanning() {
            try {
                if (this.Table == null) {
                    return;
                }
                this.Count = this.Table.row_count();
                if (this.Count < 0) {
                    return;
                }
                this.ShotID = new int[this.Count];
                this.RecID = new int[this.Count];
                this.Pick = new float[this.Count];
                this.Offset = new float[this.Count];
                for (int row = 0; row < this.Count; ++row) {
                    this.ShotID[row] = this.Table.getInt(row, this.IndexShotID);
                    this.RecID[row] = this.Table.getInt(row, this.IndexRecID);
                    this.Pick[row] = this.Table.getFloat(row, this.IndexPick);
                    this.Offset[row] = this.Table.getFloat(row, this.IndexOffset);
                }
                this.Table = null;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void save(RandomAccessFile file) {
            try {
                if (this.Count < 1) {
                    return;
                }
                int magic = 876332;
                int version = 1001;
                file.writeInt(magic);
                file.writeInt(version);
                if (version == 1001) {
                    file.writeDouble(this.X);
                    file.writeDouble(this.Y);
                    int numBytes = 16 * this.Count;
                    ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes);
                    file.writeInt(this.Count);
                    for (int row = 0; row < this.Count; ++row) {
                        buffer.putInt(this.ShotID[row]);
                        buffer.putInt(this.RecID[row]);
                        buffer.putFloat(this.Pick[row]);
                        buffer.putFloat(this.Offset[row]);
                    }
                    file.write(buffer.array(), 0, numBytes);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }
}

