/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Tools.Tools_ColorLibrary;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Java2D_YAxisImage {
    protected BufferedImage m_image = null;
    protected double m_scale = 1.0;
    protected double m_shift = 0.0;
    protected double m_top = 1.7976931348623158E307;
    protected double m_bottom = 0.0;
    protected String m_title = "";
    protected boolean m_titleDirty = true;
    public Color BackColor = Tools_ColorLibrary.AxisImage_Background;

    public void setTitle(String title) {
        try {
            String temp = title;
            if (title == null) {
                temp = "";
            }
            if (temp.equalsIgnoreCase(this.m_title)) {
                return;
            }
            this.m_title = temp;
            this.m_titleDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public BufferedImage image(int width, int height, double top, double bottom) {
        try {
            if (!this.imageNeedsPainting(width, height, top, bottom)) {
                return this.m_image;
            }
            int w = this.m_image.getWidth();
            int h = this.m_image.getHeight();
            Graphics2D g2d = this.m_image.createGraphics();
            g2d.setColor(this.BackColor);
            g2d.fillRect(0, 0, w, h);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            double max = Math.max(top, bottom);
            double min = Math.min(top, bottom);
            double range = max - min;
            if (range < 1.0E-4) {
                return this.m_image;
            }
            this.m_scale = (double)(h - 1) / (bottom - top);
            this.m_shift = 0.0 - this.m_scale * top;
            double tick = Tools_Plot.tickMarkInterval(range, 10);
            int temp = (int)(min / tick);
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            int stickLeft = width - 8;
            g2d.setColor(Color.BLACK);
            int priorY = -99999;
            for (double v = (double)temp * tick; v < max; v += tick) {
                String s = Tools_Strings.doubleToString(v, range, true);
                int iy = (int)(v * this.m_scale + this.m_shift);
                g2d.drawLine(width, iy, stickLeft, iy);
                int stringWidth = g2d.getFontMetrics().stringWidth(s);
                int strLeft = stickLeft - stringWidth;
                strLeft = Math.max(strLeft, 0);
                if (Math.abs(iy - priorY) <= 20) continue;
                priorY = iy;
                g2d.drawString(s, strLeft, iy + 4);
            }
            this.m_top = top;
            this.m_bottom = bottom;
            if (this.m_title.length() > 0) {
                int stringWidth = g2d.getFontMetrics().stringWidth(this.m_title);
                int strLeft = w / 2 - stringWidth / 2;
                int strHeight = g2d.getFontMetrics().getHeight();
                int strBottom = strHeight + 3;
                int strTop = strBottom - strHeight;
                g2d.setColor(Tools_ColorLibrary.AxisImage_Background);
                g2d.fillRect(strLeft, strTop, stringWidth, strHeight);
                g2d.setColor(Color.blue);
                g2d.drawString(this.m_title, strLeft, strBottom);
                this.m_titleDirty = false;
            }
            return this.m_image;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected boolean imageNeedsPainting(int width, int height, double top, double bottom) {
        try {
            if (this.m_image == null) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            if (this.m_image.getWidth() != width || this.m_image.getHeight() != height) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            double diff = Math.abs(top - this.m_top) + Math.abs(bottom - this.m_bottom);
            return diff > 1.0E-4 || this.m_titleDirty;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

