/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class Java2D_XAxisWidget
extends JPanel
implements MouseListener {
    protected Java2D_XAxisImage m_image = new Java2D_XAxisImage();
    protected double m_left = 0.0;
    protected double m_right = 100.0;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    public boolean DrawParameter = false;
    public int m_textRight;
    public int m_textBottom;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public Java2D_XAxisWidget() {
        try {
            this.addMouseListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTitle(String title) {
        try {
            this.m_image.setTitle(title);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setRange(double left, double right) {
        try {
            this.m_left = left;
            this.m_right = right;
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            BufferedImage image = this.m_image.image(size.width, size.height, this.m_left, this.m_right);
            g2d.drawImage((Image)image, 0, 0, null);
            if (this.DrawParameter) {
                int stringHeight = g2d.getFontMetrics().getHeight();
                String s = "PARAM";
                int stringWidth = g2d.getFontMetrics().stringWidth(s);
                g2d.setColor(Color.CYAN);
                g2d.fillRect(0, 0, stringWidth + 2, stringHeight + 2);
                g2d.setColor(Color.black);
                g2d.drawString(s, 2, stringHeight - 2);
                g2d.setColor(Color.BLACK);
                g2d.drawRect(0, 0, stringWidth + 2, stringHeight + 2);
                this.m_textBottom = stringHeight + 4;
                this.m_textRight = stringWidth + 4;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        try {
            if (this.DrawParameter && event.getX() <= this.m_textRight && event.getY() <= this.m_textBottom) {
                System.out.println("axis param click");
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }
}

