/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.Java2D.ColorWidgets.Java2D_HorizontalColorCompositeWidget;
import com.PecosLibrary.Windows.Java2D.ColorWidgets.Java2D_VerticalColorCompositeWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_ScrollBar;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Java2D_SimpleComposite
extends JPanel
implements ComponentListener,
ActionListener,
Java2D_Widget.Listener,
Java2D_VerticalColorCompositeWidget.Listener,
Java2D_HorizontalColorCompositeWidget.Listener,
Java2D_ScrollBar.Listener {
    protected Java2D_Widget m_mainWidget;
    protected JButton m_btnLock = new JButton();
    protected boolean m_isRangeLocked = false;
    protected ImageIcon m_lockedIcon = Tools_Bitmap.makeIcon("Lock.png");
    protected ImageIcon m_unlockedIcon = Tools_Bitmap.makeIcon("Open lock.png");
    protected boolean m_allowRangeLocking = false;
    protected Java2D_ScrollBar m_scrollX;
    protected boolean m_scrollVisibleX = false;
    protected Java2D_ScrollBar m_scrollY;
    protected boolean m_scrollVisibleY = false;
    protected Java2D_XAxisWidget m_axisX;
    protected boolean m_axisVisibleX = true;
    protected Java2D_YAxisWidget m_axisY;
    protected boolean m_axisVisibleY = true;
    protected Java2D_VerticalColorCompositeWidget m_verticalColorWidget = null;
    protected Java2D_HorizontalColorCompositeWidget m_horizontalColorWidget = null;
    protected boolean m_colorScaleVisible = true;

    public void setAllowRangeLocking(boolean allow) {
        try {
            this.m_allowRangeLocking = allow;
            if (!this.m_allowRangeLocking) {
                this.m_isRangeLocked = false;
                this.m_btnLock.setIcon(this.m_unlockedIcon);
            }
            this.m_btnLock.setVisible(this.m_allowRangeLocking && this.m_axisVisibleX && this.m_axisVisibleY);
            this.manualWidgetLayout();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_SimpleComposite(boolean horizontalColorScale) {
        try {
            this.setLayout(null);
            this.m_scrollX = new Java2D_ScrollBar(0, this);
            this.m_scrollY = new Java2D_ScrollBar(1, this);
            this.add(this.m_scrollX);
            this.add(this.m_scrollY);
            this.m_axisX = new Java2D_XAxisWidget();
            this.m_axisY = new Java2D_YAxisWidget();
            this.add(this.m_axisX);
            this.add(this.m_axisY);
            Java2D_ColorArrayWrapper colorWrapper = null;
            if (horizontalColorScale) {
                this.m_horizontalColorWidget = new Java2D_HorizontalColorCompositeWidget(this);
                this.add(this.m_horizontalColorWidget);
                colorWrapper = this.m_horizontalColorWidget.getColorArrayWrapper();
            } else {
                this.m_verticalColorWidget = new Java2D_VerticalColorCompositeWidget(this);
                this.add(this.m_verticalColorWidget);
                colorWrapper = this.m_verticalColorWidget.getColorArrayWrapper();
            }
            if (colorWrapper == null) {
                colorWrapper = new Java2D_ColorArrayWrapper(40);
            }
            this.m_mainWidget = new Java2D_Widget(colorWrapper);
            this.m_mainWidget.addListener(this);
            this.add(this.m_mainWidget);
            this.addComponentListener(this);
            this.m_btnLock.setIcon(this.m_unlockedIcon);
            this.m_btnLock.setVisible(this.m_allowRangeLocking && this.m_axisVisibleX && this.m_axisVisibleY);
            this.add(this.m_btnLock);
            this.m_btnLock.addActionListener(this);
            this.manualWidgetLayout();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnLock) {
                if (this.m_isRangeLocked) {
                    this.m_isRangeLocked = false;
                    this.m_btnLock.setIcon(this.m_unlockedIcon);
                    this.m_mainWidget.transform().unlockCurrentViewport();
                    this.m_mainWidget.mooz();
                } else {
                    this.m_isRangeLocked = true;
                    this.m_btnLock.setIcon(this.m_lockedIcon);
                    this.m_mainWidget.transform().lockCurrentViewport();
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getPixelX(double worldX) {
        try {
            return this.m_mainWidget.transform().getPixelFromWorld_X(worldX);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -99999;
        }
    }

    public int getPixelY(double worldY) {
        try {
            return this.m_mainWidget.transform().getPixelFromWorld_Y(worldY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -99999;
        }
    }

    public void lockCurrentViewport() {
        try {
            this.m_mainWidget.transform().lockCurrentViewport();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unlockCurrentViewport() {
        try {
            this.m_mainWidget.transform().unlockCurrentViewport();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Java2D_ColorArrayWrapper getColorArrayWrapper() {
        try {
            if (this.m_horizontalColorWidget != null) {
                return this.m_horizontalColorWidget.getColorArrayWrapper();
            }
            if (this.m_verticalColorWidget != null) {
                return this.m_verticalColorWidget.getColorArrayWrapper();
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void setThreeColors(Color c1, Color c2, Color c3) {
        try {
            if (this.m_horizontalColorWidget != null) {
                this.m_horizontalColorWidget.getColorArrayWrapper().setThreeColors(c1, c2, c3);
            }
            if (this.m_verticalColorWidget != null) {
                this.m_verticalColorWidget.getColorArrayWrapper().setThreeColors(c1, c2, c3);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setColorTitle(String title) {
        try {
            if (this.m_horizontalColorWidget != null) {
                this.m_horizontalColorWidget.setLabel(title);
            }
            if (this.m_verticalColorWidget != null) {
                this.m_verticalColorWidget.setLabel(title);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setVerticalTitle(String title) {
        try {
            this.m_axisY.setTitle(title);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setVerticalAxisColor(Color c) {
        try {
            this.m_axisY.setBackColor(c);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setHorizontalTitle(String title) {
        try {
            this.m_axisX.setTitle(title);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_Widget mainWidget() {
        return this.m_mainWidget;
    }

    public void setColorScaleVisible(boolean colorScaleVisible) {
        try {
            this.m_colorScaleVisible = colorScaleVisible;
            this.manualWidgetLayout();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setScrollVisible(boolean visibleX, boolean visibleY) {
        try {
            this.m_scrollVisibleX = visibleX;
            this.m_scrollVisibleY = visibleY;
            this.manualWidgetLayout();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxesVisible(boolean axisVisibleX, boolean axisVisibleY) {
        try {
            this.m_axisVisibleX = axisVisibleX;
            this.m_axisVisibleY = axisVisibleY;
            this.m_btnLock.setVisible(this.m_allowRangeLocking && this.m_axisVisibleX && this.m_axisVisibleY);
            this.manualWidgetLayout();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void manualWidgetLayout() {
        try {
            Dimension size = this.getSize();
            int horzAxisHeight = 34;
            int vertAxisWidth = 54;
            int scrollWidth = 18;
            int scrollHeight = 18;
            int vertColorWidth = 0;
            int horzColorHeight = 0;
            if (this.m_horizontalColorWidget != null) {
                this.m_horizontalColorWidget.setVisible(this.m_colorScaleVisible);
            }
            if (this.m_verticalColorWidget != null) {
                this.m_verticalColorWidget.setVisible(this.m_colorScaleVisible);
            }
            if (this.m_colorScaleVisible && this.m_verticalColorWidget != null) {
                vertColorWidth = 100;
            }
            if (this.m_colorScaleVisible && this.m_horizontalColorWidget != null) {
                horzColorHeight = 80;
            }
            this.m_scrollX.setVisible(this.m_scrollVisibleX);
            this.m_scrollY.setVisible(this.m_scrollVisibleY);
            if (!this.m_scrollVisibleX) {
                scrollHeight = 0;
            }
            if (!this.m_scrollVisibleY) {
                scrollWidth = 0;
            }
            this.m_axisX.setVisible(this.m_axisVisibleX);
            this.m_axisY.setVisible(this.m_axisVisibleY);
            if (!this.m_axisVisibleX) {
                horzAxisHeight = 0;
            }
            if (!this.m_axisVisibleY) {
                vertAxisWidth = 0;
            }
            int mainWidth = size.width - vertAxisWidth - scrollWidth - vertColorWidth;
            int mainHeight = size.height - horzAxisHeight - scrollHeight - horzColorHeight;
            if (mainWidth < 10 || mainHeight < 10) {
                return;
            }
            int mainLeft = vertAxisWidth;
            int mainTop = horzAxisHeight;
            int vertScrollLeft = mainLeft + mainWidth;
            int vertColorLeft = vertScrollLeft + scrollWidth;
            int horzScrollTop = mainTop + mainHeight;
            int horzColorTop = horzScrollTop + scrollHeight;
            if (this.m_horizontalColorWidget != null && this.m_colorScaleVisible) {
                this.m_horizontalColorWidget.setBounds(0, horzColorTop, size.width, horzColorHeight);
            }
            if (this.m_verticalColorWidget != null && this.m_colorScaleVisible) {
                this.m_verticalColorWidget.setBounds(vertColorLeft, mainTop, vertColorWidth, mainHeight);
            }
            if (this.m_scrollVisibleX) {
                this.m_scrollX.setBounds(mainLeft, horzScrollTop, mainWidth, scrollHeight);
            }
            if (this.m_scrollVisibleY) {
                this.m_scrollY.setBounds(vertScrollLeft, mainTop, scrollWidth, mainHeight);
            }
            if (this.m_axisVisibleX) {
                this.m_axisX.setBounds(mainLeft, 0, mainWidth, horzAxisHeight);
            }
            if (this.m_axisVisibleY) {
                this.m_axisY.setBounds(0, mainTop, vertAxisWidth, mainHeight);
            }
            if (this.m_btnLock.isVisible()) {
                this.m_btnLock.setBounds(0, 0, vertAxisWidth, horzAxisHeight);
            } else {
                this.m_isRangeLocked = false;
                this.m_btnLock.setIcon(this.m_unlockedIcon);
                this.m_mainWidget.transform().unlockCurrentViewport();
            }
            this.m_mainWidget.setBounds(mainLeft, mainTop, mainWidth, mainHeight);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleScrollBar(Java2D_ScrollBar sender, int orientation, double min, double max) {
        try {
            if (sender == this.m_scrollX) {
                this.m_mainWidget.transform().setDesiredWorldX(min, max);
                this.m_mainWidget.forceImageRepaint();
                this.m_mainWidget.repaint();
            }
            if (sender == this.m_scrollY) {
                this.m_mainWidget.transform().setDesiredWorldY(min, max);
                this.m_mainWidget.forceImageRepaint();
                this.m_mainWidget.repaint();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void horizontalColorMapCompositeChanged(Object sender) {
        try {
            this.m_mainWidget.forceImageRepaint();
            this.m_mainWidget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void verticalColorMapCompositeChanged(Object sender) {
        try {
            this.m_mainWidget.forceImageRepaint();
            this.m_mainWidget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            this.m_axisX.setRange(this.m_mainWidget.transform().actualLeft(), this.m_mainWidget.transform().actualRight());
            this.m_axisY.setRange(this.m_mainWidget.transform().actualTop(), this.m_mainWidget.transform().actualBottom());
            if (this.m_horizontalColorWidget != null) {
                this.m_horizontalColorWidget.repaintScale();
            }
            if (this.m_verticalColorWidget != null) {
                this.m_verticalColorWidget.repaintScale();
            }
            this.m_scrollY.Technique = this.m_mainWidget.transform().technique();
            this.m_scrollX.Technique = this.m_mainWidget.transform().technique();
            this.m_scrollY.setValues(this.m_mainWidget.rangeY().rangeMin(), this.m_mainWidget.rangeY().rangeMax(), this.m_mainWidget.transform().actualMinY(), this.m_mainWidget.transform().actualMaxY());
            this.m_scrollX.setValues(this.m_mainWidget.rangeX().rangeMin(), this.m_mainWidget.rangeX().rangeMax(), this.m_mainWidget.transform().actualLeft(), this.m_mainWidget.transform().actualRight());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.manualWidgetLayout();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

