/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.lang.ref.WeakReference;
import javax.swing.JScrollBar;

public class Java2D_ScrollBar
extends JScrollBar
implements AdjustmentListener {
    protected int m_direction;
    public boolean m_bIgnore = true;
    protected double m_rangeMin = 0.0;
    protected double m_rangeMax = 110.0;
    protected double m_viewMin = 0.0;
    protected double m_viewMax = 110.0;
    protected double m_alpha = 1.0;
    protected double m_beta = 1.0;
    public Java2D_Transform.Technique Technique = Java2D_Transform.Technique.Normal;
    protected WeakReference<Listener> m_listener;

    public Java2D_ScrollBar(int dir, Listener listener) {
        super(dir);
        try {
            if (listener != null) {
                this.m_listener = new WeakReference<Listener>(listener);
            }
            this.addAdjustmentListener(this);
            this.setEnabled(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        try {
            if (this.m_bIgnore) {
                return;
            }
            double extent = this.getVisibleAmount();
            if (extent > 9998.0) {
                this.unzoom();
                return;
            }
            if (this.getOrientation() == 0 || this.Technique == Java2D_Transform.Technique.Inverted) {
                Listener l;
                double min = ((double)this.getValue() - this.m_beta) / this.m_alpha;
                double max = min + (this.m_viewMax - this.m_viewMin);
                if (this.m_listener != null && (l = (Listener)this.m_listener.get()) != null) {
                    l.handleScrollBar(this, this.getOrientation(), min, max);
                }
            } else {
                Listener l;
                double max = ((double)this.getValue() - this.m_beta) / this.m_alpha;
                double min = max - (this.m_viewMax - this.m_viewMin);
                if (this.m_listener != null && (l = (Listener)this.m_listener.get()) != null) {
                    l.handleScrollBar(this, this.getOrientation(), min, max);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void unzoom() {
        try {
            this.m_bIgnore = true;
            this.setValues(0, 10000, 0, 10000);
            this.setEnabled(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setValues(double rangeMin, double rangeMax, double viewMin, double viewMax) {
        try {
            this.m_bIgnore = true;
            rangeMin = Math.min(viewMin, rangeMin);
            rangeMax = Math.max(viewMax, rangeMax);
            this.m_rangeMin = rangeMin;
            this.m_rangeMax = rangeMax;
            this.m_viewMin = viewMin;
            this.m_viewMax = viewMax;
            if (Math.abs(viewMax - viewMin) >= 0.999 * Math.abs(rangeMax - rangeMin)) {
                this.unzoom();
                return;
            }
            if (0 == this.getOrientation()) {
                this.prepX();
            } else if (this.Technique == Java2D_Transform.Technique.Inverted) {
                this.prepY_Inverted();
            } else {
                this.prepY_Normal();
            }
            this.m_bIgnore = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.setEnabled(false);
        }
    }

    protected void prepY_Inverted() {
        try {
            this.m_bIgnore = true;
            double extent = 10000.0 * (this.m_viewMax - this.m_viewMin) / (this.m_rangeMax - this.m_rangeMin);
            if (extent > 9999.5) {
                this.unzoom();
                return;
            }
            this.m_alpha = (10000.0 - extent) / (this.m_rangeMax - this.m_rangeMin - (this.m_viewMax - this.m_viewMin));
            this.m_beta = 0.0 - this.m_alpha * this.m_rangeMin;
            double value = this.m_alpha * this.m_viewMin + this.m_beta;
            this.setValues((int)value, (int)extent, 0, 10000);
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            this.m_bIgnore = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.setEnabled(false);
        }
    }

    protected void prepY_Normal() {
        try {
            this.m_bIgnore = true;
            double extent = 10000.0 * Math.abs(this.m_viewMax - this.m_viewMin) / Math.abs(this.m_rangeMax - this.m_rangeMin);
            if (extent > 9999.5) {
                this.unzoom();
                return;
            }
            this.m_alpha = -(10000.0 - extent) / (this.m_rangeMax - this.m_rangeMin - (this.m_viewMax - this.m_viewMin));
            this.m_beta = 0.0 - this.m_alpha * this.m_rangeMax;
            double value = this.m_alpha * this.m_viewMax + this.m_beta;
            this.setValues((int)value, (int)extent, 0, 10000);
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            this.m_bIgnore = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.setEnabled(false);
        }
    }

    protected void prepX() {
        try {
            this.m_bIgnore = true;
            double extent = 10000.0 * (this.m_viewMax - this.m_viewMin) / (this.m_rangeMax - this.m_rangeMin);
            if (extent > 9999.5) {
                this.unzoom();
                return;
            }
            this.m_alpha = (10000.0 - extent) / (this.m_rangeMax - this.m_rangeMin - (this.m_viewMax - this.m_viewMin));
            this.m_beta = 0.0 - this.m_alpha * this.m_rangeMin;
            double value = this.m_alpha * this.m_viewMin + this.m_beta;
            this.setValues((int)value, (int)extent, 0, 10000);
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            this.m_bIgnore = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.setEnabled(false);
        }
    }

    public static interface Listener {
        public void handleScrollBar(Java2D_ScrollBar var1, int var2, double var3, double var5);
    }
}

