/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JComponent;

public class Java2D_ColorArrayWrapper {
    protected Color[] m_array = null;
    public int[] m_histogram = null;
    protected WeakReference<JComponent> m_owningPanel;
    protected double m_colorScaleMinimum = 0.0;
    protected double m_colorScaleMaximum = 90.0;
    protected double m_transform = 1.0;
    protected boolean m_bRangeLocked = false;
    protected ArrayList<DeadZone> m_deadList = new ArrayList();
    protected boolean m_deadDirty = true;

    public Java2D_ColorArrayWrapper(int colorCount) {
        try {
            this.setColorCount(colorCount);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearHistogram() {
        try {
            if (this.m_histogram == null) {
                this.m_histogram = new int[this.m_array.length];
            }
            if (this.m_histogram.length != this.m_array.length) {
                this.m_histogram = new int[this.m_array.length];
            }
            for (int n = 0; n < this.m_histogram.length; ++n) {
                this.m_histogram[n] = 0;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int maxHistogram() {
        try {
            if (this.m_histogram == null) {
                return 0;
            }
            int max = 0;
            for (int n = 0; n < this.m_histogram.length; ++n) {
                max = Math.max(max, this.m_histogram[n]);
            }
            return max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public int histogram(int n) {
        try {
            if (this.m_histogram == null) {
                return 0;
            }
            return this.m_histogram[n];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public void repaintOwner() {
        try {
            JComponent panel;
            if (this.m_owningPanel != null && (panel = (JComponent)this.m_owningPanel.get()) != null) {
                panel.repaint();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setOwningComponent(JComponent owner) {
        try {
            this.m_owningPanel = owner != null ? new WeakReference<JComponent>(owner) : null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setThreeColors(Color c1, Color c2, Color c3) {
        try {
            int num = this.colorCount();
            this.setColor(0, c1);
            this.setColor(num / 2, c2);
            this.setColor(num - 1, c3);
            this.interpolateColors(0, num / 2);
            this.interpolateColors(num / 2, num - 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setRangeLocked(boolean bLocked) {
        try {
            this.m_deadDirty = true;
            this.m_bRangeLocked = bLocked;
            if (!this.m_bRangeLocked) {
                this.m_transform = (double)this.m_array.length / (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean valueOK(double v) {
        try {
            if (v < this.m_colorScaleMinimum || v > this.m_colorScaleMaximum) {
                return false;
            }
            if (this.m_deadDirty) {
                this.m_deadDirty = false;
                for (DeadZone z : this.m_deadList) {
                    z.Minimum = this.m_colorScaleMinimum + z.Fraction1 * (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
                    z.Maximum = this.m_colorScaleMinimum + z.Fraction2 * (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
                }
            }
            for (DeadZone z : this.m_deadList) {
                if (!(v > z.Minimum) || !(v < z.Maximum)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean inside(double v) {
        try {
            return v >= this.m_colorScaleMinimum && v <= this.m_colorScaleMaximum;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public double rangeMin() {
        return this.m_colorScaleMinimum;
    }

    public double rangeMax() {
        return this.m_colorScaleMaximum;
    }

    public void setColorScaleRange(double min, double max) {
        try {
            this.m_deadDirty = true;
            if (this.m_bRangeLocked) {
                return;
            }
            this.m_colorScaleMinimum = min;
            this.m_colorScaleMaximum = Math.max(max, min + 0.001);
            this.m_transform = (double)this.m_array.length / (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
            this.repaintOwner();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public ArrayList<DeadZone> deadZone() {
        return this.m_deadList;
    }

    public void clearDead() {
        this.m_deadList.clear();
        this.m_deadDirty = true;
    }

    public void addDeadZone(double f1, double f2) {
        try {
            DeadZone z = new DeadZone();
            z.Fraction1 = Math.max(f1, -0.01);
            z.Fraction2 = Math.min(f2, 1.01);
            if (z.Fraction2 <= z.Fraction1) {
                return;
            }
            this.m_deadList.add(z);
            this.m_deadDirty = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Color colorUsingValue(double v) {
        try {
            int index = (int)(this.m_transform * (v - this.m_colorScaleMinimum));
            index = Math.max(0, index);
            int n = index = Math.min(this.m_array.length - 1, index);
            this.m_histogram[n] = this.m_histogram[n] + 1;
            return this.m_array[index];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return Color.BLACK;
        }
    }

    public int colorCount() {
        return this.m_array.length;
    }

    public Color colorAtIndex(int index) {
        return this.m_array[index];
    }

    public void setColor(int index, Color c) {
        try {
            if (index >= 0 && index < this.colorCount() && c != null) {
                this.m_array[index] = c;
            }
            this.repaintOwner();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setColorCount(int numColors) {
        try {
            numColors = Math.max(10, numColors);
            numColors = Math.min(256, numColors);
            this.m_array = new Color[numColors];
            this.makeColors(Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED);
            this.clearHistogram();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeBrewer() {
        try {
            this.setColorCount(256);
            this.setColor(0, new Color(53, 0, 53));
            this.setColor(64, new Color(0, 72, 255));
            this.setColor(128, new Color(0, 166, 0));
            this.setColor(192, new Color(255, 166, 0));
            this.setColor(255, new Color(255, 217, 217));
            this.interpolateColors(0, 64);
            this.interpolateColors(64, 128);
            this.interpolateColors(128, 192);
            this.interpolateColors(192, 255);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeGrayCyanYellow() {
        try {
            this.makeColors(Color.LIGHT_GRAY, Color.CYAN, Color.YELLOW);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeWGRY() {
        try {
            this.makeColors(Color.WHITE, Color.GRAY, Color.RED, Color.YELLOW);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeHeat() {
        try {
            this.makeColors(Color.BLACK, Color.BLUE, Color.RED, Color.YELLOW);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeDefault() {
        try {
            this.makeColors(Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeGrey() {
        try {
            Color c1 = new Color(230, 230, 230);
            Color c2 = new Color(180, 180, 180);
            Color c3 = new Color(150, 150, 150);
            Color c4 = new Color(120, 120, 120);
            this.makeColors(c1, c2, c3, c4);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeAnis() {
        try {
            int numColors = this.m_array.length;
            this.setColor(0, Color.RED);
            this.setColor(numColors / 3, Color.GREEN);
            this.setColor(2 * numColors / 3, Color.BLUE);
            this.setColor(numColors - 1, Color.RED);
            this.interpolateColors(0, numColors / 3);
            this.interpolateColors(numColors / 3, 2 * numColors / 3);
            this.interpolateColors(2 * numColors / 3, numColors - 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeRWB() {
        try {
            int numColors = this.m_array.length;
            this.setColor(0, Color.RED);
            this.setColor(numColors / 2, Color.WHITE);
            this.setColor(numColors - 1, Color.BLUE);
            this.interpolateColors(0, numColors / 2);
            this.interpolateColors(numColors / 2, numColors - 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeBFC() {
        try {
            int numColors = this.m_array.length;
            int frac = numColors / 5;
            int index1 = 0;
            int index2 = index1 + frac;
            int index3 = index2 + frac;
            int index4 = index3 + frac;
            int index5 = index4 + frac;
            int index6 = numColors - 1;
            this.m_array[index1] = new Color(255, 0, 255);
            this.m_array[index2] = new Color(0, 0, 255);
            this.m_array[index3] = new Color(0, 255, 255);
            this.m_array[index4] = new Color(0, 255, 0);
            this.m_array[index5] = new Color(255, 255, 0);
            this.m_array[index6] = new Color(255, 0, 0);
            this.interpolateColors(index1, index2);
            this.interpolateColors(index2, index3);
            this.interpolateColors(index3, index4);
            this.interpolateColors(index4, index5);
            this.interpolateColors(index5, index6);
            this.repaintOwner();
            if (!this.m_bRangeLocked) {
                this.m_transform = (double)this.m_array.length / (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeColors(Color c0, Color c1, Color c2) {
        try {
            int numColors = this.m_array.length;
            int half = numColors / 2;
            this.m_array[0] = c0;
            this.m_array[half] = c1;
            this.m_array[numColors - 1] = c2;
            this.interpolateColors(0, half);
            this.interpolateColors(half, numColors - 1);
            this.repaintOwner();
            if (!this.m_bRangeLocked) {
                this.m_transform = (double)this.m_array.length / (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeColors(Color c0, Color c1, Color c2, Color c3) {
        try {
            int numColors = this.m_array.length;
            int third = numColors / 3;
            this.m_array[0] = c0;
            this.m_array[third] = c1;
            this.m_array[2 * third] = c2;
            this.m_array[numColors - 1] = c3;
            this.interpolateColors(0, third);
            this.interpolateColors(third, 2 * third);
            this.interpolateColors(2 * third, numColors - 1);
            this.repaintOwner();
            if (!this.m_bRangeLocked) {
                this.m_transform = (double)this.m_array.length / (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeRainbowRev() {
        try {
            Color c1 = new Color(139, 0, 255);
            Color c2 = new Color(75, 0, 130);
            Color c3 = new Color(0, 0, 255);
            Color c4 = new Color(0, 255, 0);
            Color c5 = new Color(255, 255, 0);
            Color c6 = new Color(255, 127, 0);
            Color c7 = new Color(255, 0, 0);
            this.makeColors(c1, c2, c3, c4, c5, c6, c7);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeColors(Color c0, Color c1, Color c2, Color c3, Color c4, Color c5, Color c6) {
        try {
            int numColors = this.m_array.length;
            int sixth = numColors / 6;
            this.m_array[0] = c0;
            this.m_array[sixth] = c1;
            this.m_array[2 * sixth] = c2;
            this.m_array[3 * sixth] = c3;
            this.m_array[4 * sixth] = c4;
            this.m_array[5 * sixth] = c5;
            this.m_array[numColors - 1] = c6;
            this.interpolateColors(0, sixth);
            this.interpolateColors(sixth, 2 * sixth);
            this.interpolateColors(2 * sixth, 3 * sixth);
            this.interpolateColors(3 * sixth, 4 * sixth);
            this.interpolateColors(4 * sixth, 5 * sixth);
            this.interpolateColors(5 * sixth, numColors - 1);
            this.repaintOwner();
            if (!this.m_bRangeLocked) {
                this.m_transform = (double)this.m_array.length / (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeColors(Color c0, Color c1, Color c2, Color c3, Color c4, Color c5) {
        try {
            int numColors = this.m_array.length;
            int fifth = numColors / 5;
            this.m_array[0] = c0;
            this.m_array[fifth] = c1;
            this.m_array[2 * fifth] = c2;
            this.m_array[3 * fifth] = c3;
            this.m_array[4 * fifth] = c4;
            this.m_array[numColors - 1] = c5;
            this.interpolateColors(0, fifth);
            this.interpolateColors(fifth, 2 * fifth);
            this.interpolateColors(2 * fifth, 3 * fifth);
            this.interpolateColors(3 * fifth, 4 * fifth);
            this.interpolateColors(4 * fifth, numColors - 1);
            this.repaintOwner();
            if (!this.m_bRangeLocked) {
                this.m_transform = (double)this.m_array.length / (this.m_colorScaleMaximum - this.m_colorScaleMinimum);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolateColors(int i1, int i2) {
        try {
            i1 = Math.max(0, i1);
            i2 = Math.min(i2, this.m_array.length - 1);
            if (i2 <= i1 + 1) {
                return;
            }
            float r1 = 0.5f + (float)this.m_array[i1].getRed();
            float g1 = 0.5f + (float)this.m_array[i1].getGreen();
            float b1 = 0.5f + (float)this.m_array[i1].getBlue();
            float r2 = 0.5f + (float)this.m_array[i2].getRed();
            float g2 = 0.5f + (float)this.m_array[i2].getGreen();
            float b2 = 0.5f + (float)this.m_array[i2].getBlue();
            float ra = (r2 - r1) / (float)(i2 - i1);
            float rb = r1 - ra * (float)i1;
            float ga = (g2 - g1) / (float)(i2 - i1);
            float gb = g1 - ga * (float)i1;
            float ba = (b2 - b1) / (float)(i2 - i1);
            float bb = b1 - ba * (float)i1;
            for (int i = i1 + 1; i < i2; ++i) {
                float r = ra * (float)i + rb;
                float g = ga * (float)i + gb;
                float b = ba * (float)i + bb;
                this.m_array[i] = new Color((int)r, (int)g, (int)b);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public class DeadZone {
        public double Fraction1 = 0.0;
        public double Fraction2 = 0.0;
        public double Minimum = 0.0;
        public double Maximum = 0.0;
    }
}

