/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Ensemble;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleHeaderDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleHeaderPlotWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleScrollBar;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Color;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Wiggles;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_RangeExpander;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Rectangle;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Java2D_VertStackedEnsembleDisplayWidget
extends JPanel
implements ComponentListener,
Java2D_EnsembleScrollBar.Listener,
Java2D_Widget.Listener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();
    public int HeaderTextRowCount = 2;
    protected ArrayList<Wrapper> m_list = new ArrayList();
    protected Java2D_EnsembleDisplayOptionsWidget m_optionsWidget = null;
    public boolean TimeLinesOnTop = false;
    protected int m_headerPlotHeight = 80;
    protected int m_numVisible = 1;
    public boolean LabelsVisible = false;
    public boolean DrawWiggles = true;
    public boolean DrawColor = false;
    protected Java2D_XAxisWidget m_axisX = new Java2D_XAxisWidget();
    protected boolean m_axisXVisible = true;
    protected Java2D_EnsembleAxisEnum m_axisType = Java2D_EnsembleAxisEnum.UniformSpacing;
    protected String m_axisTable = "Trace";
    protected String m_axisColumn = "Offset";
    protected Java2D_EnsembleScrollBar m_scrollBarHorz;
    protected Range_Double m_rangeX = new Range_Double();
    protected Range_Double m_rangeY = new Range_Double();
    protected Range_Double m_rangeC = new Range_Double();
    protected Java2D_ColorArrayWrapper m_colorArray = new Java2D_ColorArrayWrapper(10);
    protected ParameterTree m_paramTree;
    public boolean ApplyTemporaryLock = false;
    protected double m_zoomTop;
    protected double m_zoomBottom;
    protected double m_zoomLeft;
    protected double m_zoomRight;

    public void addListener(Listener listener) {
        try {
            if (listener != null) {
                this.m_listeners.add(new WeakReference<Listener>(listener));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_Transform transform(int index) {
        try {
            return this.m_list.get((int)index).Transform;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void setStackSelectedMode(boolean stackSelectedMode) {
        try {
            for (Wrapper w : this.m_list) {
                for (Java2D_EnsembleHeaderPlotWidget p : w.HeaderPlotList) {
                    p.StackSelectionMode = stackSelectedMode;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHeaderPlotVisibleCount(int index, int visibleCount) {
        try {
            Wrapper w = this.m_list.get(index);
            visibleCount = Math.max(0, visibleCount);
            w.HeaderPlotVisibleCount = visibleCount = Math.min(visibleCount, w.HeaderPlotList.size());
            double percentBuffer = 5.0;
            if (visibleCount >= 2) {
                percentBuffer = 10.0;
            }
            for (int n = 0; n < w.HeaderPlotList.size(); ++n) {
                w.HeaderPlotList.get((int)n).PercentBuffer = percentBuffer;
            }
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHeaderPlotHeader(int index, int plotIndex, String table, String column) {
        try {
            this.m_list.get((int)index).HeaderPlotList.get(plotIndex).setTableColumn(table, column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setUseGrayScale(boolean useGrayScale) {
        try {
            for (Wrapper w : this.m_list) {
                w.ColorPainter.UseGrayScale = useGrayScale;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_VertStackedEnsembleDisplayWidget(int numDisplays) {
        try {
            this.setLayout(null);
            numDisplays = Math.max(numDisplays, 1);
            this.m_numVisible = numDisplays = Math.min(numDisplays, 20);
            for (int n = 0; n < numDisplays; ++n) {
                Wrapper wrapper = new Wrapper();
                wrapper.Main = new Java2D_Widget(this.m_colorArray);
                wrapper.Main.addListener(this);
                wrapper.Transform = wrapper.Main.transform();
                wrapper.ScrollBar = new Java2D_EnsembleScrollBar(1, this);
                wrapper.Zoomer.addListener(this);
                wrapper.TimeLines.DrawHorizontalLines = true;
                wrapper.TimeLines.DrawVerticalLines = false;
                this.add(wrapper.Main);
                this.add(wrapper.AxisTime);
                this.add(wrapper.Label);
                this.add(wrapper.ScrollBar);
                this.add(wrapper.HeaderText);
                for (int p = 0; p < wrapper.HeaderPlotList.size(); ++p) {
                    this.add(wrapper.HeaderPlotList.get(p));
                }
                this.m_list.add(wrapper);
            }
            this.m_scrollBarHorz = new Java2D_EnsembleScrollBar(0, this);
            this.add(this.m_axisX);
            this.add(this.m_scrollBarHorz);
            this.addComponentListener(this);
            Messenger.singleton().addListener(this);
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setParameterTree(ParameterTree pt) {
        try {
            this.m_paramTree = pt;
            for (int n = 0; n < this.m_list.size(); ++n) {
                Wrapper wrapper = this.m_list.get(n);
                String wrapperRoot = "Wrapper" + Integer.toString(n);
                ParameterTree wpt = this.m_paramTree.ParameterTree_get(wrapperRoot);
                wrapper.HeaderText.setParameterTree(wpt);
                int index = 0;
                for (Java2D_EnsembleHeaderPlotWidget hp : wrapper.HeaderPlotList) {
                    String plotRoot = "Plot" + Integer.toString(index);
                    ParameterTree plotPT = wpt.ParameterTree_get(plotRoot);
                    hp.setParameterTree(plotPT);
                    ++index;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHeaderTableColumn(int plot, int index, String table, String column) {
        try {
            this.m_list.get((int)plot).HeaderText.setTableColumn(index, table, column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setPlotBorder(boolean visible, Color c, int w) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.PaintBorder = visible;
                wrapper.Main.BorderColor = c;
                wrapper.Main.BorderWidth = w;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTimeLineColorAndSpacing(Color c, double spacing) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.TimeLines.HorizontalLineSpacing = spacing;
                wrapper.TimeLines.HorizontalLineColor = c;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected void prepWiggleOptions() {
        try {
            if (this.m_optionsWidget == null) {
                return;
            }
            for (Wrapper wrapper : this.m_list) {
                this.m_optionsWidget.prepPainter(wrapper.WigglePainter);
            }
            this.forcePaintAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTimeAxisColor(int index, Color c) {
        try {
            if (index >= 0 && index < this.m_list.size()) {
                this.m_list.get((int)index).AxisTime.setBackColor(c);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsembleDisplayOptionsWidget(Java2D_EnsembleDisplayOptionsWidget w) {
        try {
            this.m_optionsWidget = w;
            this.m_optionsWidget.listener().addListener(this);
            this.prepWiggleOptions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearUserEventConsumerList() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.clearEventConsumerList();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearUserEventConsumerList(int index) {
        try {
            this.m_list.get((int)index).Main.clearEventConsumerList();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addZoomer() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.addEventConsumer(wrapper.Zoomer);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addEventConsumer(int index, Java2D_UserEventConsumerBase eventConsumer) {
        try {
            this.m_list.get((int)index).Main.addEventConsumer(eventConsumer);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setVisibleCount(int numVisible) {
        try {
            this.m_numVisible = Math.max(numVisible, 1);
            this.m_numVisible = Math.min(numVisible, this.m_list.size());
            this.placeWidgets();
            this.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearAllOverlays() {
        try {
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).OverlayList.clear();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addOverlayPaintable(int index, Java2D_PaintableInterface paintable) {
        try {
            this.m_list.get((int)index).OverlayList.add(paintable);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearAndLoadWigglePaintables() {
        try {
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).Main.clearPaintableList();
                if (!this.TimeLinesOnTop) {
                    this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).TimeLines, -1);
                }
                this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).RangeExpander, -9999);
                if (this.DrawWiggles && this.m_list.get((int)n).WigglePainter.ensemble() != null) {
                    this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).WigglePainter, -9999);
                }
                if (this.DrawColor && this.m_list.get((int)n).ColorPainter.ensemble() != null) {
                    this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).ColorPainter, -9999);
                }
                for (Java2D_PaintableInterface paintable : this.m_list.get((int)n).OverlayList) {
                    this.m_list.get((int)n).Main.addPaintable(paintable, -9999);
                }
                if (!this.TimeLinesOnTop) continue;
                this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).TimeLines, -1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void unzoom() {
        try {
            boolean unzoomScrollBars = true;
            if (!this.ApplyTemporaryLock) {
                int n;
                unzoomScrollBars = true;
                this.m_rangeX.clearRange();
                this.m_rangeY.clearRange();
                for (n = 0; n < this.m_numVisible; ++n) {
                    this.m_list.get((int)n).Main.recomputeAllRanges();
                    this.m_rangeX.expandRange(this.m_list.get((int)n).Main.rangeX());
                    this.m_rangeY.expandRange(this.m_list.get((int)n).Main.rangeY());
                }
                if (!this.m_rangeY.rangeValid() || !this.m_rangeX.rangeValid()) {
                    for (n = 0; n < this.m_numVisible; ++n) {
                        this.m_list.get((int)n).Main.repaint();
                    }
                    this.prepareScrollBars(true);
                    return;
                }
                this.m_rangeY.addPercentBuffer(1.0);
                this.m_rangeX.addPercentBuffer(2.0);
                for (n = 0; n < this.m_numVisible; ++n) {
                    this.m_list.get((int)n).Transform.setTechnique(Java2D_Transform.Technique.Inverted);
                    this.m_list.get((int)n).Transform.setDesiredWorldX(this.m_rangeX.rangeMin(), this.m_rangeX.rangeMax());
                    this.m_list.get((int)n).Transform.setDesiredWorldY(this.m_rangeY.rangeMin(), this.m_rangeY.rangeMax());
                    this.m_list.get((int)n).Transform.computeTransform();
                    this.m_list.get((int)n).Main.repaint();
                }
            } else {
                unzoomScrollBars = false;
                this.ApplyTemporaryLock = false;
                for (int n = 0; n < this.m_numVisible; ++n) {
                    this.m_list.get((int)n).Transform.computeTransform();
                    this.m_list.get((int)n).Main.repaint();
                }
            }
            this.prepareScrollBars(unzoomScrollBars);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisTableColumn(String table, String column) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.WigglePainter.setAxisTableColumn(table, column);
            }
            this.m_axisX.setTitle(table + " - " + column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisType(Java2D_EnsembleAxisEnum axisType) {
        try {
            this.m_axisType = axisType;
            for (Wrapper wrapper : this.m_list) {
                wrapper.WigglePainter.setAxisType(axisType);
            }
            this.placeWidgets();
            this.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisLocked_Time(boolean locked, double min, double max) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Transform.setAxisLockedY(locked, min, max);
            }
            this.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisLocked_X(boolean locked, double min, double max) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Transform.setAxisLockedX(locked, min, max);
            }
            this.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setBackground(int index, boolean plotBack, String key) {
        try {
            this.m_list.get((int)index).WigglePainter.BackgroundColorKey = key;
            this.m_list.get((int)index).WigglePainter.PlotBackgroundColor = plotBack;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsemble(int index, Ensemble ensemble) {
        try {
            this.m_list.get(index).setEnsemble(ensemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearRangeExpander() {
        try {
            for (Wrapper w : this.m_list) {
                w.RangeExpander.ApplyX = false;
                w.RangeExpander.ApplyY = false;
                w.RangeExpander.ApplyC = false;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setRangeExpander(int index, boolean applyX, double minX, double maxX, boolean applyY, double minY, double maxY) {
        try {
            this.m_list.get((int)index).RangeExpander.ApplyY = applyY;
            this.m_list.get((int)index).RangeExpander.MinY = minY;
            this.m_list.get((int)index).RangeExpander.MaxY = maxY;
            this.m_list.get((int)index).RangeExpander.ApplyX = applyX;
            this.m_list.get((int)index).RangeExpander.MinX = minX;
            this.m_list.get((int)index).RangeExpander.MaxX = maxX;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearHeaderPlotLockInfo(int plotIndex, int headerIndex) {
        try {
            this.m_list.get((int)plotIndex).HeaderPlotList.get(headerIndex).clearLockInfo();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setLockedRangeAndTableColumn(int plotIndex, int headerIndex, double min, double max, String lockTable, String lockColumn) {
        try {
            this.m_list.get((int)plotIndex).HeaderPlotList.get(headerIndex).setLockedRangeAndTableColumn(min, max, lockTable, lockColumn);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Ensemble getEnsemble(int index) {
        try {
            return this.m_list.get(index).ensemble();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void addPaintable(int index, Java2D_PaintableInterface paintable, int supplemental) {
        try {
            if (paintable == null) {
                return;
            }
            this.m_list.get((int)index).Main.addPaintable(paintable, supplemental);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleZoomRequest(Java2D_UserEventConsumer_Rectangle zoomer) {
        try {
            if (zoomer.RequestMooz) {
                this.unzoom();
                return;
            }
            this.m_zoomTop = Math.min(zoomer.StartWorldY, zoomer.EndWorldY);
            this.m_zoomBottom = Math.max(zoomer.StartWorldY, zoomer.EndWorldY);
            this.m_zoomLeft = Math.min(zoomer.StartWorldX, zoomer.EndWorldX);
            this.m_zoomRight = Math.max(zoomer.StartWorldX, zoomer.EndWorldX);
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).Transform.setDesiredWorldX(this.m_zoomLeft, this.m_zoomRight);
                this.m_list.get((int)n).Transform.setDesiredWorldY(this.m_zoomTop, this.m_zoomBottom);
                this.m_list.get((int)n).Transform.computeTransform();
                this.m_list.get((int)n).Main.repaint();
            }
            this.prepareScrollBars(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void horz_zoom(double middle, double fraction) {
        try {
            double minx = this.m_list.get((int)0).Transform.actualLeft();
            double maxx = this.m_list.get((int)0).Transform.actualRight();
            middle = Math.max(this.m_rangeX.rangeMin(), middle);
            middle = Math.min(this.m_rangeX.rangeMax(), middle);
            double x1 = middle - fraction * (middle - minx);
            double x2 = x1 + fraction * (maxx - minx);
            minx = x1;
            maxx = x2;
            double range = x2 - x1;
            range = Math.min(range, this.m_rangeX.range());
            if (minx < this.m_rangeX.rangeMin()) {
                minx = this.m_rangeX.rangeMin();
                maxx = minx + range;
            }
            if (maxx > this.m_rangeX.rangeMax()) {
                maxx = this.m_rangeX.rangeMax();
                minx = maxx - range;
            }
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).Transform.setDesiredWorldX(minx, maxx);
                this.m_list.get((int)n).Transform.computeTransform();
                this.m_list.get((int)n).Main.repaint();
            }
            this.prepareScrollBars(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void horz_shift_right(double fraction) {
        try {
            double minx = this.m_list.get((int)0).Transform.actualLeft();
            double maxx = this.m_list.get((int)0).Transform.actualRight();
            double range = maxx - minx;
            minx = (maxx += range * fraction) - range;
            if (minx < this.m_rangeX.rangeMin()) {
                minx = this.m_rangeX.rangeMin();
                maxx = minx + range;
            }
            if (maxx > this.m_rangeX.rangeMax()) {
                maxx = this.m_rangeX.rangeMax();
                minx = maxx - range;
            }
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).Transform.setDesiredWorldX(minx, maxx);
                this.m_list.get((int)n).Transform.computeTransform();
                this.m_list.get((int)n).Main.repaint();
            }
            this.prepareScrollBars(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void horz_shift_left(double fraction) {
        try {
            double minx = this.m_list.get((int)0).Transform.actualLeft();
            double maxx = this.m_list.get((int)0).Transform.actualRight();
            double range = maxx - minx;
            maxx = (minx -= range * fraction) + range;
            if (minx < this.m_rangeX.rangeMin()) {
                minx = this.m_rangeX.rangeMin();
                maxx = minx + range;
            }
            if (maxx > this.m_rangeX.rangeMax()) {
                maxx = this.m_rangeX.rangeMax();
                minx = maxx - range;
            }
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).Transform.setDesiredWorldX(minx, maxx);
                this.m_list.get((int)n).Transform.computeTransform();
                this.m_list.get((int)n).Main.repaint();
            }
            this.prepareScrollBars(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepareScrollBars(boolean unzoomed) {
        try {
            boolean enabled;
            Java2D_Transform transform = this.m_list.get((int)0).Transform;
            boolean rangeOK = this.m_rangeX.rangeValid() && this.m_rangeY.rangeValid();
            boolean bl = enabled = rangeOK && !unzoomed && transform.transformValid();
            if (unzoomed || !enabled) {
                this.m_scrollBarHorz.unzoom();
                for (Wrapper wrapper : this.m_list) {
                    wrapper.ScrollBar.unzoom();
                }
                return;
            }
            this.m_scrollBarHorz.setValues(this.m_rangeX.rangeMin(), this.m_rangeX.rangeMax(), transform.actualLeft(), transform.actualRight());
            for (Wrapper wrapper : this.m_list) {
                wrapper.ScrollBar.setValues(this.m_rangeY.rangeMin(), this.m_rangeY.rangeMax(), transform.actualTop(), transform.actualBottom());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_optionsWidget) {
                this.prepWiggleOptions();
                return;
            }
            if (sender instanceof Java2D_UserEventConsumer_Rectangle) {
                Java2D_UserEventConsumer_Rectangle zoomer = (Java2D_UserEventConsumer_Rectangle)sender;
                if (zoomer.Dragging) {
                    return;
                }
                this.handleZoomRequest((Java2D_UserEventConsumer_Rectangle)sender);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (this.m_list.get((int)0).Main == widget) {
                double left = this.m_list.get((int)0).Transform.actualLeft();
                double right = this.m_list.get((int)0).Transform.actualRight();
                this.m_axisX.setRange(left, right);
                this.m_axisX.repaint();
                this.m_axisX.invalidate();
            }
            for (int n = 0; n < this.m_numVisible; ++n) {
                if (this.m_list.get((int)n).Main != widget) continue;
                this.m_list.get(n).repaintAllHeaders();
                double top = this.m_list.get((int)n).Transform.actualTop();
                double bottom = this.m_list.get((int)n).Transform.actualBottom();
                this.m_list.get((int)n).AxisTime.setRange(top, bottom);
                for (WeakReference<Listener> listener : this.m_listeners) {
                    if (listener.get() == null) continue;
                    ((Listener)listener.get()).handleEnsembleWidgetPaintEvent(this, n, imagePainted);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleEnsembleScrollBar(Java2D_EnsembleScrollBar sender, int orientation, double min, double max) {
        try {
            if (orientation == 0) {
                for (Wrapper wrapper : this.m_list) {
                    wrapper.Transform.setDesiredWorldX(min, max);
                    wrapper.Transform.computeTransform();
                    wrapper.Main.setRequireDisplay();
                    wrapper.Main.repaint();
                }
            } else {
                for (Wrapper wrapper : this.m_list) {
                    wrapper.Transform.setDesiredWorldY(min, max);
                    wrapper.Transform.computeTransform();
                    wrapper.Main.setRequireDisplay();
                    wrapper.Main.repaint();
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void forcePaintAll() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.setRequireDisplay();
                wrapper.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void repaintAll() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void placeWidgets() {
        try {
            int width = this.getSize().width;
            int height = this.getSize().height;
            this.m_numVisible = Math.max(1, this.m_numVisible);
            this.m_numVisible = Math.min(this.m_numVisible, this.m_list.size());
            for (int n = 0; n < this.m_list.size(); ++n) {
                this.m_list.get(n).setVisible(n < this.m_numVisible);
            }
            int totalPlotPixels = 0;
            for (int n = 0; n < this.m_numVisible; ++n) {
                int numVis = this.m_list.get((int)n).HeaderPlotVisibleCount;
                if (numVis < 1) continue;
                totalPlotPixels += numVis * this.m_headerPlotHeight;
            }
            int axisHeight = 30;
            int labelHeight = 16;
            int scrollSize = 15;
            int axisWidth = 54;
            int mainWidth = width - axisWidth - scrollSize;
            int buffer = 0;
            if (this.HeaderTextRowCount < 1) {
                buffer = 10;
            }
            if (!this.LabelsVisible) {
                labelHeight = 0;
            }
            if (this.m_axisType == Java2D_EnsembleAxisEnum.UniformSpacing) {
                this.m_axisX.setVisible(false);
                axisHeight = 0;
            } else {
                this.m_axisX.setVisible(true);
            }
            int pixForBuffer = (this.m_numVisible - 1) * buffer;
            int pixelsPerSection = (height - pixForBuffer - axisHeight - scrollSize - totalPlotPixels) / this.m_numVisible;
            int headerHeight = this.HeaderTextRowCount * this.m_list.get((int)0).HeaderText.PixPerRow;
            int mainHeight = pixelsPerSection - labelHeight - headerHeight;
            if (mainHeight < 10 || mainWidth < 10) {
                this.m_axisX.setVisible(false);
                this.m_scrollBarHorz.setVisible(false);
                for (int n = 0; n < this.m_list.size(); ++n) {
                    this.m_list.get(n).setVisible(false);
                }
                return;
            }
            int top = 0;
            if (this.m_axisX.isVisible()) {
                this.m_axisX.setBounds(axisWidth, top, mainWidth, axisHeight);
                top += axisHeight;
            }
            for (int n = 0; n < this.m_numVisible; ++n) {
                if (n >= 1) {
                    top += buffer;
                }
                this.m_list.get((int)n).Label.setVisible(this.LabelsVisible);
                if (this.LabelsVisible) {
                    this.m_list.get((int)n).Label.setBounds(axisWidth, top, mainWidth, labelHeight);
                    top += labelHeight;
                }
                int headerWidth = axisWidth + mainWidth;
                if (this.HeaderTextRowCount > 0) {
                    this.m_list.get((int)n).HeaderText.setBounds(0, top, headerWidth, headerHeight);
                    this.m_list.get((int)n).HeaderText.StartX = axisWidth;
                    this.m_list.get((int)n).HeaderText.invalidate();
                    this.m_list.get((int)n).HeaderText.repaint();
                } else {
                    this.m_list.get((int)n).HeaderText.setVisible(false);
                }
                top += headerHeight;
                int numPlotVis = this.m_list.get((int)n).HeaderPlotVisibleCount;
                for (int p = 0; p < numPlotVis; ++p) {
                    this.m_list.get((int)n).HeaderPlotList.get(p).setBounds(0, top, headerWidth, this.m_headerPlotHeight);
                    this.m_list.get((int)n).HeaderPlotList.get((int)p).StartX = axisWidth;
                    this.m_list.get((int)n).HeaderPlotList.get(p).invalidate();
                    this.m_list.get((int)n).HeaderPlotList.get(p).repaint();
                    top += this.m_headerPlotHeight;
                }
                int mainTop = top;
                this.m_list.get((int)n).Main.setBounds(axisWidth, top, mainWidth, mainHeight);
                top += mainHeight;
                this.m_list.get((int)n).AxisTime.setBounds(0, mainTop, axisWidth, mainHeight);
                this.m_list.get((int)n).ScrollBar.setBounds(width - scrollSize, mainTop, scrollSize, mainHeight);
                this.m_list.get((int)n).ScrollBar.invalidate();
                this.m_list.get((int)n).ScrollBar.repaint();
            }
            this.m_scrollBarHorz.setBounds(axisWidth, top, mainWidth, scrollSize);
            this.m_scrollBarHorz.setVisible(true);
            this.m_scrollBarHorz.repaint();
            this.m_scrollBarHorz.invalidate();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void lockViewports() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.transform().lockCurrentViewport();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void unlockViewports() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.transform().unlockCurrentViewport();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public class Wrapper {
        public Java2D_Widget Main;
        public Java2D_YAxisWidget AxisTime = new Java2D_YAxisWidget();
        public Java2D_EnsembleScrollBar ScrollBar;
        public Java2D_Transform Transform;
        public Java2D_EnsembleHeaderDisplayWidget HeaderText = new Java2D_EnsembleHeaderDisplayWidget();
        public ArrayList<Java2D_EnsembleHeaderPlotWidget> HeaderPlotList = new ArrayList();
        public int HeaderPlotVisibleCount = 1;
        public JLabel Label = new JLabel("Ensemble description", 0);
        public Java2D_UserEventConsumer_Rectangle Zoomer = new Java2D_UserEventConsumer_Rectangle();
        public int Top = 0;
        public int Bottom = 0;
        public int Height = 0;
        public Java2D_Paintable_Ensemble_Wiggles WigglePainter = new Java2D_Paintable_Ensemble_Wiggles();
        public Java2D_Paintable_Ensemble_Color ColorPainter = new Java2D_Paintable_Ensemble_Color();
        public Java2D_Paintable_RangeExpander RangeExpander = new Java2D_Paintable_RangeExpander();
        public ArrayList<Java2D_PaintableInterface> OverlayList = new ArrayList();
        public Java2D_Paintable_AxisLines TimeLines = new Java2D_Paintable_AxisLines();
        protected Ensemble m_ensemble;

        public Wrapper() {
            try {
                for (int n = 0; n < 4; ++n) {
                    Java2D_EnsembleHeaderPlotWidget headerPlot = new Java2D_EnsembleHeaderPlotWidget();
                    this.HeaderPlotList.add(headerPlot);
                    if (n % 2 != 1) continue;
                    headerPlot.DotColor = Color.RED;
                    headerPlot.BackgroundColor = new Color(240, 255, 255);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setEnsemble(Ensemble ensemble) {
            try {
                this.m_ensemble = ensemble;
                for (int n = 0; n < this.HeaderPlotList.size(); ++n) {
                    this.HeaderPlotList.get(n).setEnsemble(ensemble);
                }
                this.HeaderText.setEnsemble(ensemble);
                this.WigglePainter.setEnsemble(ensemble);
                this.ColorPainter.setEnsemble(ensemble);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public Ensemble ensemble() {
            return this.m_ensemble;
        }

        public void repaintAllHeaders() {
            try {
                for (int n = 0; n < this.HeaderPlotList.size(); ++n) {
                    this.HeaderPlotList.get(n).repaint();
                    this.HeaderPlotList.get(n).invalidate();
                }
                this.HeaderText.repaint();
                this.HeaderText.invalidate();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setVisible(boolean visible) {
            this.Main.setVisible(visible);
            this.Label.setVisible(visible);
            this.HeaderText.setVisible(visible && Java2D_VertStackedEnsembleDisplayWidget.this.HeaderTextRowCount >= 1);
            this.ScrollBar.setVisible(visible);
            this.AxisTime.setVisible(visible);
            for (Java2D_EnsembleHeaderPlotWidget headerPlot : this.HeaderPlotList) {
                for (int n = 0; n < this.HeaderPlotList.size(); ++n) {
                    this.HeaderPlotList.get(n).setVisible(visible && n < this.HeaderPlotVisibleCount);
                }
            }
        }
    }

    public static interface Listener {
        public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget var1, int var2, boolean var3);
    }
}

