/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Ensemble;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleHeaderDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleHeaderPlotWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleScrollBar;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Color;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Wiggles;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Rectangle;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Java2D_HorzStackedEnsembleDisplayWidget
extends JPanel
implements ComponentListener,
Java2D_EnsembleScrollBar.Listener,
Java2D_Widget.Listener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();
    protected boolean m_externalComponentVisible = false;
    protected int m_externalComponentHeight = 24;
    protected boolean m_horzAxisVisible = true;
    protected boolean m_headerPlotVisible = true;
    protected boolean m_headerTextVisible = true;
    protected int m_headerTextCount = 2;
    protected boolean m_labelsVisible = true;
    protected ArrayList<Wrapper> m_list = new ArrayList();
    protected Java2D_EnsembleDisplayOptionsWidget m_optionsWidget = null;
    public boolean TimeLinesOnTop = false;
    protected int m_numVisible = 1;
    public boolean DrawWiggles = true;
    public boolean DrawColor = false;
    protected Java2D_YAxisWidget m_axisY = new Java2D_YAxisWidget();
    protected boolean m_axisYVisible = true;
    protected Java2D_EnsembleScrollBar m_scrollBarVert;
    protected Range_Double m_rangeY = new Range_Double();
    protected Java2D_ColorArrayWrapper m_colorArray = new Java2D_ColorArrayWrapper(10);

    public void addListener(Listener listener) {
        try {
            if (listener != null) {
                this.m_listeners.add(new WeakReference<Listener>(listener));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHeaderTextCount(int headerTextCount) {
        try {
            this.m_headerTextCount = Math.max(headerTextCount, 1);
            this.m_headerTextCount = Math.min(headerTextCount, 10);
            for (Wrapper w : this.m_list) {
                w.HeaderText.setNumRows(this.m_headerTextCount);
            }
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setExternalComponentHeight(int externalComponentHeight) {
        try {
            this.m_externalComponentHeight = Math.max(20, externalComponentHeight);
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setExternalComponentVisible(boolean externalComponentVisible) {
        try {
            this.m_externalComponentVisible = externalComponentVisible;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHeaderPlotVisible(boolean headerPlotVisible) {
        try {
            this.m_headerPlotVisible = headerPlotVisible;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setLabelsVisible(boolean labelsVisible) {
        try {
            this.m_labelsVisible = labelsVisible;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHeaderTextVisible(boolean headerTextVisible) {
        try {
            this.m_headerTextVisible = headerTextVisible;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHorzAxisVisible(boolean horzAxisVisible) {
        try {
            this.m_horzAxisVisible = horzAxisVisible;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_HorzStackedEnsembleDisplayWidget(int numDisplays) {
        try {
            this.setLayout(null);
            numDisplays = Math.max(numDisplays, 1);
            this.m_numVisible = numDisplays = Math.min(numDisplays, 20);
            for (int n = 0; n < numDisplays; ++n) {
                Wrapper wrapper = new Wrapper();
                wrapper.Main = new Java2D_Widget(this.m_colorArray);
                wrapper.Main.addListener(this);
                wrapper.Transform = wrapper.Main.transform();
                wrapper.ScrollBar = new Java2D_EnsembleScrollBar(0, this);
                wrapper.Zoomer.addListener(this);
                wrapper.TimeLines.DrawHorizontalLines = true;
                wrapper.TimeLines.DrawVerticalLines = false;
                this.add(wrapper.Main);
                this.add(wrapper.Axis);
                this.add(wrapper.Label);
                this.add(wrapper.ScrollBar);
                this.add(wrapper.HeaderText);
                this.add(wrapper.HeaderPlot);
                this.m_list.add(wrapper);
            }
            this.m_scrollBarVert = new Java2D_EnsembleScrollBar(1, this);
            this.add(this.m_axisY);
            this.add(this.m_scrollBarVert);
            this.addComponentListener(this);
            Messenger.singleton().addListener(this);
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setLabelText(int index, String s) {
        try {
            this.m_list.get((int)index).Label.setText(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setExternalComponent(int index, JComponent externalComponent) {
        try {
            this.m_list.get((int)index).ExternalComponent = externalComponent;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setPlotBorder(boolean visible, Color c, int w) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.PaintBorder = visible;
                wrapper.Main.BorderColor = c;
                wrapper.Main.BorderWidth = w;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTimeLineColorAndSpacing(Color c, double spacing) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.TimeLines.HorizontalLineSpacing = spacing;
                wrapper.TimeLines.HorizontalLineColor = c;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected void prepWiggleOptions() {
        try {
            if (this.m_optionsWidget == null) {
                return;
            }
            for (Wrapper wrapper : this.m_list) {
                this.m_optionsWidget.prepPainter(wrapper.WigglePainter);
            }
            this.forcePaintAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsembleDisplayOptionsWidget(Java2D_EnsembleDisplayOptionsWidget w) {
        try {
            this.m_optionsWidget = w;
            this.m_optionsWidget.listener().addListener(this);
            this.prepWiggleOptions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearUserEventConsumerList() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.clearEventConsumerList();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearUserEventConsumerList(int index) {
        try {
            this.m_list.get((int)index).Main.clearEventConsumerList();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addZoomer() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.addEventConsumer(wrapper.Zoomer);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addEventConsumer(int index, Java2D_UserEventConsumerBase eventConsumer) {
        try {
            this.m_list.get((int)index).Main.addEventConsumer(eventConsumer);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setVisibleCount(int numVisible) {
        try {
            this.m_numVisible = Math.max(numVisible, 1);
            this.m_numVisible = Math.min(numVisible, this.m_list.size());
            this.placeWidgets();
            this.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearAndLoadWigglePaintables() {
        try {
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).Main.clearPaintableList();
                if (!this.TimeLinesOnTop) {
                    this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).TimeLines, -1);
                }
                if (this.DrawWiggles && this.m_list.get((int)n).WigglePainter.ensemble() != null) {
                    this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).WigglePainter, -9999);
                }
                if (this.DrawColor && this.m_list.get((int)n).ColorPainter.ensemble() != null) {
                    this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).ColorPainter, -9999);
                }
                if (!this.TimeLinesOnTop) continue;
                this.m_list.get((int)n).Main.addPaintable(this.m_list.get((int)n).TimeLines, -1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void unzoom() {
        try {
            int n;
            this.m_rangeY.clearRange();
            for (n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).RangeX.clearRange();
                this.m_list.get((int)n).Main.recomputeAllRanges();
                this.m_list.get((int)n).RangeX.expandRange(this.m_list.get((int)n).Main.rangeX());
                this.m_rangeY.expandRange(this.m_list.get((int)n).Main.rangeY());
            }
            if (!this.m_rangeY.rangeValid()) {
                for (n = 0; n < this.m_numVisible; ++n) {
                    this.m_list.get((int)n).Main.repaint();
                }
                this.prepareScrollBars(true);
                return;
            }
            this.m_rangeY.addPercentBuffer(1.0);
            for (n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).RangeX.addPercentBuffer(2.0);
                this.m_list.get((int)n).Transform.setTechnique(Java2D_Transform.Technique.Inverted);
                this.m_list.get((int)n).Transform.setDesiredWorldX(this.m_list.get((int)n).RangeX.rangeMin(), this.m_list.get((int)n).RangeX.rangeMax());
                this.m_list.get((int)n).Transform.setDesiredWorldY(this.m_rangeY.rangeMin(), this.m_rangeY.rangeMax());
                this.m_list.get((int)n).Transform.computeTransform();
                this.m_list.get((int)n).Main.repaint();
            }
            this.prepareScrollBars(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisTableColumn(int plotIndex, String table, String column) {
        try {
            this.m_list.get((int)plotIndex).WigglePainter.setAxisTableColumn(table, column);
            this.m_list.get((int)plotIndex).Axis.setTitle(table + " - " + column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisType(int plotIndex, Java2D_EnsembleAxisEnum axisType) {
        try {
            this.m_list.get((int)plotIndex).AxisType = axisType;
            this.m_list.get((int)plotIndex).WigglePainter.setAxisType(axisType);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisLocked_Time(boolean locked, double min, double max) {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Transform.setAxisLockedY(locked, min, max);
            }
            this.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsemble(int index, Ensemble ensemble) {
        try {
            this.m_list.get(index).setEnsemble(ensemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Ensemble getEnsemble(int index) {
        try {
            return this.m_list.get(index).ensemble();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void addPaintable(int index, Java2D_PaintableInterface paintable, int supplemental) {
        try {
            if (paintable == null) {
                return;
            }
            this.m_list.get((int)index).Main.addPaintable(paintable, supplemental);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleZoomRequest(Java2D_UserEventConsumer_Rectangle zoomer) {
        try {
            if (zoomer.RequestMooz) {
                this.unzoom();
                return;
            }
            double top = Math.min(zoomer.StartWorldY, zoomer.EndWorldY);
            double bottom = Math.max(zoomer.StartWorldY, zoomer.EndWorldY);
            double left = Math.min(zoomer.StartWorldX, zoomer.EndWorldX);
            double right = Math.max(zoomer.StartWorldX, zoomer.EndWorldX);
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get((int)n).Transform.setDesiredWorldY(top, bottom);
                this.m_list.get((int)n).Transform.computeTransform();
                this.m_list.get((int)n).Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepareScrollBars(boolean unzoomed) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_optionsWidget) {
                this.prepWiggleOptions();
                return;
            }
            if (sender instanceof Java2D_UserEventConsumer_Rectangle) {
                Java2D_UserEventConsumer_Rectangle zoomer = (Java2D_UserEventConsumer_Rectangle)sender;
                if (zoomer.Dragging) {
                    return;
                }
                this.handleZoomRequest((Java2D_UserEventConsumer_Rectangle)sender);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (this.m_list.get((int)0).Main == widget) {
                double top = this.m_list.get((int)0).Transform.actualTop();
                double bottom = this.m_list.get((int)0).Transform.actualBottom();
                this.m_axisY.setRange(top, bottom);
                this.m_axisY.repaint();
                this.m_axisY.invalidate();
            }
            for (int n = 0; n < this.m_numVisible; ++n) {
                if (this.m_list.get((int)n).Main != widget) continue;
                this.m_list.get((int)n).HeaderText.repaint();
                this.m_list.get((int)n).HeaderText.invalidate();
                this.m_list.get((int)n).HeaderPlot.repaint();
                this.m_list.get((int)n).HeaderPlot.invalidate();
                double left = this.m_list.get((int)n).Transform.actualLeft();
                double right = this.m_list.get((int)n).Transform.actualRight();
                this.m_list.get((int)n).Axis.setRange(left, right);
                for (WeakReference<Listener> listener : this.m_listeners) {
                    if (listener.get() == null) continue;
                    ((Listener)listener.get()).handleEnsembleWidgetPaintEvent(this, n, imagePainted);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleEnsembleScrollBar(Java2D_EnsembleScrollBar sender, int orientation, double min, double max) {
    }

    public void forcePaintAll() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.setRequireDisplay();
                wrapper.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void repaintAll() {
        try {
            for (Wrapper wrapper : this.m_list) {
                wrapper.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void placeWidgets() {
        try {
            int n;
            int width = this.getSize().width;
            int height = this.getSize().height;
            this.m_numVisible = Math.max(1, this.m_numVisible);
            for (n = this.m_numVisible = Math.min(this.m_numVisible, this.m_list.size()); n < this.m_list.size(); ++n) {
                this.m_list.get(n).setInvisible();
            }
            for (n = 0; n < this.m_numVisible; ++n) {
                this.m_list.get(n).setVisible(true, this.m_headerTextCount, this.m_headerTextVisible, this.m_headerPlotVisible, this.m_horzAxisVisible, this.m_labelsVisible);
            }
            int axisHeight = 30;
            int labelHeight = 20;
            int scrollSize = 15;
            int axisWidth = 54;
            int headerPlotHeight = 80;
            int pixPerTextHeader = this.m_list.get((int)0).HeaderText.PixPerRow;
            int headerTextHeight = pixPerTextHeader * this.m_headerTextCount;
            int buffer = 5;
            int totalHeaderHeight = 0;
            if (this.m_externalComponentVisible) {
                totalHeaderHeight += this.m_externalComponentHeight;
            }
            if (this.m_labelsVisible) {
                totalHeaderHeight += labelHeight;
            }
            if (this.m_horzAxisVisible) {
                totalHeaderHeight += axisHeight;
            }
            if (this.m_headerPlotVisible) {
                totalHeaderHeight += headerPlotHeight;
            }
            if (this.m_headerTextVisible) {
                totalHeaderHeight += headerTextHeight;
            }
            int mainTop = totalHeaderHeight;
            int scrollTop = height - scrollSize;
            int mainHeight = height - totalHeaderHeight - scrollSize;
            mainHeight = Math.max(mainHeight, 10);
            int totalBuffer = buffer * (2 + (this.m_numVisible - 1));
            int pixForPlots = width - axisWidth - scrollSize - totalBuffer;
            int pixPerPlot = pixForPlots / this.m_numVisible;
            pixPerPlot = Math.max(pixPerPlot, 10);
            int left = 0;
            this.m_axisY.setBounds(left, mainTop, axisWidth, mainHeight);
            left = left + axisWidth + buffer;
            for (int n2 = 0; n2 < this.m_numVisible; ++n2) {
                this.m_list.get((int)n2).Left = left;
                this.m_list.get((int)n2).Width = pixPerPlot;
                this.m_list.get((int)n2).Right = left + pixPerPlot;
                int top = 0;
                if (this.m_externalComponentVisible) {
                    if (this.m_list.get((int)n2).ExternalComponent != null) {
                        this.m_list.get((int)n2).ExternalComponent.setBounds(left, top, pixPerPlot, this.m_externalComponentHeight);
                    }
                    top += this.m_externalComponentHeight;
                }
                if (this.m_labelsVisible) {
                    this.m_list.get((int)n2).Label.setBounds(left, top, pixPerPlot, labelHeight);
                    top += labelHeight;
                }
                if (this.m_horzAxisVisible) {
                    this.m_list.get((int)n2).Axis.setBounds(left, top, pixPerPlot, axisHeight);
                    top += axisHeight;
                }
                if (this.m_headerPlotVisible) {
                    this.m_list.get((int)n2).HeaderPlot.setBounds(left, top, pixPerPlot, headerPlotHeight);
                    top += headerPlotHeight;
                }
                if (this.m_headerTextVisible) {
                    this.m_list.get((int)n2).HeaderText.setBounds(left, top, pixPerPlot, headerTextHeight);
                    top += headerTextHeight;
                }
                this.m_list.get((int)n2).Main.setBounds(left, mainTop, pixPerPlot, mainHeight);
                this.m_list.get((int)n2).ScrollBar.setBounds(left, scrollTop, pixPerPlot, scrollSize);
                this.m_list.get((int)n2).ScrollBar.setVisible(true);
                left = this.m_list.get((int)n2).Right + buffer;
            }
            this.m_scrollBarVert.setBounds(left, mainTop, scrollSize, mainHeight);
            this.m_scrollBarVert.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public static class Wrapper {
        public Java2D_Widget Main;
        public Java2D_XAxisWidget Axis = new Java2D_XAxisWidget();
        public Java2D_EnsembleScrollBar ScrollBar;
        public Java2D_Transform Transform;
        public Java2D_EnsembleHeaderDisplayWidget HeaderText = new Java2D_EnsembleHeaderDisplayWidget();
        public Java2D_EnsembleHeaderPlotWidget HeaderPlot = new Java2D_EnsembleHeaderPlotWidget();
        public JLabel Label = new JLabel("Ensemble description", 0);
        public JComponent ExternalComponent = null;
        public Java2D_UserEventConsumer_Rectangle Zoomer = new Java2D_UserEventConsumer_Rectangle();
        public Java2D_EnsembleAxisEnum AxisType = Java2D_EnsembleAxisEnum.TraceHeader;
        public String AxisTable = "Trace";
        public String AxisColumn = "Offset";
        public int Left = 0;
        public int Right = 0;
        public int Width = 0;
        public Java2D_Paintable_Ensemble_Wiggles WigglePainter = new Java2D_Paintable_Ensemble_Wiggles();
        public Java2D_Paintable_Ensemble_Color ColorPainter = new Java2D_Paintable_Ensemble_Color();
        public Java2D_Paintable_AxisLines TimeLines = new Java2D_Paintable_AxisLines();
        protected Ensemble m_ensemble;
        public Range_Double RangeX = new Range_Double();

        public void setEnsemble(Ensemble ensemble) {
            try {
                this.m_ensemble = ensemble;
                this.HeaderPlot.setEnsemble(ensemble);
                this.HeaderText.setEnsemble(ensemble);
                this.WigglePainter.setEnsemble(ensemble);
                this.ColorPainter.setEnsemble(ensemble);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public Ensemble ensemble() {
            return this.m_ensemble;
        }

        public void setInvisible() {
            this.Main.setVisible(false);
            this.Label.setVisible(false);
            this.HeaderPlot.setVisible(false);
            this.HeaderText.setVisible(false);
            this.ScrollBar.setVisible(false);
            this.Axis.setVisible(false);
        }

        public void setVisible(boolean visible, int headerTextCount, boolean headerTextVisible, boolean headerPlotVisible, boolean axisVisible, boolean labelVisible) {
            this.Main.setVisible(visible);
            this.Label.setVisible(visible && labelVisible);
            this.HeaderPlot.setVisible(visible && headerPlotVisible);
            this.HeaderText.setVisible(visible && headerTextVisible && headerTextCount >= 1);
            this.ScrollBar.setVisible(visible);
            this.Axis.setVisible(visible && axisVisible);
        }
    }

    public static interface Listener {
        public void handleEnsembleWidgetPaintEvent(Java2D_HorzStackedEnsembleDisplayWidget var1, int var2, boolean var3);
    }
}

