/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Ensemble;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Java2D_EnsembleHeaderPlotWidget
extends JPanel
implements MouseListener,
ActionListener {
    protected static final Font m_labelFont = new Font("SansSerif", 0, 9);
    protected static final Font m_valueFont = new Font("SansSerif", 0, 12);
    protected static final Color m_oddRowTextColor = new Color(0, 0, 0);
    protected static final Color m_evenRowTextColor = new Color(0, 0, 0);
    protected static final Color m_validHeaderTextColor = new Color(0, 0, 255);
    protected static final Color m_invalidHeaderTextColor = new Color(255, 0, 0);
    protected static final Color m_dividingLineColor = new Color(200, 200, 200);
    protected static final Color m_selectedColor = new Color(44, 255, 44);
    public Color BackgroundColor = new Color(255, 255, 240);
    public Color DotColor = Color.BLUE;
    public double PercentBuffer = 5.0;
    protected ParameterTree m_paramTree;
    public int StartX = 0;
    protected Range_Double m_range = new Range_Double();
    protected EnsembleHeaderDictionary m_dictionary = null;
    protected Ensemble m_ensemble = null;
    protected String m_tableName;
    protected String m_columnName;
    protected ArrayList<LockInfo> m_lockList = new ArrayList();
    protected JPopupMenu m_popupMenu = null;
    public boolean StackSelectionMode = false;

    public void clearLockInfo() {
        this.m_lockList.clear();
        this.repaint();
    }

    public void setLockedRangeAndTableColumn(double min, double max, String lockTable, String lockColumn) {
        try {
            for (LockInfo li : this.m_lockList) {
                if (!li.Table.equalsIgnoreCase(lockTable) || !li.Column.equalsIgnoreCase(lockColumn)) continue;
                li.Minimum = min;
                li.Maximum = max;
                return;
            }
            LockInfo li = new LockInfo();
            li.Table = lockTable;
            li.Column = lockColumn;
            li.Minimum = min;
            li.Maximum = max;
            this.m_lockList.add(li);
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_EnsembleHeaderPlotWidget() {
        try {
            this.addMouseListener(this);
            this.m_tableName = "Trace";
            this.m_columnName = "Offset";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setParameterTree(ParameterTree pt) {
        try {
            this.m_paramTree = pt;
            this.m_tableName = this.m_paramTree.string_get("Table", "Trace");
            this.m_columnName = this.m_paramTree.string_get("Column", "Offset");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTableColumn(String table, String column) {
        try {
            this.m_tableName = table;
            this.m_columnName = column;
            if (this.m_paramTree != null) {
                this.m_paramTree.string_put("Table", this.m_tableName);
                this.m_paramTree.string_put("Column", this.m_columnName);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof MenuItem) {
                MenuItem mi = (MenuItem)e.getSource();
                this.setTableColumn(mi.Table, mi.Column);
                this.repaint();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            if (this.m_ensemble != null) {
                if (this.m_dictionary == null) {
                    this.m_dictionary = this.m_ensemble.dictionary().createExactCopy();
                    this.m_popupMenu = null;
                }
                if (!ensemble.dictionary().compare(this.m_dictionary)) {
                    this.m_dictionary = this.m_ensemble.dictionary().createExactCopy();
                    this.m_popupMenu = null;
                }
            }
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            int k;
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = this.getSize();
            g2d.setColor(this.BackgroundColor);
            g2d.fillRect(0, 0, size.width, size.height);
            g2d.setColor(m_dividingLineColor);
            g2d.drawLine(this.StartX, 0, this.StartX, size.height);
            if (this.m_ensemble == null) {
                return;
            }
            if (!this.m_ensemble.dictionary().compare(this.m_dictionary)) {
                this.m_dictionary = this.m_ensemble.dictionary().createExactCopy();
                this.m_popupMenu = null;
            }
            if (this.StackSelectionMode) {
                boolean selected;
                int pixel;
                EnsembleTrace t;
                if (this.m_ensemble.dictionary().containsEntry("Trace", "ShotID")) {
                    indexShotID = this.m_ensemble.dictionary().getEntryIndex("Trace", "ShotID");
                    for (k = 0; k < this.m_ensemble.traceCount(); ++k) {
                        t = this.m_ensemble.trace(k);
                        int shotID = t.header().getInt(indexShotID);
                        pixel = t.PlotData.PixelX + this.StartX;
                        boolean bl = selected = shotID == Messenger.shotID();
                        if (!selected || !t.PlotData.Visible || pixel < 0 || pixel >= size.width) continue;
                        g2d.setColor(m_selectedColor);
                        g2d.fillRect(pixel - 3, 0, 7, size.height);
                    }
                }
                if (this.m_ensemble.dictionary().containsEntry("Trace", "ReceiverID")) {
                    int indexRecID = this.m_ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
                    for (k = 0; k < this.m_ensemble.traceCount(); ++k) {
                        t = this.m_ensemble.trace(k);
                        int recID = t.header().getInt(indexRecID);
                        pixel = t.PlotData.PixelX + this.StartX;
                        boolean bl = selected = recID == Messenger.receiverID();
                        if (!selected || !t.PlotData.Visible || pixel < 0 || pixel >= size.width) continue;
                        g2d.setColor(m_selectedColor);
                        g2d.fillRect(pixel - 3, 0, 7, size.height);
                    }
                }
            } else if (this.m_ensemble.dictionary().containsEntry("Shot", "ShotID") && this.m_ensemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                indexShotID = this.m_ensemble.dictionary().getEntryIndex("Shot", "ShotID");
                int indexRecID = this.m_ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
                for (int k2 = 0; k2 < this.m_ensemble.traceCount(); ++k2) {
                    boolean selected;
                    EnsembleTrace t = this.m_ensemble.trace(k2);
                    int recID = t.header().getInt(indexRecID);
                    int shotID = t.header().getInt(indexShotID);
                    int pixel = t.PlotData.PixelX + this.StartX;
                    boolean bl = selected = recID == Messenger.receiverID() && shotID == Messenger.shotID();
                    if (!selected || !t.PlotData.Visible || pixel < 0 || pixel >= size.width) continue;
                    g2d.setColor(m_selectedColor);
                    g2d.fillRect(pixel - 3, 0, 7, size.height);
                }
            }
            if (!this.m_dictionary.containsEntry(this.m_tableName, this.m_columnName)) {
                return;
            }
            int index = this.m_dictionary.getEntryIndex(this.m_tableName, this.m_columnName);
            this.m_range.clearRange();
            for (k = 0; k < this.m_ensemble.traceCount(); ++k) {
                EnsembleTrace t = this.m_ensemble.trace(k);
                int pixel = t.PlotData.PixelX + this.StartX;
                if (!t.PlotData.Visible || pixel < 0 || pixel >= size.width) continue;
                double headerValue = t.header().getDouble(index);
                this.m_range.expandRange(headerValue);
            }
            if (!this.m_range.rangeValid()) {
                return;
            }
            this.m_range.addPercentBuffer(this.PercentBuffer);
            double max = this.m_range.rangeMax();
            double min = this.m_range.rangeMin();
            try {
                for (LockInfo li : this.m_lockList) {
                    if (!li.Table.equalsIgnoreCase(this.m_tableName) || !li.Column.equalsIgnoreCase(this.m_columnName)) continue;
                    min = li.Minimum;
                    max = li.Maximum;
                }
            }
            catch (Exception shotID) {
                // empty catch block
            }
            double scale = -((double)(size.height - 1)) / (max - min);
            double shift = 0.0 - scale * max;
            double tick = Tools_Plot.tickMarkInterval(this.m_range.range(), 5);
            int temp = (int)(min / tick);
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            g2d.setColor(Color.lightGray);
            int priorY = -99999;
            for (double v = (double)temp * tick; v < max; v += tick) {
                String s = Tools_Strings.doubleToString(v, this.m_range.range(), true);
                int iy = (int)(v * scale + shift);
                g2d.setColor(Color.lightGray);
                g2d.drawLine(this.StartX, iy, size.width, iy);
                g2d.setColor(Color.BLACK);
                int stringWidth = g2d.getFontMetrics().stringWidth(s);
                int strLeft = this.StartX - stringWidth - 2;
                if (Math.abs(iy - priorY) <= 14) continue;
                priorY = iy;
                g2d.drawString(s, strLeft, iy + 4);
            }
            g2d.setColor(Color.BLACK);
            String lbl = this.m_tableName + " - " + this.m_columnName;
            int stringWidth = g2d.getFontMetrics().stringWidth(lbl);
            int lx = size.width / 2 - stringWidth / 2;
            g2d.drawString(lbl, lx, stringHeight);
            g2d.drawString(lbl, lx, size.height - 2);
            g2d.setColor(this.DotColor);
            for (int k3 = 0; k3 < this.m_ensemble.traceCount(); ++k3) {
                EnsembleTrace t = this.m_ensemble.trace(k3);
                int pixel = t.PlotData.PixelX + this.StartX;
                if (!t.PlotData.Visible || pixel < 0 || pixel >= size.width) continue;
                double headerValue = t.header().getDouble(index);
                int y = (int)(scale * headerValue + shift);
                g2d.fillOval(pixel - 2, y - 2, 5, 5);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected void showPopupMenu(MouseEvent event) {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            if (this.m_dictionary == null) {
                return;
            }
            if (this.m_popupMenu == null) {
                this.m_popupMenu = new JPopupMenu();
                ArrayList<String> tables = this.m_dictionary.getListOfTableNames();
                for (String table : tables) {
                    JMenu menu = new JMenu(table);
                    this.m_popupMenu.add(menu);
                    JMenu menuDT = new JMenu("Delay time data");
                    menu.add(menuDT);
                    JMenu menuStatics = new JMenu("Statics");
                    menu.add(menuStatics);
                    ArrayList<String> columns = this.m_dictionary.getListOfColumnNames(table);
                    for (String column : columns) {
                        MenuItem item = new MenuItem(table, column);
                        item.setText(column);
                        item.addActionListener(this);
                        if (column.startsWith("DTA_")) {
                            menuDT.add(item);
                            continue;
                        }
                        if (column.startsWith("STATICS_")) {
                            menuStatics.add(item);
                            continue;
                        }
                        menu.add(item);
                    }
                }
            }
            this.m_popupMenu.show(event.getComponent(), event.getX(), event.getY());
            this.m_popupMenu.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            this.showPopupMenu(event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    protected class LockInfo {
        public String Table = "";
        public String Column = "";
        public double Minimum = 0.0;
        public double Maximum = 0.0;

        protected LockInfo() {
        }
    }

    protected static class MenuItem
    extends JMenuItem {
        public String Table = "";
        public String Column = "";

        public MenuItem(String tbl, String col) {
            this.Table = tbl;
            this.Column = col;
        }
    }
}

