/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.ColorWidgets;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Tools.Tools_ColorLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Java2D_VerticalColorWidget
extends JPanel
implements MouseMotionListener,
MouseListener,
ActionListener {
    protected Java2D_ColorArrayWrapper m_colorArrayWrapper = new Java2D_ColorArrayWrapper(80);
    protected int m_dividingPixel;
    protected double m_scale;
    protected double m_shift;
    protected double m_pixelsPerColor = 1.0;
    protected boolean m_bDraggingColors = false;
    protected int m_colorDragStartIndex = 0;
    protected int m_colorDragEndIndex = 0;
    protected boolean m_bDraggingKillRegion = false;
    protected int m_killRegionDragStartPixel = -999999;
    protected int m_killRegionDragEndPixel = -999999;
    protected JPopupMenu m_popupMenu;
    protected JMenuItem m_miWGRY;
    protected JMenuItem m_miDefault;
    protected JMenuItem m_miHeat;
    protected JMenuItem m_miBFC;
    protected JMenuItem m_miGrey;
    protected JMenuItem m_miRWB;
    protected JMenuItem m_miGCY;
    protected JMenuItem m_miAnis;
    protected JMenuItem m_miBrewer;
    protected JMenuItem m_miRainbowRev;
    protected WeakReference<Listener> m_listener;

    public Java2D_VerticalColorWidget(Listener listener) {
        try {
            this.m_colorArrayWrapper.setOwningComponent(this);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            if (listener != null) {
                this.m_listener = new WeakReference<Listener>(listener);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_ColorArrayWrapper getColorArrayWrapper() {
        return this.m_colorArrayWrapper;
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Listener listener;
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getSize().width;
            int h = this.getSize().height;
            g2d.setColor(Tools_ColorLibrary.ColorPlot_Background);
            g2d.fillRect(0, 0, w, h);
            this.m_dividingPixel = w / 3;
            this.m_pixelsPerColor = (double)h / (double)this.m_colorArrayWrapper.colorCount();
            int pixelsPerColor = 1 + (int)this.m_pixelsPerColor;
            for (int n = 0; n < this.m_colorArrayWrapper.colorCount(); ++n) {
                g2d.setColor(this.m_colorArrayWrapper.colorAtIndex(n));
                int y = (int)(this.m_pixelsPerColor * (double)n);
                g2d.fillRect(0, y, this.m_dividingPixel, pixelsPerColor);
            }
            if (this.m_bDraggingColors) {
                g2d.setColor(Tools_ColorLibrary.ColorPlot_DragColor);
                int minimumIndex = Math.min(this.m_colorDragStartIndex, this.m_colorDragEndIndex);
                int maximumIndex = Math.max(this.m_colorDragStartIndex, this.m_colorDragEndIndex);
                int pix1 = (int)(this.m_pixelsPerColor * (double)minimumIndex);
                int pix2 = (int)(this.m_pixelsPerColor * (double)(maximumIndex + 1));
                g2d.fillRect(0, pix1, this.m_dividingPixel, pix2 - pix1);
            }
            double top = this.m_colorArrayWrapper.rangeMin();
            double bottom = this.m_colorArrayWrapper.rangeMax();
            this.m_scale = (double)(h - 1) / (bottom - top);
            this.m_shift = 0.0 - this.m_scale * top;
            ArrayList<Java2D_ColorArrayWrapper.DeadZone> deadList = this.m_colorArrayWrapper.deadZone();
            g2d.setColor(Tools_ColorLibrary.ColorPlot_KillZone);
            for (Java2D_ColorArrayWrapper.DeadZone z : deadList) {
                int pix1 = (int)(z.Fraction1 * (double)h);
                int pix2 = (int)(z.Fraction2 * (double)h);
                g2d.fillRect(this.m_dividingPixel, pix1, w - this.m_dividingPixel, pix2 - pix1);
            }
            double range = Math.abs(bottom - top);
            double rangeMax = Math.max(top, bottom);
            double rangeMin = Math.min(top, bottom);
            g2d.setColor(Color.BLACK);
            double tickMarkInterval = Tools_Plot.tickMarkInterval(range, 10);
            int halfStringHeight = g2d.getFontMetrics().getHeight() / 2;
            int lastDrawnPixel = -100;
            for (double tickMarkValue = tickMarkInterval * (double)(Math.round(rangeMin / tickMarkInterval) - 2L); tickMarkValue < rangeMax; tickMarkValue += tickMarkInterval) {
                int tickPixel = (int)(tickMarkValue * this.m_scale + this.m_shift);
                String s = Tools_Strings.doubleToString(tickMarkValue, range);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(this.m_dividingPixel, tickPixel, w, tickPixel);
                if (Math.abs(lastDrawnPixel - tickPixel) <= 20) continue;
                lastDrawnPixel = tickPixel;
                g2d.setColor(Color.BLACK);
                g2d.drawString(s, this.m_dividingPixel + 3, tickPixel + halfStringHeight);
            }
            if (this.m_bDraggingKillRegion) {
                g2d.setColor(Tools_ColorLibrary.ColorPlot_DragKill);
                int pix1 = Math.min(this.m_killRegionDragStartPixel, this.m_killRegionDragEndPixel);
                int pix2 = Math.max(this.m_killRegionDragStartPixel, this.m_killRegionDragEndPixel);
                g2d.fillRect(this.m_dividingPixel, pix1, w - this.m_dividingPixel, pix2 - pix1);
            }
            if (!this.m_bDraggingColors && !this.m_bDraggingKillRegion && this.m_listener != null && (listener = (Listener)this.m_listener.get()) != null) {
                listener.verticalColorWidgetJustPainted(this);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            boolean modified = false;
            if (e.getSource() == this.m_miBrewer) {
                modified = true;
                this.m_colorArrayWrapper.makeBrewer();
            }
            if (e.getSource() == this.m_miGCY) {
                modified = true;
                this.m_colorArrayWrapper.makeGrayCyanYellow();
            }
            if (e.getSource() == this.m_miAnis) {
                modified = true;
                this.m_colorArrayWrapper.makeAnis();
            }
            if (e.getSource() == this.m_miRWB) {
                modified = true;
                this.m_colorArrayWrapper.makeRWB();
            }
            if (e.getSource() == this.m_miWGRY) {
                modified = true;
                this.m_colorArrayWrapper.makeWGRY();
            }
            if (e.getSource() == this.m_miBFC) {
                modified = true;
                this.m_colorArrayWrapper.makeBFC();
            }
            if (e.getSource() == this.m_miGrey) {
                modified = true;
                this.m_colorArrayWrapper.makeGrey();
            }
            if (e.getSource() == this.m_miRainbowRev) {
                modified = true;
                this.m_colorArrayWrapper.makeRainbowRev();
            }
            if (e.getSource() == this.m_miHeat) {
                modified = true;
                this.m_colorArrayWrapper.makeHeat();
            }
            if (e.getSource() == this.m_miDefault) {
                modified = true;
                this.m_colorArrayWrapper.makeDefault();
            }
            if (modified) {
                Listener listener;
                this.repaint();
                if (this.m_listener != null && (listener = (Listener)this.m_listener.get()) != null) {
                    listener.verticalColorWidgetModified(this);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected JMenuItem addMI(String txt) {
        try {
            JMenuItem mi = new JMenuItem(txt);
            this.m_popupMenu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            this.m_bDraggingColors = false;
            this.m_bDraggingKillRegion = false;
            if (event.getButton() == 3) {
                if (this.m_popupMenu == null) {
                    this.m_popupMenu = new JPopupMenu();
                    this.m_miDefault = this.addMI("Default colors (Blue-Green-Yellow-Red");
                    this.m_miHeat = this.addMI("Heat (Black-Blue-Red-Yellow)");
                    this.m_miBFC = this.addMI("WGC (Magenta-Blue-Cyan-Green-Yellow-Red)");
                    this.m_miGrey = this.addMI("Grey (Light grey - dark grey)");
                    this.m_miWGRY = this.addMI("White - Gray - Red - Yellow");
                    this.m_miRWB = this.addMI("Red - White - Blue");
                    this.m_miGCY = this.addMI("Gray - Cyan - Yellow");
                    this.m_miAnis = this.addMI("Anisotropic color scale");
                    this.m_miBrewer = this.addMI("Monotonic lightness profile");
                    this.m_miRainbowRev = this.addMI("Rainbow - reversed");
                }
                this.m_popupMenu.show(event.getComponent(), event.getX(), event.getY());
                this.m_popupMenu.setVisible(true);
            }
            if (event.getButton() == 1) {
                if (event.getX() < this.m_dividingPixel) {
                    this.m_colorDragEndIndex = this.m_colorDragStartIndex = (int)((double)event.getY() / this.m_pixelsPerColor);
                    this.m_bDraggingColors = true;
                    this.repaint();
                    return;
                }
                if (event.getX() > this.m_dividingPixel) {
                    this.m_killRegionDragStartPixel = event.getY();
                    this.m_killRegionDragEndPixel = event.getY();
                    this.m_bDraggingKillRegion = true;
                    return;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            if (this.m_bDraggingKillRegion) {
                Listener listener;
                this.m_bDraggingKillRegion = false;
                if (Math.abs(this.m_killRegionDragEndPixel - this.m_killRegionDragStartPixel) < 4) {
                    this.repaint();
                    return;
                }
                int h = this.getSize().height;
                int minPixel = Math.min(this.m_killRegionDragEndPixel, this.m_killRegionDragStartPixel);
                int maxPixel = Math.max(this.m_killRegionDragEndPixel, this.m_killRegionDragStartPixel);
                if (minPixel < 2) {
                    minPixel = -1;
                }
                if (maxPixel >= h - 3) {
                    maxPixel = h + 1;
                }
                double f1 = (double)minPixel / (double)h;
                double f2 = (double)maxPixel / (double)h;
                this.m_colorArrayWrapper.addDeadZone(Math.min(f2, f1), Math.max(f2, f1));
                this.repaint();
                if (this.m_listener != null && (listener = (Listener)this.m_listener.get()) != null) {
                    listener.verticalColorWidgetModified(this);
                }
            }
            if (this.m_bDraggingColors) {
                Listener listener;
                this.m_bDraggingColors = false;
                if (this.m_colorDragEndIndex == this.m_colorDragStartIndex) {
                    Color currentColor = this.m_colorArrayWrapper.colorAtIndex(this.m_colorDragStartIndex);
                    Color newColor = JColorChooser.showDialog(this, "Color", currentColor);
                    if (newColor != null) {
                        this.m_colorArrayWrapper.setColor(this.m_colorDragEndIndex, newColor);
                    }
                } else {
                    int startIndex = Math.min(this.m_colorDragStartIndex, this.m_colorDragEndIndex);
                    int endIndex = Math.max(this.m_colorDragStartIndex, this.m_colorDragEndIndex);
                    this.m_colorArrayWrapper.interpolateColors(startIndex, endIndex);
                }
                this.repaint();
                if (this.m_listener != null && (listener = (Listener)this.m_listener.get()) != null) {
                    listener.verticalColorWidgetModified(this);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        try {
            if (this.m_bDraggingKillRegion) {
                this.m_killRegionDragEndPixel = event.getY();
                this.repaint();
            }
            if (this.m_bDraggingColors) {
                int testEndIndex = (int)((double)event.getY() / this.m_pixelsPerColor);
                if (testEndIndex == this.m_colorDragEndIndex) {
                    return;
                }
                this.m_colorDragEndIndex = testEndIndex;
                this.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    public static interface Listener {
        public void verticalColorWidgetJustPainted(Object var1);

        public void verticalColorWidgetModified(Object var1);
    }
}

