/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_PointSymbol_ComboBox;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_VerticalStackWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class TwoDStackedDatabaseWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
ISaveableFrame {
    protected ArrayList<Wrapper> m_list = new ArrayList();
    protected Java2D_PointSymbol_ComboBox m_symbolComboRec = new Java2D_PointSymbol_ComboBox();
    protected Java2D_PointSymbol_ComboBox m_symbolComboSrc = new Java2D_PointSymbol_ComboBox();
    protected JTextField m_sizeText = new JTextField("5");
    protected JComboBox<String> m_cmbCount = new JComboBox();
    protected ComboStringListWrapper m_comboAxis = new ComboStringListWrapper();
    protected JButton m_btnReloadColumns;
    protected JButton m_btnReloadPlot;
    protected int m_maxPlots = 5;
    protected Java2D_VerticalStackWidget m_widget;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JDBC.TwoDStackedDatabaseWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "2D plots";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "2D plots";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public TwoDStackedDatabaseWidget() {
        super(1);
        try {
            this.m_widget = new Java2D_VerticalStackWidget(this.m_maxPlots);
            this.m_widget.setNumVisible(3);
            this.m_widget.setColorVisible(false);
            this.setLeftComponent(this.createLeftWidget());
            this.setRightComponent(this.m_widget);
            this.reloadListOfColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeftWidget() {
        try {
            int row = 0;
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_btnReloadColumns = main.createButton("Reload list of columns", this, 0);
            this.m_btnReloadPlot = main.createButton("Reload plot", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Display options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Plot count"), this.m_cmbCount);
            grid.addSimple(row++, new JLabel("Horizontal axis"), this.m_comboAxis);
            grid.addSimple(row++, new JLabel("Symbol size"), this.m_sizeText);
            grid.addSimple(row++, new JLabel("Receiver symbol"), this.m_symbolComboRec);
            grid.addSimple(row++, new JLabel("Shot symbol"), this.m_symbolComboSrc);
            this.m_comboAxis.setPreferredSelected("PointNumber");
            this.m_comboAxis.listener().addListener(this);
            this.m_cmbCount.addItemListener(this);
            grid = main.createGridLayoutWidget(0, "Select column", 0);
            for (int n = 0; n < this.m_maxPlots; ++n) {
                this.m_cmbCount.addItem(Integer.toString(n + 1));
                Wrapper w = new Wrapper(this, this);
                grid.addSimple(n, (Component)w.ComboColumn, (Component)w.CheckShowSource, (Component)w.CheckShowReceiver, 10, 0, 0);
                w.CheckShowReceiver.setSelected(true);
                w.CheckShowSource.setSelected(true);
                this.m_list.add(w);
            }
            this.m_cmbCount.setSelectedIndex(2);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadAll() {
        try {
            for (int n = 0; n <= this.m_cmbCount.getSelectedIndex(); ++n) {
                this.reloadPlot(n);
            }
            this.m_widget.unzoom();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot(int n) {
        try {
            Table_Abstract table;
            String query;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Wrapper w = this.m_list.get(n);
            Java2D_Widget widget = this.m_widget.mainWidget(n);
            widget.transform().setTechnique(Java2D_Transform.Technique.Normal);
            widget.clearPaintableList();
            String axisX = this.m_comboAxis.getSelectedString();
            String axisY = w.ComboColumn.getSelectedString();
            if (w.CheckShowSource.isSelected()) {
                widget.addPaintable(new Java2D_Paintable_AxisLines(), -9999);
                query = String.format("SELECT %s, %s, %s FROM %s", axisX, axisY, "ShotID", "Shot");
                table = p.geometryDatabase().extractTableDataUsingQuery("Shot", query, Pecos.MaxQueryRowCount);
                w.ShotPaintable = new Java2D_Paintable_Table();
                w.ShotPaintable.AttemptToPlotText = true;
                w.ShotPaintable.setTable(table);
                w.ShotPaintable.setAxisX(axisX);
                w.ShotPaintable.setAxisY(axisY);
                w.ShotPaintable.Size_Pixel = Tools_Widget.extractInteger(this.m_sizeText, 3, 1, 500);
                w.ShotPaintable.Symbol = this.m_symbolComboSrc.selectedSymbol();
                w.ShotPaintable.FixedColor = Color.RED;
                widget.addPaintable(w.ShotPaintable, -9999);
            }
            if (w.CheckShowReceiver.isSelected()) {
                query = String.format("SELECT %s, %s, %s FROM %s", axisX, axisY, "ReceiverID", "Receiver");
                table = p.geometryDatabase().extractTableDataUsingQuery("Receiver", query, Pecos.MaxQueryRowCount);
                w.ReceiverPaintable = new Java2D_Paintable_Table();
                w.ReceiverPaintable.AttemptToPlotText = true;
                w.ReceiverPaintable.setTable(table);
                w.ReceiverPaintable.setAxisX(axisX);
                w.ReceiverPaintable.setAxisY(axisY);
                w.ReceiverPaintable.Size_Pixel = Tools_Widget.extractInteger(this.m_sizeText, 3, 3, 21);
                w.ReceiverPaintable.Symbol = this.m_symbolComboRec.selectedSymbol();
                w.ReceiverPaintable.FixedColor = Color.BLUE;
                widget.addPaintable(w.ReceiverPaintable, -9999);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfColumns() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ArrayList<String> list = p.geometryDatabase().listOfColumnNames("Receiver", "Shot");
            for (Wrapper w : this.m_list) {
                w.ComboColumn.setStringArray(list);
            }
            this.m_comboAxis.setStringArray(list);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_cmbCount) {
                this.m_widget.setNumVisible(this.m_cmbCount.getSelectedIndex() + 1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_btnReloadColumns) {
                this.reloadListOfColumns();
                return;
            }
            if (e.getSource() == this.m_btnReloadPlot) {
                this.reloadAll();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class Wrapper {
        public JCheckBox CheckShowSource = new JCheckBox("SRC");
        public JCheckBox CheckShowReceiver = new JCheckBox("REC");
        public ComboStringListWrapper ComboColumn = new ComboStringListWrapper();
        protected Java2D_Paintable_Table ShotPaintable;
        protected Java2D_Paintable_Table ReceiverPaintable;

        public Wrapper(ActionListener act, GenericObjectListener.Listener gen) {
            this.CheckShowSource.addActionListener(act);
            this.CheckShowReceiver.addActionListener(act);
            this.ComboColumn.listener().addListener(gen);
        }
    }
}

