/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class ProjectComparisonWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
Messenger.Listener,
ItemListener,
ISaveableFrame {
    protected ElementArray m_shotArray = new ElementArray();
    protected ElementArray m_recArray = new ElementArray();
    protected ComboStringListWrapper m_cmbOtherProject = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cmbOtherVersion = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cmbOtherColumn = new ComboStringListWrapper();
    protected Java2D_SimpleComposite m_plotWidget = new Java2D_SimpleComposite(true);
    protected ComboStringListWrapper m_cmbColumn = new ComboStringListWrapper();
    protected JTextField m_txtMaxDistance = new JTextField("30");
    protected JCheckBox m_chkSource = new JCheckBox("Display source differences");
    protected JCheckBox m_chkReceiver = new JCheckBox("Display receiver differences");
    protected JButton m_loadButton;
    protected JButton m_reloadProjectsButton;
    protected JButton m_reloadColumnsButton;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JDBC.ProjectComparisonWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "4D Comp";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "4D Comp";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public ProjectComparisonWidget() {
        super(1);
        try {
            this.setRightComponent(this.centralWidget());
            this.setLeftComponent(this.createLeftWidget());
            Messenger.singleton().addListener(this);
            this.reloadProjects();
            this.reloadColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeftWidget() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            GridLayoutWidget otherGrid = main.createGridLayoutWidget(0, "Select other project, version, and column", 0);
            int row = 0;
            otherGrid.addSimple(row++, new JLabel("Select other project"), this.m_cmbOtherProject);
            otherGrid.addSimple(row++, new JLabel("Select version"), this.m_cmbOtherVersion);
            otherGrid.addSimple(row++, new JLabel("Select column"), this.m_cmbOtherColumn);
            this.m_cmbOtherProject.listener().addListener(this);
            this.m_cmbOtherVersion.listener().addListener(this);
            this.m_cmbOtherColumn.listener().addListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Select column within current project/version", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Compare with this column"), this.m_cmbColumn);
            grid.addSimple(row++, new JLabel("Maximum allowed distance"), this.m_txtMaxDistance);
            main.addComponent(this.m_chkReceiver, 0);
            main.addComponent(this.m_chkSource, 0);
            this.m_chkReceiver.setSelected(true);
            this.m_chkSource.setSelected(true);
            this.m_loadButton = main.createButton("Reload plot", this, 0);
            this.m_reloadProjectsButton = main.createButton("Reload other projects", this, 0);
            this.m_reloadColumnsButton = main.createButton("Reload columns", this, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent centralWidget() {
        try {
            return this.m_plotWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadPlot() {
        try {
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            IDatabaseConnection db1 = this.database();
            IDatabaseConnection db2 = this.getDB();
            String otherColumn = this.m_cmbOtherColumn.getSelectedString();
            String column = this.m_cmbColumn.getSelectedString();
            double maxDist = Tools_Widget.extractDouble(this.m_txtMaxDistance, 20.0, 1.0, 5000.0);
            String sql = String.format("SELECT ShotID, Easting, Northing, Killed, %s FROM Shot", otherColumn);
            Table_Abstract shotTableOther = db2.extractTableDataUsingQuery("Shot", sql, 10000000);
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            this.m_shotArray.prep(shotTable, shotTableOther, "ShotID", column, otherColumn, maxDist);
            sql = String.format("SELECT ReceiverID, Easting, Northing, Killed, %s FROM Receiver", otherColumn);
            Table_Abstract recTableOther = db2.extractTableDataUsingQuery("Receiver", sql, 10000000);
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            this.m_recArray.prep(recTable, recTableOther, "ReceiverID", column, otherColumn, maxDist);
            if (this.m_chkSource.isSelected()) {
                w.addPaintable(this.m_shotArray, -9999);
            }
            if (this.m_chkReceiver.isSelected()) {
                w.addPaintable(this.m_recArray, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_loadButton) {
                this.reloadPlot();
                return;
            }
            if (this.m_reloadProjectsButton == e.getSource()) {
                this.reloadProjects();
                return;
            }
            if (this.m_reloadColumnsButton == e.getSource()) {
                this.reloadColumns();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns() {
        try {
            IDatabaseConnection db = this.database();
            ArrayList<String> list = db.listOfColumnNames("Shot", "Receiver");
            this.m_cmbColumn.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadOtherColumns() {
        try {
            IDatabaseConnection db = this.getDB();
            ArrayList<String> list = db.listOfColumnNames("Shot", "Receiver");
            this.m_cmbOtherColumn.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadVersions() {
        try {
            String projectsPath = SharedApplicationData.staticsProjectPath();
            String selected = this.m_cmbOtherProject.getSelectedString();
            Object fullProjectPath = "";
            String fullProjectPathOld = projectsPath + "/" + selected;
            String fullProjectPathNew = projectsPath + "/" + selected + ".xtref";
            fullProjectPath = Tools_FileSystem.exists_path(fullProjectPathNew) ? fullProjectPathNew : fullProjectPathOld;
            String versionContainerPath = (String)fullProjectPath + "/Versions";
            ArrayList<String> versions = Tools_FileSystem.subdirectories(versionContainerPath, false);
            this.m_cmbOtherVersion.setStringArray(versions);
            this.reloadOtherColumns();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadProjects() {
        try {
            String currentProject = RefractionStaticsProject.singleton().name();
            String projectsPath = SharedApplicationData.staticsProjectPath();
            ArrayList<String> projects = new ArrayList<String>();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(projectsPath, false);
            for (String subdir : subdirs) {
                boolean sameProject = subdir.equalsIgnoreCase(currentProject);
                String fullProjectPath = projectsPath + "/" + subdir;
                String descFileName = fullProjectPath + "/ProjectDescription.xml";
                String projectName = "";
                if (subdir.endsWith(".xtref")) {
                    int endChar = subdir.length() - ".xtref".length();
                    projectName = subdir.substring(0, endChar);
                } else {
                    projectName = subdir;
                }
                if (sameProject || !Tools_FileSystem.exists_file(descFileName)) continue;
                projects.add(projectName);
            }
            this.m_cmbOtherProject.setStringArray(projects);
            this.reloadVersions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection getDB() {
        try {
            String projectsPath = SharedApplicationData.staticsProjectPath();
            String selectedProject = this.m_cmbOtherProject.getSelectedString();
            Object fullProjectPath = "";
            String fullProjectPathOld = projectsPath + "/" + selectedProject;
            String fullProjectPathNew = fullProjectPathOld + ".xtref";
            fullProjectPath = Tools_FileSystem.exists_path(fullProjectPathNew) ? fullProjectPathNew : fullProjectPathOld;
            String versionContainerPath = (String)fullProjectPath + "/Versions";
            String selectedVersion = this.m_cmbOtherVersion.getSelectedString();
            String versionPath = versionContainerPath + "/" + selectedVersion;
            String fileNameDB = versionPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            return db;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_cmbOtherProject) {
                this.reloadVersions();
                return;
            }
            if (sender == this.m_cmbOtherVersion) {
                this.reloadOtherColumns();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected class ElementArray
    implements Java2D_PaintableInterface {
        public Range_Double RangeX = new Range_Double();
        public Range_Double RangeY = new Range_Double();
        public Range_Double RangeC = new Range_Double();
        public ArrayList<Element> Elements = new ArrayList();
        protected int m_numValid = 0;

        protected ElementArray() {
        }

        public void clear() {
            this.m_numValid = 0;
            this.RangeX.clearRange();
            this.RangeY.clearRange();
            this.RangeC.clearRange();
        }

        public void prep(Table_Abstract table, Table_Abstract otherTable, String colnameID, String colName, String colnameOther, double maxAllowedDist) {
            try {
                this.clear();
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexV = table.column_indexOfColumn(colName);
                int indexDead = table.column_indexOfColumn("Killed");
                int indexID = table.column_indexOfColumn(colnameID);
                int indexOtherX = otherTable.column_indexOfColumn("Easting");
                int indexOtherY = otherTable.column_indexOfColumn("Northing");
                int indexOtherV = otherTable.column_indexOfColumn(colnameOther);
                int indexOtherDead = otherTable.column_indexOfColumn("Killed");
                int indexOtherID = otherTable.column_indexOfColumn(colnameID);
                for (int n = 0; n < table.row_count(); ++n) {
                    double minDist = maxAllowedDist;
                    int bestRow = -9999;
                    if (table.getBool(n, indexDead)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    int id = table.getInt(n, indexID);
                    for (int r = 0; r < otherTable.row_count(); ++r) {
                        double dy;
                        double dx;
                        double dist;
                        if (otherTable.getBool(r, indexOtherDead) || !((dist = Math.sqrt(1.0E-20 + (dx = x - otherTable.getDouble(r, indexOtherX)) * dx + (dy = y - otherTable.getDouble(r, indexOtherY)) * dy)) < minDist)) continue;
                        minDist = dist;
                        bestRow = r;
                    }
                    if (bestRow >= 0) {
                        int otherID = otherTable.getInt(bestRow, indexOtherID);
                        double diff = table.getDouble(n, indexV) - otherTable.getDouble(bestRow, indexOtherV);
                        this.add(id, otherID, true, x, y, diff);
                        continue;
                    }
                    this.add(id, -9999, false, x, y, 0.0);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void add(int id, int otherID, boolean close, double x, double y, double diff) {
            try {
                while (this.m_numValid >= this.Elements.size()) {
                    this.Elements.add(new Element());
                }
                this.RangeX.expandRange(x);
                this.RangeY.expandRange(y);
                if (close) {
                    this.RangeC.expandRange(diff);
                }
                Element e = this.Elements.get(this.m_numValid);
                e.Close = close;
                e.ID = id;
                e.OtherID = otherID;
                e.X = x;
                e.Y = y;
                e.Diff = diff;
                ++this.m_numValid;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public boolean Java2D_ImageContentsDirty(int supplementalData) {
            return true;
        }

        @Override
        public int Java2D_MaximumPaintLevel(int supplementalData) {
            return 0;
        }

        @Override
        public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
            try {
                if (this.RangeC.rangeValid()) {
                    rangeC.expandRange(this.RangeC);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
            try {
                if (this.RangeX.rangeValid()) {
                    rangeX.expandRange(this.RangeX);
                }
                if (this.RangeY.rangeValid()) {
                    rangeY.expandRange(this.RangeY);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
            try {
                int iy;
                int ix;
                Element e;
                int n;
                if (this.m_numValid < 1) {
                    return;
                }
                if (paintParameter.PaintLevel != 0) {
                    return;
                }
                Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
                Java2D_Transform transform = paintParameter.Transform;
                Graphics2D g2d = paintParameter.G2D;
                double scaleX = transform.scaleX();
                double shiftX = transform.shiftX();
                double scaleY = transform.scaleY();
                double shiftY = transform.shiftY();
                double viewMinX = transform.actualLeft();
                double viewMaxX = transform.actualRight();
                double viewMinY = transform.actualMinY();
                double viewmaxY = transform.actualMaxY();
                int size = 5;
                int h = size / 2;
                for (n = 0; n < this.m_numValid; ++n) {
                    e = this.Elements.get(n);
                    if (!e.Close) continue;
                    ix = (int)(scaleX * e.X + shiftX);
                    iy = (int)(scaleY * e.Y + shiftY);
                    if (!colorWrapper.valueOK(e.Diff)) continue;
                    g2d.setColor(colorWrapper.colorUsingValue(e.Diff));
                    g2d.fillRect(ix - h, iy - h, size, size);
                }
                g2d.setColor(Color.black);
                for (n = 0; n < this.m_numValid; ++n) {
                    e = this.Elements.get(n);
                    if (e.Close) continue;
                    ix = (int)(scaleX * e.X + shiftX);
                    iy = (int)(scaleY * e.Y + shiftY);
                    g2d.drawOval(ix - h, iy - h, size, size);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
        }
    }

    protected class Element {
        public int ID = -9999;
        public int OtherID = -9999;
        public boolean Valid = false;
        public boolean Close = false;
        public double X;
        public double Y;
        public double Diff;

        protected Element() {
        }
    }
}

