/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class OverwriteUsingImportedTableOneKeyDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected DatabaseEnum m_whichDatabase;
    protected String m_tableName;
    protected RefractionStaticsProject m_project;
    protected Table_Abstract m_outputTable;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Import");
    protected ComboStringListWrapper m_importTableCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnValCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnKeyCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_exportColumnValCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_exportColumnKeyCombo = new ComboStringListWrapper();
    protected JCheckBox m_chkClear = new JCheckBox("Reset rows that do not have a valid key to the following value");
    protected JTextField m_txtClear = new JTextField("-9999");

    public OverwriteUsingImportedTableOneKeyDialog(DatabaseEnum whichDatabase, String tableName) {
        try {
            this.m_whichDatabase = whichDatabase;
            this.m_tableName = tableName;
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Select the imported table and columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Select table"), this.m_importTableCombo);
            grid.addSimple(row++, new JLabel("Unique key column"), this.m_importColumnKeyCombo);
            grid.addSimple(row++, new JLabel("Value column"), this.m_importColumnValCombo);
            this.m_importTableCombo.listener().addListener(this);
            if (this.m_whichDatabase == DatabaseEnum.Geometry) {
                if (this.m_tableName.equalsIgnoreCase("Shot")) {
                    this.m_outputTable = this.m_project.shotTable();
                }
                if (this.m_tableName.equalsIgnoreCase("Receiver")) {
                    this.m_outputTable = this.m_project.receiverTable();
                }
            } else if (this.m_whichDatabase == DatabaseEnum.Import) {
                this.m_outputTable = this.m_project.importDatabase().extractTableDataUsingQuery(this.m_tableName, "SELECT * FROM " + this.m_tableName, Pecos.MaxQueryRowCount);
            }
            grid = main.createGridLayoutWidget(3, "Select the output columns", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Unique key column"), this.m_exportColumnKeyCombo);
            grid.addSimple(row++, new JLabel("Value column"), this.m_exportColumnValCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_chkClear);
            grid.addSimple(row++, new JLabel("Reset value"), this.m_txtClear);
            this.m_chkClear.setSelected(false);
            this.m_chkClear.addActionListener(this);
            this.m_exportColumnKeyCombo.setStringArray(this.m_outputTable.column_listOfNames());
            this.m_exportColumnValCombo.setStringArray(this.m_outputTable.column_listOfNames());
            this.m_importTableCombo.setStringArray(this.m_project.importDatabase().getTableNames());
            String tempTableName = this.m_importTableCombo.getSelectedString();
            ArrayList<String> list = this.m_project.importDatabase().listOfColumnNames(tempTableName);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.reloadColumns();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setTitle("Overwrite using imported data");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            String tableName = this.m_importTableCombo.getSelectedString();
            ArrayList<String> list = this.m_project.importDatabase().listOfColumnNames(tableName);
            this.m_importColumnValCombo.setStringArray(list);
            this.m_importColumnKeyCombo.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_importTableCombo) {
                this.reloadColumns();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean doStuff() {
        try {
            boolean required;
            String colVal = this.m_exportColumnValCombo.getSelectedString();
            String colKey = this.m_exportColumnKeyCombo.getSelectedString();
            boolean bl = required = colVal.equalsIgnoreCase("ShotID") || colVal.equalsIgnoreCase("ReceiverID");
            if (required) {
                JOptionPane.showMessageDialog(null, "Cannot modify a required column", " ", 0);
                return false;
            }
            int colExportKey = this.m_outputTable.column_indexOfColumn(colKey);
            int colExportV = this.m_outputTable.column_indexOfColumn(colVal);
            HashMap_Integer hash = new HashMap_Integer();
            for (int row = 0; row < this.m_outputTable.row_count(); ++row) {
                int key = this.m_outputTable.getInt(row, colExportKey);
                if (hash.containsKey(key)) {
                    JOptionPane.showMessageDialog(null, "Selected key not unique in database table", " ", 0);
                    return false;
                }
                hash.put(key, row);
            }
            if (this.m_chkClear.isSelected()) {
                double clear = Tools_Widget.extractDouble(this.m_txtClear, -9999.0, -1.0E20, 1.0E20);
                for (int row = 0; row < this.m_outputTable.row_count(); ++row) {
                    this.m_outputTable.putDouble(row, colExportV, clear);
                }
            }
            String importTableName = this.m_importTableCombo.getSelectedString();
            String importColKey = this.m_importColumnKeyCombo.getSelectedString();
            String importVal = this.m_importColumnValCombo.getSelectedString();
            String sql = String.format("SELECT %s, %s FROM %s", importColKey, importVal, importTableName);
            Table_Abstract importTable = this.m_project.importDatabase().extractTableDataUsingQuery(importTableName, sql, Pecos.MaxQueryRowCount);
            int colImportKey = importTable.column_indexOfColumn(importColKey);
            int colImportV = importTable.column_indexOfColumn(importVal);
            for (int row = 0; row < importTable.row_count(); ++row) {
                int key = importTable.getInt(row, colImportKey);
                double v = importTable.getDouble(row, colImportV);
                if (!hash.containsKey(key)) continue;
                int outputRow = hash.get(key);
                this.m_outputTable.putDouble(outputRow, colExportV, v);
            }
            if (this.m_whichDatabase == DatabaseEnum.Geometry) {
                this.m_project.geometryDatabase().writeColumnContentsToDatabase(this.m_outputTable, colVal);
            }
            if (this.m_whichDatabase == DatabaseEnum.Import) {
                this.m_project.importDatabase().writeColumnContentsToDatabase(this.m_outputTable, colVal);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnInterpolate) {
                if (!this.doStuff()) {
                    return;
                }
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

