/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.ColorWidgets.Java2D_VerticalColorCompositeWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_PointSymbol_ComboBox;
import com.PecosLibrary.Windows.Java2D.Java2D_ScrollBar;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Rectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class MultiBasemapWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
Messenger.Listener,
ItemListener,
ISaveableFrame {
    protected ArrayList<SubPlot> m_plots = new ArrayList();
    protected JComboBox m_comboLayout = new JComboBox();
    protected SubPlotWrapper m_subPlotWrapper;
    protected JComboBox m_cmbPlotCount = new JComboBox();
    protected JTextField m_shotSizeText = new JTextField("50");
    protected JTextField m_recSizeText = new JTextField("50");
    protected Java2D_PointSymbol_ComboBox m_shotSymbolCombo = new Java2D_PointSymbol_ComboBox();
    protected Java2D_PointSymbol_ComboBox m_recSymbolCombo = new Java2D_PointSymbol_ComboBox();
    protected ArrayList<String> m_shotColList = null;
    protected ArrayList<String> m_recColList = null;
    protected JButton m_btnReloadColumnList;
    protected JButton m_killPolygonButton;
    protected JButton m_reloadAllPlotsButton;
    protected JLabel m_mouseLabel = new JLabel("", 0);
    protected JCheckBox m_mouseTrackDot = new JCheckBox("Display dot at mouse location");
    protected JCheckBox m_mouseTrackLines = new JCheckBox("Display crosshairs at mouse location");
    protected JCheckBox m_chkLockAxes = new JCheckBox("Lock axes of all plots");
    protected JCheckBox m_chkShowAxes = new JCheckBox("Display horizontal and vertical axes");
    protected JCheckBox m_chkShowScroll = new JCheckBox("Display horizontal and vertical scroll bars");
    protected JComboBox<String> m_mouseCombo = new JComboBox();
    protected Range_Double m_rangeX = new Range_Double();
    protected Range_Double m_rangeY = new Range_Double();

    public MultiBasemapWidget() {
        super(1);
        try {
            this.m_subPlotWrapper = new SubPlotWrapper(this.m_plots);
            this.setRightComponent(this.m_subPlotWrapper);
            this.setLeftComponent(this.createLeftWidget());
            this.reloadColumns();
            Messenger.singleton().addListener(this);
            this.setPlotOptions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createLeftWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_cmbPlotCount.addItem("One");
            this.m_cmbPlotCount.addItem("Two by one");
            this.m_cmbPlotCount.addItem("Two by two");
            this.m_cmbPlotCount.addItem("Three by two");
            this.m_cmbPlotCount.addItem("Three by three");
            this.m_cmbPlotCount.setSelectedIndex(2);
            this.m_cmbPlotCount.addItemListener(this);
            main.addHorzPair(new JLabel("Window layout"), 0, this.m_cmbPlotCount, 10);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Display options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Shot size"), this.m_shotSizeText);
            grid.addSimple(row++, new JLabel("Shot symbol"), this.m_shotSymbolCombo);
            grid.addSimple(row++, new JLabel("Receiver size"), this.m_recSizeText);
            grid.addSimple(row++, new JLabel("Receiver symbol"), this.m_recSymbolCombo);
            this.m_shotSizeText.addActionListener(this);
            this.m_recSizeText.addActionListener(this);
            this.m_shotSymbolCombo.addItemListener(this);
            this.m_recSymbolCombo.addItemListener(this);
            this.m_reloadAllPlotsButton = main.createButton("Reload all plots", this, 0);
            this.m_btnReloadColumnList = main.createButton("Reload list of columns", this, 0);
            this.m_killPolygonButton = main.createButton("Clear project polygon", this, 0);
            for (MouseMode m : MouseMode.values()) {
                this.m_mouseCombo.addItem(m.Description);
            }
            this.m_mouseCombo.addItemListener(this);
            this.m_mouseCombo.setSelectedIndex(1);
            main.createGapLabel(20);
            main.addHorzPair(new JLabel("Mouse mode"), 0, this.m_mouseCombo, 7);
            main.createGapLabel(20);
            LinearLayoutWidget axes = main.createVertical(0, "Axis options", 0);
            axes.addComponent(this.m_chkLockAxes, 0);
            this.m_chkLockAxes.setSelected(false);
            this.m_chkLockAxes.addActionListener(this);
            axes.addComponent(this.m_chkShowAxes, 0);
            this.m_chkShowAxes.setSelected(true);
            this.m_chkShowAxes.addActionListener(this);
            axes.addComponent(this.m_chkShowScroll, 0);
            this.m_chkShowScroll.setSelected(true);
            this.m_chkShowScroll.addActionListener(this);
            main.createGapLabel(20);
            LinearLayoutWidget mouse = main.createVertical(0, "Mouse tracking options", 0);
            mouse.addComponent(this.m_mouseLabel, 0);
            mouse.addComponent(this.m_mouseTrackDot, 0);
            this.m_mouseTrackDot.setSelected(true);
            this.m_mouseTrackDot.addActionListener(this);
            mouse.addComponent(this.m_mouseTrackLines, 0);
            this.m_mouseTrackLines.setSelected(true);
            this.m_mouseTrackLines.addActionListener(this);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void mooz() {
        try {
            boolean rangeOK;
            if (!this.m_chkLockAxes.isSelected()) {
                return;
            }
            this.m_rangeY.clearRange();
            this.m_rangeX.clearRange();
            for (SubPlot p : this.m_plots) {
                p.Main.getRanges(this.m_rangeX, this.m_rangeY);
            }
            boolean bl = rangeOK = this.m_rangeX.rangeValid() && this.m_rangeY.rangeValid();
            if (!rangeOK) {
                return;
            }
            this.m_rangeX.addPercentBuffer(5.0);
            this.m_rangeY.addPercentBuffer(5.0);
            for (SubPlot p : this.m_plots) {
                p.Main.setRanges(this.m_rangeX, this.m_rangeY);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleMouseMove_Parent(SubPlot sender, Java2D_UserEventConsumer_MouseMove mouseMove) {
        try {
            int x = (int)mouseMove.WorldX;
            int y = (int)mouseMove.WorldY;
            String s = String.format("Mouse coordinates: (%d,  %d)", x, y);
            this.m_mouseLabel.setText(s);
            for (SubPlot p : this.m_plots) {
                p.MousePlotter.MouseX = mouseMove.WorldX;
                p.MousePlotter.MouseY = mouseMove.WorldY;
                p.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleScrollBarX_Parent(double min, double max) {
        try {
            for (SubPlot p : this.m_plots) {
                p.Main.transform().setDesiredWorldX(min, max);
                p.Main.transform().computeTransform();
                p.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleScrollBarY_Parent(double min, double max) {
        try {
            for (SubPlot p : this.m_plots) {
                p.Main.transform().setDesiredWorldY(min, max);
                p.Main.transform().computeTransform();
                p.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleZoomer_Parent(Java2D_UserEventConsumer_Rectangle zoomerRect) {
        try {
            if (!this.m_chkLockAxes.isSelected()) {
                return;
            }
            if (zoomerRect.RequestMooz) {
                this.mooz();
                return;
            }
            double minX = Math.min(zoomerRect.StartWorldX, zoomerRect.EndWorldX);
            double maxX = Math.max(zoomerRect.StartWorldX, zoomerRect.EndWorldX);
            double minY = Math.min(zoomerRect.StartWorldY, zoomerRect.EndWorldY);
            double maxY = Math.max(zoomerRect.StartWorldY, zoomerRect.EndWorldY);
            for (SubPlot p : this.m_plots) {
                p.Main.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                p.Main.transform().setDesiredWorldX(minX, maxX);
                p.Main.transform().setDesiredWorldY(minY, maxY);
                p.Main.transform().computeTransform();
                p.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            IDatabaseConnection db = RefractionStaticsProject.singleton().geometryDatabase();
            ArrayList<String> unionColList = new ArrayList<String>();
            this.m_recColList = db.listOfColumnNames("Receiver");
            this.m_shotColList = db.listOfColumnNames("Shot");
            for (String s : this.m_recColList) {
                unionColList.add(s);
            }
            for (String s : this.m_shotColList) {
                boolean ok = false;
                for (String s2 : unionColList) {
                    ok = ok || s2.equalsIgnoreCase(s);
                }
                if (ok) continue;
                unionColList.add(s);
            }
            Collections.sort(unionColList);
            for (SubPlot p : this.m_plots) {
                p.ColorCombo.setStringArray(unionColList);
                p.ShotColList = this.m_shotColList;
                p.RecColList = this.m_recColList;
            }
            unionColList.add(0, "None");
            for (SubPlot p : this.m_plots) {
                p.TextCombo.setStringArray(unionColList);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JDBC.MultiBasemapWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "MultiMap";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "MultiMap";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_reloadAllPlotsButton) {
                for (SubPlot p : this.m_plots) {
                    p.reloadPlot();
                }
                if (this.m_chkLockAxes.isSelected()) {
                    this.mooz();
                }
                return;
            }
            if (e.getSource() == this.m_mouseTrackLines || e.getSource() == this.m_mouseTrackDot) {
                for (SubPlot p : this.m_plots) {
                    p.MousePlotter.DrawDot = this.m_mouseTrackDot.isSelected();
                    p.MousePlotter.DrawLines = this.m_mouseTrackLines.isSelected();
                }
                return;
            }
            if (e.getSource() == this.m_chkShowScroll) {
                for (SubPlot p : this.m_plots) {
                    p.setShowScroll(this.m_chkShowScroll.isSelected());
                }
            }
            if (e.getSource() == this.m_chkShowAxes) {
                for (SubPlot p : this.m_plots) {
                    p.setShowAxes(this.m_chkShowAxes.isSelected());
                }
            }
            if (this.m_killPolygonButton == e.getSource()) {
                project.polygon().clear();
                project.savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, this);
                return;
            }
            if (e.getSource() == this.m_chkLockAxes) {
                for (SubPlot p : this.m_plots) {
                    p.AxesShared = this.m_chkLockAxes.isSelected();
                }
                if (this.m_chkLockAxes.isSelected()) {
                    this.mooz();
                }
                return;
            }
            if (this.m_btnReloadColumnList == e.getSource()) {
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_shotSizeText || e.getSource() == this.m_recSizeText) {
                this.setPlotOptions();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadAllPlots() {
        try {
            for (SubPlot p : this.m_plots) {
                p.reloadPlot();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void setPlotOptions() {
        try {
            int shotSize = Tools_Widget.extractInteger(this.m_shotSizeText, 50, 1, 500);
            int recSize = Tools_Widget.extractInteger(this.m_recSizeText, 50, 1, 500);
            for (SubPlot p : this.m_plots) {
                p.setPlotOptions(shotSize, recSize, this.m_shotSymbolCombo.selectedSymbol(), this.m_recSymbolCombo.selectedSymbol());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean needReplot;
            if (message == Messenger.Message.ProjectVersionChanged) {
                this.reloadColumns();
            }
            boolean bl = needReplot = message == Messenger.Message.ProjectPolygonModified || message == Messenger.Message.ProjectVersionChanged || message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ShotGeometryChanged || message == Messenger.Message.ShotKilled || message == Messenger.Message.ReceiverKilled || message == Messenger.Message.ProjectVersionChanged;
            if (needReplot) {
                this.reloadAllPlots();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_mouseCombo) {
                MouseMode[] arr = MouseMode.values();
                MouseMode mouseMode = arr[this.m_mouseCombo.getSelectedIndex()];
                for (SubPlot p : this.m_plots) {
                    p.setMouseMode(mouseMode);
                }
                return;
            }
            if (e.getSource() == this.m_cmbPlotCount) {
                int index = this.m_cmbPlotCount.getSelectedIndex();
                if (index == 0) {
                    this.m_subPlotWrapper.setNumRowsCols(1, 1);
                }
                if (index == 1) {
                    this.m_subPlotWrapper.setNumRowsCols(1, 2);
                }
                if (index == 2) {
                    this.m_subPlotWrapper.setNumRowsCols(2, 2);
                }
                if (index == 3) {
                    this.m_subPlotWrapper.setNumRowsCols(2, 3);
                }
                if (index == 4) {
                    this.m_subPlotWrapper.setNumRowsCols(3, 3);
                }
                return;
            }
            if (e.getSource() == this.m_recSymbolCombo || e.getSource() == this.m_shotSymbolCombo) {
                this.setPlotOptions();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public class SubPlotWrapper
    extends JPanel
    implements ComponentListener {
        protected ArrayList<SubPlot> m_plots = new ArrayList();
        protected int m_numRows = 2;
        protected int m_numCols = 2;

        public SubPlotWrapper(ArrayList<SubPlot> plots) {
            try {
                this.m_plots = plots;
                for (int n = 0; n < 9; ++n) {
                    SubPlot w = new SubPlot(n);
                    this.add(w);
                    this.m_plots.add(w);
                    w.setVisible(false);
                }
                this.setLayout(null);
                this.addComponentListener(this);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setNumRowsCols(int numRows, int numCols) {
            try {
                this.m_numRows = Math.max(numRows, 1);
                this.m_numRows = Math.min(this.m_numRows, 3);
                this.m_numCols = Math.max(numCols, 1);
                this.m_numCols = Math.min(this.m_numCols, 3);
                this.manualWidgetLayout();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void manualWidgetLayout() {
            try {
                Dimension size = this.getSize();
                int h = size.height / this.m_numRows;
                int w = size.width / this.m_numCols;
                if (h < 10) {
                    return;
                }
                int num = 0;
                for (int r = 0; r < this.m_numRows; ++r) {
                    for (int c = 0; c < this.m_numCols; ++c) {
                        SubPlot widget = this.m_plots.get(num);
                        widget.setVisible(true);
                        widget.setBounds(c * w, r * h, w, h);
                        widget.Visible = true;
                        ++num;
                    }
                }
                for (int n = num; n < this.m_plots.size(); ++n) {
                    this.m_plots.get(n).setVisible(false);
                    this.m_plots.get((int)n).Visible = false;
                }
                for (SubPlot p : this.m_plots) {
                    p.reloadPlot();
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            try {
                this.manualWidgetLayout();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    protected static enum MouseMode {
        Polygon("Define project polygon"),
        Shot("Select shot "),
        Receiver("Select receiver");

        public final String Description;

        private MouseMode(String desc) {
            this.Description = desc;
        }
    }

    public class SubPlot
    extends JPanel
    implements Java2D_VerticalColorCompositeWidget.Listener,
    Java2D_Widget.Listener,
    ComponentListener,
    ActionListener,
    GenericObjectListener.Listener,
    Java2D_ScrollBar.Listener {
        public Table_Abstract ShotTable = null;
        public Java2D_Paintable_Table ShotPaintable = null;
        public Table_Abstract ReceiverTable = null;
        public Java2D_Paintable_Table ReceiverPaintable = null;
        public Java2D_PointSymbol ShotSymbol = Java2D_PointSymbol.Plus;
        public Java2D_PointSymbol ReceiverSymbol = Java2D_PointSymbol.Plus;
        public int ShotSize = 50;
        public int ReceiverSize = 50;
        public ArrayList<String> ShotColList = new ArrayList();
        public ArrayList<String> RecColList = new ArrayList();
        public ComboStringListWrapper ColorCombo = new ComboStringListWrapper();
        public ComboStringListWrapper TextCombo = new ComboStringListWrapper();
        protected LinearLayoutWidget TopWidget = LinearLayoutWidget.horz(0, null);
        public Java2D_Widget Main;
        public Java2D_ScrollBar ScrollX;
        public Java2D_ScrollBar ScrollY;
        public Java2D_YAxisWidget AxisY = new Java2D_YAxisWidget();
        public Java2D_XAxisWidget AxisX = new Java2D_XAxisWidget();
        public Java2D_VerticalColorCompositeWidget VerticalColorWidget = null;
        public JCheckBox ShotCheck = new JCheckBox("Show Shots");
        public JCheckBox RecCheck = new JCheckBox("Show Rcvrs");
        public int Index = 0;
        public boolean Visible = false;
        public boolean AxesShared = false;
        public boolean DrawError = false;
        public boolean DrawMoves = false;
        public boolean ShowAxes = true;
        public boolean ShowScroll = true;
        public MouseMode m_mouseMode = MouseMode.Shot;
        public MouseLocationPlotter MousePlotter = new MouseLocationPlotter();
        public Java2D_UserEventConsumer_Rectangle ZoomerRect = new Java2D_UserEventConsumer_Rectangle();
        public Java2D_UserEventConsumer_ButtonPressed LeftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
        public Java2D_UserEventConsumer_MouseMove MouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
        public Java2D_UserEventConsumer_Line LineUEC = new Java2D_UserEventConsumer_Line();
        public Java2D_UserEventConsumer_MultiLineSegments PolygonUEC = new Java2D_UserEventConsumer_MultiLineSegments();

        public SubPlot(int n) {
            try {
                this.setLayout(null);
                this.Index = n;
                this.TopWidget.addComponent(new JLabel("Color"), 0);
                this.TopWidget.addComponent(this.ColorCombo, 5);
                this.TopWidget.addComponent(new JLabel("Text"), 0);
                this.TopWidget.addComponent(this.TextCombo, 5);
                this.TopWidget.addComponent(this.ShotCheck, 0);
                this.TopWidget.addComponent(this.RecCheck, 0);
                this.TopWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.TopWidget, -2, null, true);
                this.ShotCheck.setSelected(true);
                this.RecCheck.setSelected(true);
                this.ShotCheck.addActionListener(this);
                this.RecCheck.addActionListener(this);
                this.TextCombo.listener().addListener(this);
                this.ColorCombo.listener().addListener(this);
                this.VerticalColorWidget = new Java2D_VerticalColorCompositeWidget(this);
                Java2D_ColorArrayWrapper colorWrapper = this.VerticalColorWidget.getColorArrayWrapper();
                this.Main = new Java2D_Widget(colorWrapper);
                this.Main.addListener(this);
                this.ScrollX = new Java2D_ScrollBar(0, this);
                this.ScrollY = new Java2D_ScrollBar(1, this);
                this.add(this.ScrollX);
                this.add(this.ScrollY);
                this.add(this.TopWidget);
                this.add(this.Main);
                this.add(this.VerticalColorWidget);
                this.add(this.AxisX);
                this.add(this.AxisY);
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                this.addComponentListener(this);
                this.MouseMoveUEC.addListener(this);
                this.LeftClickUEC.addListener(this);
                this.LineUEC.addListener(this);
                this.PolygonUEC.addListener(this);
                this.PolygonUEC.DefiningPolygon = true;
                this.ZoomerRect.addListener(this);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setShowScroll(boolean show) {
            try {
                this.ShowScroll = show;
                this.manualWidgetLayout();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setShowAxes(boolean show) {
            try {
                this.ShowAxes = show;
                this.manualWidgetLayout();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setMouseMode(MouseMode mouseMode) {
            try {
                this.m_mouseMode = mouseMode;
                this.reloadUEC();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setPlotOptions(int shotSize, int recSize, Java2D_PointSymbol shotSym, Java2D_PointSymbol recSym) {
            try {
                this.ShotSymbol = shotSym;
                this.ReceiverSymbol = recSym;
                this.ShotSize = shotSize;
                this.ReceiverSize = recSize;
                if (this.ReceiverPaintable != null) {
                    this.ReceiverPaintable.Symbol = this.ReceiverSymbol;
                    this.ReceiverPaintable.Size_World = this.ReceiverSize;
                }
                if (this.ShotPaintable != null) {
                    this.ShotPaintable.Symbol = this.ShotSymbol;
                    this.ShotPaintable.Size_World = this.ShotSize;
                }
                this.Main.forceImageRepaint();
                this.Main.repaint();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void manualWidgetLayout() {
            try {
                Dimension total = this.getSize();
                int edge = 3;
                int totalWidth = total.width - 2 * edge;
                int totalHeight = total.height - 2 * edge;
                int horzAxisHeight = 34;
                int vertAxisWidth = 54;
                if (!this.ShowAxes) {
                    horzAxisHeight = 0;
                    vertAxisWidth = 0;
                }
                int scrollWidth = 18;
                int scrollHeight = 18;
                if (!this.ShowScroll) {
                    scrollWidth = 0;
                    scrollHeight = 0;
                }
                int vertColorWidth = 0;
                int horzColorHeight = 0;
                Dimension topDim = this.TopWidget.getPreferredSize();
                int topWidgetHeight = 3 + topDim.height;
                if (this.VerticalColorWidget != null) {
                    this.VerticalColorWidget.setVisible(true);
                    vertColorWidth = 100;
                }
                this.ScrollX.setVisible(this.ShowScroll);
                this.ScrollY.setVisible(this.ShowScroll);
                this.AxisX.setVisible(this.ShowAxes);
                this.AxisY.setVisible(this.ShowAxes);
                int mainWidth = totalWidth - vertAxisWidth - scrollWidth - vertColorWidth;
                int mainHeight = totalHeight - topWidgetHeight - horzAxisHeight - scrollHeight - horzColorHeight;
                if (mainWidth < 10 || mainHeight < 10) {
                    return;
                }
                int mainLeft = edge + vertAxisWidth;
                int mainTop = edge + horzAxisHeight + topWidgetHeight;
                int vertScrollLeft = mainLeft + mainWidth;
                int vertColorLeft = vertScrollLeft + scrollWidth;
                int horzScrollTop = mainTop + mainHeight;
                int horzColorTop = horzScrollTop + scrollHeight;
                if (this.VerticalColorWidget != null) {
                    this.VerticalColorWidget.setBounds(vertColorLeft, mainTop, vertColorWidth, mainHeight);
                }
                this.ScrollX.setBounds(mainLeft, horzScrollTop, mainWidth, scrollHeight);
                this.ScrollY.setBounds(vertScrollLeft, mainTop, scrollWidth, mainHeight);
                this.TopWidget.setBounds(edge, 0, totalWidth, topWidgetHeight);
                this.AxisX.setBounds(mainLeft, topWidgetHeight, mainWidth, horzAxisHeight);
                this.AxisY.setBounds(edge, mainTop, vertAxisWidth, mainHeight);
                this.Main.setBounds(mainLeft, mainTop, mainWidth, mainHeight);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
            try {
                this.AxisX.setRange(this.Main.transform().actualLeft(), this.Main.transform().actualRight());
                this.AxisY.setRange(this.Main.transform().actualTop(), this.Main.transform().actualBottom());
                if (this.VerticalColorWidget != null) {
                    this.VerticalColorWidget.repaintScale();
                }
                this.ScrollY.Technique = this.Main.transform().technique();
                this.ScrollX.Technique = this.Main.transform().technique();
                this.ScrollY.setValues(this.Main.rangeY().rangeMin(), this.Main.rangeY().rangeMax(), this.Main.transform().actualMinY(), this.Main.transform().actualMaxY());
                this.ScrollX.setValues(this.Main.rangeX().rangeMin(), this.Main.rangeX().rangeMax(), this.Main.transform().actualLeft(), this.Main.transform().actualRight());
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void handleScrollBar(Java2D_ScrollBar sender, int orientation, double min, double max) {
            try {
                if (!this.AxesShared) {
                    if (sender == this.ScrollX) {
                        this.Main.transform().setDesiredWorldX(min, max);
                        this.Main.forceImageRepaint();
                        this.Main.repaint();
                    }
                    if (sender == this.ScrollY) {
                        this.Main.transform().setDesiredWorldY(min, max);
                        this.Main.forceImageRepaint();
                        this.Main.repaint();
                    }
                } else {
                    if (sender == this.ScrollX) {
                        MultiBasemapWidget.this.handleScrollBarX_Parent(min, max);
                    }
                    if (sender == this.ScrollY) {
                        MultiBasemapWidget.this.handleScrollBarY_Parent(min, max);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void verticalColorMapCompositeChanged(Object sender) {
            try {
                this.Main.forceImageRepaint();
                this.Main.repaint();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void reloadUEC() {
            try {
                this.Main.clearEventConsumerList();
                this.Main.addEventConsumer(this.ZoomerRect);
                this.Main.addEventConsumer(this.MouseMoveUEC);
                if (this.m_mouseMode == MouseMode.Shot || this.m_mouseMode == MouseMode.Receiver) {
                    this.Main.addEventConsumer(this.LeftClickUEC);
                }
                if (this.m_mouseMode == MouseMode.Polygon) {
                    this.Main.addEventConsumer(this.PolygonUEC);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void reloadPlot() {
            try {
                this.Main.clearPaintableList();
                this.Main.clearEventConsumerList();
                if (!this.Visible) {
                    this.Main.mooz();
                    return;
                }
                this.ReceiverPaintable = null;
                this.ReceiverTable = null;
                this.ShotPaintable = null;
                this.ShotTable = null;
                Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
                this.Main.addPaintable(p, -9999);
                this.reloadTable("Shot", this.ShotColList);
                this.reloadTable("Receiver", this.RecColList);
                if (this.ShotCheck.isSelected() && this.ShotPaintable != null) {
                    this.Main.addPaintable(this.ShotPaintable, -9999);
                }
                if (this.RecCheck.isSelected() && this.ReceiverPaintable != null) {
                    this.Main.addPaintable(this.ReceiverPaintable, -9999);
                }
                if (!this.AxesShared) {
                    if (!this.Main.transform().transformValid()) {
                        this.Main.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                        this.Main.mooz();
                    } else {
                        this.Main.repaint();
                    }
                } else {
                    this.Main.repaint();
                }
                this.Main.addPaintable(this.MousePlotter, -9999);
                this.reloadUEC();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        protected void reloadTable(String tableName, ArrayList<String> columnList) {
            try {
                String query;
                IDatabaseConnection db = RefractionStaticsProject.singleton().geometryDatabase();
                Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
                Table_Abstract table = null;
                String colID = tableName + "ID";
                String axisC = this.ColorCombo.getSelectedString();
                boolean colorOK = Tools_Strings.listContainsString(columnList, axisC, true);
                colorOK = colorOK && db.columnExists(tableName, axisC);
                painter.FixedColor = Color.BLACK;
                painter.DrawTextLabels = this.TextCombo.getSelectedIndex() >= 1;
                painter.TextLabelColumn = this.TextCombo.getSelectedString();
                boolean textOK = false;
                if (painter.DrawTextLabels && painter.TextLabelColumn != null) {
                    textOK = Tools_Strings.listContainsString(columnList, painter.TextLabelColumn, true);
                    textOK = textOK && db.columnExists(tableName, painter.TextLabelColumn);
                }
                painter.FixedColor = new Color(0, 0, 0, 64);
                boolean errorOkay = this.DrawError && Tools_Strings.listContainsString(columnList, "GeomErr_Az", true) && Tools_Strings.listContainsString(columnList, "GeomErr_Dist", true);
                boolean loaded = false;
                painter.DrawErrorVectors = false;
                if (colorOK && !textOK) {
                    query = "";
                    query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, tableName);
                    table = db.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                    painter.setTable(table);
                    painter.setAxisC(axisC);
                    painter.DrawErrorVectors = errorOkay;
                    painter.UseColorScale = true;
                    painter.DrawMoveVectors = this.DrawMoves;
                    loaded = true;
                }
                if (colorOK && textOK) {
                    query = "";
                    query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, painter.TextLabelColumn, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, painter.TextLabelColumn, tableName);
                    table = db.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                    painter.setTable(table);
                    painter.setAxisC(axisC);
                    painter.DrawErrorVectors = errorOkay;
                    painter.UseColorScale = true;
                    painter.DrawMoveVectors = this.DrawMoves;
                    loaded = true;
                }
                if (!colorOK && textOK) {
                    query = "";
                    query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", colID, painter.TextLabelColumn, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", colID, painter.TextLabelColumn, tableName);
                    table = db.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                    painter.setTable(table);
                    painter.DrawErrorVectors = errorOkay;
                    painter.UseColorScale = false;
                    painter.DrawMoveVectors = this.DrawMoves;
                    loaded = true;
                }
                if (!loaded) {
                    query = "";
                    query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s FROM %s WHERE KILLED = FALSE", colID, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s FROM %s WHERE KILLED = FALSE", colID, tableName);
                    table = db.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                    painter.setTable(table);
                    painter.UseColorScale = false;
                    painter.DrawErrorVectors = errorOkay;
                    painter.DrawMoveVectors = this.DrawMoves;
                }
                painter.setAxisX("Easting");
                painter.setAxisY("Northing");
                painter.Size_UsePixel = false;
                if (tableName.equalsIgnoreCase("Shot")) {
                    painter.Size_World = this.ShotSize;
                    painter.Symbol = this.ShotSymbol;
                    this.ShotTable = table;
                    this.ShotPaintable = painter;
                }
                if (tableName.equalsIgnoreCase("Receiver")) {
                    painter.Size_World = this.ReceiverSize;
                    painter.Symbol = this.ReceiverSymbol;
                    this.ReceiverTable = table;
                    this.ReceiverPaintable = painter;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.reloadPlot();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        protected void handleZoomer() {
            try {
                if (this.ZoomerRect.Dragging) {
                    this.repaint();
                    return;
                }
                if (this.AxesShared) {
                    MultiBasemapWidget.this.handleZoomer_Parent(this.ZoomerRect);
                    return;
                }
                if (this.ZoomerRect.RequestMooz) {
                    this.Main.mooz();
                    return;
                }
                this.Main.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                double minX = Math.min(this.ZoomerRect.StartWorldX, this.ZoomerRect.EndWorldX);
                double maxX = Math.max(this.ZoomerRect.StartWorldX, this.ZoomerRect.EndWorldX);
                double minY = Math.min(this.ZoomerRect.StartWorldY, this.ZoomerRect.EndWorldY);
                double maxY = Math.max(this.ZoomerRect.StartWorldY, this.ZoomerRect.EndWorldY);
                this.Main.transform().setDesiredWorldX(minX, maxX);
                this.Main.transform().setDesiredWorldY(minY, maxY);
                this.Main.transform().computeTransform();
                this.Main.repaint();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void handleGenericObjectListener(Object sender, Object data) {
            try {
                if (sender == this.MouseMoveUEC) {
                    MultiBasemapWidget.this.handleMouseMove_Parent(this, this.MouseMoveUEC);
                    return;
                }
                if (sender == this.ZoomerRect) {
                    this.handleZoomer();
                    return;
                }
                if (sender == this.PolygonUEC) {
                    if (this.PolygonUEC.Dragging) {
                        return;
                    }
                    if (!this.PolygonUEC.Finished) {
                        return;
                    }
                    int num = this.PolygonUEC.numPoints();
                    if (this.PolygonUEC.numPoints() < 3) {
                        return;
                    }
                    Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
                    p.X = new double[num];
                    p.Y = new double[num];
                    for (int n = 0; n < num; ++n) {
                        p.X[n] = this.PolygonUEC.getX(n);
                        p.Y[n] = this.PolygonUEC.getY(n);
                    }
                    RefractionStaticsProject.singleton().savePolygon();
                    Messenger.broadcast(Messenger.Message.ProjectPolygonModified, sender, null);
                    this.reloadPlot();
                    return;
                }
                if (sender == this.LeftClickUEC) {
                    double x = this.LeftClickUEC.WorldX;
                    double y = this.LeftClickUEC.WorldY;
                    if (this.ShotTable != null && this.m_mouseMode == MouseMode.Shot && this.ShotTable.selectNearestSpatialPoint(x, y)) {
                        Messenger.broadcastShotSelected(this, this.ShotTable.SelectedID);
                    }
                    if (this.ReceiverTable != null && this.m_mouseMode == MouseMode.Receiver && this.ReceiverTable.selectNearestSpatialPoint(x, y)) {
                        Messenger.broadcastReceiverSelected(this, this.ReceiverTable.SelectedID);
                    }
                    return;
                }
                if (sender == this.ColorCombo || sender == this.TextCombo) {
                    this.reloadPlot();
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            try {
                this.manualWidgetLayout();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    protected class MouseLocationPlotter
    implements Java2D_PaintableInterface {
        public double MouseX;
        public double MouseY;
        public Color DotColor = new Color(192, 192, 192, 128);
        public boolean DrawDot = true;
        public boolean DrawLines = true;

        protected MouseLocationPlotter() {
        }

        @Override
        public boolean Java2D_ImageContentsDirty(int supplementalData) {
            return false;
        }

        @Override
        public int Java2D_MaximumPaintLevel(int supplementalData) {
            return 1;
        }

        @Override
        public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
            try {
                if (paintParameter.PaintLevel != 1) {
                    return;
                }
                Java2D_Transform transform = paintParameter.Transform;
                Graphics2D g2d = paintParameter.G2D;
                double scaleX = transform.scaleX();
                double shiftX = transform.shiftX();
                double scaleY = transform.scaleY();
                double shiftY = transform.shiftY();
                int ix = (int)(scaleX * this.MouseX + shiftX);
                int iy = (int)(scaleY * this.MouseY + shiftY);
                int size = 13;
                int h = size / 2;
                g2d.setColor(this.DotColor);
                if (this.DrawLines) {
                    g2d.drawLine(ix, 0, ix, transform.sizeY());
                    g2d.drawLine(0, iy, transform.sizeX(), iy);
                }
                if (this.DrawDot) {
                    g2d.fillOval(ix - h, iy - h, size, size);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        }

        @Override
        public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        }

        @Override
        public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
        }
    }
}

