/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Plugins.IPlugin;
import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.JDBC.AddColumnDialog;
import com.PecosLibrary.Windows.JDBC.ColumnMathDialog;
import com.PecosLibrary.Windows.JDBC.DeleteColumnsDialog;
import com.PecosLibrary.Windows.JDBC.ImportColumnDelimitedTableDialog;
import com.PecosLibrary.Windows.JDBC.ImportOtherProjectDialog;
import com.PecosLibrary.Windows.JDBC.OldQueryDialog;
import com.PecosLibrary.Windows.JDBC.OverwriteUsingImportedTableDialog;
import com.PecosLibrary.Windows.JDBC.OverwriteUsingImportedTableLPIDialog;
import com.PecosLibrary.Windows.JDBC.OverwriteUsingImportedTableOneKeyDialog;
import com.PecosLibrary.Windows.JDBC.SpatialModImportedDataDialog;
import com.PecosLibrary.Windows.JDBC.SqlStatementSelectorButton;
import com.PecosLibrary.Windows.JDBC.VersionImportDialog;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Refraction.Database.InterpolateValuesDialog;
import com.PecosLibrary.Windows.Refraction.Database.SetValueUsingPolygon;
import com.PecosLibrary.Windows.Refraction.Database.SmoothDialog;
import com.PecosLibrary.Windows.Refraction.Database.SmoothValueUsingPolygonDialog;
import com.PecosLibrary.Windows.Refraction.Database.ThreePointDialog;
import com.PecosLibrary.Windows.Refraction.Database.ZeroMeanDialog;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ElementTableBaseWidget
extends JSplitPane
implements ActionListener,
ListSelectionListener,
ItemListener,
Messenger.Listener,
PopupMenuButton.Listener,
SqlStatementSelectorButton.Listener,
GenericObjectListener.Listener,
MouseListener {
    protected String m_tableName;
    protected String m_IdColumnName;
    protected boolean m_tableHasIdColumn = false;
    protected boolean m_tableHasKilledColumn = false;
    protected ArrayList<String> m_columnNameList = null;
    protected DatabaseEnum m_whichDatabase;
    protected IDatabaseConnection m_db;
    protected ArrayList<String> m_selectedNameList = new ArrayList();
    protected JButton m_reloadColumnsButton;
    protected JButton m_selectAllButton;
    protected JList m_visibleColumnsList = new JList();
    protected JCheckBox m_chkDescPrimary = new JCheckBox("Descend");
    protected JCheckBox m_chkDescSecondary = new JCheckBox("Descend");
    protected JCheckBox m_chkOrderPrimary = new JCheckBox("Use");
    protected JCheckBox m_chkOrderSecondary = new JCheckBox("Use");
    protected ComboStringListWrapper m_comboSortPrimary = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboSortSecondary = new ComboStringListWrapper();
    protected JCheckBox m_chkFiltPrimary = new JCheckBox("Use");
    protected JCheckBox m_chkFiltSecondary = new JCheckBox("Use");
    protected ComboStringListWrapper m_comboFiltPrimary = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboFiltSecondary = new ComboStringListWrapper();
    protected JTextField m_txtFiltMinPrimary = new JTextField("0");
    protected JTextField m_txtFiltMaxPrimary = new JTextField("0");
    protected JTextField m_txtFiltMinSecondary = new JTextField("0");
    protected JTextField m_txtFiltMaxSecondary = new JTextField("0");
    protected JButton m_deleteColumnButton;
    protected JButton m_addColumnButton;
    protected JButton m_changeKilledButton;
    protected PopupMenuButton m_columnModPopup;
    protected String m_modSetPolygonFlag = "Flag shots and receivers inside polygon";
    protected String m_modColumnMath = "Open column math dialog";
    protected String m_modThreePoint = "Define plane using three points";
    protected String m_modSmooth = "Apply spatial smoother";
    protected String m_modSmoothElevation = "Smooth surface elevation";
    protected String m_modVersionCopy = "Copy data between versions";
    protected String m_modInterpolate = "Interpolate bad values";
    protected String m_modSetValueInsidePolygon = "Set value inside polygon";
    protected String m_modSmoothValueInsidePolygon = "Smooth value inside polygon";
    protected String m_modImportedData_Spatial = "Use data in an imported table (X,Y coords)";
    protected String m_modImportedData_LPI = "Use data in an imported table (Line/Point/Index)";
    protected String m_modImportedData_OneKey = "Use data in an imported table (use single identifier, such as FFID)";
    protected String m_modZeroMean = "Convert column to zero mean";
    protected String m_modSpatialModifyImportedDataUsingShotRec = "Modify using data in shot/receiver tables";
    protected String m_modImportLinePoint = "Import CSV file, overwrite delay time fields";
    protected PopupMenuButton m_importOtherProjectPopup;
    protected String m_importOtherProject_Coords = "Import data from another project using coordinates";
    protected PopupMenuButton m_exportPopup;
    protected String m_exportSelectedCSV = "Export selected data, CSV format";
    protected String m_exportSelectedColumn = "Export selected data, column-delimited format";
    protected ScrollTable m_scrollTable;
    protected JTextField m_selectSqlText = new JTextField("");
    protected JButton m_runQueryButton;
    protected JButton m_oldQueriesButton;
    protected JButton m_saveSqlButton;
    protected SqlStatementSelectorButton m_selectorButton;
    protected JLabel m_resultsLabel;
    protected JLabel m_statusLabel = new JLabel("");
    protected Table_Abstract m_table = null;
    protected Table_SimpleModel m_model = null;
    protected int m_selectedID = -9999;
    protected ArrayList<OldQuery> m_oldQueryList = new ArrayList();
    protected OverwriteUsingImportedTableDialog m_overwriteUsingImportedTableDialog = null;
    protected OverwriteUsingImportedTableLPIDialog m_overwriteUsingImportedTableLPIDialog = null;
    protected SpatialModImportedDataDialog m_SpatialModImportedDataDialog = null;
    protected VersionImportDialog m_versionImportDialog = null;
    protected ImportOtherProjectDialog m_ImportOtherProjectDialog = null;

    public ElementTableBaseWidget(IDatabaseConnection db, String tableName, DatabaseEnum whichDatabase) {
        super(1);
        try {
            this.m_db = db;
            this.m_whichDatabase = whichDatabase;
            this.m_tableName = tableName;
            this.m_IdColumnName = this.m_tableName + "ID";
            this.setLeftComponent(this.createLeftWidget());
            this.setRightComponent(this.createRightWidget());
            this.reloadListOfColumns();
            this.m_scrollTable.table().setSelectionMode(0);
            this.m_scrollTable.table().getSelectionModel().addListSelectionListener(this);
            JTableHeader header = this.m_scrollTable.table().getTableHeader();
            header.setReorderingAllowed(false);
            header.addMouseListener(this);
            Messenger.singleton().addListener(this);
            this.readOldQueries();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.buildQueryStatement();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean reload;
            if (message == Messenger.Message.ProjectVersionChanged || message == Messenger.Message.ColumnsModified) {
                this.reloadListOfColumns();
                this.m_scrollTable.table().setModel(new DefaultTableModel());
                return;
            }
            if (message == Messenger.Message.ShotSelected && this.m_tableName.equalsIgnoreCase("Shot")) {
                this.select(Messenger.shotID());
                return;
            }
            if (message == Messenger.Message.TraceSelected && this.m_tableName.equalsIgnoreCase("Shot")) {
                this.select(Messenger.shotID());
                return;
            }
            if (message == Messenger.Message.ReceiverSelected && this.m_tableName.equalsIgnoreCase("Receiver")) {
                this.select(Messenger.receiverID());
                return;
            }
            if (message == Messenger.Message.TraceSelected && this.m_tableName.equalsIgnoreCase("Receiver")) {
                this.select(Messenger.receiverID());
                return;
            }
            boolean bl = reload = message == Messenger.Message.ShotKilled || message == Messenger.Message.ReceiverKilled || message == Messenger.Message.ShotGeometryChanged || message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ShotPolarityFlipped || message == Messenger.Message.ReceiverPolarityFlipped;
            if (reload) {
                this.runQuery();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleSqlButton(SqlStatementSelectorButton button, String text) {
        try {
            text = text.toUpperCase();
            if (this.m_tableName.equalsIgnoreCase("Shot")) {
                text = text.replaceAll("TABLENAME", "SHOT");
            }
            if (this.m_tableName.equalsIgnoreCase("Receiver")) {
                text = text.replaceAll("TABLENAME", "RECEIVER");
            }
            this.m_selectSqlText.setText(text);
            this.runQuery();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void select(int id) {
        try {
            this.m_changeKilledButton.setEnabled(false);
            this.m_selectedID = -9999;
            if (this.m_table == null) {
                return;
            }
            if (!this.m_table.column_exists(this.m_IdColumnName)) {
                return;
            }
            JTable table = this.m_scrollTable.table();
            if (!(table.getModel() instanceof Table_SimpleModel)) {
                return;
            }
            if (this.m_model.getRowCount() != this.m_table.row_count()) {
                return;
            }
            int index = this.m_table.column_indexOfColumn(this.m_IdColumnName);
            int selRow = -999;
            for (int r = 0; r < this.m_table.row_count() && selRow < 0; ++r) {
                int tempID = this.m_table.getInt(r, index);
                if (tempID != id) continue;
                selRow = r;
            }
            if (selRow < 0) {
                return;
            }
            this.m_selectedID = id;
            table.setRowSelectionInterval(selRow, selRow);
            Rectangle rect = table.getCellRect(selRow, 0, true);
            table.scrollRectToVisible(rect);
            this.m_changeKilledButton.setEnabled(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return this.m_db;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightWidget() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sortAndFilt = w.createHorizontal(0, null, 0);
            GridLayoutWidget sortGrid = sortAndFilt.createGridLayoutWidget(0, "Sorting options", 5);
            sortGrid.addSimple(0, new JLabel("Primary"), this.m_comboSortPrimary, this.m_chkOrderPrimary, this.m_chkDescPrimary, 0, 10, 0, 0);
            sortGrid.addSimple(1, new JLabel("Secondary"), this.m_comboSortSecondary, this.m_chkOrderSecondary, this.m_chkDescSecondary, 0, 10, 0, 0);
            this.m_chkOrderPrimary.addActionListener(this);
            this.m_chkOrderSecondary.addActionListener(this);
            this.m_chkDescPrimary.addActionListener(this);
            this.m_chkDescSecondary.addActionListener(this);
            this.m_comboSortPrimary.listener().addListener(this);
            this.m_comboSortSecondary.listener().addListener(this);
            GridLayoutWidget filtGrid = sortAndFilt.createGridLayoutWidget(0, "Filtering options", 9);
            filtGrid.addSimple(0, new JLabel("Column:"), new JLabel(" "), new JLabel("Minimum"), new JLabel("Maximum"), 10, 0, 6, 6);
            filtGrid.addSimple(1, this.m_comboFiltPrimary, this.m_chkFiltPrimary, this.m_txtFiltMinPrimary, this.m_txtFiltMaxPrimary, 10, 0, 6, 6);
            filtGrid.addSimple(2, this.m_comboFiltSecondary, this.m_chkFiltSecondary, this.m_txtFiltMinSecondary, this.m_txtFiltMaxSecondary, 10, 0, 6, 6);
            this.m_chkFiltPrimary.addActionListener(this);
            this.m_chkFiltSecondary.addActionListener(this);
            this.m_txtFiltMinPrimary.addActionListener(this);
            this.m_txtFiltMinSecondary.addActionListener(this);
            this.m_txtFiltMaxPrimary.addActionListener(this);
            this.m_txtFiltMaxSecondary.addActionListener(this);
            this.m_comboFiltPrimary.listener().addListener(this);
            this.m_comboFiltSecondary.listener().addListener(this);
            LinearLayoutWidget top = w.createVertical(0, null, 0);
            LinearLayoutWidget query = top.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            query.addComponent(this.m_selectSqlText, 10);
            this.m_selectSqlText.addActionListener(this);
            this.m_runQueryButton = query.createButton("Run query", this, 0);
            LinearLayoutWidget button = top.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            this.m_selectorButton = new SqlStatementSelectorButton("Select", "Open saved SQL statement", this);
            button.addComponent(this.m_selectorButton, 0);
            this.m_saveSqlButton = button.createButton("Save current query", this, 0);
            this.m_oldQueriesButton = button.createButton("Prior queries dialog...", this, 0);
            this.m_resultsLabel = button.createLabel("", 2, 10);
            this.m_statusLabel = button.createLabel("", 4, 10);
            Tools_FontChanger.changeSizeOfFont(sortAndFilt, -2, null, true);
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            Tools_FontChanger.changeSizeOfFont(this.m_statusLabel, 2);
            this.m_scrollTable = new ScrollTable();
            w.addComponent(this.m_scrollTable, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeftWidget() {
        try {
            boolean readWriteOkay;
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_reloadColumnsButton = w.createButton("Reload list of columns", this, 0);
            this.m_selectAllButton = w.createButton("Clear selected columns (selects all!)", this, 0);
            w.createLabel("Select visible columns:", 2, 0);
            w.addComponent(new JScrollPane(this.m_visibleColumnsList), 10);
            this.m_visibleColumnsList.addListSelectionListener(this);
            this.m_addColumnButton = w.createButton("Add column", this, 0);
            this.m_deleteColumnButton = w.createButton("Drop nonrequired columns", this, 0);
            this.m_columnModPopup = new PopupMenuButton(null, "Column modifications...", this);
            w.addComponent(this.m_columnModPopup, 0);
            this.m_columnModPopup.addOption(this.m_modColumnMath);
            this.m_columnModPopup.addOption(this.m_modZeroMean);
            if (this.m_whichDatabase == DatabaseEnum.Geometry) {
                this.m_columnModPopup.addOption(this.m_modSetPolygonFlag);
                this.m_columnModPopup.addOption(this.m_modVersionCopy);
                this.m_columnModPopup.addOption(this.m_modInterpolate);
                this.m_columnModPopup.addOption(this.m_modThreePoint);
                this.m_columnModPopup.addOption(this.m_modSmooth);
                this.m_columnModPopup.addOption(this.m_modSmoothElevation);
                this.m_columnModPopup.addOption(this.m_modSetValueInsidePolygon);
                this.m_columnModPopup.addOption(this.m_modSmoothValueInsidePolygon);
                this.m_columnModPopup.addOption(this.m_modImportedData_OneKey);
                this.m_columnModPopup.addOption(this.m_modImportedData_Spatial);
                this.m_columnModPopup.addOption(this.m_modImportedData_LPI);
                this.m_columnModPopup.addOption(this.m_modImportLinePoint);
            }
            if (this.m_whichDatabase == DatabaseEnum.Import) {
                this.m_columnModPopup.addOption(this.m_modImportedData_OneKey);
                this.m_columnModPopup.addOption(this.m_modSpatialModifyImportedDataUsingShotRec);
            }
            if (readWriteOkay = true) {
                this.m_exportPopup = new PopupMenuButton(null, "Export options...", this);
                w.addComponent(this.m_exportPopup, 0);
                this.m_exportPopup.addOption(this.m_exportSelectedCSV);
                this.m_exportPopup.addOption(this.m_exportSelectedColumn);
            }
            if (DatabaseEnum.Geometry == this.m_whichDatabase) {
                this.m_importOtherProjectPopup = new PopupMenuButton(null, "Import from other project...", this);
                w.addComponent(this.m_importOtherProjectPopup, 0);
                this.m_importOtherProjectPopup.addOption(this.m_importOtherProject_Coords);
            }
            this.m_changeKilledButton = w.createButton("Kill / resurrect", this, 0);
            Tools_FontChanger.changeSizeOfFont(w, -2, null, true);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reloadListOfColumns() {
        try {
            this.m_selectedNameList.clear();
            this.m_visibleColumnsList.removeAll();
            this.m_tableHasIdColumn = false;
            this.m_tableHasKilledColumn = false;
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null) {
                if (plugin.overrideDataFormat()) {
                    if (plugin.getSeismicProject() == null) throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
                    this.m_columnNameList = plugin.getSeismicProject().getTable(this.m_tableName).column_listOfNames();
                } else {
                    this.m_columnNameList = this.database().listOfColumnNames(this.m_tableName);
                }
            } else {
                this.m_columnNameList = this.database().listOfColumnNames(this.m_tableName);
            }
            this.m_visibleColumnsList.setListData(this.m_columnNameList.toArray());
            this.m_comboFiltPrimary.setStringArray(this.m_columnNameList);
            this.m_comboFiltSecondary.setStringArray(this.m_columnNameList);
            this.m_comboSortPrimary.setStringArray(this.m_columnNameList);
            this.m_comboSortSecondary.setStringArray(this.m_columnNameList);
            for (String s : this.m_columnNameList) {
                this.m_tableHasIdColumn = this.m_tableHasIdColumn || s.equalsIgnoreCase(this.m_IdColumnName);
                this.m_tableHasKilledColumn = this.m_tableHasKilledColumn || s.equalsIgnoreCase("Killed");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.buildQueryStatement();
            return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void executeDeleteRows() {
        try {
            this.m_scrollTable.table().setModel(new DefaultTableModel());
            String sql = this.m_selectSqlText.getText();
            this.database().executeUpdateStatement(sql);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addOldQuery(String sql, String result) {
        try {
            OldQuery old = new OldQuery();
            old.Date = new Date().toString();
            old.SQL = sql;
            old.Result = result;
            this.m_oldQueryList.add(old);
            this.saveOldQueries();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void openOldQueryDialog() {
        try {
            OldQueryModel model = new OldQueryModel(this.m_oldQueryList);
            OldQueryDialog dialog = new OldQueryDialog(model, this.m_oldQueryList);
            if (dialog.OK && dialog.SelectedRow >= 0) {
                String sql = this.m_oldQueryList.get((int)dialog.SelectedRow).SQL;
                this.m_selectSqlText.setText(sql);
                this.runQuery();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void readOldQueries() {
        try {
            this.m_oldQueryList.clear();
            String filename = RefractionStaticsProject.singleton().projectPath() + "/OldQueries_" + this.m_tableName + ".data";
            if (!Tools_FileSystem.exists_file(filename)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(filename, "rw");
            int count = file.readInt();
            int version = file.readInt();
            if (version == 1000) {
                for (int n = 0; n < count; ++n) {
                    OldQuery old = new OldQuery();
                    old.Date = file.readUTF();
                    old.SQL = file.readUTF();
                    old.Result = file.readUTF();
                    this.m_oldQueryList.add(old);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void saveOldQueries() {
        try {
            String filename = RefractionStaticsProject.singleton().projectPath() + "/OldQueries_" + this.m_tableName + ".data";
            RandomAccessFile file = new RandomAccessFile(filename, "rw");
            int count = this.m_oldQueryList.size();
            int version = 1000;
            file.writeInt(count);
            file.writeInt(version);
            if (version == 1000) {
                for (OldQuery old : this.m_oldQueryList) {
                    file.writeUTF(old.Date);
                    file.writeUTF(old.SQL);
                    file.writeUTF(old.Result);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runQuery() {
        try {
            this.m_scrollTable.table().setModel(new DefaultTableModel());
            String sql = this.m_selectSqlText.getText();
            if (Tools_Strings.startsWithIgnoreCase(sql, "delete")) {
                this.executeDeleteRows();
                return;
            }
            if (!Tools_Strings.startsWithIgnoreCase(sql, "select")) {
                JOptionPane.showMessageDialog(null, "Only allowed to run SELECT or DELETE statements", "Query not valid", 0);
                this.m_resultsLabel.setText("Failed to execute SQL - only SELECT and DELETE allowed");
                this.m_resultsLabel.setForeground(Color.red);
                this.buildQueryStatement();
                return;
            }
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null) {
                if (plugin.overrideDataFormat()) {
                    if (plugin.getSeismicProject() == null) throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
                    this.m_table = plugin.getSeismicProject().getTable(this.m_tableName);
                } else {
                    this.m_table = this.database().extractTableDataUsingQuery(this.m_tableName, sql, Pecos.MaxQueryRowCount);
                }
            } else {
                this.m_table = this.database().extractTableDataUsingQuery(this.m_tableName, sql, Pecos.MaxQueryRowCount);
            }
            this.m_statusLabel.setText("");
            if (this.m_table != null) {
                this.m_model = new Table_SimpleModel(this.m_table);
                this.m_scrollTable.table().setModel(this.m_model);
                this.m_model.fireTableStructureChanged();
                this.m_resultsLabel.setText(String.format("Query returned %d rows", this.m_table.row_count()));
                this.m_resultsLabel.setForeground(Color.blue);
                if (!this.m_table.column_exists(this.m_IdColumnName)) {
                    this.m_statusLabel.setText("Cannot select or edit without " + this.m_IdColumnName + " column!");
                    this.m_statusLabel.setForeground(Color.red);
                }
                this.addOldQuery(sql, String.format("%d rows", this.m_table.row_count()));
            } else {
                this.m_resultsLabel.setText("Failed to execute query");
                this.m_resultsLabel.setForeground(Color.red);
                this.addOldQuery(sql, "Failed to execute");
            }
            this.select(-9999);
            return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected ArrayList<String> selArray(boolean addKilled, boolean addID) {
        try {
            int[] sel = this.m_visibleColumnsList.getSelectedIndices();
            boolean addedID = false;
            boolean addedKilled = false;
            ArrayList<String> list = new ArrayList<String>();
            for (int n = 0; n < sel.length; ++n) {
                String colName = this.m_columnNameList.get(sel[n]);
                addedID = addedID || colName.equalsIgnoreCase(this.m_IdColumnName);
                addedKilled = addedKilled || colName.equalsIgnoreCase("Killed");
                list.add(colName);
            }
            if (this.m_tableHasIdColumn && !addedID && addID) {
                list.add(this.m_IdColumnName);
            }
            if (this.m_tableHasKilledColumn && !addedKilled && addKilled) {
                list.add("Killed");
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected String buildWhere() {
        try {
            String pri = this.m_comboFiltPrimary.getSelectedString();
            String sec = this.m_comboFiltSecondary.getSelectedString();
            if (!this.m_chkFiltPrimary.isSelected()) {
                return "";
            }
            String where = " WHERE " + pri + " >= " + this.m_txtFiltMinPrimary.getText() + " AND " + pri + " <= " + this.m_txtFiltMaxPrimary.getText();
            if (this.m_chkFiltSecondary.isSelected()) {
                where = where + " AND " + sec + " >= " + this.m_txtFiltMinSecondary.getText() + " AND " + sec + " <= " + this.m_txtFiltMaxSecondary.getText();
            }
            return where + " ";
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    protected void buildQueryStatement() {
        try {
            int[] sel = this.m_visibleColumnsList.getSelectedIndices();
            Object query = "";
            if (sel == null || sel.length < 1) {
                query = "SELECT * FROM " + this.m_tableName;
            } else {
                this.m_selectedNameList = this.selArray(false, false);
                query = "SELECT " + this.m_selectedNameList.get(0);
                for (int n = 1; n < this.m_selectedNameList.size(); ++n) {
                    query = (String)query + ", " + this.m_selectedNameList.get(n);
                }
                query = (String)query + " FROM " + this.m_tableName;
            }
            query = (String)query + this.buildWhere();
            if (this.m_chkOrderPrimary.isSelected()) {
                query = (String)query + " ORDER BY " + this.m_comboSortPrimary.getSelectedString();
                if (this.m_chkDescPrimary.isSelected()) {
                    query = (String)query + " DESC ";
                }
                if (this.m_chkOrderSecondary.isSelected()) {
                    query = (String)query + ", " + this.m_comboSortSecondary.getSelectedString();
                    if (this.m_chkDescSecondary.isSelected()) {
                        query = (String)query + " DESC ";
                    }
                }
            }
            this.m_selectSqlText.setText((String)query);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
        try {
            String fileName;
            if (button == this.m_importOtherProjectPopup && text.equalsIgnoreCase(this.m_importOtherProject_Coords)) {
                if (this.m_ImportOtherProjectDialog == null) {
                    this.m_ImportOtherProjectDialog = new ImportOtherProjectDialog();
                }
                this.m_ImportOtherProjectDialog.showDialog();
                return;
            }
            if (button == this.m_columnModPopup && text.equalsIgnoreCase(this.m_modSpatialModifyImportedDataUsingShotRec)) {
                if (this.m_SpatialModImportedDataDialog == null) {
                    this.m_SpatialModImportedDataDialog = new SpatialModImportedDataDialog(this.m_tableName);
                }
                this.m_SpatialModImportedDataDialog.showDialog();
                return;
            }
            if (button == this.m_columnModPopup && text.equalsIgnoreCase(this.m_modColumnMath)) {
                ColumnMathDialog dlg = new ColumnMathDialog(this.m_tableName, null, "Column math", this.database());
                RefractionStaticsProject.singleton().reloadAllData();
                this.runQuery();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modVersionCopy)) {
                if (this.m_versionImportDialog == null) {
                    this.m_versionImportDialog = new VersionImportDialog(RefractionStaticsProject.singleton().versionName());
                }
                this.m_versionImportDialog.showDialog();
                RefractionStaticsProject.singleton().reloadAllData();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modSmooth)) {
                SmoothDialog dlg = new SmoothDialog();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modThreePoint)) {
                ThreePointDialog dlg = new ThreePointDialog();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modSmoothElevation)) {
                MultiTextDialog dlg = new MultiTextDialog(null, "Elevation smoothing radius", "Smoothing radius (ft/m)");
                dlg.setText(0, Double.toString(1000.0));
                dlg.showDialog("OK");
                if (!dlg.OK) {
                    return;
                }
                double radius = dlg.getDouble(0, 1000.0, 1.0, 100000.0);
                Tools_RefractionStaticsProject.smoothColumn_SpatialInterpolator("Elevation", radius);
                RefractionStaticsProject.singleton().reloadAllData();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modSetPolygonFlag)) {
                this.setPolygonFlag();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modInterpolate)) {
                InterpolateValuesDialog dlg = new InterpolateValuesDialog();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modSetValueInsidePolygon)) {
                Java2D_Polygon poly = RefractionStaticsProject.singleton().polygon();
                if (!poly.valid()) {
                    JOptionPane.showMessageDialog(null, "Define the project polygon in the basemap window first", "Polygon not valid", 0);
                    return;
                }
                SetValueUsingPolygon dlg = new SetValueUsingPolygon();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modSmoothValueInsidePolygon)) {
                Java2D_Polygon poly = RefractionStaticsProject.singleton().polygon();
                if (!poly.valid()) {
                    JOptionPane.showMessageDialog(null, "Define the project polygon in the basemap window first", "Polygon not valid", 0);
                    return;
                }
                SmoothValueUsingPolygonDialog dlg = new SmoothValueUsingPolygonDialog();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modZeroMean)) {
                ZeroMeanDialog dlg = new ZeroMeanDialog();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modImportedData_OneKey)) {
                ArrayList<String> list = RefractionStaticsProject.singleton().importDatabase().getTableNames();
                if (list.size() < 1) {
                    JOptionPane.showMessageDialog(null, "No imported tables", " ", 0);
                    return;
                }
                OverwriteUsingImportedTableOneKeyDialog dlg = new OverwriteUsingImportedTableOneKeyDialog(this.m_whichDatabase, this.m_tableName);
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Import && text.equalsIgnoreCase(this.m_modImportedData_OneKey)) {
                ArrayList<String> list = RefractionStaticsProject.singleton().importDatabase().getTableNames();
                if (list.size() < 1) {
                    JOptionPane.showMessageDialog(null, "No imported tables", " ", 0);
                    return;
                }
                OverwriteUsingImportedTableOneKeyDialog dlg = new OverwriteUsingImportedTableOneKeyDialog(this.m_whichDatabase, this.m_tableName);
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modImportedData_Spatial)) {
                ArrayList<String> list = RefractionStaticsProject.singleton().importDatabase().getTableNames();
                if (list.size() < 1) {
                    JOptionPane.showMessageDialog(null, "No imported tables", " ", 0);
                    return;
                }
                this.m_overwriteUsingImportedTableDialog = new OverwriteUsingImportedTableDialog(this.m_tableName);
                this.m_overwriteUsingImportedTableDialog.showDialog();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modImportedData_LPI)) {
                ArrayList<String> list = RefractionStaticsProject.singleton().importDatabase().getTableNames();
                if (list.size() < 1) {
                    JOptionPane.showMessageDialog(null, "No imported tables", " ", 0);
                    return;
                }
                if (this.m_overwriteUsingImportedTableLPIDialog == null) {
                    this.m_overwriteUsingImportedTableLPIDialog = new OverwriteUsingImportedTableLPIDialog(this.m_tableName);
                }
                this.m_overwriteUsingImportedTableLPIDialog.showDialog();
                return;
            }
            if (button == this.m_columnModPopup && this.m_whichDatabase == DatabaseEnum.Geometry && text.equalsIgnoreCase(this.m_modImportLinePoint)) {
                this.importLinePointCSV();
                return;
            }
            if (text.equalsIgnoreCase(this.m_exportSelectedCSV)) {
                fileName = Tools_Chooser.getSaveFileName("csv");
                if (fileName == null || this.m_table == null) {
                    return;
                }
                this.m_table.exportCSV(fileName);
            }
            if (text.equalsIgnoreCase(this.m_exportSelectedColumn)) {
                fileName = Tools_Chooser.getSaveFileName("txt");
                if (fileName == null || this.m_table == null) {
                    return;
                }
                this.m_table.exportColumn(fileName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void importLinePointCSV() {
        try {
            this.m_selectSqlText.setText("SELECT * FROM " + this.m_tableName);
            this.runQuery();
            String fileName = Tools_Chooser.getFileName();
            if (fileName.length() < 3) {
                return;
            }
            Table_Abstract table = Table_Memory.readCSV(fileName);
            int colLine = table.column_indexOfColumn("LineNumber");
            int colPoint = table.column_indexOfColumn("PointNumber");
            HashMap_Integers<Integer> map = new HashMap_Integers<Integer>();
            for (int r = 0; r < table.row_count(); ++r) {
                int line = table.getInt(r, colLine);
                int point = table.getInt(r, colPoint);
                map.put(r, line, point);
            }
            for (int b = 0; b < 6; ++b) {
                String col = "DelayTime_" + Integer.toString(b);
                if (table.column_exists(col)) {
                    this.importCrap(map, col, "DTA_" + col, table);
                }
                if (!table.column_exists(col = "Velocity_" + Integer.toString(b))) continue;
                this.importCrap(map, col, "DTA_" + col, table);
            }
            for (int c = 0; c < table.column_count(); ++c) {
                String col = table.column_name(c);
                if (!col.startsWith("Static")) continue;
                this.importCrap(map, col, col + "_Import", table);
            }
            this.reloadListOfColumns();
            this.runQuery();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void importCrap(HashMap_Integers<Integer> map, String col, String outputCol, Table_Abstract table) {
        try {
            int colLine = this.m_table.column_indexOfColumn("LineNumber");
            int colPoint = this.m_table.column_indexOfColumn("PointNumber");
            int colImp = table.column_indexOfColumn(col);
            int colOut = this.m_table.column_append(outputCol, DataType.Double);
            for (int r = 0; r < this.m_table.row_count(); ++r) {
                int point;
                int line = this.m_table.getInt(r, colLine);
                if (!map.containsKey(line, point = this.m_table.getInt(r, colPoint))) continue;
                int r1 = map.get(line, point);
                double v = table.getDouble(r1, colImp);
                this.m_table.putDouble(r, colOut, v);
            }
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(this.m_table, outputCol);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setPolygonFlag() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (p.polygon() == null) {
                JOptionPane.showMessageDialog(null, "Polygon not valid", "", 0);
                return;
            }
            if (!p.polygon().valid()) {
                JOptionPane.showMessageDialog(null, "Polygon not valid", "", 0);
                return;
            }
            this.setPolygonFlag(p.receiverTable());
            this.setPolygonFlag(p.shotTable());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setPolygonFlag(Table_Abstract table) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexP = table.column_append("InsidePolygon", DataType.Int);
            for (int row = 0; row < table.row_count(); ++row) {
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                if (p.polygon().contains(x, y)) {
                    table.putInt(row, indexP, 1);
                    continue;
                }
                table.putInt(row, indexP, 0);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(table, "InsidePolygon");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void importNewRows_PointNumber() {
        try {
            if (this.database() != RefractionStaticsProject.singleton().geometryDatabase()) {
                return;
            }
            ImportColumnDelimitedTableDialog dlg = new ImportColumnDelimitedTableDialog(null, "Select file", null, false);
            if (dlg.table() == null) {
                return;
            }
            Table_Abstract importTable = dlg.table();
            if (!importTable.column_exists("Easting")) {
                return;
            }
            if (!importTable.column_exists("Northing")) {
                return;
            }
            Table_Abstract geomTable = null;
            if (this.m_tableName.equalsIgnoreCase("Receiver")) {
                geomTable = RefractionStaticsProject.singleton().receiverTable();
            }
            if (this.m_tableName.equalsIgnoreCase("Shot")) {
                geomTable = RefractionStaticsProject.singleton().shotTable();
            }
            int initialRowCount = geomTable.row_count();
            HashMap_Integer fixedMap = new HashMap_Integer();
            int indexGeomEasting = geomTable.column_indexOfColumn("Easting");
            int indexGeomNorthing = geomTable.column_indexOfColumn("Northing");
            int indexGeomLineNumber = geomTable.column_indexOfColumn("LineNumber");
            int indexGeomPointNumber = geomTable.column_indexOfColumn("PointNumber");
            int indexGeomPointIndex = geomTable.column_indexOfColumn("PointIndex");
            int indexGeomKilled = geomTable.column_indexOfColumn("Killed");
            int indexGeomID = geomTable.column_indexOfColumn(this.m_tableName + "ID");
            fixedMap.put(indexGeomEasting, indexGeomEasting);
            fixedMap.put(indexGeomNorthing, indexGeomNorthing);
            fixedMap.put(indexGeomLineNumber, indexGeomLineNumber);
            fixedMap.put(indexGeomPointNumber, indexGeomPointNumber);
            fixedMap.put(indexGeomPointIndex, indexGeomPointIndex);
            fixedMap.put(indexGeomKilled, indexGeomKilled);
            fixedMap.put(indexGeomID, indexGeomID);
            HashMap_Integers<Integer> map = new HashMap_Integers<Integer>();
            int nextID = 1000;
            for (int r = 0; r < geomTable.row_count(); ++r) {
                nextID = Math.max(nextID, geomTable.getInt(r, indexGeomID));
                int line = geomTable.getInt(r, indexGeomLineNumber);
                int point = geomTable.getInt(r, indexGeomPointNumber);
                int index = geomTable.getInt(r, indexGeomPointIndex);
                map.put(new Integer(r), line, point, index);
            }
            ++nextID;
            int[] interpColumnIndex = new int[geomTable.column_count()];
            double[] interpSum = new double[geomTable.column_count()];
            double[] interpWeight = new double[geomTable.column_count()];
            int numInterp = 0;
            for (int n = 0; n < geomTable.column_count(); ++n) {
                if (fixedMap.containsKey(n)) continue;
                fixedMap.put(n, n);
                interpColumnIndex[numInterp] = n;
                ++numInterp;
            }
            int indexImportEasting = importTable.column_indexOfColumn("Easting");
            int indexImportNorthing = importTable.column_indexOfColumn("Northing");
            int indexImportLineNumber = -9999;
            int indexImportPointNumber = -9999;
            int indexImportPointIndex = -9999;
            if (importTable.column_exists("LineNumber")) {
                indexImportLineNumber = importTable.column_indexOfColumn("LineNumber");
            }
            if (importTable.column_exists("PointNumber")) {
                indexImportPointNumber = importTable.column_indexOfColumn("PointNumber");
            }
            if (importTable.column_exists("PointIndex")) {
                indexImportPointIndex = importTable.column_indexOfColumn("PointIndex");
            }
            for (int row = 0; row < importTable.row_count(); ++row) {
                System.out.println(String.valueOf(row));
                int line = 99999999;
                int point = 99999999;
                int index = 99999999;
                if (indexImportLineNumber >= 0) {
                    line = importTable.getInt(row, indexImportLineNumber);
                }
                if (indexImportPointNumber >= 0) {
                    point = importTable.getInt(row, indexImportPointNumber);
                }
                if (indexImportPointIndex >= 0) {
                    index = importTable.getInt(row, indexImportPointIndex);
                }
                if (map.containsKey(line, point, index)) continue;
                for (int n = 0; n < numInterp; ++n) {
                    interpSum[n] = 0.0;
                    interpWeight[n] = 1.0E-20;
                }
                double x = importTable.getDouble(row, indexImportEasting);
                double y = importTable.getDouble(row, indexImportNorthing);
                int newRow = geomTable.row_increment();
                map.put(new Integer(newRow), line, point, index);
                geomTable.putInt(newRow, indexGeomID, nextID);
                geomTable.putInt(newRow, indexGeomLineNumber, line);
                geomTable.putInt(newRow, indexGeomPointNumber, point);
                geomTable.putInt(newRow, indexGeomPointIndex, index);
                geomTable.putDouble(newRow, indexGeomEasting, x);
                geomTable.putDouble(newRow, indexGeomNorthing, y);
                ++nextID;
                for (int r = 0; r < geomTable.row_count() - 1; ++r) {
                    if (geomTable.getBool(r, indexGeomKilled)) continue;
                    double dx = x - geomTable.getDouble(r, indexGeomEasting);
                    double dy = y - geomTable.getDouble(r, indexGeomNorthing);
                    double dr2 = dx * dx + dy * dy;
                    double w = 100.0 / (100.0 + dr2);
                    int n = 0;
                    while (n < numInterp) {
                        int n2 = n;
                        interpSum[n2] = interpSum[n2] + w * geomTable.getDouble(r, interpColumnIndex[n]);
                        int n3 = n++;
                        interpWeight[n3] = interpWeight[n3] + w;
                    }
                }
                for (int n = 0; n < numInterp; ++n) {
                    double v = interpSum[n] / interpWeight[n];
                    geomTable.putDouble(newRow, interpColumnIndex[n], v);
                }
            }
            System.out.println("Begin database merge");
            RefractionStaticsProject.singleton().geometryDatabase().appendTable(geomTable, initialRowCount);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getSource() == this.m_scrollTable.table().getSelectionModel()) {
                if (this.m_table == null) {
                    return;
                }
                int row = this.m_scrollTable.table().getSelectedRow();
                if (row < 0 || row >= this.m_table.row_count()) {
                    return;
                }
                if (!this.m_table.column_exists(this.m_IdColumnName)) {
                    return;
                }
                int id = this.m_table.getInt(row, this.m_table.column_indexOfColumn(this.m_IdColumnName));
                if (this.m_table.name().equalsIgnoreCase("Receiver")) {
                    Messenger.broadcastReceiverSelected(this, id);
                }
                if (this.m_table.name().equalsIgnoreCase("Shot")) {
                    Messenger.broadcastShotSelected(this, id);
                }
                return;
            }
            if (e.getSource() == this.m_visibleColumnsList) {
                this.buildQueryStatement();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            JDialog dlg;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_oldQueriesButton) {
                this.openOldQueryDialog();
                return;
            }
            if (this.m_selectedID >= 0 && e.getSource() == this.m_changeKilledButton) {
                if (this.m_tableName.equalsIgnoreCase("Shot")) {
                    p.flipShotKilled(this.m_selectedID);
                }
                if (this.m_tableName.equalsIgnoreCase("Receiver")) {
                    p.flipReceiverKilled(this.m_selectedID);
                }
                int tempID = this.m_selectedID;
                this.runQuery();
                this.select(tempID);
                return;
            }
            if (e.getSource() == this.m_saveSqlButton) {
                String sql = this.m_selectSqlText.getText();
                if (sql.length() < 5) {
                    return;
                }
                if (!(sql = sql.toUpperCase()).startsWith("SELECT")) {
                    return;
                }
                SharedApplicationData.singleton().appendSQL("Select", sql);
                JOptionPane.showMessageDialog(null, "SQL statement saved", "", 1);
            }
            if (e.getSource() == this.m_deleteColumnButton) {
                dlg = new DeleteColumnsDialog(this.m_tableName, null, "Drop columns", this.database());
                if (dlg.Dropped && (this.m_tableName.equalsIgnoreCase("Receiver") || this.m_tableName.equalsIgnoreCase("Shot"))) {
                    RefractionStaticsProject.singleton().reloadAllData();
                    Messenger.broadcast(Messenger.Message.ColumnsModified, null, null);
                }
                this.reloadListOfColumns();
                return;
            }
            if (e.getSource() == this.m_addColumnButton) {
                dlg = new AddColumnDialog(this.m_tableName, null, "Add column", this.database(), RefractionStaticsProject.singleton().shotTable(), RefractionStaticsProject.singleton().receiverTable());
                this.reloadListOfColumns();
                return;
            }
            if (e.getSource() == this.m_selectSqlText) {
                this.runQuery();
                return;
            }
            if (e.getSource() == this.m_runQueryButton) {
                this.runQuery();
                return;
            }
            if (e.getSource() == this.m_reloadColumnsButton || e.getSource() == this.m_selectAllButton) {
                this.reloadListOfColumns();
                return;
            }
            if (e.getSource() == this.m_chkOrderPrimary || e.getSource() == this.m_chkOrderSecondary || e.getSource() == this.m_chkDescPrimary || e.getSource() == this.m_chkDescSecondary) {
                this.buildQueryStatement();
                return;
            }
            if (e.getSource() == this.m_chkFiltPrimary || e.getSource() == this.m_chkFiltSecondary || e.getSource() == this.m_txtFiltMinPrimary || e.getSource() == this.m_txtFiltMaxPrimary || e.getSource() == this.m_txtFiltMinSecondary || e.getSource() == this.m_txtFiltMaxSecondary) {
                this.buildQueryStatement();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        try {
            Table_Abstract table = this.m_table;
            if (this.m_table == null) {
                return;
            }
            TableColumnModel colModel = this.m_scrollTable.table().getColumnModel();
            int index = colModel.getColumnIndexAtX(event.getX());
            if (index < 0 || index >= this.m_table.column_count()) {
                return;
            }
            String col = this.m_table.column_name(index);
            String currSel = this.m_comboSortPrimary.getSelectedString();
            boolean same = false;
            if (currSel != null) {
                same = currSel.equalsIgnoreCase(col);
            }
            this.m_comboSortPrimary.setPreferredSelected(col);
            this.m_chkOrderPrimary.setSelected(true);
            if (same) {
                this.m_chkDescPrimary.setSelected(!this.m_chkDescPrimary.isSelected());
            }
            this.buildQueryStatement();
            this.runQuery();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            if (event.getSource() == this.m_visibleColumnsList) {
                int index = this.m_visibleColumnsList.locationToIndex(event.getPoint());
                if (index < 0 || index >= this.m_columnNameList.size()) {
                    return;
                }
                String s = this.m_columnNameList.get(index);
                s = s.toUpperCase();
                for (String s1 : this.m_selectedNameList) {
                    if (!s1.equalsIgnoreCase(s)) continue;
                    return;
                }
                this.m_selectedNameList.add(s);
                this.buildQueryStatement();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public void interpolateStatics() {
        try {
            String sql = "SELECT EASTING, NORTHING, KILLED, " + this.m_IdColumnName + " FROM " + this.m_tableName;
            Table_Abstract coordTable = RefractionStaticsProject.singleton().geometryDatabase().extractTableDataUsingQuery(this.m_tableName, sql, Pecos.MaxQueryRowCount);
            HashMap_Integer idMap_Coord = coordTable.createMapID();
            int indexKilled = coordTable.column_indexOfColumn("Killed");
            int indexX = coordTable.column_indexOfColumn("Easting");
            int indexY = coordTable.column_indexOfColumn("Northing");
            for (int i = 0; i < this.m_table.column_count(); ++i) {
                float stat;
                double y;
                double x;
                boolean killed;
                int n;
                if (!this.m_table.column_name(i).startsWith("STATICS")) continue;
                Grid3D grid = RefractionStaticsProject.singleton().getEmptyGrid3D();
                grid.interp_Prep();
                for (n = 0; n < this.m_table.row_count(); ++n) {
                    killed = this.m_table.getBool(n, indexKilled);
                    if (killed) continue;
                    x = this.m_table.getDouble(n, indexX);
                    y = this.m_table.getDouble(n, indexY);
                    stat = this.m_table.getFloat(n, i);
                    grid.interp_Add(x, y, stat, 1.0f);
                }
                grid.interp_Finish(0);
                for (n = 0; n < this.m_table.row_count(); ++n) {
                    killed = this.m_table.getBool(n, indexKilled);
                    if (!killed) continue;
                    x = this.m_table.getDouble(n, indexX);
                    y = this.m_table.getDouble(n, indexY);
                    stat = grid.getNearestValue(x, y, true);
                    this.m_table.putFloat(n, i, stat);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class OldQuery {
        public String Date = "";
        public String SQL = "";
        public String Result = "";

        protected OldQuery() {
        }
    }

    protected class OldQueryModel
    extends AbstractTableModel {
        protected ArrayList<OldQuery> m_list = new ArrayList();

        public OldQueryModel(ArrayList<OldQuery> oldQueryList) {
            this.m_list = oldQueryList;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                row = this.m_list.size() - row - 1;
                OldQuery old = this.m_list.get(row);
                if (column == 0) {
                    return old.Date;
                }
                if (column == 1) {
                    return old.SQL;
                }
                if (column == 2) {
                    return old.Result;
                }
                return "Error";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            if (this.m_list == null) {
                return 0;
            }
            return this.m_list.size();
        }

        @Override
        public int getColumnCount() {
            if (this.m_list == null) {
                return 0;
            }
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return "Date";
                }
                if (column == 1) {
                    return "SQL";
                }
                if (column == 2) {
                    return "Result";
                }
                return "Error";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

