/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.JDBC.HistogramWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorHistogramWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;

public class ColumnComparisonWidget
extends JSplitPane
implements INumberedWidget,
ActionListener,
GenericObjectListener.Listener,
Messenger.Listener,
ItemListener,
ISaveableFrame,
Java2D_Widget.Listener {
    protected Table_Abstract m_shotTable = null;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Table_Abstract m_receiverTable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected HistogramWidget m_histogramWidget = new HistogramWidget(this);
    protected Java2D_ColorHistogramWidget m_colorHistogram = new Java2D_ColorHistogramWidget(this);
    protected JButton m_reloadVersionsButton;
    protected ComboStringListWrapper m_comboCol1 = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboVer1 = new ComboStringListWrapper();
    protected JButton m_reloadColumnsButton1;
    protected ComboStringListWrapper m_comboCol2 = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboVer2 = new ComboStringListWrapper();
    protected JButton m_reloadColumnsButton2;
    protected JButton m_reloadPlotButton;
    protected JCheckBox m_chkRec = new JCheckBox("Show receivers");
    protected JCheckBox m_chkSrc = new JCheckBox("Show sources");
    protected Java2D_SimpleComposite m_plotWidget = new Java2D_SimpleComposite(true);
    protected JLabel m_plotLabel = new JLabel(" ", 0);
    protected JComboBox<String> m_mouseCombo = new JComboBox();
    protected MouseMode m_mouseMode = MouseMode.Shot;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected int m_widgetNumber = 1;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JDBC.ColumnComparisonWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Diff plot";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Diff plot";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public ColumnComparisonWidget() {
        super(1);
        try {
            this.setRightComponent(this.centralWidget());
            this.setLeftComponent(this.createMainWidget());
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.reloadVersions();
            this.reloadColumns1();
            this.reloadColumns2();
            this.reloadPlot();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (widget == this.m_plotWidget.mainWidget()) {
                this.m_colorHistogram.setColorArrayWrapper(this.m_plotWidget.getColorArrayWrapper());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
    }

    protected JComponent centralWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            Tools_FontChanger.changeSizeOfFont(this.m_plotLabel, 4);
            this.m_plotLabel.setForeground(Color.blue);
            main.addComponent(this.m_plotLabel, 0);
            main.addComponent(this.m_plotWidget, 10);
            this.m_plotWidget.setAllowRangeLocking(true);
            this.m_plotWidget.mainWidget().addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMainWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_reloadVersionsButton = main.createButton("Reload list of versions", this, 0);
            this.m_reloadColumnsButton1 = new JButton("Reload columns");
            this.m_reloadColumnsButton1.addActionListener(this);
            this.m_comboCol1.listener().addListener(this);
            this.m_comboVer1.listener().addListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "First column", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Version:"), this.m_comboVer1);
            grid.addSimple(row++, new JLabel("Name:"), this.m_comboCol1);
            grid.addSimple(row++, new JLabel(" "), this.m_reloadColumnsButton1);
            this.m_reloadColumnsButton2 = new JButton("Reload columns");
            this.m_reloadColumnsButton2.addActionListener(this);
            this.m_comboCol2.listener().addListener(this);
            this.m_comboVer2.listener().addListener(this);
            grid = main.createGridLayoutWidget(0, "Second column", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Version:"), this.m_comboVer2);
            grid.addSimple(row++, new JLabel("Name:"), this.m_comboCol2);
            grid.addSimple(row++, new JLabel(" "), this.m_reloadColumnsButton2);
            main.addComponent(this.m_chkSrc, 0);
            main.addComponent(this.m_chkRec, 0);
            this.m_chkSrc.setSelected(true);
            this.m_chkRec.setSelected(true);
            this.m_chkSrc.addActionListener(this);
            this.m_chkRec.addActionListener(this);
            this.m_reloadPlotButton = main.createButton("Reload plot", this, 0);
            LinearLayoutWidget mouse = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Mouse mode", 0);
            for (MouseMode m : MouseMode.values()) {
                this.m_mouseCombo.addItem(m.Description);
            }
            this.m_mouseCombo.addItemListener(this);
            this.m_mouseCombo.setSelectedIndex(0);
            mouse.addComponent(this.m_mouseCombo, 0);
            main.addComponent(this.m_colorHistogram, 10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean needReloadPlot;
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                // empty if block
            }
            boolean bl = needReloadPlot = message == Messenger.Message.ProjectPolygonModified || message == Messenger.Message.ProjectVersionChanged || message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ShotGeometryChanged;
            if (needReloadPlot) {
                this.reloadPlot();
            }
            if (message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ReceiverSelected) {
                return;
            }
            if (message == Messenger.Message.ShotGeometryChanged || message == Messenger.Message.ShotSelected) {
                return;
            }
            if (message == Messenger.Message.Bin3DSelected) {
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadVersions() {
        try {
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_comboVer1.setStringArray(versionList);
            this.m_comboVer2.setStringArray(versionList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMouse() {
        try {
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_leftClickUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            String colName1 = this.m_comboCol1.getSelectedString();
            String versionName1 = this.m_comboVer1.getSelectedString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName1);
            Table_Abstract shotTable1 = this.loadTable(database, "Shot", colName1);
            Table_Abstract recTable1 = this.loadTable(database, "Receiver", colName1);
            database = null;
            System.gc();
            String colName2 = this.m_comboCol2.getSelectedString();
            String versionName2 = this.m_comboVer2.getSelectedString();
            database = RefractionStaticsProject.singleton().getVersionDatabase(versionName2);
            Table_Abstract shotTable2 = this.loadTable(database, "Shot", colName2);
            Table_Abstract recTable2 = this.loadTable(database, "Receiver", colName2);
            database = null;
            System.gc();
            this.m_plotLabel.setText(String.format("%s:%s - %s:%s", versionName1, colName1, versionName2, colName2));
            this.m_histogramWidget.prepare();
            this.m_shotTable = new Table_Memory();
            this.m_shotTable.setName("Shot");
            int indexShotID = this.m_shotTable.column_append("ShotID", DataType.Int);
            int indexShotX = this.m_shotTable.column_append("Easting", DataType.Double);
            int indexShotY = this.m_shotTable.column_append("Northing", DataType.Double);
            int indexShotDiff = this.m_shotTable.column_append("Difference", DataType.Double);
            HashMap_Integer shotHash1 = shotTable1.createMapID();
            int indexShotID2 = shotTable2.column_indexOfColumn("ShotID");
            int indexShotX2 = shotTable2.column_indexOfColumn("Easting");
            int indexShotY2 = shotTable2.column_indexOfColumn("Northing");
            int indexShotVal1 = shotTable1.column_indexOfColumn(colName1);
            int indexShotVal2 = shotTable2.column_indexOfColumn(colName2);
            for (int row2 = 0; row2 < shotTable2.row_count(); ++row2) {
                int id2 = shotTable2.getInt(row2, indexShotID2);
                if (!shotHash1.containsKey(id2)) continue;
                int row1 = shotHash1.get(id2);
                double x = shotTable2.getDouble(row2, indexShotX2);
                double y = shotTable2.getDouble(row2, indexShotY2);
                double v1 = shotTable1.getDouble(row1, indexShotVal1);
                double v2 = shotTable2.getDouble(row2, indexShotVal2);
                int row = this.m_shotTable.row_increment();
                this.m_shotTable.putInt(row, indexShotID, id2);
                this.m_shotTable.putDouble(row, indexShotX, x);
                this.m_shotTable.putDouble(row, indexShotY, y);
                this.m_shotTable.putDouble(row, indexShotDiff, v1 - v2);
                this.m_histogramWidget.add(v1 - v2);
            }
            this.m_shotPaintable = this.getPainter(this.m_shotTable);
            this.m_receiverTable = new Table_Memory();
            this.m_receiverTable.setName("Receiver");
            int indexRecID = this.m_receiverTable.column_append("ReceiverID", DataType.Int);
            int indexRecX = this.m_receiverTable.column_append("Easting", DataType.Double);
            int indexRecY = this.m_receiverTable.column_append("Northing", DataType.Double);
            int indexRecDiff = this.m_receiverTable.column_append("Difference", DataType.Double);
            HashMap_Integer recHash1 = recTable1.createMapID();
            int indexRecID2 = recTable2.column_indexOfColumn("ReceiverID");
            int indexRecX2 = recTable2.column_indexOfColumn("Easting");
            int indexRecY2 = recTable2.column_indexOfColumn("Northing");
            int indexRecVal1 = recTable1.column_indexOfColumn(colName1);
            int indexRecVal2 = recTable2.column_indexOfColumn(colName2);
            for (int row2 = 0; row2 < recTable2.row_count(); ++row2) {
                int id2 = recTable2.getInt(row2, indexShotID2);
                if (!recHash1.containsKey(id2)) continue;
                int row1 = recHash1.get(id2);
                double x = recTable2.getDouble(row2, indexRecX2);
                double y = recTable2.getDouble(row2, indexRecY2);
                double v1 = recTable1.getDouble(row1, indexRecVal1);
                double v2 = recTable2.getDouble(row2, indexRecVal2);
                int row = this.m_receiverTable.row_increment();
                this.m_receiverTable.putInt(row, indexRecID, id2);
                this.m_receiverTable.putDouble(row, indexRecX, x);
                this.m_receiverTable.putDouble(row, indexRecY, y);
                this.m_receiverTable.putDouble(row, indexRecDiff, v1 - v2);
                this.m_histogramWidget.add(v1 - v2);
            }
            this.m_histogramWidget.finish();
            this.m_receiverPaintable = this.getPainter(this.m_receiverTable);
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            if (this.m_chkSrc.isSelected()) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_chkRec.isSelected()) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            this.reloadMouse();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract loadTable(IDatabaseConnection database, String tableName, String columnName) {
        try {
            String colID = tableName + "ID";
            String query = String.format("SELECT Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", columnName, colID, tableName);
            return database.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Java2D_Paintable_Table getPainter(Table_Abstract table) {
        try {
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            painter.FixedColor = Color.LIGHT_GRAY;
            painter.Size_Pixel = 5;
            painter.Symbol = Java2D_PointSymbol.FilledSquare;
            painter.setTable(table);
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            painter.setAxisC("Difference");
            painter.UseColorScale = true;
            return painter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadTable(String tableName, ArrayList<String> columnList) {
    }

    protected void reloadColumns1() {
        try {
            this.m_comboCol1.removeAllItems();
            String versionName = this.m_comboVer1.getSelectedString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> intersection = new ArrayList<String>();
            for (String rec : recColList) {
                boolean ok = false;
                for (String shot : shotColList) {
                    if (!rec.equalsIgnoreCase(shot)) continue;
                    ok = true;
                }
                if (!ok) continue;
                intersection.add(rec);
            }
            Collections.sort(intersection);
            this.m_comboCol1.setStringArray(intersection);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns2() {
        try {
            this.m_comboCol2.removeAllItems();
            String versionName = this.m_comboVer2.getSelectedString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> intersection = new ArrayList<String>();
            for (String rec : recColList) {
                boolean ok = false;
                for (String shot : shotColList) {
                    if (!rec.equalsIgnoreCase(shot)) continue;
                    ok = true;
                }
                if (!ok) continue;
                intersection.add(rec);
            }
            Collections.sort(intersection);
            this.m_comboCol2.setStringArray(intersection);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_reloadVersionsButton) {
                this.reloadVersions();
                this.reloadColumns1();
                this.reloadColumns2();
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_reloadColumnsButton1) {
                this.reloadColumns1();
                return;
            }
            if (e.getSource() == this.m_reloadColumnsButton2) {
                this.reloadColumns2();
                return;
            }
            if (e.getSource() == this.m_chkSrc || e.getSource() == this.m_chkRec) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_reloadPlotButton) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_reloadPlotButton) {
                this.reloadPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_comboVer2) {
                this.reloadColumns2();
                this.reloadPlot();
                return;
            }
            if (sender == this.m_comboVer1) {
                this.reloadColumns1();
                this.reloadPlot();
                return;
            }
            if (sender == this.m_histogramWidget) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_comboCol1) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_comboCol2) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_leftClickUEC) {
                double x = this.m_leftClickUEC.WorldX;
                double y = this.m_leftClickUEC.WorldY;
                if (this.m_receiverTable != null && this.m_mouseMode == MouseMode.Receiver && this.m_receiverTable.selectNearestSpatialPoint(x, y)) {
                    Messenger.broadcastReceiverSelected(this, this.m_receiverTable.SelectedID);
                }
                if (this.m_shotTable != null && this.m_mouseMode == MouseMode.Shot && this.m_shotTable.selectNearestSpatialPoint(x, y)) {
                    Messenger.broadcastShotSelected(this, this.m_shotTable.SelectedID);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected static enum MouseMode {
        Shot("Select shot "),
        Receiver("Select receiver");

        public final String Description;

        private MouseMode(String desc) {
            this.Description = desc;
        }
    }
}

