/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_RowModel;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.JDBC.FoldMapWidget;
import com.PecosLibrary.Windows.JDBC.ImportedTablePlotWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorHistogramWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleHeaderCrossplot;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_TextTable;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.ElementPlotOptionsWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class BasemapWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
Messenger.Listener,
ItemListener,
ISaveableFrame,
Java2D_Widget.Listener {
    protected ArrayList<String> m_shotColList = null;
    protected ArrayList<String> m_recColList = null;
    protected Table_Abstract m_shotTable = null;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Table_Abstract m_receiverTable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected Grid3D m_interpGrid;
    protected Grid3D m_foldGrid;
    protected ElementPlotOptionsWidget m_shotOptions = new ElementPlotOptionsWidget("Shot");
    protected ElementPlotOptionsWidget m_receiverOptions = new ElementPlotOptionsWidget("Receiver");
    protected ComboStringListWrapper m_cCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_textCombo = new ComboStringListWrapper();
    protected JButton m_reloadColumnsButton = new JButton("Reload list of columns");
    protected JButton m_reloadPlotButton = new JButton("Reload plot");
    protected JCheckBox m_chkGrid = new JCheckBox("Interpolate to grid");
    protected JComboBox m_cmbSmoothRadius = new JComboBox();
    protected JCheckBox m_chkGridUseShots = new JCheckBox("Use shots to interpolate grid");
    protected JCheckBox m_chkGridUseRecs = new JCheckBox("Use receivers to interpolate grid");
    protected Java2D_SimpleComposite m_plotWidget = new Java2D_SimpleComposite(true);
    protected Java2D_ColorHistogramWidget m_colorHistogram = new Java2D_ColorHistogramWidget(this);
    protected ImportedTablePlotWidget m_importWidget;
    protected FoldMapWidget m_foldWidget;
    protected boolean m_colorScaleInUse = false;
    protected Java2D_Paintable_TextTable m_textTablePO = null;
    protected int m_currentTableIndex = -9999;
    protected JTable m_selTable = new JTable();
    protected JTable m_shotRowTable = new JTable();
    protected Table_RowModel m_shotRowModel;
    protected JTable m_recRowTable = new JTable();
    protected Table_RowModel m_recRowModel;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected JButton m_killPolygonButton;
    protected JButton m_importPolygonButton;
    protected JTable m_polygonTable = new JTable();
    protected JButton m_exportPolygonButton;
    protected JComboBox<String> m_mouseCombo = new JComboBox();
    protected ButtonGroup m_radioGroupMouseMove = new ButtonGroup();
    protected JRadioButton m_radioSelectShotMouseMove = new JRadioButton("Select shot on mouse movement");
    protected JRadioButton m_radioSelectReceiverMouseMove = new JRadioButton("Select receiver on mouse movement");
    protected JRadioButton m_radioSelectNoneMouseMove = new JRadioButton("Select nothing on mouse movement");
    protected JCheckBox m_chkDrawMoves = new JCheckBox("Draw geometry correction vector");
    protected JCheckBox m_chkDrawError = new JCheckBox("Draw predicted error vector");
    protected JCheckBox m_chkDrawBranch = new JCheckBox("Draw branch assignment locations");
    protected JButton m_btnClearSelected;
    protected JLabel m_directionsLabel = new JLabel();
    protected String m_directionsSel;
    protected String m_directionsGrid3D;
    protected String m_directionsPolygon;
    protected JLabel m_infoLabel = new JLabel("", 0);
    protected MouseMode m_mouseMode = MouseMode.Shot;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC;
    protected Java2D_UserEventConsumer_Line m_lineUEC;
    protected Java2D_UserEventConsumer_MultiLineSegments m_polygonUEC;
    protected Ensemble m_ensemble = new Ensemble();
    protected Java2D_Paintable_EnsembleHeaderCrossplot m_paintableShot = new Java2D_Paintable_EnsembleHeaderCrossplot();
    protected Java2D_Paintable_EnsembleHeaderCrossplot m_paintableRec = new Java2D_Paintable_EnsembleHeaderCrossplot();

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JDBC.BasemapWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Basemap";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Basemap";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public BasemapWidget() {
        super(1);
        try {
            this.setRightComponent(this.centralWidget());
            this.setLeftComponent(this.createMainWidget());
            this.m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
            this.m_mouseMoveUEC.addListener(this);
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_lineUEC = new Java2D_UserEventConsumer_Line();
            this.m_lineUEC.addListener(this);
            this.m_polygonUEC = new Java2D_UserEventConsumer_MultiLineSegments();
            this.m_polygonUEC.addListener(this);
            this.m_polygonUEC.DefiningPolygon = true;
            this.m_paintableShot.setEnsemble(this.m_ensemble);
            this.m_paintableShot.setAxisX("Shot", "Easting");
            this.m_paintableShot.setAxisY("Shot", "Northing");
            this.m_paintableShot.Size = 9;
            this.m_paintableShot.FixedColor = new Color(0, 0, 255);
            this.m_paintableShot.Symbol = Java2D_PointSymbol.FilledOval;
            this.m_paintableShot.UseColorScale = false;
            this.m_paintableRec.setEnsemble(this.m_ensemble);
            this.m_paintableRec.setAxisX("Receiver", "Easting");
            this.m_paintableRec.setAxisY("Receiver", "Northing");
            this.m_paintableRec.Size = 9;
            this.m_paintableRec.FixedColor = new Color(255, 0, 0);
            this.m_paintableRec.Symbol = Java2D_PointSymbol.FilledOval;
            this.m_paintableRec.UseColorScale = false;
            this.reloadColumns();
            this.reloadPlot();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent centralWidget() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            LinearLayoutWidget right = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget pwidge = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Mouse, right, "Mouse mode");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.ShotTable, new JScrollPane(this.m_shotRowTable), "Shot table");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.ReceiverTable, new JScrollPane(this.m_recRowTable), "Receiver table");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.ImportedTable, new JScrollPane(this.m_selTable), "Imported data table");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.PreviousPicks, pwidge, "Polygon");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            pwidge.addComponent(new JScrollPane(this.m_polygonTable), 10);
            this.m_exportPolygonButton = pwidge.createButton("Export polygon", this, 0);
            this.m_shotRowTable.setGridColor(Color.LIGHT_GRAY);
            this.m_shotRowTable.setShowGrid(true);
            this.m_recRowTable.setGridColor(Color.LIGHT_GRAY);
            this.m_recRowTable.setShowGrid(true);
            this.m_selTable.setGridColor(Color.LIGHT_GRAY);
            this.m_selTable.setShowGrid(true);
            this.m_polygonTable.setGridColor(Color.LIGHT_GRAY);
            this.m_polygonTable.setShowGrid(true);
            right.setMaximumSize(new Dimension(250, 10000));
            this.m_infoLabel.setMinimumSize(new Dimension(200, 12));
            this.m_infoLabel.setForeground(Color.blue);
            right.addComponent(this.m_infoLabel, 0);
            LinearLayoutWidget mouse = right.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Mouse mode", 0);
            for (MouseMode m : MouseMode.values()) {
                this.m_mouseCombo.addItem(m.Description);
            }
            this.m_mouseCombo.addItemListener(this);
            this.m_mouseCombo.setSelectedIndex(1);
            this.m_directionsGrid3D = "<HTML>Left-click and drag to define grid azimuth. Redefining the grid will invalidate the refractor velocity grids, so all analysis will  need to be redone.</HTML>";
            this.m_directionsPolygon = "<HTML>Left-click to add corners, double-click to finish</HTML>";
            this.m_directionsSel = "<HTML>Hold down CTRL to select in all open windows. Hold down SHIFT to open geometry correction dialog (requires delay time solution)</HTML>";
            this.m_directionsLabel.setText(this.m_directionsPolygon);
            mouse.addComponent(this.m_mouseCombo, 0);
            mouse.addComponent(this.m_directionsLabel, 10);
            mouse.createGapLabel(20);
            mouse.addComponent(this.m_radioSelectShotMouseMove, 0);
            mouse.addComponent(this.m_radioSelectReceiverMouseMove, 0);
            mouse.addComponent(this.m_radioSelectNoneMouseMove, 0);
            this.m_radioGroupMouseMove.add(this.m_radioSelectShotMouseMove);
            this.m_radioGroupMouseMove.add(this.m_radioSelectReceiverMouseMove);
            this.m_radioGroupMouseMove.add(this.m_radioSelectNoneMouseMove);
            this.m_radioSelectNoneMouseMove.setSelected(true);
            this.m_btnClearSelected = right.createButton("Clear overlay ensemble", this, 0);
            this.m_killPolygonButton = right.createButton("clear project polygon", this, 0);
            this.m_importPolygonButton = right.createButton("Import polygon", this, 0);
            right.addStretch(5);
            right.addComponent(this.m_colorHistogram, 10);
            Tools_FontChanger.changeSizeOfFont(this.m_bitmapCardWidget, -2, null, true);
            splitter.setRightComponent(this.m_bitmapCardWidget);
            splitter.setLeftComponent(this.m_plotWidget);
            this.m_plotWidget.setScrollVisible(true, true);
            this.m_plotWidget.setAllowRangeLocking(true);
            this.m_plotWidget.mainWidget().addListener(this);
            splitter.setResizeWeight(1.0);
            splitter.setDividerLocation(600);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMainWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            JTabbedPane tabs = new JTabbedPane();
            this.m_receiverOptions.setSelectedSymbol(Java2D_PointSymbol.FilledSquare);
            this.m_receiverOptions.setSymbolColor(Color.black);
            this.m_shotOptions.setSelectedSymbol(Java2D_PointSymbol.FilledSquare);
            this.m_shotOptions.setSymbolColor(Color.black);
            this.m_receiverOptions.listener().addListener(this);
            this.m_shotOptions.listener().addListener(this);
            tabs.addTab("Shot options", this.m_shotOptions);
            tabs.addTab("Receiver options", this.m_receiverOptions);
            main.addComponent(tabs, 0);
            this.m_cmbSmoothRadius.addItem("Do not smooth");
            this.m_cmbSmoothRadius.setSelectedIndex(0);
            for (int n = 1; n <= 20; ++n) {
                this.m_cmbSmoothRadius.addItem(String.format("%d bins", n));
            }
            this.m_cmbSmoothRadius.setSelectedIndex(2);
            this.m_cmbSmoothRadius.addItemListener(this);
            this.m_reloadColumnsButton = new JButton("Reload list of columns");
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Color and text options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Color column:"), this.m_cCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_chkGrid);
            grid.addSimple(row++, new JLabel("Grid smooth radius"), this.m_cmbSmoothRadius);
            grid.addSimple(row++, new JLabel(" "), this.m_chkGridUseShots);
            grid.addSimple(row++, new JLabel(" "), this.m_chkGridUseRecs);
            grid.addSimple(row++, new JLabel("Text column:"), this.m_textCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_reloadColumnsButton);
            this.m_cCombo.addItemListener(this);
            this.m_textCombo.addItemListener(this);
            this.m_reloadColumnsButton.addActionListener(this);
            this.m_chkGrid.addActionListener(this);
            this.m_chkGridUseShots.addActionListener(this);
            this.m_chkGridUseRecs.addActionListener(this);
            this.m_cmbSmoothRadius.setEnabled(this.m_chkGrid.isSelected());
            this.m_chkGridUseShots.setEnabled(this.m_chkGrid.isSelected());
            this.m_chkGridUseRecs.setEnabled(this.m_chkGrid.isSelected());
            this.m_chkGridUseShots.setSelected(true);
            this.m_chkGridUseRecs.setSelected(true);
            JTabbedPane lowerTabs = new JTabbedPane();
            LinearLayoutWidget temp = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            temp.addComponent(this.m_chkDrawMoves, 0);
            temp.addComponent(this.m_chkDrawError, 0);
            temp.addComponent(this.m_chkDrawBranch, 0);
            temp.addStretch(7);
            this.m_chkDrawMoves.addActionListener(this);
            this.m_chkDrawError.addActionListener(this);
            this.m_chkDrawBranch.addActionListener(this);
            this.m_importWidget = new ImportedTablePlotWidget();
            this.m_foldWidget = new FoldMapWidget();
            lowerTabs.addTab("Fold map", this.m_foldWidget);
            lowerTabs.addTab("Imported data", this.m_importWidget);
            lowerTabs.addTab("Extras", temp);
            this.m_foldWidget.listener().addListener(this);
            main.addComponent(lowerTabs, 0);
            this.m_importWidget.listener().addListener(this);
            this.m_reloadPlotButton = main.createButton("Reload plot", this, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean needReloadPlot;
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                this.reloadColumns();
            }
            boolean bl = needReloadPlot = message == Messenger.Message.ProjectPolygonModified || message == Messenger.Message.ProjectVersionChanged || message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ShotGeometryChanged || message == Messenger.Message.ShotKilled || message == Messenger.Message.ReceiverKilled;
            if (needReloadPlot) {
                this.reloadPlot();
            }
            if (message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ReceiverSelected) {
                this.loadReceiver(Messenger.receiverID());
                return;
            }
            if (message == Messenger.Message.ShotGeometryChanged || message == Messenger.Message.ShotSelected) {
                this.loadShot(Messenger.shotID());
                return;
            }
            if (this.m_mouseMode == MouseMode.Shot && message == Messenger.Message.TraceSelected) {
                this.loadShot(Messenger.shotID());
                return;
            }
            if (this.m_mouseMode == MouseMode.Receiver && message == Messenger.Message.TraceSelected) {
                this.loadShot(Messenger.receiverID());
                return;
            }
            if (message == Messenger.Message.Bin2DSelected) {
                this.loadBin2D(Messenger.bin2D());
                return;
            }
            if (message == Messenger.Message.Bin3DSelected) {
                this.loadBin3D(Messenger.inline(), Messenger.crossline());
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMouse() {
        try {
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearEventConsumerList();
            w.addZoomer();
            MouseMode[] arr = MouseMode.values();
            this.m_mouseMode = arr[this.m_mouseCombo.getSelectedIndex()];
            w.addEventConsumer(this.m_mouseMoveUEC);
            if (this.m_mouseMode == MouseMode.Shot || this.m_mouseMode == MouseMode.Receiver || this.m_mouseMode == MouseMode.Midpoint) {
                w.addEventConsumer(this.m_leftClickUEC);
                this.m_directionsLabel.setText(this.m_directionsSel);
            }
            if (this.m_mouseMode == MouseMode.Polygon) {
                w.addEventConsumer(this.m_polygonUEC);
                this.m_directionsLabel.setText(this.m_directionsPolygon);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot_ColorGrid() {
        try {
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            String axisC = this.m_cCombo.getSelectedString();
            int rad = this.m_cmbSmoothRadius.getSelectedIndex();
            this.m_interpGrid = RefractionStaticsProject.singleton().getEmptyGrid3D();
            Tools_RefractionStaticsProject.interpolateGrid(this.m_interpGrid, axisC, rad, this.m_chkGridUseShots.isSelected(), this.m_chkGridUseRecs.isSelected());
            if (this.m_cmbSmoothRadius.getSelectedIndex() >= 1) {
                int smooth = this.m_cmbSmoothRadius.getSelectedIndex();
                this.m_interpGrid.smooth(smooth);
            }
            w.addPaintable(this.m_interpGrid, -9999);
            if (this.m_shotOptions.display()) {
                this.reloadTable("Shot", this.m_shotColList, this.m_shotOptions, true);
                if (this.m_shotPaintable != null) {
                    w.addPaintable(this.m_shotPaintable, -9999);
                }
            }
            if (this.m_receiverOptions.display()) {
                this.reloadTable("Receiver", this.m_recColList, this.m_receiverOptions, true);
                if (this.m_receiverPaintable != null) {
                    w.addPaintable(this.m_receiverPaintable, -9999);
                }
            }
            this.m_plotWidget.setColorTitle(axisC + this.setAverageValueString(axisC));
            Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
            w.addPaintable(p, -9999);
            if (this.m_chkDrawBranch.isSelected()) {
                RefractionStaticsProject.singleton();
                BranchAssignment ba = RefractionStaticsProject.delayTimeData().branchAssignment();
                w.addPaintable(ba, BranchAssignment.PlotType.Map.ordinal());
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            this.reloadMouse();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            if (this.m_chkGrid.isSelected()) {
                this.reloadPlot_ColorGrid();
                return;
            }
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            this.m_interpGrid = null;
            this.m_receiverPaintable = null;
            this.m_receiverTable = null;
            this.m_shotPaintable = null;
            this.m_shotTable = null;
            this.m_foldGrid = this.m_foldWidget.getFoldMap();
            this.m_colorScaleInUse = false;
            this.m_textTablePO = null;
            this.m_currentTableIndex = -9999;
            if (this.m_foldGrid == null && this.m_importWidget.plotSelected()) {
                this.m_colorScaleInUse = this.m_importWidget.plotColor();
                this.m_textTablePO = this.m_importWidget.getPaintable();
                w.addPaintable(this.m_textTablePO, -9999);
                if (this.m_colorScaleInUse) {
                    this.m_plotWidget.setColorTitle(this.m_importWidget.getColorAxis());
                }
            }
            Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
            w.addPaintable(p, -9999);
            if (this.m_chkDrawBranch.isSelected()) {
                RefractionStaticsProject.singleton();
                BranchAssignment ba = RefractionStaticsProject.delayTimeData().branchAssignment();
                w.addPaintable(ba, BranchAssignment.PlotType.Map.ordinal());
            }
            this.reloadTable("Shot", this.m_shotColList, this.m_shotOptions, false);
            this.reloadTable("Receiver", this.m_recColList, this.m_receiverOptions, false);
            if (this.m_foldGrid != null) {
                w.addPaintable(this.m_foldGrid, -9999);
                this.m_plotWidget.setColorTitle("Fold" + this.setAverageValueString("Fold"));
            }
            if (this.m_shotPaintable != null) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_receiverPaintable != null) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            w.addPaintable(this.m_paintableShot, -9999);
            w.addPaintable(this.m_paintableRec, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            this.reloadMouse();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadTable(String tableName, ArrayList<String> columnList, ElementPlotOptionsWidget options, boolean alwaysIgnoreColor) {
        try {
            String query;
            if (!options.display()) {
                return;
            }
            boolean init = true;
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            Table_Abstract table = null;
            String colID = tableName + "ID";
            String axisC = this.m_cCombo.getSelectedString();
            boolean colorOK = options.useColorScale() && Tools_Strings.listContainsString(columnList, axisC, true);
            boolean bl = colorOK = colorOK && this.database().columnExists(tableName, axisC);
            if (alwaysIgnoreColor) {
                colorOK = false;
            }
            painter.FixedColor = options.symbolColor();
            painter.Size_Pixel = options.symbolSize(1, 500);
            painter.Symbol = options.selectedSymbol();
            painter.DrawTextLabels = this.m_textCombo.getSelectedIndex() >= 1;
            painter.TextLabelColumn = this.m_textCombo.getSelectedString();
            boolean textOK = false;
            if (painter.DrawTextLabels && painter.TextLabelColumn != null) {
                textOK = Tools_Strings.listContainsString(columnList, painter.TextLabelColumn, true);
                boolean bl2 = textOK = textOK && this.database().columnExists(tableName, painter.TextLabelColumn);
            }
            if (this.m_colorScaleInUse) {
                painter.FixedColor = new Color(0, 0, 0, 64);
            }
            colorOK = this.m_foldGrid == null && colorOK && !this.m_colorScaleInUse;
            boolean errorOkay = this.m_chkDrawError.isSelected() && Tools_Strings.listContainsString(columnList, "GeomErr_Az", true) && Tools_Strings.listContainsString(columnList, "GeomErr_Dist", true);
            boolean loaded = false;
            painter.DrawErrorVectors = false;
            if (colorOK && !textOK) {
                query = "";
                query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, tableName);
                table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.setAxisC(axisC);
                painter.DrawErrorVectors = errorOkay;
                painter.UseColorScale = true;
                painter.DrawMoveVectors = this.m_chkDrawMoves.isSelected();
                if (this.m_shotTable != null && this.m_receiverTable != null) {
                    this.m_plotWidget.setColorTitle(axisC + this.setAverageValueString(axisC));
                    init = false;
                }
                loaded = true;
            }
            if (colorOK && textOK) {
                query = "";
                query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, painter.TextLabelColumn, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s, %s, %s FROM %s WHERE KILLED = FALSE", axisC, colID, painter.TextLabelColumn, tableName);
                table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.setAxisC(axisC);
                painter.DrawErrorVectors = errorOkay;
                painter.UseColorScale = true;
                painter.DrawMoveVectors = this.m_chkDrawMoves.isSelected();
                if (this.m_shotTable != null && this.m_receiverTable != null) {
                    this.m_plotWidget.setColorTitle(axisC + this.setAverageValueString(axisC));
                    init = false;
                }
                loaded = true;
            }
            if (!colorOK && textOK) {
                query = "";
                query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", colID, painter.TextLabelColumn, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", colID, painter.TextLabelColumn, tableName);
                table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.DrawErrorVectors = errorOkay;
                painter.UseColorScale = false;
                painter.DrawMoveVectors = this.m_chkDrawMoves.isSelected();
                loaded = true;
            }
            if (!loaded) {
                query = "";
                query = errorOkay ? String.format("SELECT GeomErr_Az, GeomErr_Dist, InitialEasting, InitialNorthing, Easting, Northing, %s FROM %s WHERE KILLED = FALSE", colID, tableName) : String.format("SELECT InitialEasting, InitialNorthing, Easting, Northing, %s FROM %s WHERE KILLED = FALSE", colID, tableName);
                table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.UseColorScale = false;
                painter.DrawErrorVectors = errorOkay;
                painter.DrawMoveVectors = this.m_chkDrawMoves.isSelected();
            }
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            if (tableName.equalsIgnoreCase("Shot")) {
                this.m_shotTable = table;
                this.m_shotPaintable = painter;
            }
            if (tableName.equalsIgnoreCase("Receiver")) {
                this.m_receiverTable = table;
                this.m_receiverPaintable = painter;
            }
            if (init) {
                if (this.m_shotTable != null && this.m_receiverTable != null) {
                    this.m_plotWidget.setColorTitle(axisC + this.setAverageValueString(axisC));
                } else {
                    this.m_plotWidget.setColorTitle(axisC);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadColumns() {
        try {
            this.m_cCombo.removeAllItems();
            ArrayList<String> unionColList = new ArrayList<String>();
            this.m_recColList = this.database().listOfColumnNames("Receiver");
            this.m_shotColList = this.database().listOfColumnNames("Shot");
            for (String s : this.m_recColList) {
                unionColList.add(s);
            }
            for (String s : this.m_shotColList) {
                boolean ok = false;
                for (String s2 : unionColList) {
                    ok = ok || s2.equalsIgnoreCase(s);
                }
                if (ok) continue;
                unionColList.add(s);
            }
            Collections.sort(unionColList);
            this.m_cCombo.setStringArray(unionColList);
            unionColList.add(0, "None");
            this.m_textCombo.setStringArray(unionColList);
            this.m_shotRowModel = new Table_RowModel(RefractionStaticsProject.singleton().shotTable());
            this.m_shotRowTable.setModel(this.m_shotRowModel);
            this.m_recRowModel = new Table_RowModel(RefractionStaticsProject.singleton().receiverTable());
            this.m_recRowTable.setModel(this.m_recRowModel);
            Java2D_Polygon polygon = RefractionStaticsProject.singleton().polygon();
            if (polygon.valid()) {
                Table_Memory polyTable = new Table_Memory();
                int indexX = polyTable.column_append("X", DataType.Double);
                int indexY = polyTable.column_append("Y", DataType.Double);
                for (int n = 0; n < polygon.X.length; ++n) {
                    polyTable.row_increment();
                    polyTable.putDouble(n, indexX, polygon.X[n]);
                    polyTable.putDouble(n, indexY, polygon.Y[n]);
                }
                Table_SimpleModel polyModel = new Table_SimpleModel(polyTable);
                this.m_polygonTable.setModel(polyModel);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_cCombo || e.getSource() == this.m_textCombo || e.getSource() == this.m_cmbSmoothRadius) {
                this.reloadPlot();
            }
            if (e.getSource() == this.m_mouseCombo) {
                this.m_paintableShot.PaintOK = false;
                this.m_paintableRec.PaintOK = false;
                this.m_plotWidget.mainWidget().repaint();
                this.reloadMouse();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importPolygon() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String fileName = Tools_Chooser.getFileName();
            if (fileName.isEmpty()) {
                return;
            }
            File file = new File(fileName);
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            project.polygon().clear();
            double[] arrx = new double[10000];
            double[] arry = new double[10000];
            int num = 0;
            while (line != null) {
                ArrayList<String> tokens = Tools_Strings.tokenizer(line);
                arrx[num] = Double.parseDouble(tokens.get(0));
                arry[num] = Double.parseDouble(tokens.get(1));
                ++num;
                line = br.readLine();
            }
            project.polygon().X = new double[num];
            project.polygon().Y = new double[num];
            for (int n = 0; n < num; ++n) {
                project.polygon().X[n] = arrx[n];
                project.polygon().Y[n] = arry[n];
            }
            project.savePolygon();
            Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_cmbSmoothRadius.setEnabled(this.m_chkGrid.isSelected());
            this.m_chkGridUseShots.setEnabled(this.m_chkGrid.isSelected());
            this.m_chkGridUseRecs.setEnabled(this.m_chkGrid.isSelected());
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (this.m_killPolygonButton == e.getSource()) {
                project.polygon().clear();
                project.savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, this);
                return;
            }
            if (this.m_importPolygonButton == e.getSource()) {
                this.importPolygon();
                return;
            }
            if (e.getSource() == this.m_btnClearSelected) {
                this.clearSelected();
                return;
            }
            if (e.getSource() == this.m_reloadColumnsButton) {
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_chkDrawMoves || e.getSource() == this.m_chkDrawError || e.getSource() == this.m_reloadPlotButton || e.getSource() == this.m_chkDrawBranch || e.getSource() == this.m_chkGrid || e.getSource() == this.m_chkGridUseShots || e.getSource() == this.m_chkGridUseRecs) {
                this.m_paintableShot.PaintOK = false;
                this.m_paintableRec.PaintOK = false;
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_exportPolygonButton) {
                RefractionStaticsProject.singleton().polygon().writeToXML();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void testPolygon() {
        try {
            Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
            double x = this.m_leftClickUEC.WorldX;
            double y = this.m_leftClickUEC.WorldY;
            if (p.contains(x, y)) {
                System.out.println("inside");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleMouseMoveUEC() {
        try {
            Grid3D_Conversion grid = RefractionStaticsProject.singleton().getGrid3D_Conversion();
            try {
                grid.setWorldLocation(this.m_mouseMoveUEC.WorldX, this.m_mouseMoveUEC.WorldY);
                String s = String.format("X=%d  Y=%d     I=%d  C=%d", (int)this.m_mouseMoveUEC.WorldX, (int)this.m_mouseMoveUEC.WorldY, grid.Inline, grid.Crossline);
                this.m_infoLabel.setText(s);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (this.m_radioSelectShotMouseMove.isSelected()) {
                project.selectShotOnMouseMove(this, this.m_mouseMoveUEC.WorldX, this.m_mouseMoveUEC.WorldY);
                return;
            }
            if (this.m_radioSelectReceiverMouseMove.isSelected()) {
                project.selectReceiverOnMouseMove(this, this.m_mouseMoveUEC.WorldX, this.m_mouseMoveUEC.WorldY);
                return;
            }
            if (this.m_shotTable != null && this.m_shotRowModel != null) {
                project.shotTable().selectNearestSpatialPoint_MouseMove(this.m_mouseMoveUEC.WorldX, this.m_mouseMoveUEC.WorldY);
                if (project.shotTable().MouseMoveChanged) {
                    this.m_shotRowModel.setSelectedRow(project.shotTable().MouseMoveRow);
                }
            }
            if (this.m_receiverTable != null && this.m_recRowModel != null) {
                project.receiverTable().selectNearestSpatialPoint_MouseMove(this.m_mouseMoveUEC.WorldX, this.m_mouseMoveUEC.WorldY);
                if (project.receiverTable().MouseMoveChanged) {
                    this.m_recRowModel.setSelectedRow(project.receiverTable().MouseMoveRow);
                }
            }
            if (this.m_textTablePO != null) {
                int nearestIndex = this.m_textTablePO.getNearestIndex(this.m_mouseMoveUEC.PixelX, this.m_mouseMoveUEC.PixelY);
                if (nearestIndex == this.m_currentTableIndex) {
                    return;
                }
                this.m_currentTableIndex = nearestIndex;
                this.m_textTablePO.selectRow(this.m_currentTableIndex);
                Table_Abstract table = this.m_textTablePO.getSelectedRowTable();
                this.m_selTable.setModel(new Table_SimpleModel(table));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (widget == this.m_plotWidget.mainWidget()) {
                this.m_colorHistogram.setColorArrayWrapper(this.m_plotWidget.getColorArrayWrapper());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_foldWidget) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_importWidget) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_shotOptions) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_receiverOptions) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_polygonUEC) {
                if (this.m_polygonUEC.Dragging) {
                    return;
                }
                if (!this.m_polygonUEC.Finished) {
                    return;
                }
                int num = this.m_polygonUEC.numPoints();
                if (this.m_polygonUEC.numPoints() < 3) {
                    return;
                }
                Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
                p.X = new double[num];
                p.Y = new double[num];
                for (int n = 0; n < num; ++n) {
                    p.X[n] = this.m_polygonUEC.getX(n);
                    p.Y[n] = this.m_polygonUEC.getY(n);
                }
                RefractionStaticsProject.singleton().savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, sender, null);
            }
            if (sender == this.m_mouseMoveUEC) {
                this.handleMouseMoveUEC();
                return;
            }
            if (sender == this.m_lineUEC) {
                int off = (int)this.m_lineUEC.Offset;
                double az = this.m_lineUEC.Azimuth * 180.0 / Math.PI;
                if (this.m_lineUEC.Dragging) {
                    String s = "Distance: " + Integer.toString(off) + " Azimuth: " + Tools_Strings.getString(az, 2);
                    this.m_infoLabel.setText(s);
                    return;
                }
                this.m_infoLabel.setText("");
                this.m_plotWidget.mainWidget().repaint();
                if (this.m_lineUEC.TinyLine) {
                    return;
                }
            }
            if (sender == this.m_leftClickUEC) {
                double x = this.m_leftClickUEC.WorldX;
                double y = this.m_leftClickUEC.WorldY;
                if (this.m_mouseMode == MouseMode.Midpoint && RefractionStaticsProject.singleton().dim2D()) {
                    IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                    int bin = grid2D.getBin(x, y);
                    if (this.m_leftClickUEC.ControlDown) {
                        Messenger.broadcastBin2DSelected(this, bin);
                    } else {
                        this.loadBin2D(bin);
                    }
                }
                if (this.m_mouseMode == MouseMode.Midpoint && RefractionStaticsProject.singleton().dim3D()) {
                    Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
                    grid3D.setWorldLocation(x, y);
                    int inline = grid3D.Inline;
                    int crossline = grid3D.Crossline;
                    if (this.m_leftClickUEC.ControlDown) {
                        Messenger.broadcastBin3DSelected(this, inline, crossline);
                    } else {
                        this.loadBin3D(inline, crossline);
                    }
                }
                if (this.m_receiverTable != null && this.m_mouseMode == MouseMode.Receiver) {
                    if (this.m_receiverTable.selectNearestSpatialPoint(x, y)) {
                        if (this.m_leftClickUEC.ControlDown) {
                            Messenger.broadcastReceiverSelected(this, this.m_receiverTable.SelectedID);
                        } else if (this.m_leftClickUEC.ShiftDown) {
                            System.out.println("SHIFT");
                        } else {
                            this.loadReceiver(this.m_receiverTable.SelectedID);
                        }
                    } else {
                        this.clearSelected();
                    }
                }
                if (this.m_shotTable != null && this.m_mouseMode == MouseMode.Shot) {
                    if (this.m_shotTable.selectNearestSpatialPoint(x, y)) {
                        if (this.m_leftClickUEC.ControlDown) {
                            Messenger.broadcastShotSelected(this, this.m_shotTable.SelectedID);
                        } else if (this.m_leftClickUEC.ShiftDown) {
                            System.out.println("SHIFT");
                        } else {
                            this.loadShot(this.m_shotTable.SelectedID);
                        }
                    } else {
                        this.clearSelected();
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadBin2D(int bin) {
        try {
            this.m_ensemble.clearTraces(false);
            RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_ensemble, bin, 0, false);
            this.m_paintableShot.PaintOK = true;
            this.m_paintableRec.PaintOK = true;
            this.m_paintableRec.checkStatus();
            this.m_paintableShot.checkStatus();
            this.m_plotWidget.mainWidget().repaint();
            this.prepErrorWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadBin3D(int inline, int crossline) {
        try {
            this.m_ensemble.clearTraces(false);
            RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_ensemble, inline, crossline, 0, false);
            this.m_paintableShot.PaintOK = true;
            this.m_paintableRec.PaintOK = true;
            this.m_paintableRec.checkStatus();
            this.m_paintableShot.checkStatus();
            this.m_plotWidget.mainWidget().repaint();
            this.prepErrorWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadReceiver(int recID) {
        try {
            this.m_ensemble.clearTraces(false);
            RefractionStaticsProject.singleton().ensemble_Receiver(this.m_ensemble, recID, false);
            this.m_paintableShot.PaintOK = true;
            this.m_paintableRec.PaintOK = true;
            this.m_paintableRec.checkStatus();
            this.m_paintableShot.checkStatus();
            this.m_plotWidget.mainWidget().repaint();
            this.prepErrorWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadShot(int shotID) {
        try {
            this.m_ensemble.clearTraces(false);
            RefractionStaticsProject.singleton().ensemble_Shot(this.m_ensemble, shotID, false);
            this.m_paintableShot.PaintOK = true;
            this.m_paintableRec.PaintOK = true;
            this.m_paintableRec.checkStatus();
            this.m_paintableShot.checkStatus();
            this.m_plotWidget.mainWidget().repaint();
            this.prepErrorWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepErrorWidget() {
    }

    protected void clearSelected() {
        try {
            this.m_ensemble.clearTraces(false);
            this.m_paintableShot.PaintOK = true;
            this.m_paintableRec.PaintOK = true;
            this.m_paintableRec.checkStatus();
            this.m_paintableShot.checkStatus();
            this.m_plotWidget.mainWidget().repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected String setAverageValueString(String field) {
        try {
            if (field.length() == 0) {
                return "";
            }
            if (field.equalsIgnoreCase("ShotID") || field.equalsIgnoreCase("ReceiverID") || field.equalsIgnoreCase("LineNumber") || field.equalsIgnoreCase("PointNumber") || field.equalsIgnoreCase("FFID") || field.equalsIgnoreCase("Killed") || field.equalsIgnoreCase("Polarity") || field.equalsIgnoreCase("PointIndex") || field.equalsIgnoreCase("Flag")) {
                return "";
            }
            int value = 0;
            if (this.m_shotTable.column_exists(field)) {
                index = this.m_shotTable.column_indexOfColumn(field);
                if (this.m_shotTable.column_type(index) == DataType.Double) {
                    double avg = RefractionStaticsProject.singleton().findAverageValue_Double(field);
                    value = (int)avg;
                }
                if (this.m_shotTable.column_type(index) == DataType.Float) {
                    float avg = RefractionStaticsProject.singleton().findAverageValue_Float(field);
                    value = (int)avg;
                }
                if (this.m_shotTable.column_type(index) == DataType.Int) {
                    int avg;
                    value = avg = RefractionStaticsProject.singleton().findAverageValue_Int(field);
                }
            } else if (this.m_receiverTable.column_exists(field)) {
                index = this.m_receiverTable.column_indexOfColumn(field);
                if (this.m_receiverTable.column_type(index) == DataType.Double) {
                    double avg = RefractionStaticsProject.singleton().findAverageValue_Double(field);
                    value = (int)avg;
                }
                if (this.m_receiverTable.column_type(index) == DataType.Float) {
                    float avg = RefractionStaticsProject.singleton().findAverageValue_Float(field);
                    value = (int)avg;
                }
                if (this.m_receiverTable.column_type(index) == DataType.Int) {
                    int avg;
                    value = avg = RefractionStaticsProject.singleton().findAverageValue_Int(field);
                }
            } else {
                return "";
            }
            String display = "   (AVG = " + Integer.toString(value) + ")";
            return display;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    protected static enum MouseMode {
        Polygon("Define project polygon"),
        Shot("Select shot "),
        Receiver("Select receiver"),
        Midpoint("Select midpoint");

        public final String Description;

        private MouseMode(String desc) {
            this.Description = desc;
        }
    }
}

