/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Geometry.GeometryProject_SPS;
import com.PecosLibrary.Windows.ASCII.AsciiImportData;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SPSHeaderMapWidget
extends LinearLayoutWidget
implements ItemListener,
ActionListener {
    protected GeometryProject_SPS m_project;
    protected Color m_colorOn = new Color(200, 255, 200);
    protected Color m_colorOff = new Color(255, 255, 200);
    protected ArrayList<WidgetEntry> m_shotWidgets = new ArrayList();
    protected ArrayList<WidgetEntry> m_receiverWidgets = new ArrayList();
    protected JComboBox m_cmbElevScalar = new JComboBox();
    protected JComboBox m_cmbCoordScalar = new JComboBox();
    protected JButton m_btnRefreshAll;
    protected JButton m_btnSaveAll;
    protected JButton m_btnDefSht;
    protected JButton m_btnDefRec;
    protected boolean m_ignoreCombo = false;
    protected boolean m_ignoreSave = false;

    public SPSHeaderMapWidget(GeometryProject_SPS project) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_project = project;
            LinearLayoutWidget top = this.createHorizontal(2, null, 0);
            LinearLayoutWidget sub = top.createVertical(5, null, 0);
            this.m_btnRefreshAll = sub.createButton("Refresh all", this, 0);
            this.m_btnSaveAll = sub.createButton("Save all", this, 0);
            top.createGapLabel(20);
            sub = top.createVertical(5, null, 0);
            this.m_btnDefSht = sub.createButton("Generate default shot map", this, 0);
            this.m_btnDefRec = sub.createButton("Generate default receiver map", this, 0);
            top.createGapLabel(20);
            this.m_cmbCoordScalar.addItem("None");
            this.m_cmbCoordScalar.addItem("Multiply by 10");
            this.m_cmbCoordScalar.addItem("Multiply by 100");
            this.m_cmbCoordScalar.addItem("Multiply by 1000");
            this.m_cmbElevScalar.addItem("None");
            this.m_cmbElevScalar.addItem("Multiply by 10");
            this.m_cmbElevScalar.addItem("Multiply by 100");
            this.m_cmbElevScalar.addItem("Multiply by 1000");
            GridLayoutWidget grid = top.createGridLayoutWidget(2, 2);
            grid.addSimple(0, new JLabel("Elevation scalar "), this.m_cmbElevScalar);
            grid.addSimple(1, new JLabel("Coordinate scalar "), this.m_cmbCoordScalar);
            this.m_cmbElevScalar.addItemListener(this);
            this.m_cmbCoordScalar.addItemListener(this);
            this.m_ignoreCombo = true;
            int coord = this.m_project.parameterTree().int_get("CoordScalar", 1);
            coord = Math.max(coord, 0);
            coord = Math.min(coord, 3);
            this.m_cmbCoordScalar.setSelectedIndex(coord);
            int elev = this.m_project.parameterTree().int_get("ElevScalar", 1);
            elev = Math.max(elev, 0);
            elev = Math.min(elev, 3);
            this.m_cmbElevScalar.setSelectedIndex(elev);
            top.addStretch(10);
            LinearLayoutWidget bottom = this.createHorizontal(0, null, 10);
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget right = LinearLayoutWidget.vert(0, null);
            GridLayoutWidget sg = left.createGridLayoutWidget(0, "Shot export options", 0);
            GridLayoutWidget rg = right.createGridLayoutWidget(0, "Receiver export options", 0);
            left.addStretch(10);
            right.addStretch(10);
            bottom.addComponent(left, 10);
            bottom.addComponent(right, 10);
            this.createGrid(sg, this.m_shotWidgets);
            this.createGrid(rg, this.m_receiverWidgets);
            this.refresh();
            this.saveAll();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreCombo = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreCombo) {
                return;
            }
            this.saveAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveAll() {
        try {
            if (this.m_ignoreSave) {
                return;
            }
            this.m_project.parameterTree().int_put("ElevScalar", this.m_cmbElevScalar.getSelectedIndex());
            this.m_project.parameterTree().int_put("CoordScalar", this.m_cmbCoordScalar.getSelectedIndex());
            for (WidgetEntry we : this.m_shotWidgets) {
                we.extract();
            }
            for (WidgetEntry we : this.m_receiverWidgets) {
                we.extract();
            }
            this.m_project.saveColumnDefinitions();
            this.m_project.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.saveAll();
            if (e.getSource() == this.m_btnDefRec) {
                this.m_project.asciiImportData("Receiver").defRecMap();
                this.refresh();
                this.saveAll();
                return;
            }
            if (e.getSource() == this.m_btnDefSht) {
                this.m_project.asciiImportData("Shot").defShotMap();
                this.refresh();
                this.saveAll();
                return;
            }
            if (e.getSource() == this.m_btnSaveAll) {
                return;
            }
            if (e.getSource() == this.m_btnRefreshAll) {
                this.refresh();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void refresh() {
        try {
            this.m_ignoreSave = true;
            this.refresh(this.m_shotWidgets, this.m_project.asciiImportData("Shot"), "Shot");
            this.refresh(this.m_receiverWidgets, this.m_project.asciiImportData("Receiver"), "Receiver");
            this.m_ignoreSave = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreSave = false;
    }

    protected void refresh(ArrayList<WidgetEntry> array, AsciiImportData aid, String table) {
        try {
            int n;
            ArrayList<AsciiImportData.Column> columns = aid.columns();
            for (n = 0; n < columns.size(); ++n) {
                AsciiImportData.Column column = columns.get(n);
                array.get(n).setColumnData(table, column);
            }
            for (n = columns.size(); n < array.size(); ++n) {
                array.get(n).setColumnData(table, null);
                array.get(n).setVisible(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createGrid(GridLayoutWidget g, ArrayList<WidgetEntry> array) {
        try {
            int row = 0;
            g.addComponent(new JLabel(" "), row, 0, 0.0, 1.0);
            g.addComponent(new JLabel("Export?"), row, 1, 0.0, 1.0);
            g.addComponent(new JLabel("Header type"), row, 2, 0.0, 1.0);
            g.addComponent(new JLabel("Byte offset"), row, 3, 0.0, 2.0);
            g.addComponent(new JLabel("Elevation scalar"), row, 4, 0.0, 1.0);
            g.addComponent(new JLabel("Coord scalar"), row, 5, 0.0, 1.0);
            ++row;
            for (int n = 0; n < 40; ++n) {
                WidgetEntry w = new WidgetEntry();
                array.add(w);
                g.addComponent(w.ColumnLabel, row, 0, 0.0, 1.0);
                g.addComponent(w.ExportCheck, row, 1, 0.0, 1.0);
                g.addComponent(w.TypeCombo, row, 2, 0.0, 1.0);
                g.addComponent(w.OffsetText, row, 3, 0.0, 2.0);
                g.addComponent(w.ApplyElevCheck, row, 4, 0.0, 1.0);
                g.addComponent(w.ApplyCoordCheck, row, 5, 0.0, 1.0);
                w.OffsetText.addActionListener(this);
                w.ExportCheck.addActionListener(this);
                w.ApplyElevCheck.addActionListener(this);
                w.ApplyCoordCheck.addActionListener(this);
                w.TypeCombo.addItemListener(this);
                ++row;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class WidgetEntry {
        public JLabel ColumnLabel = new JLabel("", 2);
        public JTextField OffsetText = new JTextField();
        public JComboBox TypeCombo = new JComboBox();
        public JCheckBox ExportCheck = new JCheckBox(" ");
        public JCheckBox ApplyElevCheck = new JCheckBox(" ");
        public JCheckBox ApplyCoordCheck = new JCheckBox(" ");
        public AsciiImportData.Column ColumnData = null;

        public WidgetEntry() {
            try {
                this.ColumnLabel.setOpaque(true);
                this.ExportCheck.setOpaque(true);
                this.TypeCombo.addItem("4 byte int");
                this.TypeCombo.addItem("2 byte int");
                this.TypeCombo.addItem("IBM float");
                this.setVisible(false);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void extract() {
            try {
                if (this.ColumnData == null) {
                    return;
                }
                this.ColumnData.Offset = Tools_Widget.extractInteger(this.OffsetText, 1, 1, 239);
                this.ColumnData.WriteToHeader = this.ExportCheck.isSelected();
                this.ColumnData.ApplyElevScalar = this.ApplyElevCheck.isSelected();
                this.ColumnData.ApplyCoordScalar = this.ApplyCoordCheck.isSelected();
                this.ColumnData.ExportType = DataType.Int;
                if (this.TypeCombo.getSelectedIndex() == 0) {
                    this.ColumnData.ExportType = DataType.Int;
                }
                if (this.TypeCombo.getSelectedIndex() == 1) {
                    this.ColumnData.ExportType = DataType.Short;
                }
                if (this.TypeCombo.getSelectedIndex() == 2) {
                    this.ColumnData.ExportType = DataType.FloatIBM;
                }
                if (this.ExportCheck.isSelected()) {
                    this.ExportCheck.setBackground(SPSHeaderMapWidget.this.m_colorOn);
                } else {
                    this.ExportCheck.setBackground(SPSHeaderMapWidget.this.m_colorOff);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setColumnData(String table, AsciiImportData.Column colData) {
            try {
                this.ColumnData = colData;
                if (this.ColumnData == null) {
                    this.ColumnLabel.setText("");
                    return;
                }
                this.setVisible(true);
                this.ColumnLabel.setText(this.ColumnData.Name);
                this.OffsetText.setText(Integer.toString(this.ColumnData.Offset));
                this.ExportCheck.setSelected(this.ColumnData.WriteToHeader);
                this.ApplyElevCheck.setSelected(this.ColumnData.ApplyElevScalar);
                this.ApplyCoordCheck.setSelected(this.ColumnData.ApplyCoordScalar);
                this.TypeCombo.setSelectedIndex(0);
                if (this.ColumnData.ExportType == DataType.Int) {
                    this.TypeCombo.setSelectedIndex(0);
                }
                if (this.ColumnData.ExportType == DataType.Short) {
                    this.TypeCombo.setSelectedIndex(1);
                }
                if (this.ColumnData.ExportType == DataType.FloatIBM) {
                    this.TypeCombo.setSelectedIndex(2);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setVisible(boolean v) {
            try {
                this.ColumnLabel.setVisible(v);
                this.OffsetText.setVisible(v);
                this.TypeCombo.setVisible(v);
                this.ApplyElevCheck.setVisible(v);
                this.ApplyCoordCheck.setVisible(v);
                this.ExportCheck.setVisible(v);
                if (!v) {
                    this.ColumnData = null;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

