/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Geometry.GeometryProject_SPS;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import com.PecosLibrary.Windows.Shared.FileSelector;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class NewSPSProjectDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Geometry);
    protected JButton m_btnOK;
    protected JButton m_btnCancel;
    protected FileSelector m_selSrc;
    protected FileSelector m_selRec;
    protected FileSelector m_selRel;
    protected JLabel m_label = new JLabel("Status", 0);
    protected RadioPanel m_verGroup;
    public boolean OK = false;
    public String ProjectName;

    public NewSPSProjectDialog(Frame parent) {
        super(parent, "New project using SPS files", true);
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            main.addComponent(this.m_nameWidget, 0);
            this.m_nameWidget.Type = ProjectNameSelectionWidget.ProjectType.Geometry;
            this.m_nameWidget.getListenerController().addListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "File selection", 0);
            this.m_selSrc = new FileSelector(grid, 0, "Source file", this);
            this.m_selRec = new FileSelector(grid, 1, "Receiver file", this);
            this.m_selRel = new FileSelector(grid, 2, "Relational file", this);
            this.m_verGroup = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Select SPS version", "Revision 0 (1993)", "Revision 2.1 (2006)");
            main.addComponent(this.m_verGroup, 0);
            LinearLayoutWidget bottom = main.createHorizontal(0, null, 0);
            this.m_btnOK = bottom.createButton("Create project", this, 0);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            bottom.addComponent(this.m_label, 10);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)main, "Center");
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setLocationRelativeTo(null);
            this.m_selSrc.m_txt.setText("/Users/matt/Data/SPS/sps4matt/LASKI3D_Swath01.sps");
            this.m_selRec.m_txt.setText("/Users/matt/Data/SPS/sps4matt/LASKI3D_Swath01.rps");
            this.m_selRel.m_txt.setText("/Users/matt/Data/SPS/sps4matt/LASKI3D_Swath01.xps");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkStatus() {
        try {
            this.m_label.setForeground(Color.red);
            this.m_btnOK.setEnabled(false);
            if (!this.m_nameWidget.checkName()) {
                this.m_label.setText("Project name not valid");
                return;
            }
            if (!this.m_selSrc.fileExists()) {
                this.m_label.setText("Source file name not valid");
                return;
            }
            if (!this.m_selRec.fileExists()) {
                this.m_label.setText("Receiver file name not valid");
                return;
            }
            if (!this.m_selRel.fileExists()) {
                this.m_label.setText("Relational file name not valid");
                return;
            }
            this.m_label.setText("Options look okay");
            this.m_label.setForeground(Color.blue);
            this.m_btnOK.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.checkStatus();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkStatus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            this.checkStatus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createProject() {
        try {
            this.ProjectName = this.m_nameWidget.name();
            GeometryProject_SPS project = new GeometryProject_SPS(this.ProjectName);
            project.parameterTree().string_put("Origin", Pecos.SPS);
            project.parameterTree().string_put("DateCreated", new Date().toString());
            project.setAsciiFileName(GeometryProject_SPS.Shot, this.m_selSrc.m_txt.getText());
            project.setAsciiFileName(GeometryProject_SPS.Receiver, this.m_selRec.m_txt.getText());
            project.setAsciiFileName(GeometryProject_SPS.Relation, this.m_selRel.m_txt.getText());
            if (this.m_verGroup.getSelectedIndex() == 0) {
                project.asciiImportData(GeometryProject_SPS.Shot).createDefSPS_Ver0();
                project.asciiImportData(GeometryProject_SPS.Receiver).createDefSPS_Ver0();
                project.asciiImportData(GeometryProject_SPS.Relation).createDefXPS_Ver0();
            } else {
                project.asciiImportData(GeometryProject_SPS.Shot).createDefSPS_Ver21();
                project.asciiImportData(GeometryProject_SPS.Receiver).createDefSPS_Ver21();
                project.asciiImportData(GeometryProject_SPS.Relation).createDefXPS_Ver21();
            }
            project.saveParameters();
            project.saveColumnDefinitions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.checkStatus();
            if (e.getSource() == this.m_btnOK) {
                this.createProject();
                this.OK = true;
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.OK = false;
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

