/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Ensemble.Sequence;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_PaintCompositeWidget;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_SelectionButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Sequence_SplitterWidget
extends JSplitPane
implements ListSelectionListener,
ActionListener,
Sequence_SelectionButton.Listener,
GenericObjectListener.Listener {
    protected EnsembleWorker_Sequence m_sequence;
    protected JButton m_upButton;
    protected JButton m_downButton;
    protected JButton m_toggleButton;
    protected JButton m_deleteButton;
    protected JButton m_deleteAllButton;
    protected Sequence_PaintCompositeWidget m_paintWidget;
    protected Sequence_SelectionButton m_addButton;
    protected JPanel m_blankPanel = new JPanel();

    public Sequence_SplitterWidget(EnsembleWorker_Sequence sequence) {
        super(0);
        try {
            this.m_sequence = sequence;
            this.m_sequence.addListener(this);
            this.setTopComponent(this.createTopComponent());
            this.m_blankPanel.setMinimumSize(new Dimension(300, 300));
            this.setBottomComponent(this.m_blankPanel);
            this.clearSelection();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void toggle_unlocked_processes() {
        try {
            this.m_sequence.toggle_unlocked();
            this.m_paintWidget.force_paint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void toggle_active_process() {
        try {
            this.m_sequence.toggleSelected();
            EnsembleWorker_Base worker = this.m_sequence.getSelectedWorker();
            if (worker != null) {
                this.prepToggle(worker);
            }
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return;
        }
    }

    protected JComponent createTopComponent() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this.m_paintWidget = new Sequence_PaintCompositeWidget(this.m_sequence);
            main.addComponent(this.m_paintWidget, 10);
            LinearLayoutWidget btn = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null, 0);
            boolean requireInteractiveFlowsOkay = this.m_sequence.getType() == EnsembleWorker_Sequence.SequenceType.Interactive;
            this.m_addButton = new Sequence_SelectionButton(this.m_sequence, requireInteractiveFlowsOkay, this);
            btn.addComponent(this.m_addButton, 0);
            btn.addStretch(10);
            this.m_upButton = Tools_Bitmap.makeButton(btn, BitmapEnum.Up, "Move up", (ActionListener)this);
            this.m_downButton = Tools_Bitmap.makeButton(btn, BitmapEnum.Down, "Move down", (ActionListener)this);
            this.m_toggleButton = Tools_Bitmap.makeButton(btn, BitmapEnum.Toggle_OnState, "Turn item off", (ActionListener)this);
            btn.addStretch(10);
            this.m_deleteButton = Tools_Bitmap.makeButton(btn, BitmapEnum.Delete, "Delete selected item", (ActionListener)this);
            this.m_deleteAllButton = Tools_Bitmap.makeButton(btn, BitmapEnum.DeleteAll, "Remove all items", (ActionListener)this);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_sequence) {
                JComponent c;
                RefractionStaticsProject project;
                EnsembleWorker_Base worker;
                int index;
                if (this.m_sequence.MessageData.SelectedChanged) {
                    this.clearSelection();
                    if (this.m_sequence.size() < 1) {
                        return;
                    }
                    index = this.m_sequence.getSelectedIndex();
                    if (index < 0 || index >= this.m_sequence.size()) {
                        return;
                    }
                    this.m_upButton.setEnabled(index >= 1);
                    this.m_downButton.setEnabled(index < this.m_sequence.size() - 1);
                    this.m_deleteButton.setEnabled(true);
                    this.m_toggleButton.setEnabled(true);
                    worker = this.m_sequence.worker(index);
                    if (worker.hasEditorWidget()) {
                        project = RefractionStaticsProject.singleton();
                        worker.setRefractionStaticsProject(project);
                        c = worker.editorWidget();
                        if (this.getBottomComponent() == c) {
                            return;
                        }
                        c.setMinimumSize(new Dimension(300, 300));
                        this.setBottomComponent(c);
                    } else {
                        this.setBottomComponent(this.m_blankPanel);
                    }
                    this.prepToggle(worker);
                }
                if (this.m_sequence.MessageData.SequenceModified) {
                    index = this.m_sequence.getSelectedIndex();
                    if (index < 0 || index >= this.m_sequence.size()) {
                        return;
                    }
                    this.m_upButton.setEnabled(index >= 1);
                    this.m_downButton.setEnabled(index < this.m_sequence.size() - 1);
                    this.m_deleteButton.setEnabled(true);
                    this.m_toggleButton.setEnabled(true);
                    worker = this.m_sequence.worker(index);
                    if (worker.hasEditorWidget()) {
                        project = RefractionStaticsProject.singleton();
                        worker.setRefractionStaticsProject(project);
                        c = worker.editorWidget();
                        if (this.getBottomComponent() == c) {
                            return;
                        }
                        c.setMinimumSize(new Dimension(300, 300));
                        this.setBottomComponent(c);
                    } else {
                        this.setBottomComponent(this.m_blankPanel);
                    }
                    this.prepToggle(worker);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleEnsembleWorkerButton(EnsembleWorker_Base worker) {
        try {
            this.m_sequence.add(worker);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_toggleButton) {
                this.m_sequence.toggleSelected();
                EnsembleWorker_Base worker = this.m_sequence.getSelectedWorker();
                if (worker != null) {
                    this.prepToggle(worker);
                }
                return;
            }
            if (e.getSource() == this.m_downButton) {
                this.m_sequence.moveLater();
                return;
            }
            if (e.getSource() == this.m_upButton) {
                this.m_sequence.moveEarlier();
                return;
            }
            if (e.getSource() == this.m_deleteButton) {
                this.m_sequence.remove();
                return;
            }
            if (e.getSource() == this.m_deleteAllButton) {
                this.m_sequence.clear();
                this.clearSelection();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void clearSelection() {
        try {
            this.m_upButton.setEnabled(false);
            this.m_downButton.setEnabled(false);
            this.m_deleteButton.setEnabled(false);
            this.m_toggleButton.setEnabled(false);
            this.setBottomComponent(new JLabel());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepToggle(EnsembleWorker_Base worker) {
        try {
            if (worker.WorkerTurnedOn) {
                this.m_toggleButton.setIcon(Tools_Bitmap.toggleOn());
                this.m_toggleButton.setToolTipText("Item on - click to turn off");
            } else {
                this.m_toggleButton.setIcon(Tools_Bitmap.toggleOff());
                this.m_toggleButton.setToolTipText("Item off - click to turn on");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            System.out.println("valueChanged(ListSelectionEvent e)");
            this.clearSelection();
            if (this.m_sequence.size() < 1) {
                return;
            }
            int index = 0;
            if (index < 0 || index >= this.m_sequence.size()) {
                return;
            }
            this.m_upButton.setEnabled(index >= 1);
            this.m_downButton.setEnabled(index < this.m_sequence.size() - 1);
            this.m_deleteButton.setEnabled(true);
            this.m_toggleButton.setEnabled(true);
            EnsembleWorker_Base worker = this.m_sequence.worker(index);
            if (worker.hasEditorWidget()) {
                this.setBottomComponent(worker.editorWidget());
            }
            this.prepToggle(worker);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

