/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Ensemble.Sequence;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Ensemble.Worker.EnsembleWorker_CompleteList;
import com.PecosLibrary.Tools.Tools_Bitmap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Sequence_SelectionButton
extends JButton
implements ActionListener,
MouseListener {
    protected EnsembleWorker_Sequence m_sequence;
    protected WeakReference<Listener> m_listener;
    protected JPopupMenu m_popupMenu = null;
    protected boolean m_requireInteractiveFlowsOkay = true;

    public Sequence_SelectionButton(EnsembleWorker_Sequence sequence, boolean requireInteractiveFlowsOkay, Listener listener) {
        try {
            this.m_sequence = sequence;
            this.m_requireInteractiveFlowsOkay = requireInteractiveFlowsOkay;
            this.m_listener = new WeakReference<Listener>(listener);
            URL url = Tools_Bitmap.url("Add.png");
            this.setToolTipText("Add");
            if (url != null) {
                this.setIcon(new ImageIcon(url, "Add"));
            } else {
                this.setText("Add");
            }
            this.addMouseListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof WorkerMenuItem) {
                WorkerMenuItem mi = (WorkerMenuItem)e.getSource();
                Class<?> c = mi.Worker.getClass();
                ClassLoader loader = this.getClass().getClassLoader();
                Listener listener = (Listener)this.m_listener.get();
                if (listener != null) {
                    listener.handleEnsembleWorkerButton((EnsembleWorker_Base)c.newInstance());
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected void showPopupMenu(MouseEvent event) {
        try {
            if (this.m_popupMenu == null) {
                EnsembleWorker_CompleteList list = EnsembleWorker_CompleteList.singleton();
                ArrayList<String> typeList = list.listOfTypes(this.m_requireInteractiveFlowsOkay, this.m_sequence.getType());
                this.m_popupMenu = new JPopupMenu();
                for (String type : typeList) {
                    JMenu menu = new JMenu(type);
                    this.m_popupMenu.add(menu);
                    ArrayList<EnsembleWorker_Base> workerList = list.listOfWorkersOfType(type);
                    for (EnsembleWorker_Base worker : workerList) {
                        WorkerMenuItem mi = new WorkerMenuItem(worker);
                        mi.addActionListener(this);
                        menu.add(mi);
                    }
                }
            }
            this.m_popupMenu.show(event.getComponent(), event.getX(), event.getY());
            this.m_popupMenu.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            this.showPopupMenu(event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    protected static class WorkerMenuItem
    extends JMenuItem {
        public EnsembleWorker_Base Worker;

        public WorkerMenuItem(EnsembleWorker_Base w) {
            this.setText(w.concat());
            this.Worker = w;
        }
    }

    public static interface Listener {
        public void handleEnsembleWorkerButton(EnsembleWorker_Base var1);
    }
}

